/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EdsLoadBalancerProvider;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.LocalityStore;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class EdsLoadBalancer
extends LoadBalancer {
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final GracefulSwitchLoadBalancer switchingLoadBalancer;
    private final LoadBalancerRegistry lbRegistry;
    private final LocalityStore.LocalityStoreFactory localityStoreFactory;
    private final Bootstrapper bootstrapper;
    private final XdsClient.XdsChannelFactory channelFactory;
    private final LoadBalancer.Helper helper;
    @Nullable
    private ObjectPool<XdsClient> xdsClientPool;
    @Nullable
    private XdsClient xdsClient;
    @Nullable
    private String clusterName;
    @Nullable
    private String edsServiceName;

    EdsLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry(), LocalityStore.LocalityStoreFactory.getInstance(), Bootstrapper.getInstance(), XdsClient.XdsChannelFactory.getInstance());
    }

    @VisibleForTesting
    EdsLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, LocalityStore.LocalityStoreFactory localityStoreFactory, Bootstrapper bootstrapper, XdsClient.XdsChannelFactory channelFactory) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.localityStoreFactory = (LocalityStore.LocalityStoreFactory)Preconditions.checkNotNull((Object)localityStoreFactory, (Object)"localityStoreFactory");
        this.bootstrapper = (Bootstrapper)Preconditions.checkNotNull((Object)bootstrapper, (Object)"bootstrapper");
        this.channelFactory = (XdsClient.XdsChannelFactory)Preconditions.checkNotNull((Object)channelFactory, (Object)"channelFactory");
        this.switchingLoadBalancer = new GracefulSwitchLoadBalancer(helper);
        this.logId = InternalLogId.allocate((String)"eds-lb", (String)helper.getAuthority());
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        if (lbConfig == null) {
            this.handleNameResolutionError(Status.UNAVAILABLE.withDescription("Missing EDS lb config"));
            return;
        }
        EdsLoadBalancerProvider.EdsConfig newEdsConfig = (EdsLoadBalancerProvider.EdsConfig)lbConfig;
        if (this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received EDS lb config: cluster={0}, child_policy={1}, eds_service_name={2}, report_load={3}", newEdsConfig.clusterName, newEdsConfig.endpointPickingPolicy.getProvider().getPolicyName(), newEdsConfig.edsServiceName, newEdsConfig.lrsServerName != null);
        }
        boolean firstUpdate = false;
        if (this.clusterName == null) {
            firstUpdate = true;
        }
        this.clusterName = newEdsConfig.clusterName;
        if (this.xdsClientPool == null) {
            Attributes attributes = resolvedAddresses.getAttributes();
            this.xdsClientPool = (ObjectPool)attributes.get(XdsAttributes.XDS_CLIENT_POOL);
            if (this.xdsClientPool == null) {
                Bootstrapper.BootstrapInfo bootstrapInfo;
                try {
                    bootstrapInfo = this.bootstrapper.readBootstrap();
                }
                catch (Exception e) {
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Failed to bootstrap").withCause((Throwable)e)));
                    return;
                }
                final List<Bootstrapper.ServerInfo> serverList = bootstrapInfo.getServers();
                final EnvoyProtoData.Node node = bootstrapInfo.getNode();
                if (serverList.isEmpty()) {
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("No management server provided by bootstrap")));
                    return;
                }
                XdsClient.XdsClientFactory xdsClientFactory = new XdsClient.XdsClientFactory(){

                    @Override
                    XdsClient createXdsClient() {
                        return new XdsClientImpl(EdsLoadBalancer.this.helper.getAuthority(), serverList, EdsLoadBalancer.this.channelFactory, node, EdsLoadBalancer.this.helper.getSynchronizationContext(), EdsLoadBalancer.this.helper.getScheduledExecutorService(), (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider(), (Supplier<Stopwatch>)GrpcUtil.STOPWATCH_SUPPLIER);
                    }
                };
                this.xdsClientPool = new XdsClient.RefCountedXdsClientObjectPool(xdsClientFactory);
            } else {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Use xDS client from channel");
            }
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        if (firstUpdate || !Objects.equals(newEdsConfig.edsServiceName, this.edsServiceName)) {
            ClusterEndpointsBalancerFactory clusterEndpointsLoadBalancerFactory = new ClusterEndpointsBalancerFactory(newEdsConfig.edsServiceName);
            this.switchingLoadBalancer.switchTo((LoadBalancer.Factory)clusterEndpointsLoadBalancerFactory);
        }
        this.switchingLoadBalancer.handleResolvedAddresses(resolvedAddresses);
        this.edsServiceName = newEdsConfig.edsServiceName;
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchingLoadBalancer.handleNameResolutionError(error);
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        this.switchingLoadBalancer.shutdown();
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    private final class ClusterEndpointsBalancerFactory
    extends LoadBalancer.Factory {
        @Nullable
        final String clusterServiceName;

        ClusterEndpointsBalancerFactory(String clusterServiceName) {
            this.clusterServiceName = clusterServiceName;
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new ClusterEndpointsBalancer(helper);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClusterEndpointsBalancerFactory)) {
                return false;
            }
            ClusterEndpointsBalancerFactory that = (ClusterEndpointsBalancerFactory)((Object)o);
            return Objects.equals(this.clusterServiceName, that.clusterServiceName);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.clusterServiceName);
        }

        final class ClusterEndpointsBalancer
        extends LoadBalancer {
            final String resourceName;
            final LoadBalancer.Helper helper;
            final EndpointWatcherImpl endpointWatcher;
            final LocalityStore localityStore;
            boolean isReportingLoad;

            ClusterEndpointsBalancer(LoadBalancer.Helper helper) {
                this.helper = helper;
                this.resourceName = ClusterEndpointsBalancerFactory.this.clusterServiceName != null ? ClusterEndpointsBalancerFactory.this.clusterServiceName : EdsLoadBalancer.this.clusterName;
                LoadStatsManager.LoadStatsStore loadStatsStore = EdsLoadBalancer.this.xdsClient.addClientStats(EdsLoadBalancer.this.clusterName, ClusterEndpointsBalancerFactory.this.clusterServiceName);
                this.localityStore = EdsLoadBalancer.this.localityStoreFactory.newLocalityStore(EdsLoadBalancer.this.logId, helper, EdsLoadBalancer.this.lbRegistry, loadStatsStore);
                this.endpointWatcher = new EndpointWatcherImpl();
                EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start endpoint watcher on {0} with xDS client {1}", this.resourceName, EdsLoadBalancer.this.xdsClient);
                EdsLoadBalancer.this.xdsClient.watchEndpointData(this.resourceName, this.endpointWatcher);
            }

            public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
                EdsLoadBalancerProvider.EdsConfig config = (EdsLoadBalancerProvider.EdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
                if (config.lrsServerName != null) {
                    if (!config.lrsServerName.equals("")) {
                        throw new AssertionError((Object)"Can only report load to the same management server");
                    }
                    if (!this.isReportingLoad) {
                        EdsLoadBalancer.this.xdsClient.reportClientStats();
                        this.isReportingLoad = true;
                    }
                } else if (this.isReportingLoad) {
                    EdsLoadBalancer.this.xdsClient.cancelClientStatsReport();
                    this.isReportingLoad = false;
                }
            }

            public void handleNameResolutionError(Status error) {
                if (!this.endpointWatcher.endpointsReceived) {
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                }
            }

            public boolean canHandleEmptyAddressListFromNameResolution() {
                return true;
            }

            public void shutdown() {
                if (this.isReportingLoad) {
                    EdsLoadBalancer.this.xdsClient.cancelClientStatsReport();
                    this.isReportingLoad = false;
                }
                this.localityStore.reset();
                EdsLoadBalancer.this.xdsClient.removeClientStats(EdsLoadBalancer.this.clusterName, ClusterEndpointsBalancerFactory.this.clusterServiceName);
                EdsLoadBalancer.this.xdsClient.cancelEndpointDataWatch(this.resourceName, this.endpointWatcher);
                EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cancelled endpoint watcher on {0} with xDS client {1}", this.resourceName, EdsLoadBalancer.this.xdsClient);
            }

            private final class EndpointWatcherImpl
            implements XdsClient.EndpointWatcher {
                boolean endpointsReceived;

                private EndpointWatcherImpl() {
                }

                @Override
                public void onEndpointChanged(XdsClient.EndpointUpdate endpointUpdate) {
                    EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update: {0}", endpointUpdate);
                    if (EdsLoadBalancer.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                        EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received endpoint update from xDS client {0}: cluster_name={1}, {2} localities, {3} drop categories", EdsLoadBalancer.this.xdsClient, endpointUpdate.getClusterName(), endpointUpdate.getLocalityLbEndpointsMap().size(), endpointUpdate.getDropPolicies().size());
                    }
                    this.endpointsReceived = true;
                    List<EnvoyProtoData.DropOverload> dropOverloads = endpointUpdate.getDropPolicies();
                    ImmutableList.Builder dropOverloadsBuilder = ImmutableList.builder();
                    for (EnvoyProtoData.DropOverload dropOverload : dropOverloads) {
                        dropOverloadsBuilder.add((Object)dropOverload);
                        if (dropOverload.getDropsPerMillion() != 1000000) continue;
                        break;
                    }
                    ClusterEndpointsBalancer.this.localityStore.updateDropPercentage((List<EnvoyProtoData.DropOverload>)dropOverloadsBuilder.build());
                    ImmutableMap.Builder localityEndpointsMapping = new ImmutableMap.Builder();
                    for (Map.Entry<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> entry : endpointUpdate.getLocalityLbEndpointsMap().entrySet()) {
                        int localityWeight = entry.getValue().getLocalityWeight();
                        if (localityWeight == 0) continue;
                        localityEndpointsMapping.put((Object)entry.getKey(), (Object)entry.getValue());
                    }
                    ClusterEndpointsBalancer.this.localityStore.updateLocalityStore((Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints>)localityEndpointsMapping.build());
                }

                @Override
                public void onResourceDoesNotExist(String resourceName) {
                    EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} is unavailable", resourceName);
                    if (ClusterEndpointsBalancer.this.isReportingLoad) {
                        EdsLoadBalancer.this.xdsClient.cancelClientStatsReport();
                        ClusterEndpointsBalancer.this.isReportingLoad = false;
                    }
                    ClusterEndpointsBalancer.this.localityStore.reset();
                    ClusterEndpointsBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Resource " + resourceName + " is unavailable")));
                }

                @Override
                public void onError(Status error) {
                    EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}: {2}", EdsLoadBalancer.this.xdsClient, error.getCode(), error.getDescription());
                    if (!this.endpointsReceived) {
                        ClusterEndpointsBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                    }
                }
            }
        }
    }
}

