/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Duration;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.Durations;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import io.grpc.EquivalentAddressGroup;
import io.grpc.xds.RouteMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.HealthStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.ClusterStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.UpstreamLocalityStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.UpstreamLocalityStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.WeightedCluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.FractionalPercent;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class EnvoyProtoData {
    private EnvoyProtoData() {
    }

    private static Value convertToValue(Object rawObject) {
        Value.Builder valueBuilder = Value.newBuilder();
        if (rawObject == null) {
            valueBuilder.setNullValue(NullValue.NULL_VALUE);
        } else if (rawObject instanceof Double) {
            valueBuilder.setNumberValue(((Double)rawObject).doubleValue());
        } else if (rawObject instanceof String) {
            valueBuilder.setStringValue((String)rawObject);
        } else if (rawObject instanceof Boolean) {
            valueBuilder.setBoolValue(((Boolean)rawObject).booleanValue());
        } else if (rawObject instanceof Map) {
            Struct.Builder structBuilder = Struct.newBuilder();
            Map map = (Map)rawObject;
            for (Map.Entry entry : map.entrySet()) {
                structBuilder.putFields((String)entry.getKey(), EnvoyProtoData.convertToValue(entry.getValue()));
            }
            valueBuilder.setStructValue(structBuilder);
        } else if (rawObject instanceof List) {
            ListValue.Builder listBuilder = ListValue.newBuilder();
            List list = (List)rawObject;
            for (Object obj : list) {
                listBuilder.addValues(EnvoyProtoData.convertToValue(obj));
            }
            valueBuilder.setListValue(listBuilder);
        }
        return valueBuilder.build();
    }

    static final class EndpointLoadMetricStats {
        private final String metricName;
        private final long numRequestsFinishedWithMetric;
        private final double totalMetricValue;

        private EndpointLoadMetricStats(String metricName, long numRequestsFinishedWithMetric, double totalMetricValue) {
            this.metricName = (String)Preconditions.checkNotNull((Object)metricName, (Object)"metricName");
            this.numRequestsFinishedWithMetric = numRequestsFinishedWithMetric;
            this.totalMetricValue = totalMetricValue;
        }

        String getMetricName() {
            return this.metricName;
        }

        long getNumRequestsFinishedWithMetric() {
            return this.numRequestsFinishedWithMetric;
        }

        double getTotalMetricValue() {
            return this.totalMetricValue;
        }

        private io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.EndpointLoadMetricStats toEnvoyProtoEndpointLoadMetricStats() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.EndpointLoadMetricStats.newBuilder().setMetricName(this.metricName).setNumRequestsFinishedWithMetric(this.numRequestsFinishedWithMetric).setTotalMetricValue(this.totalMetricValue).build();
        }

        private io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.EndpointLoadMetricStats toEnvoyProtoEndpointLoadMetricStatsV2() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.EndpointLoadMetricStats.newBuilder().setMetricName(this.metricName).setNumRequestsFinishedWithMetric(this.numRequestsFinishedWithMetric).setTotalMetricValue(this.totalMetricValue).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointLoadMetricStats that = (EndpointLoadMetricStats)o;
            return this.numRequestsFinishedWithMetric == that.numRequestsFinishedWithMetric && Double.compare(that.totalMetricValue, this.totalMetricValue) == 0 && Objects.equals(this.metricName, that.metricName);
        }

        public int hashCode() {
            return Objects.hash(this.metricName, this.numRequestsFinishedWithMetric, this.totalMetricValue);
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class Builder {
            private String metricName;
            private long numRequestsFinishedWithMetric;
            private double totalMetricValue;

            private Builder() {
            }

            Builder setMetricName(String metricName) {
                this.metricName = (String)Preconditions.checkNotNull((Object)metricName, (Object)"metricName");
                return this;
            }

            Builder setNumRequestsFinishedWithMetric(long numRequestsFinishedWithMetric) {
                this.numRequestsFinishedWithMetric = numRequestsFinishedWithMetric;
                return this;
            }

            Builder setTotalMetricValue(double totalMetricValue) {
                this.totalMetricValue = totalMetricValue;
                return this;
            }

            EndpointLoadMetricStats build() {
                return new EndpointLoadMetricStats(this.metricName, this.numRequestsFinishedWithMetric, this.totalMetricValue);
            }
        }
    }

    static final class UpstreamLocalityStats {
        private final Locality locality;
        private final long totalSuccessfulRequests;
        private final long totalErrorRequests;
        private final long totalRequestsInProgress;
        private final long totalIssuedRequests;
        private final List<EndpointLoadMetricStats> loadMetricStatsList;

        private UpstreamLocalityStats(Locality locality, long totalSuccessfulRequests, long totalErrorRequests, long totalRequestsInProgress, long totalIssuedRequests, List<EndpointLoadMetricStats> loadMetricStatsList) {
            this.locality = (Locality)Preconditions.checkNotNull((Object)locality, (Object)"locality");
            this.totalSuccessfulRequests = totalSuccessfulRequests;
            this.totalErrorRequests = totalErrorRequests;
            this.totalRequestsInProgress = totalRequestsInProgress;
            this.totalIssuedRequests = totalIssuedRequests;
            this.loadMetricStatsList = Collections.unmodifiableList((List)Preconditions.checkNotNull(loadMetricStatsList, (Object)"loadMetricStatsList"));
        }

        Locality getLocality() {
            return this.locality;
        }

        long getTotalSuccessfulRequests() {
            return this.totalSuccessfulRequests;
        }

        long getTotalErrorRequests() {
            return this.totalErrorRequests;
        }

        long getTotalRequestsInProgress() {
            return this.totalRequestsInProgress;
        }

        long getTotalIssuedRequests() {
            return this.totalIssuedRequests;
        }

        List<EndpointLoadMetricStats> getLoadMetricStatsList() {
            return this.loadMetricStatsList;
        }

        private io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.UpstreamLocalityStats toEnvoyProtoUpstreamLocalityStats() {
            UpstreamLocalityStats.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.UpstreamLocalityStats.newBuilder();
            builder.setLocality(this.locality.toEnvoyProtoLocality()).setTotalSuccessfulRequests(this.totalSuccessfulRequests).setTotalErrorRequests(this.totalErrorRequests).setTotalRequestsInProgress(this.totalRequestsInProgress).setTotalIssuedRequests(this.totalIssuedRequests);
            for (EndpointLoadMetricStats endpointLoadMetricStats : this.loadMetricStatsList) {
                builder.addLoadMetricStats(endpointLoadMetricStats.toEnvoyProtoEndpointLoadMetricStats());
            }
            return builder.build();
        }

        private io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.UpstreamLocalityStats toEnvoyProtoUpstreamLocalityStatsV2() {
            UpstreamLocalityStats.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.UpstreamLocalityStats.newBuilder();
            builder.setLocality(this.locality.toEnvoyProtoLocalityV2()).setTotalSuccessfulRequests(this.totalSuccessfulRequests).setTotalErrorRequests(this.totalErrorRequests).setTotalRequestsInProgress(this.totalRequestsInProgress).setTotalIssuedRequests(this.totalIssuedRequests);
            for (EndpointLoadMetricStats endpointLoadMetricStats : this.loadMetricStatsList) {
                builder.addLoadMetricStats(endpointLoadMetricStats.toEnvoyProtoEndpointLoadMetricStatsV2());
            }
            return builder.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpstreamLocalityStats that = (UpstreamLocalityStats)o;
            return this.totalSuccessfulRequests == that.totalSuccessfulRequests && this.totalErrorRequests == that.totalErrorRequests && this.totalRequestsInProgress == that.totalRequestsInProgress && this.totalIssuedRequests == that.totalIssuedRequests && Objects.equals(this.locality, that.locality) && Objects.equals(this.loadMetricStatsList, that.loadMetricStatsList);
        }

        public int hashCode() {
            return Objects.hash(this.locality, this.totalSuccessfulRequests, this.totalErrorRequests, this.totalRequestsInProgress, this.totalIssuedRequests, this.loadMetricStatsList);
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class Builder {
            private Locality locality;
            private long totalSuccessfulRequests;
            private long totalErrorRequests;
            private long totalRequestsInProgress;
            private long totalIssuedRequests;
            private final List<EndpointLoadMetricStats> loadMetricStatsList = new ArrayList<EndpointLoadMetricStats>();

            private Builder() {
            }

            Builder setLocality(Locality locality) {
                this.locality = (Locality)Preconditions.checkNotNull((Object)locality, (Object)"locality");
                return this;
            }

            Builder setTotalSuccessfulRequests(long totalSuccessfulRequests) {
                this.totalSuccessfulRequests = totalSuccessfulRequests;
                return this;
            }

            Builder setTotalErrorRequests(long totalErrorRequests) {
                this.totalErrorRequests = totalErrorRequests;
                return this;
            }

            Builder setTotalRequestsInProgress(long totalRequestsInProgress) {
                this.totalRequestsInProgress = totalRequestsInProgress;
                return this;
            }

            Builder setTotalIssuedRequests(long totalIssuedRequests) {
                this.totalIssuedRequests = totalIssuedRequests;
                return this;
            }

            Builder addLoadMetricStats(EndpointLoadMetricStats endpointLoadMetricStats) {
                this.loadMetricStatsList.add((EndpointLoadMetricStats)Preconditions.checkNotNull((Object)endpointLoadMetricStats, (Object)"endpointLoadMetricStats"));
                return this;
            }

            Builder addAllLoadMetricStats(Collection<EndpointLoadMetricStats> endpointLoadMetricStats) {
                this.loadMetricStatsList.addAll((Collection)Preconditions.checkNotNull(endpointLoadMetricStats, (Object)"endpointLoadMetricStats"));
                return this;
            }

            UpstreamLocalityStats build() {
                return new UpstreamLocalityStats(this.locality, this.totalSuccessfulRequests, this.totalErrorRequests, this.totalRequestsInProgress, this.totalIssuedRequests, this.loadMetricStatsList);
            }
        }
    }

    static final class ClusterStats {
        private final String clusterName;
        @Nullable
        private final String clusterServiceName;
        private final List<UpstreamLocalityStats> upstreamLocalityStatsList;
        private final List<DroppedRequests> droppedRequestsList;
        private final long totalDroppedRequests;
        private final long loadReportIntervalNanos;

        private ClusterStats(String clusterName, @Nullable String clusterServiceName, List<UpstreamLocalityStats> upstreamLocalityStatsList, List<DroppedRequests> droppedRequestsList, long totalDroppedRequests, long loadReportIntervalNanos) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.clusterServiceName = clusterServiceName;
            this.upstreamLocalityStatsList = Collections.unmodifiableList((List)Preconditions.checkNotNull(upstreamLocalityStatsList, (Object)"upstreamLocalityStatsList"));
            this.droppedRequestsList = Collections.unmodifiableList((List)Preconditions.checkNotNull(droppedRequestsList, (Object)"dropRequestsList"));
            this.totalDroppedRequests = totalDroppedRequests;
            this.loadReportIntervalNanos = loadReportIntervalNanos;
        }

        String getClusterName() {
            return this.clusterName;
        }

        @Nullable
        String getClusterServiceName() {
            return this.clusterServiceName;
        }

        List<UpstreamLocalityStats> getUpstreamLocalityStatsList() {
            return this.upstreamLocalityStatsList;
        }

        List<DroppedRequests> getDroppedRequestsList() {
            return this.droppedRequestsList;
        }

        long getTotalDroppedRequests() {
            return this.totalDroppedRequests;
        }

        long getLoadReportIntervalNanos() {
            return this.loadReportIntervalNanos;
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterStats toEnvoyProtoClusterStats() {
            ClusterStats.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterStats.newBuilder();
            builder.setClusterName(this.clusterName);
            if (this.clusterServiceName != null) {
                builder.setClusterServiceName(this.clusterServiceName);
            }
            for (UpstreamLocalityStats upstreamLocalityStats : this.upstreamLocalityStatsList) {
                builder.addUpstreamLocalityStats(upstreamLocalityStats.toEnvoyProtoUpstreamLocalityStats());
            }
            for (DroppedRequests droppedRequests : this.droppedRequestsList) {
                builder.addDroppedRequests(droppedRequests.toEnvoyProtoDroppedRequests());
            }
            builder.setTotalDroppedRequests(this.totalDroppedRequests);
            builder.setLoadReportInterval(Durations.fromNanos((long)this.loadReportIntervalNanos));
            return builder.build();
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.ClusterStats toEnvoyProtoClusterStatsV2() {
            ClusterStats.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.ClusterStats.newBuilder();
            builder.setClusterName(this.clusterName);
            for (UpstreamLocalityStats upstreamLocalityStats : this.upstreamLocalityStatsList) {
                builder.addUpstreamLocalityStats(upstreamLocalityStats.toEnvoyProtoUpstreamLocalityStatsV2());
            }
            for (DroppedRequests droppedRequests : this.droppedRequestsList) {
                builder.addDroppedRequests(droppedRequests.toEnvoyProtoDroppedRequestsV2());
            }
            builder.setTotalDroppedRequests(this.totalDroppedRequests);
            builder.setLoadReportInterval(Durations.fromNanos((long)this.loadReportIntervalNanos));
            return builder.build();
        }

        @VisibleForTesting
        Builder toBuilder() {
            Builder builder = new Builder().setClusterName(this.clusterName).setTotalDroppedRequests(this.totalDroppedRequests).setLoadReportIntervalNanos(this.loadReportIntervalNanos);
            if (this.clusterServiceName != null) {
                builder.setClusterServiceName(this.clusterServiceName);
            }
            for (UpstreamLocalityStats upstreamLocalityStats : this.upstreamLocalityStatsList) {
                builder.addUpstreamLocalityStats(upstreamLocalityStats);
            }
            for (DroppedRequests droppedRequests : this.droppedRequestsList) {
                builder.addDroppedRequests(droppedRequests);
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterStats that = (ClusterStats)o;
            return this.totalDroppedRequests == that.totalDroppedRequests && this.loadReportIntervalNanos == that.loadReportIntervalNanos && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.clusterServiceName, that.clusterServiceName) && Objects.equals(this.upstreamLocalityStatsList, that.upstreamLocalityStatsList) && Objects.equals(this.droppedRequestsList, that.droppedRequestsList);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.clusterServiceName, this.upstreamLocalityStatsList, this.droppedRequestsList, this.totalDroppedRequests, this.loadReportIntervalNanos);
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class DroppedRequests {
            private final String category;
            private final long droppedCount;

            DroppedRequests(String category, long droppedCount) {
                this.category = (String)Preconditions.checkNotNull((Object)category, (Object)"category");
                this.droppedCount = droppedCount;
            }

            String getCategory() {
                return this.category;
            }

            long getDroppedCount() {
                return this.droppedCount;
            }

            private ClusterStats.DroppedRequests toEnvoyProtoDroppedRequests() {
                return ClusterStats.DroppedRequests.newBuilder().setCategory(this.category).setDroppedCount(this.droppedCount).build();
            }

            private ClusterStats.DroppedRequests toEnvoyProtoDroppedRequestsV2() {
                return ClusterStats.DroppedRequests.newBuilder().setCategory(this.category).setDroppedCount(this.droppedCount).build();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DroppedRequests that = (DroppedRequests)o;
                return this.droppedCount == that.droppedCount && Objects.equals(this.category, that.category);
            }

            public int hashCode() {
                return Objects.hash(this.category, this.droppedCount);
            }
        }

        static final class Builder {
            private String clusterName;
            private String clusterServiceName;
            private final List<UpstreamLocalityStats> upstreamLocalityStatsList = new ArrayList<UpstreamLocalityStats>();
            private final List<DroppedRequests> droppedRequestsList = new ArrayList<DroppedRequests>();
            private long totalDroppedRequests;
            private long loadReportIntervalNanos;

            private Builder() {
            }

            Builder setClusterName(String clusterName) {
                this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
                return this;
            }

            Builder setClusterServiceName(String clusterServiceName) {
                this.clusterServiceName = (String)Preconditions.checkNotNull((Object)clusterServiceName, (Object)"clusterServiceName");
                return this;
            }

            Builder setTotalDroppedRequests(long totalDroppedRequests) {
                this.totalDroppedRequests = totalDroppedRequests;
                return this;
            }

            Builder setLoadReportIntervalNanos(long loadReportIntervalNanos) {
                this.loadReportIntervalNanos = loadReportIntervalNanos;
                return this;
            }

            Builder addUpstreamLocalityStats(UpstreamLocalityStats upstreamLocalityStats) {
                this.upstreamLocalityStatsList.add((UpstreamLocalityStats)Preconditions.checkNotNull((Object)upstreamLocalityStats, (Object)"upstreamLocalityStats"));
                return this;
            }

            Builder addAllUpstreamLocalityStats(Collection<UpstreamLocalityStats> upstreamLocalityStats) {
                this.upstreamLocalityStatsList.addAll(upstreamLocalityStats);
                return this;
            }

            Builder addDroppedRequests(DroppedRequests droppedRequests) {
                this.droppedRequestsList.add((DroppedRequests)Preconditions.checkNotNull((Object)droppedRequests, (Object)"dropRequests"));
                return this;
            }

            ClusterStats build() {
                return new ClusterStats(this.clusterName, this.clusterServiceName, this.upstreamLocalityStatsList, this.droppedRequestsList, this.totalDroppedRequests, this.loadReportIntervalNanos);
            }
        }
    }

    static final class ClusterWeight {
        private final String name;
        private final int weight;

        @VisibleForTesting
        ClusterWeight(String name, int weight) {
            this.name = name;
            this.weight = weight;
        }

        String getName() {
            return this.name;
        }

        int getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterWeight that = (ClusterWeight)o;
            return this.weight == that.weight && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.weight);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("weight", this.weight).toString();
        }

        @VisibleForTesting
        static ClusterWeight fromEnvoyProtoClusterWeight(WeightedCluster.ClusterWeight proto) {
            return new ClusterWeight(proto.getName(), proto.getWeight().getValue());
        }
    }

    static final class RouteAction {
        private final long timeoutNano;
        @Nullable
        private final String cluster;
        @Nullable
        private final List<ClusterWeight> weightedClusters;

        @VisibleForTesting
        RouteAction(long timeoutNano, @Nullable String cluster, @Nullable List<ClusterWeight> weightedClusters) {
            this.timeoutNano = timeoutNano;
            this.cluster = cluster;
            this.weightedClusters = weightedClusters;
        }

        Long getTimeoutNano() {
            return this.timeoutNano;
        }

        @Nullable
        String getCluster() {
            return this.cluster;
        }

        @Nullable
        List<ClusterWeight> getWeightedCluster() {
            return this.weightedClusters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteAction that = (RouteAction)o;
            return Objects.equals(this.timeoutNano, that.timeoutNano) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.weightedClusters, that.weightedClusters);
        }

        public int hashCode() {
            return Objects.hash(this.timeoutNano, this.cluster, this.weightedClusters);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("timeout", (Object)(this.timeoutNano + "ns"));
            if (this.cluster != null) {
                toStringHelper.add("cluster", (Object)this.cluster);
            }
            if (this.weightedClusters != null) {
                toStringHelper.add("weightedClusters", this.weightedClusters);
            }
            return toStringHelper.toString();
        }

        @Nullable
        @VisibleForTesting
        static StructOrError<RouteAction> fromEnvoyProtoRouteAction(io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteAction proto) {
            String cluster = null;
            ArrayList<ClusterWeight> weightedClusters = null;
            switch (proto.getClusterSpecifierCase()) {
                case CLUSTER: {
                    cluster = proto.getCluster();
                    break;
                }
                case CLUSTER_HEADER: {
                    return null;
                }
                case WEIGHTED_CLUSTERS: {
                    List<WeightedCluster.ClusterWeight> clusterWeights = proto.getWeightedClusters().getClustersList();
                    if (clusterWeights.isEmpty()) {
                        return StructOrError.fromError("No cluster found in weighted cluster list");
                    }
                    weightedClusters = new ArrayList<ClusterWeight>();
                    for (WeightedCluster.ClusterWeight clusterWeight : clusterWeights) {
                        weightedClusters.add(ClusterWeight.fromEnvoyProtoClusterWeight(clusterWeight));
                    }
                    break;
                }
                default: {
                    return StructOrError.fromError("Unknown cluster specifier: " + (Object)((Object)proto.getClusterSpecifierCase()));
                }
            }
            long timeoutNano = TimeUnit.SECONDS.toNanos(15L);
            if (proto.hasMaxGrpcTimeout()) {
                timeoutNano = Durations.toNanos((Duration)proto.getMaxGrpcTimeout());
            } else if (proto.hasTimeout()) {
                timeoutNano = Durations.toNanos((Duration)proto.getTimeout());
            }
            if (timeoutNano == 0L) {
                timeoutNano = Long.MAX_VALUE;
            }
            return StructOrError.fromStruct(new RouteAction(timeoutNano, cluster, weightedClusters));
        }
    }

    static final class Route {
        private final io.grpc.xds.RouteMatch routeMatch;
        private final RouteAction routeAction;

        @VisibleForTesting
        Route(io.grpc.xds.RouteMatch routeMatch, @Nullable RouteAction routeAction) {
            this.routeMatch = routeMatch;
            this.routeAction = routeAction;
        }

        io.grpc.xds.RouteMatch getRouteMatch() {
            return this.routeMatch;
        }

        RouteAction getRouteAction() {
            return this.routeAction;
        }

        boolean isDefaultRoute() {
            String prefix = this.routeMatch.getPathMatch().getPrefix();
            if (prefix != null) {
                return prefix.isEmpty() || prefix.equals("/");
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Route route = (Route)o;
            return Objects.equals(this.routeMatch, route.routeMatch) && Objects.equals(this.routeAction, route.routeAction);
        }

        public int hashCode() {
            return Objects.hash(this.routeMatch, this.routeAction);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("routeMatch", (Object)this.routeMatch).add("routeAction", (Object)this.routeAction).toString();
        }

        @Nullable
        static StructOrError<Route> fromEnvoyProtoRoute(io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.Route proto) {
            StructOrError<RouteAction> routeAction;
            StructOrError<io.grpc.xds.RouteMatch> routeMatch = Route.convertEnvoyProtoRouteMatch(proto.getMatch());
            if (routeMatch == null) {
                return null;
            }
            if (routeMatch.getErrorDetail() != null) {
                return StructOrError.fromError("Invalid route [" + proto.getName() + "]: " + routeMatch.getErrorDetail());
            }
            switch (proto.getActionCase()) {
                case ROUTE: {
                    routeAction = RouteAction.fromEnvoyProtoRouteAction(proto.getRoute());
                    break;
                }
                case REDIRECT: {
                    return StructOrError.fromError("Unsupported action type: redirect");
                }
                case DIRECT_RESPONSE: {
                    return StructOrError.fromError("Unsupported action type: direct_response");
                }
                case FILTER_ACTION: {
                    return StructOrError.fromError("Unsupported action type: filter_action");
                }
                default: {
                    return StructOrError.fromError("Unknown action type: " + (Object)((Object)proto.getActionCase()));
                }
            }
            if (routeAction == null) {
                return null;
            }
            if (routeAction.getErrorDetail() != null) {
                return StructOrError.fromError("Invalid route [" + proto.getName() + "]: " + routeAction.getErrorDetail());
            }
            return StructOrError.fromStruct(new Route(routeMatch.getStruct(), routeAction.getStruct()));
        }

        @Nullable
        @VisibleForTesting
        static StructOrError<io.grpc.xds.RouteMatch> convertEnvoyProtoRouteMatch(RouteMatch proto) {
            if (proto.getQueryParametersCount() != 0) {
                return null;
            }
            if (proto.hasCaseSensitive() && !proto.getCaseSensitive().getValue()) {
                return StructOrError.fromError("Unsupported match option: case insensitive");
            }
            StructOrError<RouteMatch.PathMatcher> pathMatch = Route.convertEnvoyProtoPathMatcher(proto);
            if (pathMatch.getErrorDetail() != null) {
                return StructOrError.fromError(pathMatch.getErrorDetail());
            }
            RouteMatch.FractionMatcher fractionMatch = null;
            if (proto.hasRuntimeFraction()) {
                StructOrError<RouteMatch.FractionMatcher> parsedFraction = Route.convertEnvoyProtoFraction(proto.getRuntimeFraction().getDefaultValue());
                if (parsedFraction.getErrorDetail() != null) {
                    return StructOrError.fromError(parsedFraction.getErrorDetail());
                }
                fractionMatch = parsedFraction.getStruct();
            }
            ArrayList<RouteMatch.HeaderMatcher> headerMatchers = new ArrayList<RouteMatch.HeaderMatcher>();
            for (HeaderMatcher hmProto : proto.getHeadersList()) {
                StructOrError<RouteMatch.HeaderMatcher> headerMatcher = Route.convertEnvoyProtoHeaderMatcher(hmProto);
                if (headerMatcher.getErrorDetail() != null) {
                    return StructOrError.fromError(headerMatcher.getErrorDetail());
                }
                headerMatchers.add(headerMatcher.getStruct());
            }
            return StructOrError.fromStruct(new io.grpc.xds.RouteMatch(pathMatch.getStruct(), Collections.unmodifiableList(headerMatchers), fractionMatch));
        }

        private static StructOrError<RouteMatch.PathMatcher> convertEnvoyProtoPathMatcher(RouteMatch proto) {
            String path = null;
            String prefix = null;
            Pattern safeRegEx = null;
            switch (proto.getPathSpecifierCase()) {
                case PREFIX: {
                    prefix = proto.getPrefix();
                    break;
                }
                case PATH: {
                    path = proto.getPath();
                    break;
                }
                case SAFE_REGEX: {
                    String rawPattern = proto.getSafeRegex().getRegex();
                    try {
                        safeRegEx = Pattern.compile((String)rawPattern);
                        break;
                    }
                    catch (PatternSyntaxException e) {
                        return StructOrError.fromError("Malformed safe regex pattern: " + e.getMessage());
                    }
                }
                default: {
                    return StructOrError.fromError("Unknown path match type");
                }
            }
            return StructOrError.fromStruct(new RouteMatch.PathMatcher(path, prefix, safeRegEx));
        }

        private static StructOrError<RouteMatch.FractionMatcher> convertEnvoyProtoFraction(io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent proto) {
            int numerator = proto.getNumerator();
            int denominator = 0;
            switch (proto.getDenominator()) {
                case HUNDRED: {
                    denominator = 100;
                    break;
                }
                case TEN_THOUSAND: {
                    denominator = 10000;
                    break;
                }
                case MILLION: {
                    denominator = 1000000;
                    break;
                }
                default: {
                    return StructOrError.fromError("Unrecognized fractional percent denominator: " + (Object)((Object)proto.getDenominator()));
                }
            }
            return StructOrError.fromStruct(new RouteMatch.FractionMatcher(numerator, denominator));
        }

        @VisibleForTesting
        static StructOrError<RouteMatch.HeaderMatcher> convertEnvoyProtoHeaderMatcher(HeaderMatcher proto) {
            String exactMatch = null;
            Pattern safeRegExMatch = null;
            RouteMatch.HeaderMatcher.Range rangeMatch = null;
            Boolean presentMatch = null;
            String prefixMatch = null;
            String suffixMatch = null;
            switch (proto.getHeaderMatchSpecifierCase()) {
                case EXACT_MATCH: {
                    exactMatch = proto.getExactMatch();
                    break;
                }
                case SAFE_REGEX_MATCH: {
                    String rawPattern = proto.getSafeRegexMatch().getRegex();
                    try {
                        safeRegExMatch = Pattern.compile((String)rawPattern);
                        break;
                    }
                    catch (PatternSyntaxException e) {
                        return StructOrError.fromError("HeaderMatcher [" + proto.getName() + "] contains malformed safe regex pattern: " + e.getMessage());
                    }
                }
                case RANGE_MATCH: {
                    rangeMatch = new RouteMatch.HeaderMatcher.Range(proto.getRangeMatch().getStart(), proto.getRangeMatch().getEnd());
                    break;
                }
                case PRESENT_MATCH: {
                    presentMatch = proto.getPresentMatch();
                    break;
                }
                case PREFIX_MATCH: {
                    prefixMatch = proto.getPrefixMatch();
                    break;
                }
                case SUFFIX_MATCH: {
                    suffixMatch = proto.getSuffixMatch();
                    break;
                }
                default: {
                    return StructOrError.fromError("Unknown header matcher type");
                }
            }
            return StructOrError.fromStruct(new RouteMatch.HeaderMatcher(proto.getName(), exactMatch, safeRegExMatch, rangeMatch, presentMatch, prefixMatch, suffixMatch, proto.getInvertMatch()));
        }
    }

    static final class DropOverload {
        private final String category;
        private final int dropsPerMillion;

        @VisibleForTesting
        DropOverload(String category, int dropsPerMillion) {
            this.category = category;
            this.dropsPerMillion = dropsPerMillion;
        }

        static DropOverload fromEnvoyProtoDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
            io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent percent = proto.getDropPercentage();
            int numerator = percent.getNumerator();
            FractionalPercent.DenominatorType type = percent.getDenominator();
            switch (type) {
                case TEN_THOUSAND: {
                    numerator *= 100;
                    break;
                }
                case HUNDRED: {
                    numerator *= 10000;
                    break;
                }
                case MILLION: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown denominator type of " + percent);
                }
            }
            if (numerator > 1000000) {
                numerator = 1000000;
            }
            return new DropOverload(proto.getCategory(), numerator);
        }

        @VisibleForTesting
        static DropOverload fromEnvoyProtoDropOverloadV2(ClusterLoadAssignment.Policy.DropOverload proto) {
            FractionalPercent percent = proto.getDropPercentage();
            int numerator = percent.getNumerator();
            FractionalPercent.DenominatorType type = percent.getDenominator();
            switch (type) {
                case TEN_THOUSAND: {
                    numerator *= 100;
                    break;
                }
                case HUNDRED: {
                    numerator *= 10000;
                    break;
                }
                case MILLION: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown denominator type of " + percent);
                }
            }
            if (numerator > 1000000) {
                numerator = 1000000;
            }
            return new DropOverload(proto.getCategory(), numerator);
        }

        String getCategory() {
            return this.category;
        }

        int getDropsPerMillion() {
            return this.dropsPerMillion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DropOverload that = (DropOverload)o;
            return this.dropsPerMillion == that.dropsPerMillion && Objects.equals(this.category, that.category);
        }

        public int hashCode() {
            return Objects.hash(this.category, this.dropsPerMillion);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("category", (Object)this.category).add("dropsPerMillion", this.dropsPerMillion).toString();
        }
    }

    static final class LbEndpoint {
        private final EquivalentAddressGroup eag;
        private final int loadBalancingWeight;
        private final boolean isHealthy;

        @VisibleForTesting
        LbEndpoint(String address, int port, int loadBalancingWeight, boolean isHealthy) {
            this(new EquivalentAddressGroup((java.net.SocketAddress)new InetSocketAddress(address, port)), loadBalancingWeight, isHealthy);
        }

        @VisibleForTesting
        LbEndpoint(EquivalentAddressGroup eag, int loadBalancingWeight, boolean isHealthy) {
            this.eag = eag;
            this.loadBalancingWeight = loadBalancingWeight;
            this.isHealthy = isHealthy;
        }

        static LbEndpoint fromEnvoyProtoLbEndpoint(io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint proto) {
            io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress socketAddress = proto.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            return new LbEndpoint(new EquivalentAddressGroup((List)ImmutableList.of((Object)addr)), proto.getLoadBalancingWeight().getValue(), proto.getHealthStatus() == io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus.HEALTHY || proto.getHealthStatus() == io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus.UNKNOWN);
        }

        private static LbEndpoint fromEnvoyProtoLbEndpointV2(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LbEndpoint proto) {
            SocketAddress socketAddress = proto.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            return new LbEndpoint(new EquivalentAddressGroup((List)ImmutableList.of((Object)addr)), proto.getLoadBalancingWeight().getValue(), proto.getHealthStatus() == HealthStatus.HEALTHY || proto.getHealthStatus() == HealthStatus.UNKNOWN);
        }

        EquivalentAddressGroup getAddress() {
            return this.eag;
        }

        int getLoadBalancingWeight() {
            return this.loadBalancingWeight;
        }

        boolean isHealthy() {
            return this.isHealthy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LbEndpoint that = (LbEndpoint)o;
            return this.loadBalancingWeight == that.loadBalancingWeight && Objects.equals(this.eag, that.eag) && this.isHealthy == that.isHealthy;
        }

        public int hashCode() {
            return Objects.hash(this.eag, this.loadBalancingWeight, this.isHealthy);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("eag", (Object)this.eag).add("loadBalancingWeight", this.loadBalancingWeight).add("isHealthy", this.isHealthy).toString();
        }
    }

    static final class LocalityLbEndpoints {
        private final List<LbEndpoint> endpoints;
        private final int localityWeight;
        private final int priority;

        @VisibleForTesting
        LocalityLbEndpoints(List<LbEndpoint> endpoints, int localityWeight, int priority) {
            this.endpoints = endpoints;
            this.localityWeight = localityWeight;
            this.priority = priority;
        }

        static LocalityLbEndpoints fromEnvoyProtoLocalityLbEndpoints(io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints proto) {
            ArrayList<LbEndpoint> endpoints = new ArrayList<LbEndpoint>(proto.getLbEndpointsCount());
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint endpoint : proto.getLbEndpointsList()) {
                endpoints.add(LbEndpoint.fromEnvoyProtoLbEndpoint(endpoint));
            }
            return new LocalityLbEndpoints(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority());
        }

        @VisibleForTesting
        static LocalityLbEndpoints fromEnvoyProtoLocalityLbEndpointsV2(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LocalityLbEndpoints proto) {
            ArrayList<LbEndpoint> endpoints = new ArrayList<LbEndpoint>(proto.getLbEndpointsCount());
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LbEndpoint endpoint : proto.getLbEndpointsList()) {
                endpoints.add(LbEndpoint.fromEnvoyProtoLbEndpointV2(endpoint));
            }
            return new LocalityLbEndpoints(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority());
        }

        List<LbEndpoint> getEndpoints() {
            return Collections.unmodifiableList(this.endpoints);
        }

        int getLocalityWeight() {
            return this.localityWeight;
        }

        int getPriority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalityLbEndpoints that = (LocalityLbEndpoints)o;
            return this.localityWeight == that.localityWeight && this.priority == that.priority && Objects.equals(this.endpoints, that.endpoints);
        }

        public int hashCode() {
            return Objects.hash(this.endpoints, this.localityWeight, this.priority);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("endpoints", this.endpoints).add("localityWeight", this.localityWeight).add("priority", this.priority).toString();
        }
    }

    static final class Locality {
        private final String region;
        private final String zone;
        private final String subZone;

        Locality(@Nullable String region, @Nullable String zone, @Nullable String subZone) {
            this.region = region == null ? "" : region;
            this.zone = zone == null ? "" : zone;
            this.subZone = subZone == null ? "" : subZone;
        }

        static Locality fromEnvoyProtoLocality(io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality locality) {
            return new Locality(locality.getRegion(), locality.getZone(), locality.getSubZone());
        }

        @VisibleForTesting
        static Locality fromEnvoyProtoLocalityV2(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality locality) {
            return new Locality(locality.getRegion(), locality.getZone(), locality.getSubZone());
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality toEnvoyProtoLocality() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality.newBuilder().setRegion(this.region).setZone(this.zone).setSubZone(this.subZone).build();
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality toEnvoyProtoLocalityV2() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality.newBuilder().setRegion(this.region).setZone(this.zone).setSubZone(this.subZone).build();
        }

        String getRegion() {
            return this.region;
        }

        String getZone() {
            return this.zone;
        }

        String getSubZone() {
            return this.subZone;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Locality locality = (Locality)o;
            return Objects.equals(this.region, locality.region) && Objects.equals(this.zone, locality.zone) && Objects.equals(this.subZone, locality.subZone);
        }

        public int hashCode() {
            return Objects.hash(this.region, this.zone, this.subZone);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("region", (Object)this.region).add("zone", (Object)this.zone).add("subZone", (Object)this.subZone).toString();
        }
    }

    static final class Address {
        private final String address;
        private final int port;

        Address(String address, int port) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.port = port;
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address toEnvoyProtoAddress() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address.newBuilder().setSocketAddress(io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress.newBuilder().setAddress(this.address).setPortValue(this.port)).build();
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Address toEnvoyProtoAddressV2() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Address.newBuilder().setSocketAddress(SocketAddress.newBuilder().setAddress(this.address).setPortValue(this.port)).build();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("port", this.port).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Address address1 = (Address)o;
            return this.port == address1.port && Objects.equals(this.address, address1.address);
        }

        public int hashCode() {
            return Objects.hash(this.address, this.port);
        }
    }

    public static final class Node {
        private final String id;
        private final String cluster;
        @Nullable
        private final Map<String, ?> metadata;
        @Nullable
        private final Locality locality;
        private final List<Address> listeningAddresses;
        private final String buildVersion;
        private final String userAgentName;
        @Nullable
        private final String userAgentVersion;
        private final List<String> clientFeatures;

        private Node(String id, String cluster, @Nullable Map<String, ?> metadata, @Nullable Locality locality, List<Address> listeningAddresses, String buildVersion, String userAgentName, @Nullable String userAgentVersion, List<String> clientFeatures) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.cluster = (String)Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
            this.metadata = metadata;
            this.locality = locality;
            this.listeningAddresses = Collections.unmodifiableList((List)Preconditions.checkNotNull(listeningAddresses, (Object)"listeningAddresses"));
            this.buildVersion = (String)Preconditions.checkNotNull((Object)buildVersion, (Object)"buildVersion");
            this.userAgentName = (String)Preconditions.checkNotNull((Object)userAgentName, (Object)"userAgentName");
            this.userAgentVersion = userAgentVersion;
            this.clientFeatures = Collections.unmodifiableList((List)Preconditions.checkNotNull(clientFeatures, (Object)"clientFeatures"));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("cluster", (Object)this.cluster).add("metadata", this.metadata).add("locality", (Object)this.locality).add("listeningAddresses", this.listeningAddresses).add("buildVersion", (Object)this.buildVersion).add("userAgentName", (Object)this.userAgentName).add("userAgentVersion", (Object)this.userAgentVersion).add("clientFeatures", this.clientFeatures).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.id, node.id) && Objects.equals(this.cluster, node.cluster) && Objects.equals(this.metadata, node.metadata) && Objects.equals(this.locality, node.locality) && Objects.equals(this.listeningAddresses, node.listeningAddresses) && Objects.equals(this.buildVersion, node.buildVersion) && Objects.equals(this.userAgentName, node.userAgentName) && Objects.equals(this.userAgentVersion, node.userAgentVersion) && Objects.equals(this.clientFeatures, node.clientFeatures);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.cluster, this.metadata, this.locality, this.listeningAddresses, this.buildVersion, this.userAgentName, this.userAgentVersion, this.clientFeatures);
        }

        static Builder newBuilder() {
            return new Builder();
        }

        Builder toBuilder() {
            Builder builder = new Builder().setId(this.id).setCluster(this.cluster);
            if (this.metadata != null) {
                builder.setMetadata(this.metadata);
            }
            if (this.locality != null) {
                builder.setLocality(this.locality);
            }
            builder.listeningAddresses.addAll(this.listeningAddresses);
            return builder;
        }

        String getId() {
            return this.id;
        }

        String getCluster() {
            return this.cluster;
        }

        @Nullable
        Map<String, ?> getMetadata() {
            return this.metadata;
        }

        @Nullable
        Locality getLocality() {
            return this.locality;
        }

        List<Address> getListeningAddresses() {
            return this.listeningAddresses;
        }

        @VisibleForTesting
        public io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node toEnvoyProtoNode() {
            Node.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node.newBuilder();
            builder.setId(this.id);
            builder.setCluster(this.cluster);
            if (this.metadata != null) {
                Struct.Builder structBuilder = Struct.newBuilder();
                for (Map.Entry<String, ?> entry : this.metadata.entrySet()) {
                    structBuilder.putFields(entry.getKey(), EnvoyProtoData.convertToValue(entry.getValue()));
                }
                builder.setMetadata(structBuilder);
            }
            if (this.locality != null) {
                builder.setLocality(this.locality.toEnvoyProtoLocality());
            }
            for (Address address : this.listeningAddresses) {
                builder.addListeningAddresses(address.toEnvoyProtoAddress());
            }
            builder.setUserAgentName(this.userAgentName);
            if (this.userAgentVersion != null) {
                builder.setUserAgentVersion(this.userAgentVersion);
            }
            builder.addAllClientFeatures(this.clientFeatures);
            return builder.build();
        }

        public io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node toEnvoyProtoNodeV2() {
            Node.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node.newBuilder();
            builder.setId(this.id);
            builder.setCluster(this.cluster);
            if (this.metadata != null) {
                Struct.Builder structBuilder = Struct.newBuilder();
                for (Map.Entry<String, ?> entry : this.metadata.entrySet()) {
                    structBuilder.putFields(entry.getKey(), EnvoyProtoData.convertToValue(entry.getValue()));
                }
                builder.setMetadata(structBuilder);
            }
            if (this.locality != null) {
                builder.setLocality(this.locality.toEnvoyProtoLocalityV2());
            }
            for (Address address : this.listeningAddresses) {
                builder.addListeningAddresses(address.toEnvoyProtoAddressV2());
            }
            builder.setBuildVersion(this.buildVersion);
            builder.setUserAgentName(this.userAgentName);
            if (this.userAgentVersion != null) {
                builder.setUserAgentVersion(this.userAgentVersion);
            }
            builder.addAllClientFeatures(this.clientFeatures);
            return builder.build();
        }

        static final class Builder {
            private String id = "";
            private String cluster = "";
            @Nullable
            private Map<String, ?> metadata;
            @Nullable
            private Locality locality;
            private final List<Address> listeningAddresses = new ArrayList<Address>();
            private String buildVersion = "";
            private String userAgentName = "";
            @Nullable
            private String userAgentVersion;
            private final List<String> clientFeatures = new ArrayList<String>();

            private Builder() {
            }

            Builder setId(String id) {
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
                return this;
            }

            Builder setCluster(String cluster) {
                this.cluster = (String)Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
                return this;
            }

            Builder setMetadata(Map<String, ?> metadata) {
                this.metadata = (Map)Preconditions.checkNotNull(metadata, (Object)"metadata");
                return this;
            }

            Builder setLocality(Locality locality) {
                this.locality = (Locality)Preconditions.checkNotNull((Object)locality, (Object)"locality");
                return this;
            }

            Builder addListeningAddresses(Address address) {
                this.listeningAddresses.add((Address)Preconditions.checkNotNull((Object)address, (Object)"address"));
                return this;
            }

            Builder setBuildVersion(String buildVersion) {
                this.buildVersion = (String)Preconditions.checkNotNull((Object)buildVersion, (Object)"buildVersion");
                return this;
            }

            Builder setUserAgentName(String userAgentName) {
                this.userAgentName = (String)Preconditions.checkNotNull((Object)userAgentName, (Object)"userAgentName");
                return this;
            }

            Builder setUserAgentVersion(String userAgentVersion) {
                this.userAgentVersion = (String)Preconditions.checkNotNull((Object)userAgentVersion, (Object)"userAgentVersion");
                return this;
            }

            Builder addClientFeatures(String clientFeature) {
                this.clientFeatures.add((String)Preconditions.checkNotNull((Object)clientFeature, (Object)"clientFeature"));
                return this;
            }

            Node build() {
                return new Node(this.id, this.cluster, this.metadata, this.locality, this.listeningAddresses, this.buildVersion, this.userAgentName, this.userAgentVersion, this.clientFeatures);
            }
        }
    }

    static final class StructOrError<T> {
        private final String errorDetail;
        private final T struct;

        static <T> StructOrError<T> fromStruct(T struct) {
            return new StructOrError<T>(struct);
        }

        static <T> StructOrError<T> fromError(String errorDetail) {
            return new StructOrError<T>(errorDetail);
        }

        private StructOrError(T struct) {
            this.struct = Preconditions.checkNotNull(struct, (Object)"struct");
            this.errorDetail = null;
        }

        private StructOrError(String errorDetail) {
            this.struct = null;
            this.errorDetail = (String)Preconditions.checkNotNull((Object)errorDetail, (Object)"errorDetail");
        }

        @Nullable
        public T getStruct() {
            return this.struct;
        }

        @Nullable
        String getErrorDetail() {
            return this.errorDetail;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructOrError that = (StructOrError)o;
            return Objects.equals(this.errorDetail, that.errorDetail) && Objects.equals(this.struct, that.struct);
        }

        public int hashCode() {
            return Objects.hash(this.errorDetail, this.struct);
        }

        public String toString() {
            if (this.struct != null) {
                return MoreObjects.toStringHelper((Object)this).add("struct", this.struct).toString();
            }
            assert (this.errorDetail != null);
            return MoreObjects.toStringHelper((Object)this).add("error", (Object)this.errorDetail).toString();
        }
    }
}

