/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Duration;
import com.google.protobuf.ProtocolStringList;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.InternalLogId;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.internal.certprovider.CertificateProvider;
import io.grpc.xds.internal.sds.trust.CertificateUtils;
import io.grpc.xds.shaded.com.google.security.meshca.v1.MeshCertificateRequest;
import io.grpc.xds.shaded.com.google.security.meshca.v1.MeshCertificateResponse;
import io.grpc.xds.shaded.com.google.security.meshca.v1.MeshCertificateServiceGrpc;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

final class MeshCaCertificateProvider
extends CertificateProvider {
    private static final Logger logger = Logger.getLogger(MeshCaCertificateProvider.class.getName());
    @VisibleForTesting
    static final Metadata.Key<String> KEY_FOR_ZONE_INFO = Metadata.Key.of((String)"x-goog-request-params", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final long INITIAL_DELAY_SECONDS = 4L;
    private static final EnumSet<Status.Code> RETRIABLE_CODES = EnumSet.of(Status.Code.CANCELLED, new Status.Code[]{Status.Code.UNKNOWN, Status.Code.DEADLINE_EXCEEDED, Status.Code.RESOURCE_EXHAUSTED, Status.Code.ABORTED, Status.Code.INTERNAL, Status.Code.UNAVAILABLE});
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService scheduledExecutorService;
    private final int maxRetryAttempts;
    private final ZoneInfoClientInterceptor headerInterceptor;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final String meshCaUrl;
    private final long validitySeconds;
    private final long renewalGracePeriodSeconds;
    private final int keySize;
    private final String signatureAlg;
    private final GoogleCredentials oauth2Creds;
    private final TimeProvider timeProvider;
    private final MeshCaChannelFactory meshCaChannelFactory;
    @VisibleForTesting
    SynchronizationContext.ScheduledHandle scheduledHandle;
    private final long rpcTimeoutMillis;

    MeshCaCertificateProvider(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String meshCaUrl, String zone, long validitySeconds, int keySize, String unused, String signatureAlg, MeshCaChannelFactory meshCaChannelFactory, BackoffPolicy.Provider backoffPolicyProvider, long renewalGracePeriodSeconds, int maxRetryAttempts, GoogleCredentials oauth2Creds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider, long rpcTimeoutMillis) {
        super(watcher, notifyCertUpdates);
        this.meshCaUrl = (String)Preconditions.checkNotNull((Object)meshCaUrl, (Object)"meshCaUrl");
        Preconditions.checkArgument((validitySeconds > 4L ? 1 : 0) != 0, (Object)"validitySeconds must be greater than 4");
        this.validitySeconds = validitySeconds;
        this.keySize = keySize;
        this.signatureAlg = (String)Preconditions.checkNotNull((Object)signatureAlg, (Object)"signatureAlg");
        this.meshCaChannelFactory = (MeshCaChannelFactory)Preconditions.checkNotNull((Object)meshCaChannelFactory, (Object)"meshCaChannelFactory");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        Preconditions.checkArgument((renewalGracePeriodSeconds > 0L && renewalGracePeriodSeconds < validitySeconds ? 1 : 0) != 0, (Object)("renewalGracePeriodSeconds should be between 0 and " + validitySeconds));
        this.renewalGracePeriodSeconds = renewalGracePeriodSeconds;
        Preconditions.checkArgument((maxRetryAttempts >= 0 ? 1 : 0) != 0, (Object)"maxRetryAttempts must be >= 0");
        this.maxRetryAttempts = maxRetryAttempts;
        this.oauth2Creds = (GoogleCredentials)Preconditions.checkNotNull((Object)oauth2Creds, (Object)"oauth2Creds");
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService");
        this.timeProvider = (TimeProvider)Preconditions.checkNotNull((Object)timeProvider, (Object)"timeProvider");
        this.headerInterceptor = new ZoneInfoClientInterceptor((String)Preconditions.checkNotNull((Object)zone, (Object)"zone"));
        this.syncContext = this.createSynchronizationContext(meshCaUrl);
        this.rpcTimeoutMillis = rpcTimeoutMillis;
    }

    private SynchronizationContext createSynchronizationContext(String details) {
        final InternalLogId logId = InternalLogId.allocate((String)"MeshCaCertificateProvider", (String)details);
        return new SynchronizationContext(new Thread.UncaughtExceptionHandler(){
            private boolean panicMode;

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "[" + logId + "] Uncaught exception in the SynchronizationContext. Panic!", e);
                this.panic(e);
            }

            void panic(Throwable t) {
                if (this.panicMode) {
                    return;
                }
                this.panicMode = true;
                MeshCaCertificateProvider.this.close();
            }
        });
    }

    @Override
    public void start() {
        this.scheduleNextRefreshCertificate(4L);
    }

    @Override
    public void close() {
        if (this.scheduledHandle != null) {
            this.scheduledHandle.cancel();
            this.scheduledHandle = null;
        }
        this.getWatcher().close();
    }

    private void scheduleNextRefreshCertificate(long delayInSeconds) {
        if (this.scheduledHandle != null && this.scheduledHandle.isPending()) {
            logger.log(Level.SEVERE, "Pending task found: inconsistent state in scheduledHandle!");
            this.scheduledHandle.cancel();
        }
        RefreshCertificateTask runnable = new RefreshCertificateTask();
        this.scheduledHandle = this.syncContext.schedule((Runnable)runnable, delayInSeconds, TimeUnit.SECONDS, this.scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void refreshCertificate() throws NoSuchAlgorithmException, IOException, OperatorCreationException {
        long refreshDelaySeconds = this.computeRefreshSecondsFromCurrentCertExpiry();
        ManagedChannel channel = this.meshCaChannelFactory.createChannel(this.meshCaUrl);
        try {
            String uniqueReqIdForAllRetries = UUID.randomUUID().toString();
            Duration duration = Duration.newBuilder().setSeconds(this.validitySeconds).build();
            KeyPair keyPair = this.generateKeyPair();
            String csr = this.generateCsr(keyPair);
            MeshCertificateServiceGrpc.MeshCertificateServiceBlockingStub stub = this.createStubToMeshCa(channel);
            List<X509Certificate> x509Chain = this.makeRequestWithRetries(stub, uniqueReqIdForAllRetries, duration, csr);
            if (x509Chain != null) {
                refreshDelaySeconds = this.computeDelaySecondsToCertExpiry(x509Chain.get(0)) - this.renewalGracePeriodSeconds;
                this.getWatcher().updateCertificate(keyPair.getPrivate(), x509Chain);
                this.getWatcher().updateTrustedRoots((List<X509Certificate>)ImmutableList.of((Object)x509Chain.get(x509Chain.size() - 1)));
            }
        }
        finally {
            MeshCaCertificateProvider.shutdownChannel(channel);
            this.scheduleNextRefreshCertificate(refreshDelaySeconds);
        }
    }

    private MeshCertificateServiceGrpc.MeshCertificateServiceBlockingStub createStubToMeshCa(ManagedChannel channel) {
        return (MeshCertificateServiceGrpc.MeshCertificateServiceBlockingStub)((MeshCertificateServiceGrpc.MeshCertificateServiceBlockingStub)MeshCertificateServiceGrpc.newBlockingStub((Channel)channel).withCallCredentials(MoreCallCredentials.from((Credentials)this.oauth2Creds))).withInterceptors(new ClientInterceptor[]{this.headerInterceptor});
    }

    private List<X509Certificate> makeRequestWithRetries(MeshCertificateServiceGrpc.MeshCertificateServiceBlockingStub stub, String reqId, Duration duration, String csr) {
        MeshCertificateRequest request = MeshCertificateRequest.newBuilder().setValidity(duration).setCsr(csr).setRequestId(reqId).build();
        BackoffPolicy backoffPolicy = this.backoffPolicyProvider.get();
        Throwable lastException = null;
        for (int i = 0; i <= this.maxRetryAttempts; ++i) {
            try {
                MeshCertificateResponse response = ((MeshCertificateServiceGrpc.MeshCertificateServiceBlockingStub)stub.withDeadlineAfter(this.rpcTimeoutMillis, TimeUnit.MILLISECONDS)).createCertificate(request);
                return this.getX509CertificatesFromResponse(response);
            }
            catch (Throwable t) {
                if (!MeshCaCertificateProvider.retriable(t)) {
                    this.generateErrorIfCurrentCertExpired(t);
                    return null;
                }
                lastException = t;
                this.sleepForNanos(backoffPolicy.nextBackoffNanos());
                continue;
            }
        }
        this.generateErrorIfCurrentCertExpired(lastException);
        return null;
    }

    private void sleepForNanos(long nanos) {
        ScheduledFuture<?> future = this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
            }
        }, nanos, TimeUnit.NANOSECONDS);
        try {
            future.get(nanos, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ie) {
            logger.log(Level.SEVERE, "Inside sleep", ie);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException ex) {
            logger.log(Level.SEVERE, "Inside sleep", ex);
        }
    }

    private static boolean retriable(Throwable t) {
        return RETRIABLE_CODES.contains(Status.fromThrowable((Throwable)t).getCode());
    }

    private void generateErrorIfCurrentCertExpired(Throwable t) {
        X509Certificate currentCert = this.getWatcher().getLastIdentityCert();
        if (currentCert != null) {
            long delaySeconds = this.computeDelaySecondsToCertExpiry(currentCert);
            if (delaySeconds > 4L) {
                return;
            }
            this.getWatcher().clearValues();
        }
        this.getWatcher().onError(Status.fromThrowable((Throwable)t));
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(this.keySize);
        return keyPairGenerator.generateKeyPair();
    }

    private String generateCsr(KeyPair pair) throws IOException, OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal("CN=EXAMPLE.COM"), pair.getPublic());
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(this.signatureAlg);
        ContentSigner signer = csBuilder.build(pair.getPrivate());
        PKCS10CertificationRequest csr = p10Builder.build(signer);
        PemObject pemObject = new PemObject("NEW CERTIFICATE REQUEST", csr.getEncoded());
        try (StringWriter str = new StringWriter();){
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)str);){
                pemWriter.writeObject((PemObjectGenerator)pemObject);
            }
            String string = str.toString();
            return string;
        }
    }

    private long computeRefreshSecondsFromCurrentCertExpiry() {
        X509Certificate lastCert = this.getWatcher().getLastIdentityCert();
        if (lastCert == null) {
            return 4L;
        }
        long delayToCertExpirySeconds = this.computeDelaySecondsToCertExpiry(lastCert) / 2L;
        return Math.max(delayToCertExpirySeconds, 4L);
    }

    private long computeDelaySecondsToCertExpiry(X509Certificate lastCert) {
        Preconditions.checkNotNull((Object)lastCert, (Object)"lastCert");
        return TimeUnit.NANOSECONDS.toSeconds(TimeUnit.MILLISECONDS.toNanos(lastCert.getNotAfter().getTime()) - this.timeProvider.currentTimeNanos());
    }

    private static void shutdownChannel(ManagedChannel channel) {
        channel.shutdown();
        try {
            channel.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "awaiting channel Termination", ex);
            channel.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private List<X509Certificate> getX509CertificatesFromResponse(MeshCertificateResponse response) throws CertificateException, IOException {
        ProtocolStringList certChain = response.getCertChainList();
        ArrayList<X509Certificate> x509Chain = new ArrayList<X509Certificate>(certChain.size());
        for (String certString : certChain) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(certString.getBytes(StandardCharsets.UTF_8));){
                x509Chain.add(CertificateUtils.toX509Certificate(bais));
            }
        }
        return x509Chain;
    }

    private class ZoneInfoClientInterceptor
    implements ClientInterceptor {
        private final String zone;

        ZoneInfoClientInterceptor(String zone) {
            this.zone = zone;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    headers.put(KEY_FOR_ZONE_INFO, (Object)ZoneInfoClientInterceptor.this.zone);
                    super.start(responseListener, headers);
                }
            };
        }
    }

    static abstract class Factory {
        private static final Factory DEFAULT_INSTANCE = new Factory(){

            @Override
            MeshCaCertificateProvider create(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String meshCaUrl, String zone, long validitySeconds, int keySize, String alg, String signatureAlg, MeshCaChannelFactory meshCaChannelFactory, BackoffPolicy.Provider backoffPolicyProvider, long renewalGracePeriodSeconds, int maxRetryAttempts, GoogleCredentials oauth2Creds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider, long rpcTimeoutMillis) {
                return new MeshCaCertificateProvider(watcher, notifyCertUpdates, meshCaUrl, zone, validitySeconds, keySize, alg, signatureAlg, meshCaChannelFactory, backoffPolicyProvider, renewalGracePeriodSeconds, maxRetryAttempts, oauth2Creds, scheduledExecutorService, timeProvider, rpcTimeoutMillis);
            }
        };

        Factory() {
        }

        static Factory getInstance() {
            return DEFAULT_INSTANCE;
        }

        abstract MeshCaCertificateProvider create(CertificateProvider.DistributorWatcher var1, boolean var2, String var3, String var4, long var5, int var7, String var8, String var9, MeshCaChannelFactory var10, BackoffPolicy.Provider var11, long var12, int var14, GoogleCredentials var15, ScheduledExecutorService var16, TimeProvider var17, long var18);
    }

    static abstract class MeshCaChannelFactory {
        private static final MeshCaChannelFactory DEFAULT_INSTANCE = new MeshCaChannelFactory(){

            @Override
            ManagedChannel createChannel(String serverUri) {
                Preconditions.checkArgument((serverUri != null && !serverUri.isEmpty() ? 1 : 0) != 0, (Object)"serverUri is null/empty!");
                logger.log(Level.INFO, "Creating channel to {0}", serverUri);
                ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forTarget((String)serverUri);
                return channelBuilder.keepAliveTime(1L, TimeUnit.MINUTES).build();
            }
        };

        MeshCaChannelFactory() {
        }

        static MeshCaChannelFactory getInstance() {
            return DEFAULT_INSTANCE;
        }

        abstract ManagedChannel createChannel(String var1);
    }

    @VisibleForTesting
    class RefreshCertificateTask
    implements Runnable {
        RefreshCertificateTask() {
        }

        @Override
        public void run() {
            try {
                MeshCaCertificateProvider.this.refreshCertificate();
            }
            catch (IOException | NoSuchAlgorithmException | OperatorCreationException ex) {
                logger.log(Level.SEVERE, "refreshing certificate", ex);
            }
        }
    }
}

