/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClientWrapperForServerSds;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.TlsContextManagerImpl;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@VisibleForTesting
public final class SdsProtocolNegotiators {
    private static final Logger logger = Logger.getLogger(SdsProtocolNegotiators.class.getName());
    private static final AsciiString SCHEME = AsciiString.of((CharSequence)"http");

    private SdsProtocolNegotiators() {
    }

    public static InternalNettyChannelBuilder.ProtocolNegotiatorFactory clientProtocolNegotiatorFactory() {
        return new ClientSdsProtocolNegotiatorFactory();
    }

    public static ServerSdsProtocolNegotiator serverProtocolNegotiator(int port, @Nullable InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
        return new ServerSdsProtocolNegotiator(new XdsClientWrapperForServerSds(port), fallbackProtocolNegotiator);
    }

    @VisibleForTesting
    static final class ServerSdsHandler
    extends InternalProtocolNegotiators.ProtocolNegotiationHandler {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext;
        @Nullable
        private final InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

        ServerSdsHandler(GrpcHttp2ConnectionHandler grpcHandler, EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
            super((ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            });
            Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.grpcHandler = grpcHandler;
            this.downstreamTlsContext = downstreamTlsContext;
            this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        }

        protected void handlerAdded0(final ChannelHandlerContext ctx) {
            final BufferReadsHandler bufferReads = new BufferReadsHandler();
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)bufferReads);
            SslContextProvider sslContextProviderTemp = null;
            try {
                sslContextProviderTemp = TlsContextManagerImpl.getInstance().findOrCreateServerSslContextProvider(this.downstreamTlsContext);
            }
            catch (Exception e) {
                if (this.fallbackProtocolNegotiator == null) {
                    ctx.fireExceptionCaught((Throwable)new CertStoreException("No certificate source found!", e));
                    return;
                }
                logger.log(Level.INFO, "Using fallback for {0}", ctx.channel().localAddress());
                ctx.pipeline().replace((ChannelHandler)this, null, this.fallbackProtocolNegotiator.newHandler(this.grpcHandler));
                ctx.pipeline().remove((ChannelHandler)bufferReads);
                return;
            }
            final SslContextProvider sslContextProvider = sslContextProviderTemp;
            sslContextProvider.addCallback(new SslContextProvider.Callback((Executor)ctx.executor()){

                @Override
                public void updateSecret(SslContext sslContext) {
                    ChannelHandler handler = InternalProtocolNegotiators.serverTls((SslContext)sslContext).newHandler(ServerSdsHandler.this.grpcHandler);
                    ctx.pipeline().addAfter(ctx.name(), null, handler);
                    ServerSdsHandler.this.fireProtocolNegotiationEvent(ctx);
                    ctx.pipeline().remove((ChannelHandler)bufferReads);
                    TlsContextManagerImpl.getInstance().releaseServerSslContextProvider(sslContextProvider);
                }

                @Override
                public void onException(Throwable throwable) {
                    ctx.fireExceptionCaught(throwable);
                }
            });
        }
    }

    @VisibleForTesting
    static final class HandlerPickerHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final XdsClientWrapperForServerSds xdsClientWrapperForServerSds;
        @Nullable
        private final InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

        HandlerPickerHandler(GrpcHttp2ConnectionHandler grpcHandler, @Nullable XdsClientWrapperForServerSds xdsClientWrapperForServerSds, InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
            this.grpcHandler = (GrpcHttp2ConnectionHandler)Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.xdsClientWrapperForServerSds = xdsClientWrapperForServerSds;
            this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext;
                EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext2 = downstreamTlsContext = this.xdsClientWrapperForServerSds == null ? null : this.xdsClientWrapperForServerSds.getDownstreamTlsContext(ctx.channel());
                if (downstreamTlsContext == null) {
                    if (this.fallbackProtocolNegotiator == null) {
                        ctx.fireExceptionCaught((Throwable)new CertStoreException("No certificate source found!"));
                        return;
                    }
                    logger.log(Level.INFO, "Using fallback for {0}", ctx.channel().localAddress());
                    ctx.pipeline().replace((ChannelHandler)this, null, this.fallbackProtocolNegotiator.newHandler(this.grpcHandler));
                    ProtocolNegotiationEvent pne = InternalProtocolNegotiationEvent.getDefault();
                    ctx.fireUserEventTriggered((Object)pne);
                    return;
                }
                ctx.pipeline().replace((ChannelHandler)this, null, (ChannelHandler)new ServerSdsHandler(this.grpcHandler, downstreamTlsContext, this.fallbackProtocolNegotiator));
                ProtocolNegotiationEvent pne = InternalProtocolNegotiationEvent.getDefault();
                ctx.fireUserEventTriggered((Object)pne);
                return;
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    @VisibleForTesting
    public static final class ServerSdsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final XdsClientWrapperForServerSds xdsClientWrapperForServerSds;
        @Nullable
        private final InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

        @VisibleForTesting
        public ServerSdsProtocolNegotiator(XdsClientWrapperForServerSds xdsClientWrapperForServerSds, @Nullable InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
            this.xdsClientWrapperForServerSds = (XdsClientWrapperForServerSds)Preconditions.checkNotNull((Object)xdsClientWrapperForServerSds, (Object)"xdsClientWrapperForServerSds");
            this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        }

        XdsClientWrapperForServerSds getXdsClientWrapperForServerSds() {
            return this.xdsClientWrapperForServerSds;
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            return new HandlerPickerHandler(grpcHandler, this.xdsClientWrapperForServerSds, this.fallbackProtocolNegotiator);
        }

        public void close() {
        }
    }

    @VisibleForTesting
    static final class ClientSdsHandler
    extends InternalProtocolNegotiators.ProtocolNegotiationHandler {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext;

        ClientSdsHandler(GrpcHttp2ConnectionHandler grpcHandler, EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
            super((ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            });
            Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.grpcHandler = grpcHandler;
            this.upstreamTlsContext = upstreamTlsContext;
        }

        protected void handlerAdded0(final ChannelHandlerContext ctx) {
            final BufferReadsHandler bufferReads = new BufferReadsHandler();
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)bufferReads);
            final SslContextProvider sslContextProvider = TlsContextManagerImpl.getInstance().findOrCreateClientSslContextProvider(this.upstreamTlsContext);
            sslContextProvider.addCallback(new SslContextProvider.Callback((Executor)ctx.executor()){

                @Override
                public void updateSecret(SslContext sslContext) {
                    logger.log(Level.FINEST, "ClientSdsHandler.updateSecret authority={0}, ctx.name={1}", new Object[]{ClientSdsHandler.this.grpcHandler.getAuthority(), ctx.name()});
                    ChannelHandler handler = InternalProtocolNegotiators.tls((SslContext)sslContext).newHandler(ClientSdsHandler.this.grpcHandler);
                    ctx.pipeline().addAfter(ctx.name(), null, handler);
                    ClientSdsHandler.this.fireProtocolNegotiationEvent(ctx);
                    ctx.pipeline().remove((ChannelHandler)bufferReads);
                    TlsContextManagerImpl.getInstance().releaseClientSslContextProvider(sslContextProvider);
                }

                @Override
                public void onException(Throwable throwable) {
                    ctx.fireExceptionCaught(throwable);
                }
            });
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.log(Level.SEVERE, "exceptionCaught", cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    private static class BufferReadsHandler
    extends ChannelInboundHandlerAdapter {
        private final List<Object> reads = new ArrayList<Object>();
        private boolean readComplete;

        private BufferReadsHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.reads.add(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            this.readComplete = true;
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            for (Object msg : this.reads) {
                super.channelRead(ctx, msg);
            }
            if (this.readComplete) {
                super.channelReadComplete(ctx);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.log(Level.SEVERE, "exceptionCaught", cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    @VisibleForTesting
    static final class ClientSdsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        ClientSdsProtocolNegotiator() {
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            EnvoyServerProtoData.UpstreamTlsContext localUpstreamTlsContext = (EnvoyServerProtoData.UpstreamTlsContext)grpcHandler.getEagAttributes().get(XdsAttributes.ATTR_UPSTREAM_TLS_CONTEXT);
            if (ClientSdsProtocolNegotiator.isTlsContextEmpty(localUpstreamTlsContext)) {
                return InternalProtocolNegotiators.plaintext().newHandler(grpcHandler);
            }
            return new ClientSdsHandler(grpcHandler, localUpstreamTlsContext);
        }

        private static boolean isTlsContextEmpty(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
            return upstreamTlsContext == null || upstreamTlsContext.getCommonTlsContext() == null;
        }

        public void close() {
        }
    }

    private static final class ClientSdsProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private ClientSdsProtocolNegotiatorFactory() {
        }

        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator() {
            final ClientSdsProtocolNegotiator negotiator = new ClientSdsProtocolNegotiator();
            final class LocalSdsNegotiator
            implements InternalProtocolNegotiator.ProtocolNegotiator {
                LocalSdsNegotiator() {
                }

                public AsciiString scheme() {
                    return negotiator.scheme();
                }

                public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
                    return negotiator.newHandler(grpcHandler);
                }

                public void close() {
                    negotiator.close();
                }
            }
            return new LocalSdsNegotiator();
        }
    }
}

