/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.Closeable;
import io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManagerFactory;

public abstract class SslContextProvider
implements Closeable {
    private static final Logger logger = Logger.getLogger(SslContextProvider.class.getName());
    protected final EnvoyServerProtoData.BaseTlsContext tlsContext;

    protected SslContextProvider(EnvoyServerProtoData.BaseTlsContext tlsContext) {
        this.tlsContext = (EnvoyServerProtoData.BaseTlsContext)Preconditions.checkNotNull((Object)tlsContext, (Object)"tlsContext");
    }

    protected CommonTlsContext getCommonTlsContext() {
        return this.tlsContext.getCommonTlsContext();
    }

    protected void setClientAuthValues(SslContextBuilder sslContextBuilder, SdsTrustManagerFactory sdsTrustManagerFactory) throws CertificateException, IOException, CertStoreException {
        EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext = this.getDownstreamTlsContext();
        if (sdsTrustManagerFactory != null) {
            sslContextBuilder.trustManager((TrustManagerFactory)((Object)sdsTrustManagerFactory));
            sslContextBuilder.clientAuth(downstreamTlsContext.isRequireClientCertificate() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
        } else {
            sslContextBuilder.clientAuth(ClientAuth.NONE);
        }
    }

    public EnvoyServerProtoData.DownstreamTlsContext getDownstreamTlsContext() {
        Preconditions.checkState((boolean)(this.tlsContext instanceof EnvoyServerProtoData.DownstreamTlsContext), (Object)"expected DownstreamTlsContext");
        return (EnvoyServerProtoData.DownstreamTlsContext)this.tlsContext;
    }

    public EnvoyServerProtoData.UpstreamTlsContext getUpstreamTlsContext() {
        Preconditions.checkState((boolean)(this.tlsContext instanceof EnvoyServerProtoData.UpstreamTlsContext), (Object)"expected UpstreamTlsContext");
        return (EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext;
    }

    @Override
    public abstract void close();

    public abstract void addCallback(Callback var1);

    protected final void performCallback(final SslContextGetter sslContextGetter, final Callback callback) {
        Preconditions.checkNotNull((Object)sslContextGetter, (Object)"sslContextGetter");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        callback.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SslContext sslContext = sslContextGetter.get();
                    try {
                        callback.updateSecret(sslContext);
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, "Exception from callback.updateSecret", t);
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Exception from sslContextGetter.get()", e);
                    callback.onException(e);
                }
            }
        });
    }

    protected static interface SslContextGetter {
        public SslContext get() throws Exception;
    }

    static abstract class Callback {
        private final Executor executor;

        protected Callback(Executor executor) {
            this.executor = executor;
        }

        abstract void updateSecret(SslContext var1);

        abstract void onException(Throwable var1);
    }
}

