/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.certprovider.CertificateProvider;
import io.grpc.xds.internal.certprovider.CertificateProviderStore;
import io.grpc.xds.internal.sds.DynamicSslContextProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

abstract class CertProviderSslContextProvider
extends DynamicSslContextProvider
implements CertificateProvider.Watcher {
    @Nullable
    private final CertificateProviderStore.Handle certHandle;
    @Nullable
    private final CertificateProviderStore.Handle rootCertHandle;
    @Nullable
    private final CommonTlsContext.CertificateProviderInstance certInstance;
    @Nullable
    private final CommonTlsContext.CertificateProviderInstance rootCertInstance;
    @Nullable
    protected PrivateKey savedKey;
    @Nullable
    protected List<X509Certificate> savedCertChain;
    @Nullable
    protected List<X509Certificate> savedTrustedRoots;

    protected CertProviderSslContextProvider(Node node, Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.BaseTlsContext tlsContext, CertificateProviderStore certificateProviderStore) {
        super(tlsContext, staticCertValidationContext);
        Bootstrapper.CertificateProviderInfo certProviderInstanceConfig;
        this.certInstance = certInstance;
        this.rootCertInstance = rootCertInstance;
        String certInstanceName = null;
        if (certInstance != null && certInstance.isInitialized()) {
            certInstanceName = certInstance.getInstanceName();
            certProviderInstanceConfig = this.getCertProviderConfig(certProviders, certInstanceName);
            this.certHandle = certificateProviderStore.createOrGetProvider(certInstance.getCertificateName(), certProviderInstanceConfig.getPluginName(), certProviderInstanceConfig.getConfig(), this, true);
        } else {
            this.certHandle = null;
        }
        if (rootCertInstance != null && rootCertInstance.isInitialized() && !rootCertInstance.getInstanceName().equals(certInstanceName)) {
            certProviderInstanceConfig = this.getCertProviderConfig(certProviders, rootCertInstance.getInstanceName());
            this.rootCertHandle = certificateProviderStore.createOrGetProvider(rootCertInstance.getCertificateName(), certProviderInstanceConfig.getPluginName(), certProviderInstanceConfig.getConfig(), this, true);
        } else {
            this.rootCertHandle = null;
        }
    }

    private Bootstrapper.CertificateProviderInfo getCertProviderConfig(Map<String, Bootstrapper.CertificateProviderInfo> certProviders, String pluginInstanceName) {
        return certProviders.get(pluginInstanceName);
    }

    @Override
    public final void updateCertificate(PrivateKey key, List<X509Certificate> certChain) {
        this.savedKey = key;
        this.savedCertChain = certChain;
        this.updateSslContextWhenReady();
    }

    @Override
    public final void updateTrustedRoots(List<X509Certificate> trustedRoots) {
        this.savedTrustedRoots = trustedRoots;
        this.updateSslContextWhenReady();
    }

    private void updateSslContextWhenReady() {
        if (this.isMtls()) {
            if (this.savedKey != null && this.savedTrustedRoots != null) {
                this.updateSslContext();
                this.clearKeysAndCerts();
            }
        } else if (this.isClientSideTls()) {
            if (this.savedTrustedRoots != null) {
                this.updateSslContext();
                this.clearKeysAndCerts();
            }
        } else if (this.isServerSideTls() && this.savedKey != null) {
            this.updateSslContext();
            this.clearKeysAndCerts();
        }
    }

    private void clearKeysAndCerts() {
        this.savedKey = null;
        this.savedTrustedRoots = null;
        this.savedCertChain = null;
    }

    protected final boolean isMtls() {
        return this.certInstance != null && this.rootCertInstance != null;
    }

    protected final boolean isClientSideTls() {
        return this.rootCertInstance != null && this.certInstance == null;
    }

    protected final boolean isServerSideTls() {
        return this.certInstance != null && this.rootCertInstance == null;
    }

    @Override
    protected final CertificateValidationContext generateCertificateValidationContext() {
        return this.staticCertificateValidationContext;
    }

    @Override
    public final void close() {
        if (this.certHandle != null) {
            this.certHandle.close();
        }
        if (this.rootCertHandle != null) {
            this.rootCertHandle.close();
        }
    }
}

