/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.rbac.engine;

import com.google.common.collect.ImmutableMap;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import java.net.SocketAddress;

public class EvaluateArgs {
    private Metadata headers;
    private ServerCall<?, ?> call;

    public EvaluateArgs(Metadata headers, ServerCall<?, ?> call) {
        this.headers = headers;
        this.call = call;
    }

    protected String getRequestUrlPath() {
        String requestUrlPath = this.call.getMethodDescriptor().getFullMethodName();
        return requestUrlPath;
    }

    protected String getRequestHost() {
        String requestHost = this.call.getAuthority();
        return requestHost;
    }

    protected String getRequestMethod() {
        String requestMethod = this.call.getMethodDescriptor().getServiceName();
        return requestMethod;
    }

    protected Metadata getRequestHeaders() {
        Metadata requestHeaders = this.headers;
        return requestHeaders;
    }

    protected String getSourceAddress() {
        String sourceAddress = ((SocketAddress)this.call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).toString();
        return sourceAddress;
    }

    protected int getSourcePort() {
        int sourcePort = 0;
        return sourcePort;
    }

    protected String getDestinationAddress() {
        String destinationAddress = ((SocketAddress)this.call.getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR)).toString();
        return destinationAddress;
    }

    protected int getDestinationPort() {
        int destinationPort = 0;
        return destinationPort;
    }

    protected String getConnectionUriSanPeerCertificate() {
        String connectionUriSanPeerCertificate = "placeholder";
        return connectionUriSanPeerCertificate;
    }

    protected String getSourcePrincipal() {
        String sourcePrincipal = "placeholder";
        return sourcePrincipal;
    }

    public ImmutableMap<String, Object> generateEnvoyAttributes() {
        ImmutableMap attributes = ImmutableMap.builder().put((Object)"request.url_path", (Object)this.getRequestUrlPath()).put((Object)"request.host", (Object)this.getRequestHost()).put((Object)"request.method", (Object)this.getRequestMethod()).put((Object)"request.headers", (Object)this.getRequestHeaders()).put((Object)"source.address", (Object)this.getSourceAddress()).put((Object)"source.port", (Object)this.getSourcePort()).put((Object)"destination.address", (Object)this.getDestinationAddress()).put((Object)"destination.port", (Object)this.getDestinationPort()).put((Object)"connection.uri_san_peer_certificate", (Object)this.getConnectionUriSanPeerCertificate()).put((Object)"source.principal", (Object)this.getSourcePrincipal()).build();
        return attributes;
    }
}

