/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class PriorityLoadBalancer
extends LoadBalancer {
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService executor;
    private final XdsLogger logger;
    private final Map<String, ChildLbState> children = new HashMap<String, ChildLbState>();
    private LoadBalancer.ResolvedAddresses resolvedAddresses;
    private List<String> priorityNames;
    private Map<String, Integer> priorityNameToIndex;
    private ConnectivityState currentConnectivityState;
    private LoadBalancer.SubchannelPicker currentPicker;

    PriorityLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.syncContext = helper.getSynchronizationContext();
        this.executor = helper.getScheduledExecutorService();
        InternalLogId logId = InternalLogId.allocate((String)"priority-lb", (String)helper.getAuthority());
        this.logger = XdsLogger.withLogId(logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        this.resolvedAddresses = resolvedAddresses;
        PriorityLoadBalancerProvider.PriorityLbConfig config = (PriorityLoadBalancerProvider.PriorityLbConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull((Object)config, (Object)"missing priority lb config");
        this.priorityNames = config.priorities;
        HashMap<String, Integer> pToI = new HashMap<String, Integer>();
        for (int i = 0; i < this.priorityNames.size(); ++i) {
            pToI.put(this.priorityNames.get(i), i);
        }
        this.priorityNameToIndex = Collections.unmodifiableMap(pToI);
        for (String priority : this.children.keySet()) {
            if (this.priorityNameToIndex.containsKey(priority)) continue;
            this.children.get(priority).deactivate();
        }
        for (String priority : this.priorityNames) {
            if (!this.children.containsKey(priority)) continue;
            this.children.get(priority).updateResolvedAddresses();
        }
        this.tryNextPriority(false);
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.children.isEmpty()) {
            this.updateOverallState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(error));
        }
        for (ChildLbState child : this.children.values()) {
            child.lb.handleNameResolutionError(error);
        }
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        for (ChildLbState child : this.children.values()) {
            child.tearDown();
        }
    }

    private void tryNextPriority(boolean reportConnecting) {
        for (int i = 0; i < this.priorityNames.size(); ++i) {
            ChildLbState child;
            String priority = this.priorityNames.get(i);
            if (!this.children.containsKey(priority)) {
                child = new ChildLbState(priority);
                this.children.put(priority, child);
                child.updateResolvedAddresses();
                this.updateOverallState(ConnectivityState.CONNECTING, XdsSubchannelPickers.BUFFER_PICKER);
                return;
            }
            child = this.children.get(priority);
            child.reactivate();
            if (child.connectivityState.equals((Object)ConnectivityState.READY) || child.connectivityState.equals((Object)ConnectivityState.IDLE)) {
                this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Shifted to priority {0}", priority);
                this.updateOverallState(child.connectivityState, child.picker);
                for (int j = i + 1; j < this.priorityNames.size(); ++j) {
                    String p = this.priorityNames.get(j);
                    if (!this.children.containsKey(p)) continue;
                    this.children.get(p).deactivate();
                }
                return;
            }
            if (child.failOverTimer == null || !child.failOverTimer.isPending()) continue;
            if (reportConnecting) {
                this.updateOverallState(ConnectivityState.CONNECTING, XdsSubchannelPickers.BUFFER_PICKER);
            }
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "All priority failed");
        this.updateOverallState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE));
    }

    private void updateOverallState(ConnectivityState state, LoadBalancer.SubchannelPicker picker) {
        if (!state.equals((Object)this.currentConnectivityState) || !picker.equals(this.currentPicker)) {
            this.currentConnectivityState = state;
            this.currentPicker = picker;
            this.helper.updateBalancingState(state, picker);
        }
    }

    private final class ChildLbState {
        final String priority;
        final ChildHelper childHelper;
        final GracefulSwitchLoadBalancer lb;
        final SynchronizationContext.ScheduledHandle failOverTimer;
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;
        @Nullable
        String policy;
        ConnectivityState connectivityState = ConnectivityState.CONNECTING;
        LoadBalancer.SubchannelPicker picker = XdsSubchannelPickers.BUFFER_PICKER;

        ChildLbState(final String priority) {
            this.priority = priority;
            this.childHelper = new ChildHelper();
            this.lb = new GracefulSwitchLoadBalancer((LoadBalancer.Helper)this.childHelper);
            class FailOverTask
            implements Runnable {
                FailOverTask() {
                }

                @Override
                public void run() {
                    if (ChildLbState.this.deletionTimer != null && ChildLbState.this.deletionTimer.isPending()) {
                        return;
                    }
                    PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority {0} failed over to next", priority);
                    PriorityLoadBalancer.this.tryNextPriority(true);
                }
            }
            this.failOverTimer = PriorityLoadBalancer.this.syncContext.schedule((Runnable)new FailOverTask(), 10L, TimeUnit.SECONDS, PriorityLoadBalancer.this.executor);
            PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority created: {0}", priority);
        }

        void reactivate() {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
                PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority reactivated: {0}", this.priority);
            }
        }

        void deactivate() {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                return;
            }
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ChildLbState.this.tearDown();
                    PriorityLoadBalancer.this.children.remove(ChildLbState.this.priority);
                }
            }
            this.deletionTimer = PriorityLoadBalancer.this.syncContext.schedule((Runnable)new DeletionTask(), 15L, TimeUnit.MINUTES, PriorityLoadBalancer.this.executor);
            PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority deactivated: {0}", this.priority);
        }

        void tearDown() {
            if (this.failOverTimer.isPending()) {
                this.failOverTimer.cancel();
            }
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
            }
            this.lb.shutdown();
            PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority deleted: {0}", this.priority);
        }

        void updateResolvedAddresses() {
            final LoadBalancer.ResolvedAddresses addresses = PriorityLoadBalancer.this.resolvedAddresses;
            PriorityLoadBalancer.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    PriorityLoadBalancerProvider.PriorityLbConfig config = (PriorityLoadBalancerProvider.PriorityLbConfig)addresses.getLoadBalancingPolicyConfig();
                    ServiceConfigUtil.PolicySelection childPolicySelection = config.childConfigs.get(ChildLbState.this.priority);
                    LoadBalancerProvider lbProvider = childPolicySelection.getProvider();
                    String newPolicy = lbProvider.getPolicyName();
                    if (!newPolicy.equals(ChildLbState.this.policy)) {
                        ChildLbState.this.policy = newPolicy;
                        ChildLbState.this.lb.switchTo((LoadBalancer.Factory)lbProvider);
                    }
                    ChildLbState.this.lb.handleResolvedAddresses(addresses.toBuilder().setAddresses(AddressFilter.filter(addresses.getAddresses(), ChildLbState.this.priority)).setLoadBalancingPolicyConfig(childPolicySelection.getConfig()).build());
                }
            });
        }

        final class ChildHelper
        extends ForwardingLoadBalancerHelper {
            ChildHelper() {
            }

            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                ChildLbState.this.connectivityState = newState;
                ChildLbState.this.picker = newPicker;
                if (ChildLbState.this.deletionTimer != null && ChildLbState.this.deletionTimer.isPending()) {
                    return;
                }
                if (ChildLbState.this.failOverTimer.isPending() && (newState.equals((Object)ConnectivityState.READY) || newState.equals((Object)ConnectivityState.TRANSIENT_FAILURE))) {
                    ChildLbState.this.failOverTimer.cancel();
                }
                PriorityLoadBalancer.this.tryNextPriority(true);
            }

            protected LoadBalancer.Helper delegate() {
                return PriorityLoadBalancer.this.helper;
            }
        }
    }
}

