/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TypeRegistry;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.LoadReportClient;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryResponse;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.Listener;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChainMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.Route;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.Rds;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class XdsClientImpl
extends XdsClient {
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    @VisibleForTesting
    static final String ADS_TYPE_URL_LDS_V2 = "type.googleapis.com/envoy.api.v2.Listener";
    @VisibleForTesting
    static final String ADS_TYPE_URL_LDS = "type.googleapis.com/envoy.config.listener.v3.Listener";
    @VisibleForTesting
    static final String ADS_TYPE_URL_RDS_V2 = "type.googleapis.com/envoy.api.v2.RouteConfiguration";
    @VisibleForTesting
    static final String ADS_TYPE_URL_RDS = "type.googleapis.com/envoy.config.route.v3.RouteConfiguration";
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER_V2 = "type.googleapis.com/envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager";
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER = "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager";
    @VisibleForTesting
    static final String ADS_TYPE_URL_CDS_V2 = "type.googleapis.com/envoy.api.v2.Cluster";
    @VisibleForTesting
    static final String ADS_TYPE_URL_CDS = "type.googleapis.com/envoy.config.cluster.v3.Cluster";
    @VisibleForTesting
    static final String ADS_TYPE_URL_EDS_V2 = "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment";
    @VisibleForTesting
    static final String ADS_TYPE_URL_EDS = "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment";
    private final MessagePrinter respPrinter = new MessagePrinter();
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final String targetName;
    private final XdsClient.XdsChannel xdsChannel;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final Stopwatch adsStreamRetryStopwatch;
    private EnvoyProtoData.Node node;
    private final Map<String, XdsClient.ClusterUpdate> clusterNamesToClusterUpdates = new HashMap<String, XdsClient.ClusterUpdate>();
    private final Set<String> absentCdsResources = new HashSet<String>();
    private final Map<String, XdsClient.EndpointUpdate> clusterNamesToEndpointUpdates = new HashMap<String, XdsClient.EndpointUpdate>();
    private final Set<String> absentEdsResources = new HashSet<String>();
    private final Map<String, Set<XdsClient.ClusterWatcher>> clusterWatchers = new HashMap<String, Set<XdsClient.ClusterWatcher>>();
    private final Map<String, Set<XdsClient.EndpointWatcher>> endpointWatchers = new HashMap<String, Set<XdsClient.EndpointWatcher>>();
    private final Map<String, SynchronizationContext.ScheduledHandle> cdsRespTimers = new HashMap<String, SynchronizationContext.ScheduledHandle>();
    private final Map<String, SynchronizationContext.ScheduledHandle> edsRespTimers = new HashMap<String, SynchronizationContext.ScheduledHandle>();
    private final LoadStatsManager loadStatsManager = new LoadStatsManager();
    @Nullable
    private SynchronizationContext.ScheduledHandle ldsRespTimer;
    @Nullable
    private SynchronizationContext.ScheduledHandle rdsRespTimer;
    @Nullable
    private AbstractAdsStream adsStream;
    @Nullable
    private BackoffPolicy retryBackoffPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle rpcRetryTimer;
    @Nullable
    private LoadReportClient lrsClient;
    private int loadReportCount;
    @Nullable
    private XdsClient.ConfigWatcher configWatcher;
    @Nullable
    private String ldsResourceName;
    @Nullable
    private XdsClient.ListenerWatcher listenerWatcher;
    private int listenerPort = -1;

    XdsClientImpl(String targetName, List<Bootstrapper.ServerInfo> servers, XdsClient.XdsChannelFactory channelFactory, EnvoyProtoData.Node node, SynchronizationContext syncContext, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        XdsClient.XdsChannel xdsChannel;
        this.targetName = (String)Preconditions.checkNotNull((Object)targetName, (Object)"targetName");
        this.xdsChannel = xdsChannel = ((XdsClient.XdsChannelFactory)Preconditions.checkNotNull((Object)channelFactory, (Object)"channelFactory")).createChannel((List)Preconditions.checkNotNull(servers, (Object)"servers"));
        this.node = (EnvoyProtoData.Node)Preconditions.checkNotNull((Object)node, (Object)"node");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService, (Object)"timeService");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatch");
        this.adsStreamRetryStopwatch = (Stopwatch)stopwatchSupplier.get();
        this.logId = InternalLogId.allocate((String)"xds-client", (String)targetName);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutting down");
        this.xdsChannel.getManagedChannel().shutdown();
        if (this.adsStream != null) {
            this.adsStream.close((Exception)Status.CANCELLED.withDescription("shutdown").asException());
        }
        this.cleanUpResources();
        if (this.lrsClient != null) {
            this.lrsClient.stopLoadReporting();
            this.lrsClient = null;
        }
        if (this.rpcRetryTimer != null) {
            this.rpcRetryTimer.cancel();
        }
    }

    private void cleanUpResources() {
        this.clusterNamesToClusterUpdates.clear();
        this.absentCdsResources.clear();
        this.clusterNamesToEndpointUpdates.clear();
        this.absentEdsResources.clear();
        if (this.ldsRespTimer != null) {
            this.ldsRespTimer.cancel();
            this.ldsRespTimer = null;
        }
        if (this.rdsRespTimer != null) {
            this.rdsRespTimer.cancel();
            this.rdsRespTimer = null;
        }
        for (SynchronizationContext.ScheduledHandle handle : this.cdsRespTimers.values()) {
            handle.cancel();
        }
        this.cdsRespTimers.clear();
        for (SynchronizationContext.ScheduledHandle handle : this.edsRespTimers.values()) {
            handle.cancel();
        }
        this.edsRespTimers.clear();
    }

    @Override
    void watchConfigData(String targetAuthority, XdsClient.ConfigWatcher watcher) {
        Preconditions.checkState((this.configWatcher == null ? 1 : 0) != 0, (String)"watcher for %s already registered", (Object)targetAuthority);
        Preconditions.checkState((this.listenerWatcher == null ? 1 : 0) != 0, (Object)"ListenerWatcher already registered");
        this.ldsResourceName = (String)Preconditions.checkNotNull((Object)targetAuthority, (Object)"targetAuthority");
        this.configWatcher = (XdsClient.ConfigWatcher)Preconditions.checkNotNull((Object)watcher, (Object)"watcher");
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Started watching config {0}", this.ldsResourceName);
        if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
        }
        this.adsStream.sendXdsRequest(ResourceType.LDS, (Collection)ImmutableList.of((Object)this.ldsResourceName));
        this.ldsRespTimer = this.syncContext.schedule((Runnable)new LdsResourceFetchTimeoutTask(this.ldsResourceName), 15L, TimeUnit.SECONDS, this.timeService);
    }

    @Override
    void watchClusterData(String clusterName, XdsClient.ClusterWatcher watcher) {
        Set<XdsClient.ClusterWatcher> watchers;
        Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
        Preconditions.checkNotNull((Object)watcher, (Object)"watcher");
        boolean needRequest = false;
        if (!this.clusterWatchers.containsKey(clusterName)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching cluster {0}", clusterName);
            needRequest = true;
            this.clusterWatchers.put(clusterName, new HashSet());
        }
        Preconditions.checkState((!(watchers = this.clusterWatchers.get(clusterName)).contains(watcher) ? 1 : 0) != 0, (String)"watcher for %s already registered", (Object)clusterName);
        watchers.add(watcher);
        if (this.absentCdsResources.contains(clusterName)) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Cluster resource {0} is known to be absent", clusterName);
            watcher.onResourceDoesNotExist(clusterName);
            return;
        }
        if (this.clusterNamesToClusterUpdates.containsKey(clusterName)) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Retrieve cluster info {0} from local cache", clusterName);
            watcher.onClusterChanged(this.clusterNamesToClusterUpdates.get(clusterName));
            return;
        }
        if (needRequest) {
            if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
                return;
            }
            if (this.adsStream == null) {
                this.startRpcStream();
            }
            this.adsStream.sendXdsRequest(ResourceType.CDS, this.clusterWatchers.keySet());
            SynchronizationContext.ScheduledHandle timeoutHandle = this.syncContext.schedule((Runnable)new CdsResourceFetchTimeoutTask(clusterName), 15L, TimeUnit.SECONDS, this.timeService);
            this.cdsRespTimers.put(clusterName, timeoutHandle);
        }
    }

    @Override
    void cancelClusterDataWatch(String clusterName, XdsClient.ClusterWatcher watcher) {
        Preconditions.checkNotNull((Object)watcher, (Object)"watcher");
        Set<XdsClient.ClusterWatcher> watchers = this.clusterWatchers.get(clusterName);
        Preconditions.checkState((watchers != null && watchers.contains(watcher) ? 1 : 0) != 0, (String)"watcher for %s was not registered", (Object)clusterName);
        watchers.remove(watcher);
        if (watchers.isEmpty()) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching cluster {0}", clusterName);
            this.clusterWatchers.remove(clusterName);
            this.absentCdsResources.remove(clusterName);
            this.clusterNamesToClusterUpdates.remove(clusterName);
            if (this.cdsRespTimers.containsKey(clusterName)) {
                this.cdsRespTimers.get(clusterName).cancel();
                this.cdsRespTimers.remove(clusterName);
            }
            if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
                return;
            }
            Preconditions.checkState((this.adsStream != null ? 1 : 0) != 0, (Object)"Severe bug: ADS stream was not created while an endpoint watcher was registered");
            this.adsStream.sendXdsRequest(ResourceType.CDS, this.clusterWatchers.keySet());
        }
    }

    @Override
    void watchEndpointData(String clusterName, XdsClient.EndpointWatcher watcher) {
        Set<XdsClient.EndpointWatcher> watchers;
        Preconditions.checkNotNull((Object)watcher, (Object)"watcher");
        boolean needRequest = false;
        if (!this.endpointWatchers.containsKey(clusterName)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching endpoints in cluster {0}", clusterName);
            needRequest = true;
            this.endpointWatchers.put(clusterName, new HashSet());
        }
        Preconditions.checkState((!(watchers = this.endpointWatchers.get(clusterName)).contains(watcher) ? 1 : 0) != 0, (String)"watcher for %s already registered", (Object)clusterName);
        watchers.add(watcher);
        if (this.absentEdsResources.contains(clusterName)) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Endpoint resource for cluster {0} is known to be absent.", clusterName);
            watcher.onResourceDoesNotExist(clusterName);
            return;
        }
        if (this.clusterNamesToEndpointUpdates.containsKey(clusterName)) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Retrieve endpoints info for cluster {0} from local cache.", clusterName);
            watcher.onEndpointChanged(this.clusterNamesToEndpointUpdates.get(clusterName));
            return;
        }
        if (needRequest) {
            if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
                return;
            }
            if (this.adsStream == null) {
                this.startRpcStream();
            }
            this.adsStream.sendXdsRequest(ResourceType.EDS, this.endpointWatchers.keySet());
            SynchronizationContext.ScheduledHandle timeoutHandle = this.syncContext.schedule((Runnable)new EdsResourceFetchTimeoutTask(clusterName), 15L, TimeUnit.SECONDS, this.timeService);
            this.edsRespTimers.put(clusterName, timeoutHandle);
        }
    }

    @Override
    void cancelEndpointDataWatch(String clusterName, XdsClient.EndpointWatcher watcher) {
        Preconditions.checkNotNull((Object)watcher, (Object)"watcher");
        Set<XdsClient.EndpointWatcher> watchers = this.endpointWatchers.get(clusterName);
        Preconditions.checkState((watchers != null && watchers.contains(watcher) ? 1 : 0) != 0, (String)"watcher for %s was not registered", (Object)clusterName);
        watchers.remove(watcher);
        if (watchers.isEmpty()) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching endpoints in cluster {0}", clusterName);
            this.endpointWatchers.remove(clusterName);
            this.absentEdsResources.remove(clusterName);
            this.clusterNamesToEndpointUpdates.remove(clusterName);
            if (this.edsRespTimers.containsKey(clusterName)) {
                this.edsRespTimers.get(clusterName).cancel();
                this.edsRespTimers.remove(clusterName);
            }
            if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
                return;
            }
            this.adsStream.sendXdsRequest(ResourceType.EDS, this.endpointWatchers.keySet());
        }
    }

    @Override
    void watchListenerData(int port, XdsClient.ListenerWatcher watcher) {
        Preconditions.checkState((this.configWatcher == null ? 1 : 0) != 0, (Object)"ListenerWatcher cannot be set when ConfigWatcher set");
        Preconditions.checkState((this.listenerWatcher == null ? 1 : 0) != 0, (Object)"ListenerWatcher already registered");
        this.listenerWatcher = (XdsClient.ListenerWatcher)Preconditions.checkNotNull((Object)watcher, (Object)"watcher");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port needs to be > 0");
        this.listenerPort = port;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Started watching listener for port {0}", port);
        if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
        }
        this.updateNodeMetadataForListenerRequest(port);
        this.adsStream.sendXdsRequest(ResourceType.LDS, (Collection)ImmutableList.of());
        this.ldsRespTimer = this.syncContext.schedule((Runnable)new ListenerResourceFetchTimeoutTask(":" + port), 15L, TimeUnit.SECONDS, this.timeService);
    }

    private void updateNodeMetadataForListenerRequest(int port) {
        HashMap<String, Object> newMetadata = new HashMap<String, Object>();
        if (this.node.getMetadata() != null) {
            newMetadata.putAll(this.node.getMetadata());
        }
        newMetadata.put("TRAFFICDIRECTOR_PROXYLESS", "1");
        EnvoyProtoData.Address listeningAddress = new EnvoyProtoData.Address("0.0.0.0", port);
        this.node = this.node.toBuilder().setMetadata(newMetadata).addListeningAddresses(listeningAddress).build();
    }

    @Override
    void reportClientStats() {
        if (this.lrsClient == null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Turning on load reporting");
            this.lrsClient = new LoadReportClient(this.targetName, this.loadStatsManager, this.xdsChannel, this.node, this.syncContext, this.timeService, this.backoffPolicyProvider, this.stopwatchSupplier);
        }
        if (this.loadReportCount == 0) {
            this.lrsClient.startLoadReporting();
        }
        ++this.loadReportCount;
    }

    @Override
    void cancelClientStatsReport() {
        Preconditions.checkState((this.loadReportCount > 0 ? 1 : 0) != 0, (Object)"load reporting was never started");
        --this.loadReportCount;
        if (this.loadReportCount == 0) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Turning off load reporting");
            this.lrsClient.stopLoadReporting();
            this.lrsClient = null;
        }
    }

    @Override
    LoadStatsManager.LoadStatsStore addClientStats(String clusterName, @Nullable String clusterServiceName) {
        return this.loadStatsManager.addLoadStats(clusterName, clusterServiceName);
    }

    @Override
    void removeClientStats(String clusterName, @Nullable String clusterServiceName) {
        this.loadStatsManager.removeLoadStats(clusterName, clusterServiceName);
    }

    public String toString() {
        return this.logId.toString();
    }

    private void startRpcStream() {
        Preconditions.checkState((this.adsStream == null ? 1 : 0) != 0, (Object)"Previous adsStream has not been cleared yet");
        this.adsStream = this.xdsChannel.isUseProtocolV3() ? new AdsStream() : new AdsStreamV2();
        this.adsStream.start();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "ADS stream started");
        this.adsStreamRetryStopwatch.reset().start();
    }

    private void handleLdsResponse(DiscoveryResponseData ldsResponse) {
        Preconditions.checkState((this.configWatcher != null != (this.listenerWatcher != null) ? 1 : 0) != 0, (Object)"No LDS request was ever sent. Management server is doing something wrong");
        if (this.listenerWatcher != null) {
            this.handleLdsResponseForListener(ldsResponse);
        } else {
            this.handleLdsResponseForConfigUpdate(ldsResponse);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleLdsResponseForConfigUpdate(DiscoveryResponseData ldsResponse) {
        void var5_17;
        Preconditions.checkState((this.ldsResourceName != null && this.configWatcher != null ? 1 : 0) != 0, (Object)"LDS request for ConfigWatcher was never sent!");
        ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener> listeners = new ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener>(ldsResponse.getResourcesList().size());
        ArrayList<String> listenerNames = new ArrayList<String>(ldsResponse.getResourcesList().size());
        try {
            for (Any any : ldsResponse.getResourcesList()) {
                void var5_6;
                if (any.getTypeUrl().equals(ADS_TYPE_URL_LDS_V2)) {
                    Any any2 = any.toBuilder().setTypeUrl(ADS_TYPE_URL_LDS).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener listener = (io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener)var5_6.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener.class);
                listeners.add(listener);
                listenerNames.add(listener.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listeners in LDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.LDS, (Collection)ImmutableList.of((Object)this.ldsResourceName), ldsResponse.getVersionInfo(), "Malformed LDS response: " + (Object)((Object)e));
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received LDS response for resources: {0}", listenerNames);
        io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager requestedHttpConnManager = null;
        try {
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener listener : listeners) {
                Any apiListener = listener.getApiListener().getApiListener();
                if (apiListener.getTypeUrl().equals(TYPE_URL_HTTP_CONNECTION_MANAGER_V2)) {
                    apiListener = apiListener.toBuilder().setTypeUrl(TYPE_URL_HTTP_CONNECTION_MANAGER).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager hm = (io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager)apiListener.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.class);
                if (!listener.getName().equals(this.ldsResourceName)) continue;
                requestedHttpConnManager = hm;
            }
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack HttpConnectionManagers in Listeners of LDS response {0}", new Object[]{invalidProtocolBufferException});
            this.adsStream.sendNackRequest(ResourceType.LDS, (Collection)ImmutableList.of((Object)this.ldsResourceName), ldsResponse.getVersionInfo(), "Malformed LDS response: " + (Object)((Object)invalidProtocolBufferException));
            return;
        }
        Object var5_11 = null;
        List<EnvoyProtoData.Route> routes = null;
        String rdsRouteConfigName = null;
        if (requestedHttpConnManager != null) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Found http connection manager");
            if (requestedHttpConnManager.hasRouteConfig()) {
                RouteConfiguration rc = requestedHttpConnManager.getRouteConfig();
                try {
                    routes = XdsClientImpl.findRoutesInRouteConfig(rc, this.ldsResourceName);
                }
                catch (InvalidProtoDataException e) {
                    String string = "Listener " + this.ldsResourceName + " : cannot find a valid cluster name in any virtual hosts domains matching: " + this.ldsResourceName + " with the reason : " + e.getMessage();
                }
            } else if (requestedHttpConnManager.hasRds()) {
                Rds rds = requestedHttpConnManager.getRds();
                if (!rds.getConfigSource().hasAds()) {
                    String string = "Listener " + this.ldsResourceName + " : for using RDS, config_source must be set to use ADS.";
                } else {
                    rdsRouteConfigName = rds.getRouteConfigName();
                }
            } else {
                String string = "Listener " + this.ldsResourceName + " : HttpConnectionManager message must either provide the RouteConfiguration directly in-line or tell the client to use RDS to obtain it.";
            }
        }
        if (var5_17 != null) {
            this.adsStream.sendNackRequest(ResourceType.LDS, (Collection)ImmutableList.of((Object)this.ldsResourceName), ldsResponse.getVersionInfo(), (String)var5_17);
            return;
        }
        this.adsStream.sendAckRequest(ResourceType.LDS, (Collection)ImmutableList.of((Object)this.ldsResourceName), ldsResponse.getVersionInfo());
        if ((routes != null || rdsRouteConfigName != null) && this.ldsRespTimer != null) {
            this.ldsRespTimer.cancel();
            this.ldsRespTimer = null;
        }
        if (routes != null) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Found routes (inlined in route config): {0}", routes);
            XdsClient.ConfigUpdate configUpdate = XdsClient.ConfigUpdate.newBuilder().addRoutes(routes).build();
            this.configWatcher.onConfigChanged(configUpdate);
        } else if (rdsRouteConfigName != null) {
            if (!rdsRouteConfigName.equals(this.adsStream.rdsResourceName)) {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Use RDS to dynamically resolve route config, resource name: {0}", rdsRouteConfigName);
                this.adsStream.sendXdsRequest(ResourceType.RDS, (Collection)ImmutableList.of((Object)rdsRouteConfigName));
                if (this.rdsRespTimer != null) {
                    this.rdsRespTimer.cancel();
                }
                this.rdsRespTimer = this.syncContext.schedule((Runnable)new RdsResourceFetchTimeoutTask(rdsRouteConfigName), 15L, TimeUnit.SECONDS, this.timeService);
            }
        } else if (this.ldsRespTimer == null) {
            this.configWatcher.onResourceDoesNotExist(this.ldsResourceName);
        }
    }

    private void handleLdsResponseForListener(DiscoveryResponseData ldsResponse) {
        Preconditions.checkState((this.ldsResourceName == null && this.listenerPort > 0 && this.listenerWatcher != null ? 1 : 0) != 0, (Object)"LDS request for ListenerWatcher was never sent!");
        io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener requestedListener = null;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Listener count: {0}", ldsResponse.getResourcesList().size());
        try {
            for (Any res : ldsResponse.getResourcesList()) {
                if (res.getTypeUrl().equals(ADS_TYPE_URL_LDS_V2)) {
                    res = res.toBuilder().setTypeUrl(ADS_TYPE_URL_LDS).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener listener = (io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener)res.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener.class);
                this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Found listener {0}", listener.toString());
                if (!this.isRequestedListener(listener)) continue;
                requestedListener = listener;
                this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Requested listener found: {0}", listener.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listeners in LDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.LDS, (Collection)ImmutableList.of(), ldsResponse.getVersionInfo(), "Malformed LDS response: " + (Object)((Object)e));
            return;
        }
        XdsClient.ListenerUpdate listenerUpdate = null;
        if (requestedListener != null) {
            if (this.ldsRespTimer != null) {
                this.ldsRespTimer.cancel();
                this.ldsRespTimer = null;
            }
            try {
                listenerUpdate = XdsClient.ListenerUpdate.newBuilder().setListener(EnvoyServerProtoData.Listener.fromEnvoyProtoListener(requestedListener)).build();
            }
            catch (InvalidProtocolBufferException e) {
                this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listener in LDS response {0}", new Object[]{e});
                this.adsStream.sendNackRequest(ResourceType.LDS, (Collection)ImmutableList.of(), ldsResponse.getVersionInfo(), "Malformed LDS response: " + (Object)((Object)e));
                return;
            }
        } else if (this.ldsRespTimer == null) {
            this.listenerWatcher.onResourceDoesNotExist(":" + this.listenerPort);
        }
        this.adsStream.sendAckRequest(ResourceType.LDS, (Collection)ImmutableList.of(), ldsResponse.getVersionInfo());
        if (listenerUpdate != null) {
            this.listenerWatcher.onListenerChanged(listenerUpdate);
        }
    }

    private boolean isRequestedListener(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener listener) {
        return this.isAddressMatching(listener.getAddress()) && this.hasMatchingFilter(listener.getFilterChainsList());
    }

    private boolean isAddressMatching(Address address) {
        return address.hasSocketAddress() && address.getSocketAddress().getPortValue() == this.listenerPort;
    }

    private boolean hasMatchingFilter(List<FilterChain> filterChainsList) {
        for (FilterChain filterChain : filterChainsList) {
            FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            if (this.listenerPort != filterChainMatch.getDestinationPort().getValue()) continue;
            return true;
        }
        return false;
    }

    private void handleRdsResponse(DiscoveryResponseData rdsResponse) {
        Preconditions.checkState((this.adsStream.rdsResourceName != null ? 1 : 0) != 0, (Object)"Never requested for RDS resources, management server is doing something wrong");
        ArrayList<String> routeConfigNames = new ArrayList<String>(rdsResponse.getResourcesList().size());
        RouteConfiguration requestedRouteConfig = null;
        try {
            for (Any res : rdsResponse.getResourcesList()) {
                if (res.getTypeUrl().equals(ADS_TYPE_URL_RDS_V2)) {
                    res = res.toBuilder().setTypeUrl(ADS_TYPE_URL_RDS).build();
                }
                RouteConfiguration rc = (RouteConfiguration)res.unpack(RouteConfiguration.class);
                routeConfigNames.add(rc.getName());
                if (!rc.getName().equals(this.adsStream.rdsResourceName)) continue;
                requestedRouteConfig = rc;
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack RouteConfiguration in RDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.RDS, (Collection)ImmutableList.of((Object)this.adsStream.rdsResourceName), rdsResponse.getVersionInfo(), "Malformed RDS response: " + (Object)((Object)e));
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received RDS response for resources: {0}", routeConfigNames);
        List<EnvoyProtoData.Route> routes = null;
        if (requestedRouteConfig != null) {
            try {
                routes = XdsClientImpl.findRoutesInRouteConfig(requestedRouteConfig, this.ldsResourceName);
            }
            catch (InvalidProtoDataException e) {
                String errorDetail = e.getMessage();
                this.adsStream.sendNackRequest(ResourceType.RDS, (Collection)ImmutableList.of((Object)this.adsStream.rdsResourceName), rdsResponse.getVersionInfo(), "RouteConfiguration " + requestedRouteConfig.getName() + ": cannot find a valid cluster name in any virtual hosts with domains matching: " + this.ldsResourceName + " with the reason: " + errorDetail);
                return;
            }
        }
        this.adsStream.sendAckRequest(ResourceType.RDS, (Collection)ImmutableList.of((Object)this.adsStream.rdsResourceName), rdsResponse.getVersionInfo());
        if (routes != null) {
            if (this.rdsRespTimer != null) {
                this.rdsRespTimer.cancel();
                this.rdsRespTimer = null;
            }
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Found routes: {0}", routes);
            XdsClient.ConfigUpdate configUpdate = XdsClient.ConfigUpdate.newBuilder().addRoutes(routes).build();
            this.configWatcher.onConfigChanged(configUpdate);
        }
    }

    private static List<EnvoyProtoData.Route> findRoutesInRouteConfig(RouteConfiguration config, String hostName) throws InvalidProtoDataException {
        VirtualHost targetVirtualHost = XdsClientImpl.findVirtualHostForHostName(config, hostName);
        if (targetVirtualHost == null) {
            throw new InvalidProtoDataException("Unable to find virtual host for " + hostName);
        }
        return XdsClientImpl.populateRoutesInVirtualHost(targetVirtualHost);
    }

    @VisibleForTesting
    static List<EnvoyProtoData.Route> populateRoutesInVirtualHost(VirtualHost virtualHost) throws InvalidProtoDataException {
        ArrayList<EnvoyProtoData.Route> routes = new ArrayList<EnvoyProtoData.Route>();
        List<Route> routesProto = virtualHost.getRoutesList();
        for (Route routeProto : routesProto) {
            EnvoyProtoData.StructOrError<EnvoyProtoData.Route> route = EnvoyProtoData.Route.fromEnvoyProtoRoute(routeProto);
            if (route == null) continue;
            if (route.getErrorDetail() != null) {
                throw new InvalidProtoDataException("Virtual host [" + virtualHost.getName() + "] contains invalid route : " + route.getErrorDetail());
            }
            routes.add(route.getStruct());
        }
        if (routes.isEmpty()) {
            throw new InvalidProtoDataException("Virtual host [" + virtualHost.getName() + "] contains no usable route");
        }
        return Collections.unmodifiableList(routes);
    }

    @Nullable
    @VisibleForTesting
    static VirtualHost findVirtualHostForHostName(RouteConfiguration config, String hostName) {
        List<VirtualHost> virtualHosts = config.getVirtualHostsList();
        int matchingLen = -1;
        boolean exactMatchFound = false;
        VirtualHost targetVirtualHost = null;
        for (VirtualHost vHost : virtualHosts) {
            for (String domain : vHost.getDomainsList()) {
                boolean selected = false;
                if (XdsClientImpl.matchHostName(hostName, domain)) {
                    if (!domain.contains("*")) {
                        exactMatchFound = true;
                        targetVirtualHost = vHost;
                        break;
                    }
                    if (domain.length() > matchingLen) {
                        selected = true;
                    } else if (domain.length() == matchingLen && domain.startsWith("*")) {
                        selected = true;
                    }
                }
                if (!selected) continue;
                matchingLen = domain.length();
                targetVirtualHost = vHost;
            }
            if (!exactMatchFound) continue;
            break;
        }
        return targetVirtualHost;
    }

    private void handleCdsResponse(DiscoveryResponseData cdsResponse) {
        String clusterName;
        this.adsStream.cdsRespNonce = cdsResponse.getNonce();
        ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster> clusters = new ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster>(cdsResponse.getResourcesList().size());
        ArrayList<String> clusterNames = new ArrayList<String>(cdsResponse.getResourcesList().size());
        try {
            for (Any res : cdsResponse.getResourcesList()) {
                if (res.getTypeUrl().equals(ADS_TYPE_URL_CDS_V2)) {
                    res = res.toBuilder().setTypeUrl(ADS_TYPE_URL_CDS).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster cluster = (io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster)res.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster.class);
                clusters.add(cluster);
                clusterNames.add(cluster.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Clusters in CDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.CDS, this.clusterWatchers.keySet(), cdsResponse.getVersionInfo(), "Malformed CDS response: " + (Object)((Object)e));
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received CDS response for resources: {0}", clusterNames);
        String errorMessage = null;
        HashMap<String, XdsClient.ClusterUpdate> clusterUpdates = new HashMap<String, XdsClient.ClusterUpdate>();
        HashSet<String> edsServices = new HashSet<String>();
        for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster cluster : clusters) {
            XdsClient.ClusterUpdate.Builder updateBuilder;
            block24: {
                clusterName = cluster.getName();
                if (!this.clusterWatchers.containsKey(clusterName)) continue;
                updateBuilder = XdsClient.ClusterUpdate.newBuilder();
                updateBuilder.setClusterName(clusterName);
                if (!cluster.getType().equals((Object)Cluster.DiscoveryType.EDS)) {
                    errorMessage = "Cluster " + clusterName + " : only EDS discovery type is supported in gRPC.";
                    break;
                }
                Cluster.EdsClusterConfig edsClusterConfig = cluster.getEdsClusterConfig();
                if (!edsClusterConfig.getEdsConfig().hasAds()) {
                    errorMessage = "Cluster " + clusterName + " : field eds_cluster_config must be set to indicate to use EDS over ADS.";
                    break;
                }
                if (!edsClusterConfig.getServiceName().isEmpty()) {
                    updateBuilder.setEdsServiceName(edsClusterConfig.getServiceName());
                    edsServices.add(edsClusterConfig.getServiceName());
                } else {
                    edsServices.add(clusterName);
                }
                if (!cluster.getLbPolicy().equals((Object)Cluster.LbPolicy.ROUND_ROBIN)) {
                    errorMessage = "Cluster " + clusterName + " : only round robin load balancing policy is supported in gRPC.";
                    break;
                }
                updateBuilder.setLbPolicy("round_robin");
                if (cluster.hasLrsServer()) {
                    if (!cluster.getLrsServer().hasSelf()) {
                        errorMessage = "Cluster " + clusterName + " : only support enabling LRS for the same management server.";
                        break;
                    }
                    updateBuilder.setLrsServerName("");
                }
                try {
                    EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = XdsClientImpl.getTlsContextFromCluster(cluster);
                    if (upstreamTlsContext == null || upstreamTlsContext.getCommonTlsContext() == null) break block24;
                    updateBuilder.setUpstreamTlsContext(upstreamTlsContext);
                }
                catch (InvalidProtocolBufferException e) {
                    errorMessage = "Cluster " + clusterName + " : " + e.getMessage();
                    break;
                }
            }
            clusterUpdates.put(clusterName, updateBuilder.build());
        }
        if (errorMessage != null) {
            this.adsStream.sendNackRequest(ResourceType.CDS, this.clusterWatchers.keySet(), cdsResponse.getVersionInfo(), errorMessage);
            return;
        }
        this.adsStream.sendAckRequest(ResourceType.CDS, this.clusterWatchers.keySet(), cdsResponse.getVersionInfo());
        this.absentCdsResources.removeAll(clusterUpdates.keySet());
        for (Map.Entry entry : this.clusterNamesToClusterUpdates.entrySet()) {
            if (!clusterUpdates.containsKey(entry.getKey())) {
                this.absentCdsResources.add((String)entry.getKey());
                continue;
            }
            if (!((XdsClient.ClusterUpdate)clusterUpdates.get(entry.getKey())).equals(entry.getValue())) continue;
            clusterUpdates.remove(entry.getKey());
        }
        this.clusterNamesToClusterUpdates.keySet().removeAll(this.absentCdsResources);
        this.clusterNamesToClusterUpdates.putAll(clusterUpdates);
        for (String string : this.clusterNamesToEndpointUpdates.keySet()) {
            if (edsServices.contains(string)) continue;
            this.absentEdsResources.add(string);
            if (!this.endpointWatchers.containsKey(string)) continue;
            Set<XdsClient.EndpointWatcher> watchers = this.endpointWatchers.get(string);
            for (XdsClient.EndpointWatcher endpointWatcher : watchers) {
                endpointWatcher.onResourceDoesNotExist(string);
            }
        }
        this.clusterNamesToEndpointUpdates.keySet().retainAll(edsServices);
        for (String string : clusterUpdates.keySet()) {
            if (!this.cdsRespTimers.containsKey(string)) continue;
            this.cdsRespTimers.get(string).cancel();
            this.cdsRespTimers.remove(string);
        }
        for (Map.Entry entry : this.clusterWatchers.entrySet()) {
            clusterName = (String)entry.getKey();
            if (clusterUpdates.containsKey(entry.getKey())) {
                XdsClient.ClusterUpdate clusterUpdate = (XdsClient.ClusterUpdate)clusterUpdates.get(clusterName);
                for (XdsClient.ClusterWatcher watcher : (Set)entry.getValue()) {
                    watcher.onClusterChanged(clusterUpdate);
                }
                continue;
            }
            if (this.clusterNamesToClusterUpdates.containsKey(entry.getKey()) || this.cdsRespTimers.containsKey(clusterName)) continue;
            for (XdsClient.ClusterWatcher clusterWatcher : (Set)entry.getValue()) {
                clusterWatcher.onResourceDoesNotExist((String)entry.getKey());
            }
        }
    }

    @Nullable
    private static EnvoyServerProtoData.UpstreamTlsContext getTlsContextFromCluster(io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster cluster) throws InvalidProtocolBufferException {
        if (cluster.hasTransportSocket() && "tls".equals(cluster.getTransportSocket().getName())) {
            Any any = cluster.getTransportSocket().getTypedConfig();
            return EnvoyServerProtoData.UpstreamTlsContext.fromEnvoyProtoUpstreamTlsContext(UpstreamTlsContext.parseFrom(any.getValue()));
        }
        return null;
    }

    private void handleEdsResponse(DiscoveryResponseData edsResponse) {
        String clusterName;
        ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment> clusterLoadAssignments = new ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment>(edsResponse.getResourcesList().size());
        ArrayList<String> claNames = new ArrayList<String>(edsResponse.getResourcesList().size());
        try {
            for (Any res : edsResponse.getResourcesList()) {
                if (res.getTypeUrl().equals(ADS_TYPE_URL_EDS_V2)) {
                    res = res.toBuilder().setTypeUrl(ADS_TYPE_URL_EDS).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment assignment = (io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment)res.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment.class);
                clusterLoadAssignments.add(assignment);
                claNames.add(assignment.getClusterName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack ClusterLoadAssignments in EDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.EDS, this.endpointWatchers.keySet(), edsResponse.getVersionInfo(), "Malformed EDS response: " + (Object)((Object)e));
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received EDS response for resources: {0}", claNames);
        String errorMessage = null;
        HashMap<String, XdsClient.EndpointUpdate> endpointUpdates = new HashMap<String, XdsClient.EndpointUpdate>();
        for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment clusterLoadAssignment : clusterLoadAssignments) {
            clusterName = clusterLoadAssignment.getClusterName();
            if (!this.endpointWatchers.containsKey(clusterName)) continue;
            XdsClient.EndpointUpdate.Builder updateBuilder = XdsClient.EndpointUpdate.newBuilder();
            updateBuilder.setClusterName(clusterName);
            HashSet<Integer> priorities = new HashSet<Integer>();
            int maxPriority = -1;
            for (LocalityLbEndpoints localityLbEndpoints : clusterLoadAssignment.getEndpointsList()) {
                if (!localityLbEndpoints.hasLoadBalancingWeight() || localityLbEndpoints.getLoadBalancingWeight().getValue() < 1) continue;
                int localityPriority = localityLbEndpoints.getPriority();
                if (localityPriority < 0) {
                    errorMessage = "ClusterLoadAssignment " + clusterName + " : locality with negative priority.";
                    break;
                }
                maxPriority = Math.max(maxPriority, localityPriority);
                priorities.add(localityPriority);
                for (LbEndpoint lbEndpoint : localityLbEndpoints.getLbEndpointsList()) {
                    if (lbEndpoint.getEndpoint().hasAddress()) continue;
                    errorMessage = "ClusterLoadAssignment " + clusterName + " : endpoint with no address.";
                    break;
                }
                if (errorMessage != null) break;
                updateBuilder.addLocalityLbEndpoints(EnvoyProtoData.Locality.fromEnvoyProtoLocality(localityLbEndpoints.getLocality()), EnvoyProtoData.LocalityLbEndpoints.fromEnvoyProtoLocalityLbEndpoints(localityLbEndpoints));
            }
            if (errorMessage != null) break;
            if (priorities.size() != maxPriority + 1) {
                errorMessage = "ClusterLoadAssignment " + clusterName + " : sparse priorities.";
                break;
            }
            for (ClusterLoadAssignment.Policy.DropOverload dropOverload : clusterLoadAssignment.getPolicy().getDropOverloadsList()) {
                updateBuilder.addDropPolicy(EnvoyProtoData.DropOverload.fromEnvoyProtoDropOverload(dropOverload));
            }
            XdsClient.EndpointUpdate update = updateBuilder.build();
            endpointUpdates.put(clusterName, update);
        }
        if (errorMessage != null) {
            this.adsStream.sendNackRequest(ResourceType.EDS, this.endpointWatchers.keySet(), edsResponse.getVersionInfo(), errorMessage);
            return;
        }
        this.adsStream.sendAckRequest(ResourceType.EDS, this.endpointWatchers.keySet(), edsResponse.getVersionInfo());
        this.clusterNamesToEndpointUpdates.putAll(endpointUpdates);
        this.absentEdsResources.removeAll(endpointUpdates.keySet());
        for (Map.Entry entry : endpointUpdates.entrySet()) {
            clusterName = (String)entry.getKey();
            if (this.edsRespTimers.containsKey(clusterName)) {
                this.edsRespTimers.get(clusterName).cancel();
                this.edsRespTimers.remove(clusterName);
            }
            if (!this.endpointWatchers.containsKey(clusterName)) continue;
            for (XdsClient.EndpointWatcher watcher : this.endpointWatchers.get(clusterName)) {
                watcher.onEndpointChanged((XdsClient.EndpointUpdate)entry.getValue());
            }
        }
    }

    @VisibleForTesting
    static boolean matchHostName(String hostName, String pattern) {
        Preconditions.checkArgument((hostName.length() != 0 && !hostName.startsWith(".") && !hostName.endsWith(".") ? 1 : 0) != 0, (Object)"Invalid host name");
        Preconditions.checkArgument((pattern.length() != 0 && !pattern.startsWith(".") && !pattern.endsWith(".") ? 1 : 0) != 0, (Object)"Invalid pattern/domain name");
        hostName = hostName.toLowerCase(Locale.US);
        pattern = pattern.toLowerCase(Locale.US);
        if (!pattern.contains("*")) {
            return hostName.equals(pattern);
        }
        if (pattern.length() == 1) {
            return true;
        }
        int index = pattern.indexOf(42);
        if (pattern.indexOf(42, index + 1) != -1) {
            return false;
        }
        if (index != 0 && index != pattern.length() - 1) {
            return false;
        }
        if (hostName.length() < pattern.length()) {
            return false;
        }
        if (index == 0 && hostName.endsWith(pattern.substring(1))) {
            return true;
        }
        return index == pattern.length() - 1 && hostName.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    @VisibleForTesting
    static final class InvalidProtoDataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private InvalidProtoDataException(String message) {
            super(message, null, false, false);
        }
    }

    @VisibleForTesting
    static final class MessagePrinter {
        private final JsonFormat.Printer printer;

        @VisibleForTesting
        MessagePrinter() {
            TypeRegistry registry = TypeRegistry.newBuilder().add(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener.getDescriptor()).add(Listener.getDescriptor()).add(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.getDescriptor()).add(HttpConnectionManager.getDescriptor()).add(RouteConfiguration.getDescriptor()).add(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.RouteConfiguration.getDescriptor()).add(io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster.getDescriptor()).add(Cluster.getDescriptor()).add(io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment.getDescriptor()).add(ClusterLoadAssignment.getDescriptor()).build();
            this.printer = JsonFormat.printer().usingTypeRegistry(registry);
        }

        @VisibleForTesting
        String print(MessageOrBuilder message) {
            String res;
            try {
                res = this.printer.print(message);
            }
            catch (InvalidProtocolBufferException e) {
                res = message + " (failed to pretty-print: " + (Object)((Object)e) + ")";
            }
            return res;
        }
    }

    @VisibleForTesting
    final class EdsResourceFetchTimeoutTask
    extends ResourceFetchTimeoutTask {
        EdsResourceFetchTimeoutTask(String resourceName) {
            super(resourceName);
        }

        @Override
        public void run() {
            super.run();
            XdsClientImpl.this.edsRespTimers.remove(this.resourceName);
            XdsClientImpl.this.absentEdsResources.add(this.resourceName);
            for (XdsClient.EndpointWatcher wat : (Set)XdsClientImpl.this.endpointWatchers.get(this.resourceName)) {
                wat.onResourceDoesNotExist(this.resourceName);
            }
        }
    }

    @VisibleForTesting
    final class CdsResourceFetchTimeoutTask
    extends ResourceFetchTimeoutTask {
        CdsResourceFetchTimeoutTask(String resourceName) {
            super(resourceName);
        }

        @Override
        public void run() {
            super.run();
            XdsClientImpl.this.cdsRespTimers.remove(this.resourceName);
            XdsClientImpl.this.absentCdsResources.add(this.resourceName);
            for (XdsClient.ClusterWatcher wat : (Set)XdsClientImpl.this.clusterWatchers.get(this.resourceName)) {
                wat.onResourceDoesNotExist(this.resourceName);
            }
        }
    }

    @VisibleForTesting
    final class RdsResourceFetchTimeoutTask
    extends ResourceFetchTimeoutTask {
        RdsResourceFetchTimeoutTask(String resourceName) {
            super(resourceName);
        }

        @Override
        public void run() {
            super.run();
            XdsClientImpl.this.rdsRespTimer = null;
            XdsClientImpl.this.configWatcher.onResourceDoesNotExist(this.resourceName);
        }
    }

    @VisibleForTesting
    final class ListenerResourceFetchTimeoutTask
    extends ResourceFetchTimeoutTask {
        ListenerResourceFetchTimeoutTask(String resourceName) {
            super(resourceName);
        }

        @Override
        public void run() {
            super.run();
            XdsClientImpl.this.ldsRespTimer = null;
            XdsClientImpl.this.listenerWatcher.onResourceDoesNotExist(this.resourceName);
        }
    }

    @VisibleForTesting
    final class LdsResourceFetchTimeoutTask
    extends ResourceFetchTimeoutTask {
        LdsResourceFetchTimeoutTask(String resourceName) {
            super(resourceName);
        }

        @Override
        public void run() {
            super.run();
            XdsClientImpl.this.ldsRespTimer = null;
            XdsClientImpl.this.configWatcher.onResourceDoesNotExist(this.resourceName);
        }
    }

    private abstract class ResourceFetchTimeoutTask
    implements Runnable {
        final String resourceName;

        ResourceFetchTimeoutTask(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public void run() {
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Did not receive resource info {0} after {1} seconds, conclude it absent", this.resourceName, 15);
        }
    }

    private final class AdsStream
    extends AbstractAdsStream {
        private final AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub stub;
        private StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest> requestWriter;

        AdsStream() {
            this.stub = io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc.newStub((Channel)XdsClientImpl.this.xdsChannel.getManagedChannel());
        }

        @Override
        void start() {
            StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse> responseReader = new StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse>(){

                public void onNext(io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse response) {
                    DiscoveryResponseData responseData = DiscoveryResponseData.fromEnvoyProto(response);
                    if (XdsClientImpl.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                        XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", new Object[]{responseData.getResourceType(), XdsClientImpl.this.respPrinter.print(response)});
                    }
                    AdsStream.this.onDiscoveryResponse(responseData);
                }

                public void onError(Throwable t) {
                    AdsStream.this.onError(t);
                }

                public void onCompleted() {
                    AdsStream.this.onCompleted();
                }
            };
            this.requestWriter = ((AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub)this.stub.withWaitForReady()).streamAggregatedResources(responseReader);
        }

        @Override
        void sendDiscoveryRequest(DiscoveryRequestData request) {
            Preconditions.checkState((this.requestWriter != null ? 1 : 0) != 0, (Object)"ADS stream has not been started");
            io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest requestProto = request.toEnvoyProto();
            this.requestWriter.onNext((Object)requestProto);
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", requestProto);
        }

        @Override
        void sendError(Exception error) {
            this.requestWriter.onError((Throwable)error);
        }
    }

    private final class AdsStreamV2
    extends AbstractAdsStream {
        private final AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub stubV2;
        private StreamObserver<DiscoveryRequest> requestWriterV2;

        AdsStreamV2() {
            this.stubV2 = AggregatedDiscoveryServiceGrpc.newStub((Channel)XdsClientImpl.this.xdsChannel.getManagedChannel());
        }

        @Override
        void start() {
            StreamObserver<DiscoveryResponse> responseReaderV2 = new StreamObserver<DiscoveryResponse>(){

                public void onNext(DiscoveryResponse response) {
                    DiscoveryResponseData responseData = DiscoveryResponseData.fromEnvoyProtoV2(response);
                    if (XdsClientImpl.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                        XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", new Object[]{responseData.getResourceType(), XdsClientImpl.this.respPrinter.print(response)});
                    }
                    AdsStreamV2.this.onDiscoveryResponse(responseData);
                }

                public void onError(Throwable t) {
                    AdsStreamV2.this.onError(t);
                }

                public void onCompleted() {
                    AdsStreamV2.this.onCompleted();
                }
            };
            this.requestWriterV2 = ((AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub)this.stubV2.withWaitForReady()).streamAggregatedResources(responseReaderV2);
        }

        @Override
        void sendDiscoveryRequest(DiscoveryRequestData request) {
            Preconditions.checkState((this.requestWriterV2 != null ? 1 : 0) != 0, (Object)"ADS stream has not been started");
            DiscoveryRequest requestProto = request.toEnvoyProtoV2();
            this.requestWriterV2.onNext((Object)requestProto);
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", requestProto);
        }

        @Override
        void sendError(Exception error) {
            this.requestWriterV2.onError((Throwable)error);
        }
    }

    private abstract class AbstractAdsStream {
        private boolean responseReceived;
        private boolean closed;
        private String ldsVersion = "";
        private String rdsVersion = "";
        private String cdsVersion = "";
        private String edsVersion = "";
        private String ldsRespNonce = "";
        private String rdsRespNonce = "";
        private String cdsRespNonce = "";
        private String edsRespNonce = "";
        @Nullable
        private String rdsResourceName;

        private AbstractAdsStream() {
        }

        abstract void start();

        abstract void sendDiscoveryRequest(DiscoveryRequestData var1);

        abstract void sendError(Exception var1);

        final void onDiscoveryResponse(final DiscoveryResponseData response) {
            XdsClientImpl.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (AbstractAdsStream.this.closed) {
                        return;
                    }
                    AbstractAdsStream.this.responseReceived = true;
                    String respNonce = response.getNonce();
                    ResourceType resourceType = response.getResourceType();
                    switch (resourceType) {
                        case LDS: {
                            AbstractAdsStream.this.ldsRespNonce = respNonce;
                            XdsClientImpl.this.handleLdsResponse(response);
                            break;
                        }
                        case RDS: {
                            AbstractAdsStream.this.rdsRespNonce = respNonce;
                            XdsClientImpl.this.handleRdsResponse(response);
                            break;
                        }
                        case CDS: {
                            AbstractAdsStream.this.cdsRespNonce = respNonce;
                            XdsClientImpl.this.handleCdsResponse(response);
                            break;
                        }
                        case EDS: {
                            AbstractAdsStream.this.edsRespNonce = respNonce;
                            XdsClientImpl.this.handleEdsResponse(response);
                            break;
                        }
                        case UNKNOWN: {
                            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received an unknown type of DiscoveryResponse\n{0}", respNonce);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Missing case in enum switch: " + (Object)((Object)resourceType)));
                        }
                    }
                }
            });
        }

        final void onError(final Throwable t) {
            XdsClientImpl.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractAdsStream.this.handleStreamClosed(Status.fromThrowable((Throwable)t));
                }
            });
        }

        final void onCompleted() {
            XdsClientImpl.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractAdsStream.this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
                }
            });
        }

        private void handleStreamClosed(Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "ADS stream closed with status {0}: {1}. Cause: {2}", error.getCode(), error.getDescription(), error.getCause());
            this.closed = true;
            if (XdsClientImpl.this.configWatcher != null) {
                XdsClientImpl.this.configWatcher.onError(error);
            }
            if (XdsClientImpl.this.listenerWatcher != null) {
                XdsClientImpl.this.listenerWatcher.onError(error);
            }
            for (Set watchers : XdsClientImpl.this.clusterWatchers.values()) {
                for (XdsClient.ResourceWatcher watcher : watchers) {
                    watcher.onError(error);
                }
            }
            for (Set watchers : XdsClientImpl.this.endpointWatchers.values()) {
                for (XdsClient.ResourceWatcher watcher : watchers) {
                    watcher.onError(error);
                }
            }
            this.cleanUp();
            XdsClientImpl.this.cleanUpResources();
            if (this.responseReceived || XdsClientImpl.this.retryBackoffPolicy == null) {
                XdsClientImpl.this.retryBackoffPolicy = XdsClientImpl.this.backoffPolicyProvider.get();
            }
            long delayNanos = 0L;
            if (!this.responseReceived) {
                delayNanos = Math.max(0L, XdsClientImpl.this.retryBackoffPolicy.nextBackoffNanos() - XdsClientImpl.this.adsStreamRetryStopwatch.elapsed(TimeUnit.NANOSECONDS));
            }
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry ADS stream in {0} ns", delayNanos);
            XdsClientImpl.this.rpcRetryTimer = XdsClientImpl.this.syncContext.schedule((Runnable)new RpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, XdsClientImpl.this.timeService);
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.sendError(error);
        }

        private void cleanUp() {
            if (XdsClientImpl.this.adsStream == this) {
                XdsClientImpl.this.adsStream = null;
            }
        }

        private void sendXdsRequest(ResourceType resourceType, Collection<String> resourceNames) {
            String nonce;
            String version;
            switch (resourceType) {
                case LDS: {
                    version = this.ldsVersion;
                    nonce = this.ldsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending LDS request for resources: {0}", resourceNames);
                    break;
                }
                case RDS: {
                    Preconditions.checkArgument((resourceNames.size() == 1 ? 1 : 0) != 0, (Object)"RDS request requesting for more than one resource");
                    version = this.rdsVersion;
                    nonce = this.rdsRespNonce;
                    this.rdsResourceName = resourceNames.iterator().next();
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending RDS request for resources: {0}", resourceNames);
                    break;
                }
                case CDS: {
                    version = this.cdsVersion;
                    nonce = this.cdsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending CDS request for resources: {0}", resourceNames);
                    break;
                }
                case EDS: {
                    version = this.edsVersion;
                    nonce = this.edsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending EDS request for resources: {0}", resourceNames);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)resourceType)));
                }
            }
            DiscoveryRequestData request = new DiscoveryRequestData(resourceType, resourceNames, version, nonce, XdsClientImpl.this.node, null);
            this.sendDiscoveryRequest(request);
        }

        private void sendAckRequest(ResourceType resourceType, Collection<String> resourceNames, String versionInfo) {
            String nonce;
            switch (resourceType) {
                case LDS: {
                    this.ldsVersion = versionInfo;
                    nonce = this.ldsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending ACK for LDS update, version: {0}", versionInfo);
                    break;
                }
                case RDS: {
                    this.rdsVersion = versionInfo;
                    nonce = this.rdsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending ACK for RDS update, version: {0}", versionInfo);
                    break;
                }
                case CDS: {
                    this.cdsVersion = versionInfo;
                    nonce = this.cdsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending ACK for CDS update, version: {0}", versionInfo);
                    break;
                }
                case EDS: {
                    this.edsVersion = versionInfo;
                    nonce = this.edsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending ACK for EDS update, version: {0}", versionInfo);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)resourceType)));
                }
            }
            DiscoveryRequestData request = new DiscoveryRequestData(resourceType, resourceNames, versionInfo, nonce, XdsClientImpl.this.node, null);
            this.sendDiscoveryRequest(request);
        }

        private void sendNackRequest(ResourceType resourceType, Collection<String> resourceNames, String rejectVersion, String message) {
            String nonce;
            String versionInfo;
            switch (resourceType) {
                case LDS: {
                    versionInfo = this.ldsVersion;
                    nonce = this.ldsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending NACK for LDS update, version: {0}, reason: {1}", rejectVersion, message);
                    break;
                }
                case RDS: {
                    versionInfo = this.rdsVersion;
                    nonce = this.rdsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending NACK for RDS update, version: {0}, reason: {1}", rejectVersion, message);
                    break;
                }
                case CDS: {
                    versionInfo = this.cdsVersion;
                    nonce = this.cdsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending NACK for CDS update, version: {0}, reason: {1}", rejectVersion, message);
                    break;
                }
                case EDS: {
                    versionInfo = this.edsVersion;
                    nonce = this.edsRespNonce;
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending NACK for EDS update, version: {0}, reason: {1}", rejectVersion, message);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)resourceType)));
                }
            }
            com.google.rpc.Status error = com.google.rpc.Status.newBuilder().setCode(3).setMessage(message).build();
            DiscoveryRequestData request = new DiscoveryRequestData(resourceType, resourceNames, versionInfo, nonce, XdsClientImpl.this.node, error);
            this.sendDiscoveryRequest(request);
        }
    }

    private static final class DiscoveryResponseData {
        private final ResourceType resourceType;
        private final List<Any> resources;
        private final String versionInfo;
        private final String nonce;

        DiscoveryResponseData(ResourceType resourceType, List<Any> resources, String versionInfo, String nonce) {
            this.resourceType = resourceType;
            this.resources = resources;
            this.versionInfo = versionInfo;
            this.nonce = nonce;
        }

        ResourceType getResourceType() {
            return this.resourceType;
        }

        List<Any> getResourcesList() {
            return this.resources;
        }

        String getVersionInfo() {
            return this.versionInfo;
        }

        String getNonce() {
            return this.nonce;
        }

        static DiscoveryResponseData fromEnvoyProto(io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse proto) {
            return new DiscoveryResponseData(ResourceType.fromTypeUrl(proto.getTypeUrl()), proto.getResourcesList(), proto.getVersionInfo(), proto.getNonce());
        }

        static DiscoveryResponseData fromEnvoyProtoV2(DiscoveryResponse proto) {
            return new DiscoveryResponseData(ResourceType.fromTypeUrl(proto.getTypeUrl()), proto.getResourcesList(), proto.getVersionInfo(), proto.getNonce());
        }
    }

    private static final class DiscoveryRequestData {
        private final ResourceType resourceType;
        private final Collection<String> resourceNames;
        private final String versionInfo;
        private final String responseNonce;
        private final EnvoyProtoData.Node node;
        @Nullable
        private final com.google.rpc.Status errorDetail;

        DiscoveryRequestData(ResourceType resourceType, Collection<String> resourceNames, String versionInfo, String responseNonce, EnvoyProtoData.Node node, @Nullable com.google.rpc.Status errorDetail) {
            this.resourceType = resourceType;
            this.resourceNames = resourceNames;
            this.versionInfo = versionInfo;
            this.responseNonce = responseNonce;
            this.node = node;
            this.errorDetail = errorDetail;
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest toEnvoyProto() {
            DiscoveryRequest.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest.newBuilder().setVersionInfo(this.versionInfo).setNode(this.node.toEnvoyProtoNode()).addAllResourceNames(this.resourceNames).setTypeUrl(this.resourceType.typeUrl()).setResponseNonce(this.responseNonce);
            if (this.errorDetail != null) {
                builder.setErrorDetail(this.errorDetail);
            }
            return builder.build();
        }

        DiscoveryRequest toEnvoyProtoV2() {
            DiscoveryRequest.Builder builder = DiscoveryRequest.newBuilder().setVersionInfo(this.versionInfo).setNode(this.node.toEnvoyProtoNodeV2()).addAllResourceNames(this.resourceNames).setTypeUrl(this.resourceType.typeUrlV2()).setResponseNonce(this.responseNonce);
            if (this.errorDetail != null) {
                builder.setErrorDetail(this.errorDetail);
            }
            return builder.build();
        }
    }

    private static enum ResourceType {
        UNKNOWN,
        LDS,
        RDS,
        CDS,
        EDS;


        String typeUrl() {
            switch (this) {
                case LDS: {
                    return XdsClientImpl.ADS_TYPE_URL_LDS;
                }
                case RDS: {
                    return XdsClientImpl.ADS_TYPE_URL_RDS;
                }
                case CDS: {
                    return XdsClientImpl.ADS_TYPE_URL_CDS;
                }
                case EDS: {
                    return XdsClientImpl.ADS_TYPE_URL_EDS;
                }
            }
            throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)this)));
        }

        String typeUrlV2() {
            switch (this) {
                case LDS: {
                    return XdsClientImpl.ADS_TYPE_URL_LDS_V2;
                }
                case RDS: {
                    return XdsClientImpl.ADS_TYPE_URL_RDS_V2;
                }
                case CDS: {
                    return XdsClientImpl.ADS_TYPE_URL_CDS_V2;
                }
                case EDS: {
                    return XdsClientImpl.ADS_TYPE_URL_EDS_V2;
                }
            }
            throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)this)));
        }

        static ResourceType fromTypeUrl(String typeUrl) {
            switch (typeUrl) {
                case "type.googleapis.com/envoy.config.listener.v3.Listener": 
                case "type.googleapis.com/envoy.api.v2.Listener": {
                    return LDS;
                }
                case "type.googleapis.com/envoy.config.route.v3.RouteConfiguration": 
                case "type.googleapis.com/envoy.api.v2.RouteConfiguration": {
                    return RDS;
                }
                case "type.googleapis.com/envoy.config.cluster.v3.Cluster": 
                case "type.googleapis.com/envoy.api.v2.Cluster": {
                    return CDS;
                }
                case "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment": 
                case "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment": {
                    return EDS;
                }
            }
            return UNKNOWN;
        }
    }

    @VisibleForTesting
    final class RpcRetryTask
    implements Runnable {
        RpcRetryTask() {
        }

        @Override
        public void run() {
            SynchronizationContext.ScheduledHandle timeoutHandle;
            XdsClientImpl.this.startRpcStream();
            if (XdsClientImpl.this.configWatcher != null) {
                XdsClientImpl.this.adsStream.sendXdsRequest(ResourceType.LDS, (Collection)ImmutableList.of((Object)XdsClientImpl.this.ldsResourceName));
                XdsClientImpl.this.ldsRespTimer = XdsClientImpl.this.syncContext.schedule((Runnable)new LdsResourceFetchTimeoutTask(XdsClientImpl.this.ldsResourceName), 15L, TimeUnit.SECONDS, XdsClientImpl.this.timeService);
            }
            if (XdsClientImpl.this.listenerWatcher != null) {
                XdsClientImpl.this.adsStream.sendXdsRequest(ResourceType.LDS, (Collection)ImmutableList.of());
                XdsClientImpl.this.ldsRespTimer = XdsClientImpl.this.syncContext.schedule((Runnable)new ListenerResourceFetchTimeoutTask(":" + XdsClientImpl.this.listenerPort), 15L, TimeUnit.SECONDS, XdsClientImpl.this.timeService);
            }
            if (!XdsClientImpl.this.clusterWatchers.isEmpty()) {
                XdsClientImpl.this.adsStream.sendXdsRequest(ResourceType.CDS, XdsClientImpl.this.clusterWatchers.keySet());
                for (String clusterName : XdsClientImpl.this.clusterWatchers.keySet()) {
                    timeoutHandle = XdsClientImpl.this.syncContext.schedule((Runnable)new CdsResourceFetchTimeoutTask(clusterName), 15L, TimeUnit.SECONDS, XdsClientImpl.this.timeService);
                    XdsClientImpl.this.cdsRespTimers.put(clusterName, timeoutHandle);
                }
            }
            if (!XdsClientImpl.this.endpointWatchers.isEmpty()) {
                XdsClientImpl.this.adsStream.sendXdsRequest(ResourceType.EDS, XdsClientImpl.this.endpointWatchers.keySet());
                for (String clusterName : XdsClientImpl.this.endpointWatchers.keySet()) {
                    timeoutHandle = XdsClientImpl.this.syncContext.schedule((Runnable)new EdsResourceFetchTimeoutTask(clusterName), 15L, TimeUnit.SECONDS, XdsClientImpl.this.timeService);
                    XdsClientImpl.this.edsRespTimers.put(clusterName, timeoutHandle);
                }
            }
        }
    }
}

