/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.Internal;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.XdsNameResolver2;
import java.net.URI;
import java.util.concurrent.ScheduledExecutorService;

@Internal
public final class XdsNameResolverProvider2
extends NameResolverProvider {
    private static final String SCHEME = "xds";

    public XdsNameResolver2 newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            RefCountedXdsClientPoolFactory xdsClientPoolFactory = new RefCountedXdsClientPoolFactory(name, XdsClient.XdsChannelFactory.getInstance(), args.getSynchronizationContext(), args.getScheduledExecutorService(), (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider(), (Supplier<Stopwatch>)GrpcUtil.STOPWATCH_SUPPLIER);
            return new XdsNameResolver2(name, args.getServiceConfigParser(), args.getSynchronizationContext(), xdsClientPoolFactory);
        }
        return null;
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 4;
    }

    static class RefCountedXdsClientPoolFactory
    implements XdsClient.XdsClientPoolFactory {
        private final String serviceName;
        private final XdsClient.XdsChannelFactory channelFactory;
        private final SynchronizationContext syncContext;
        private final ScheduledExecutorService timeService;
        private final BackoffPolicy.Provider backoffPolicyProvider;
        private final Supplier<Stopwatch> stopwatchSupplier;

        RefCountedXdsClientPoolFactory(String serviceName, XdsClient.XdsChannelFactory channelFactory, SynchronizationContext syncContext, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
            this.channelFactory = (XdsClient.XdsChannelFactory)Preconditions.checkNotNull((Object)channelFactory, (Object)"channelFactory");
            this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
            this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService, (Object)"timeService");
            this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
            this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        }

        @Override
        public ObjectPool<XdsClient> newXdsClientObjectPool(final Bootstrapper.BootstrapInfo bootstrapInfo) {
            XdsClient.XdsClientFactory xdsClientFactory = new XdsClient.XdsClientFactory(){

                @Override
                XdsClient createXdsClient() {
                    return new XdsClientImpl(RefCountedXdsClientPoolFactory.this.serviceName, bootstrapInfo.getServers(), RefCountedXdsClientPoolFactory.this.channelFactory, bootstrapInfo.getNode(), RefCountedXdsClientPoolFactory.this.syncContext, RefCountedXdsClientPoolFactory.this.timeService, RefCountedXdsClientPoolFactory.this.backoffPolicyProvider, (Supplier<Stopwatch>)RefCountedXdsClientPoolFactory.this.stopwatchSupplier);
                }
            };
            return new XdsClient.RefCountedXdsClientObjectPool(xdsClientFactory);
        }
    }
}

