/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.RouteMatch;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsRoutingLoadBalancerProvider;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class XdsRoutingLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    static final int DELAYED_ACTION_DELETION_TIME_MINUTES = 15;
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final Map<String, ChildLbState> childLbStates = new HashMap<String, ChildLbState>();
    private List<XdsRoutingLoadBalancerProvider.Route> routes = ImmutableList.of();

    XdsRoutingLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"xds-routing-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        XdsRoutingLoadBalancerProvider.XdsRoutingConfig xdsRoutingConfig = (XdsRoutingLoadBalancerProvider.XdsRoutingConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        Map<String, ServiceConfigUtil.PolicySelection> newActions = xdsRoutingConfig.actions;
        for (String actionName : newActions.keySet()) {
            ServiceConfigUtil.PolicySelection action = newActions.get(actionName);
            if (!this.childLbStates.containsKey(actionName)) {
                this.childLbStates.put(actionName, new ChildLbState(actionName, action.getProvider()));
            } else {
                this.childLbStates.get(actionName).reactivate(action.getProvider());
            }
            GracefulSwitchLoadBalancer childLb = this.childLbStates.get(actionName).lb;
            this.syncContext.execute(new Runnable((LoadBalancer)childLb, resolvedAddresses, action){
                final /* synthetic */ LoadBalancer val$childLb;
                final /* synthetic */ LoadBalancer.ResolvedAddresses val$resolvedAddresses;
                final /* synthetic */ ServiceConfigUtil.PolicySelection val$action;
                {
                    this.val$childLb = loadBalancer;
                    this.val$resolvedAddresses = resolvedAddresses;
                    this.val$action = policySelection;
                }

                @Override
                public void run() {
                    this.val$childLb.handleResolvedAddresses(this.val$resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(this.val$action.getConfig()).build());
                }
            });
        }
        this.routes = xdsRoutingConfig.routes;
        Sets.SetView diff = Sets.difference(this.childLbStates.keySet(), newActions.keySet());
        for (String actionName : diff) {
            this.childLbStates.get(actionName).deactivate();
        }
        this.updateOverallBalancingState();
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        boolean gotoTransientFailure = true;
        for (ChildLbState state : this.childLbStates.values()) {
            if (state.deactivated) continue;
            gotoTransientFailure = false;
            state.lb.handleNameResolutionError(error);
        }
        if (gotoTransientFailure) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        for (ChildLbState state : this.childLbStates.values()) {
            state.tearDown();
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    private void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        LinkedHashMap<RouteMatch, LoadBalancer.SubchannelPicker> routePickers = new LinkedHashMap<RouteMatch, LoadBalancer.SubchannelPicker>();
        for (XdsRoutingLoadBalancerProvider.Route route : this.routes) {
            ChildLbState state = this.childLbStates.get(route.getActionName());
            routePickers.put(route.getRouteMatch(), state.currentPicker);
            overallState = XdsRoutingLoadBalancer.aggregateState(overallState, state.currentState);
        }
        if (overallState != null) {
            RouteMatchingSubchannelPicker picker = new RouteMatchingSubchannelPicker(routePickers);
            this.helper.updateBalancingState(overallState, (LoadBalancer.SubchannelPicker)picker);
        }
    }

    @Nullable
    @VisibleForTesting
    static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    @VisibleForTesting
    static final class RouteMatchingSubchannelPicker
    extends LoadBalancer.SubchannelPicker {
        @VisibleForTesting
        final Map<RouteMatch, LoadBalancer.SubchannelPicker> routePickers;

        RouteMatchingSubchannelPicker(Map<RouteMatch, LoadBalancer.SubchannelPicker> routePickers) {
            this.routePickers = routePickers;
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            HashMap<String, Iterable<String>> asciiHeaders = new HashMap<String, Iterable<String>>();
            Metadata headers = args.getHeaders();
            for (String string : headers.keys()) {
                if (string.endsWith("-bin")) continue;
                Metadata.Key key = Metadata.Key.of((String)string, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                asciiHeaders.put(string, headers.getAll(key));
            }
            for (Map.Entry entry : this.routePickers.entrySet()) {
                RouteMatch routeMatch = (RouteMatch)entry.getKey();
                if (!routeMatch.matches("/" + args.getMethodDescriptor().getFullMethodName(), asciiHeaders)) continue;
                return ((LoadBalancer.SubchannelPicker)entry.getValue()).pickSubchannel(args);
            }
            return LoadBalancer.PickResult.withError((Status)Status.UNAVAILABLE.withDescription("no matching route found"));
        }
    }

    private final class ChildLbState {
        private final String name;
        private final GracefulSwitchLoadBalancer lb;
        private LoadBalancerProvider policyProvider;
        private ConnectivityState currentState = ConnectivityState.CONNECTING;
        private LoadBalancer.SubchannelPicker currentPicker = XdsSubchannelPickers.BUFFER_PICKER;
        private boolean deactivated;
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;

        private ChildLbState(String name, LoadBalancerProvider policyProvider) {
            this.name = name;
            this.policyProvider = policyProvider;
            this.lb = new GracefulSwitchLoadBalancer((LoadBalancer.Helper)new RouteHelper());
            this.lb.switchTo((LoadBalancer.Factory)policyProvider);
        }

        void deactivate() {
            if (this.deactivated) {
                return;
            }
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ChildLbState.this.tearDown();
                    XdsRoutingLoadBalancer.this.childLbStates.remove(ChildLbState.this.name);
                }
            }
            this.deletionTimer = XdsRoutingLoadBalancer.this.syncContext.schedule((Runnable)new DeletionTask(), 15L, TimeUnit.MINUTES, XdsRoutingLoadBalancer.this.timeService);
            this.deactivated = true;
            XdsRoutingLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Route action {0} deactivated", this.name);
        }

        void reactivate(LoadBalancerProvider policyProvider) {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
                this.deactivated = false;
                XdsRoutingLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Route action {0} reactivated", this.name);
            }
            if (!this.policyProvider.getPolicyName().equals(policyProvider.getPolicyName())) {
                XdsRoutingLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Action {0} switching policy from {1} to {2}", this.name, this.policyProvider.getPolicyName(), policyProvider.getPolicyName());
                this.lb.switchTo((LoadBalancer.Factory)policyProvider);
                this.policyProvider = policyProvider;
            }
        }

        void tearDown() {
            this.deactivated = true;
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
            }
            this.lb.shutdown();
            XdsRoutingLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Route action {0} deleted", this.name);
        }

        private final class RouteHelper
        extends ForwardingLoadBalancerHelper {
            private RouteHelper() {
            }

            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                ChildLbState.this.currentState = newState;
                ChildLbState.this.currentPicker = newPicker;
                if (!ChildLbState.this.deactivated) {
                    XdsRoutingLoadBalancer.this.updateOverallBalancingState();
                }
            }

            protected LoadBalancer.Helper delegate() {
                return XdsRoutingLoadBalancer.this.helper;
            }
        }
    }
}

