/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerStreamTracer;
import io.grpc.ServerTransportFilter;
import io.grpc.Status;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.xds.internal.sds.SdsProtocolNegotiators;
import io.grpc.xds.internal.sds.ServerWrapperForXds;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class XdsServerBuilder
extends ServerBuilder<XdsServerBuilder> {
    private final NettyServerBuilder delegate;
    private final int port;
    private InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;
    private ErrorNotifier errorNotifier;

    private XdsServerBuilder(NettyServerBuilder nettyDelegate, int port) {
        this.delegate = nettyDelegate;
        this.port = port;
    }

    public XdsServerBuilder handshakeTimeout(long timeout, TimeUnit unit) {
        this.delegate.handshakeTimeout(timeout, unit);
        return this;
    }

    public XdsServerBuilder directExecutor() {
        this.delegate.directExecutor();
        return this;
    }

    public XdsServerBuilder addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.delegate.addStreamTracerFactory(factory);
        return this;
    }

    public XdsServerBuilder addTransportFilter(ServerTransportFilter filter) {
        this.delegate.addTransportFilter(filter);
        return this;
    }

    public XdsServerBuilder executor(Executor executor) {
        this.delegate.executor(executor);
        return this;
    }

    public XdsServerBuilder addService(ServerServiceDefinition service) {
        this.delegate.addService(service);
        return this;
    }

    public XdsServerBuilder addService(BindableService bindableService) {
        this.delegate.addService(bindableService);
        return this;
    }

    public XdsServerBuilder fallbackHandlerRegistry(@Nullable HandlerRegistry fallbackRegistry) {
        this.delegate.fallbackHandlerRegistry(fallbackRegistry);
        return this;
    }

    public XdsServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("Cannot set security parameters on XdsServerBuilder");
    }

    public XdsServerBuilder decompressorRegistry(@Nullable DecompressorRegistry registry) {
        this.delegate.decompressorRegistry(registry);
        return this;
    }

    public XdsServerBuilder compressorRegistry(@Nullable CompressorRegistry registry) {
        this.delegate.compressorRegistry(registry);
        return this;
    }

    public XdsServerBuilder intercept(ServerInterceptor interceptor) {
        this.delegate.intercept(interceptor);
        return this;
    }

    public XdsServerBuilder fallbackProtocolNegotiator(InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
        this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        return this;
    }

    public XdsServerBuilder errorNotifier(ErrorNotifier errorNotifier) {
        this.errorNotifier = errorNotifier;
        return this;
    }

    public static XdsServerBuilder forPort(int port) {
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(port));
        return new XdsServerBuilder(nettyDelegate, port);
    }

    public Server build() {
        SdsProtocolNegotiators.ServerSdsProtocolNegotiator serverProtocolNegotiator = SdsProtocolNegotiators.serverProtocolNegotiator(this.port, this.fallbackProtocolNegotiator);
        return this.buildServer(serverProtocolNegotiator);
    }

    @VisibleForTesting
    public ServerWrapperForXds buildServer(SdsProtocolNegotiators.ServerSdsProtocolNegotiator serverProtocolNegotiator) {
        this.delegate.protocolNegotiator((ProtocolNegotiator)serverProtocolNegotiator);
        return new ServerWrapperForXds(this.delegate.build(), serverProtocolNegotiator.getXdsClientWrapperForServerSds(), this.errorNotifier);
    }

    public static interface ErrorNotifier {
        public void onError(Status var1);
    }
}

