/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonParser;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Internal
public abstract class Bootstrapper {
    private static final String LOG_PREFIX = "xds-bootstrap";
    private static final String BOOTSTRAP_PATH_SYS_ENV_VAR = "GRPC_XDS_BOOTSTRAP";
    private static final String BOOTSTRAP_PATH_SYS_PROPERTY_VAR = "io.grpc.xds.bootstrap";
    @VisibleForTesting
    static final String CLIENT_FEATURE_DISABLE_OVERPROVISIONING = "envoy.lb.does_not_support_overprovisioning";
    private static final Bootstrapper DEFAULT_INSTANCE = new Bootstrapper(){

        @Override
        public BootstrapInfo readBootstrap() throws XdsInitializationException {
            String fileContent;
            String filePathSource = Bootstrapper.BOOTSTRAP_PATH_SYS_ENV_VAR;
            String filePath = System.getenv(filePathSource);
            if (filePath == null) {
                filePathSource = Bootstrapper.BOOTSTRAP_PATH_SYS_PROPERTY_VAR;
                filePath = System.getProperty(filePathSource);
            }
            if (filePath == null) {
                throw new XdsInitializationException("Environment variable GRPC_XDS_BOOTSTRAP or Java System Property io.grpc.xds.bootstrap not defined.");
            }
            XdsLogger.withPrefix(Bootstrapper.LOG_PREFIX).log(XdsLogger.XdsLogLevel.INFO, filePathSource + "={0}", filePath);
            try {
                fileContent = new String(Files.readAllBytes(Paths.get(filePath, new String[0])), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new XdsInitializationException("Fail to read bootstrap file", e);
            }
            return 1.parseConfig(fileContent);
        }
    };

    public static Bootstrapper getInstance() {
        return DEFAULT_INSTANCE;
    }

    public abstract BootstrapInfo readBootstrap() throws XdsInitializationException;

    @VisibleForTesting
    static BootstrapInfo parseConfig(String rawData) throws XdsInitializationException {
        Map rawBootstrap;
        XdsLogger logger = XdsLogger.withPrefix(LOG_PREFIX);
        logger.log(XdsLogger.XdsLogLevel.INFO, "Reading bootstrap information");
        try {
            rawBootstrap = (Map)JsonParser.parse((String)rawData);
        }
        catch (IOException e) {
            throw new XdsInitializationException("Failed to parse JSON", e);
        }
        logger.log(XdsLogger.XdsLogLevel.DEBUG, "Bootstrap configuration:\n{0}", rawBootstrap);
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        List rawServerConfigs = JsonUtil.getList((Map)rawBootstrap, (String)"xds_servers");
        if (rawServerConfigs == null) {
            throw new XdsInitializationException("Invalid bootstrap: 'xds_servers' does not exist.");
        }
        logger.log(XdsLogger.XdsLogLevel.INFO, "Configured with {0} xDS servers", rawServerConfigs.size());
        List serverConfigList = JsonUtil.checkObjectList((List)rawServerConfigs);
        for (Map serverConfig : serverConfigList) {
            String serverUri = JsonUtil.getString((Map)serverConfig, (String)"server_uri");
            if (serverUri == null) {
                throw new XdsInitializationException("Invalid bootstrap: missing 'xds_servers'");
            }
            logger.log(XdsLogger.XdsLogLevel.INFO, "xDS server URI: {0}", serverUri);
            ArrayList<ChannelCreds> channelCredsOptions = new ArrayList<ChannelCreds>();
            List rawChannelCredsList = JsonUtil.getList((Map)serverConfig, (String)"channel_creds");
            if (rawChannelCredsList == null || rawChannelCredsList.isEmpty()) {
                throw new XdsInitializationException("Invalid bootstrap: server " + serverUri + " 'channel_creds' required");
            }
            List channelCredsList = JsonUtil.checkObjectList((List)rawChannelCredsList);
            for (Map channelCreds : channelCredsList) {
                String type = JsonUtil.getString((Map)channelCreds, (String)"type");
                if (type == null) {
                    throw new XdsInitializationException("Invalid bootstrap: server " + serverUri + " with 'channel_creds' type unspecified");
                }
                logger.log(XdsLogger.XdsLogLevel.INFO, "Channel credentials option: {0}", type);
                ChannelCreds creds = new ChannelCreds(type, JsonUtil.getObject((Map)channelCreds, (String)"config"));
                channelCredsOptions.add(creds);
            }
            List serverFeatures = JsonUtil.getListOfStrings((Map)serverConfig, (String)"server_features");
            if (serverFeatures != null) {
                logger.log(XdsLogger.XdsLogLevel.INFO, "Server features: {0}", serverFeatures);
            }
            servers.add(new ServerInfo(serverUri, channelCredsOptions, serverFeatures));
        }
        EnvoyProtoData.Node.Builder nodeBuilder = EnvoyProtoData.Node.newBuilder();
        Map rawNode = JsonUtil.getObject((Map)rawBootstrap, (String)"node");
        if (rawNode != null) {
            Object rawLocality;
            Map metadata;
            String cluster;
            String id = JsonUtil.getString((Map)rawNode, (String)"id");
            if (id != null) {
                logger.log(XdsLogger.XdsLogLevel.INFO, "Node id: {0}", id);
                nodeBuilder.setId(id);
            }
            if ((cluster = JsonUtil.getString((Map)rawNode, (String)"cluster")) != null) {
                logger.log(XdsLogger.XdsLogLevel.INFO, "Node cluster: {0}", cluster);
                nodeBuilder.setCluster(cluster);
            }
            if ((metadata = JsonUtil.getObject((Map)rawNode, (String)"metadata")) != null) {
                nodeBuilder.setMetadata(metadata);
            }
            if ((rawLocality = JsonUtil.getObject((Map)rawNode, (String)"locality")) != null) {
                String region = JsonUtil.getString((Map)rawLocality, (String)"region");
                String zone = JsonUtil.getString((Map)rawLocality, (String)"zone");
                String subZone = JsonUtil.getString((Map)rawLocality, (String)"sub_zone");
                if (region != null) {
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Locality region: {0}", region);
                }
                if (rawLocality.containsKey("zone")) {
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Locality zone: {0}", zone);
                }
                if (rawLocality.containsKey("sub_zone")) {
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Locality sub_zone: {0}", subZone);
                }
                EnvoyProtoData.Locality locality = new EnvoyProtoData.Locality(region, zone, subZone);
                nodeBuilder.setLocality(locality);
            }
        }
        GrpcUtil.GrpcBuildVersion buildVersion = GrpcUtil.getGrpcBuildVersion();
        logger.log(XdsLogger.XdsLogLevel.INFO, "Build version: {0}", buildVersion);
        nodeBuilder.setBuildVersion(buildVersion.toString());
        nodeBuilder.setUserAgentName(buildVersion.getUserAgent());
        nodeBuilder.setUserAgentVersion(buildVersion.getImplementationVersion());
        nodeBuilder.addClientFeatures(CLIENT_FEATURE_DISABLE_OVERPROVISIONING);
        Map certProvidersBlob = JsonUtil.getObject((Map)rawBootstrap, (String)"certificate_providers");
        HashMap<String, CertificateProviderInfo> certProviders = null;
        if (certProvidersBlob != null) {
            certProviders = new HashMap<String, CertificateProviderInfo>(certProvidersBlob.size());
            for (String name : certProvidersBlob.keySet()) {
                Map valueMap = JsonUtil.getObject((Map)certProvidersBlob, (String)name);
                String pluginName = Bootstrapper.checkForNull(JsonUtil.getString((Map)valueMap, (String)"plugin_name"), "plugin_name");
                Map config = Bootstrapper.checkForNull(JsonUtil.getObject((Map)valueMap, (String)"config"), "config");
                CertificateProviderInfo certificateProviderInfo = new CertificateProviderInfo(pluginName, config);
                certProviders.put(name, certificateProviderInfo);
            }
        }
        String grpcServerResourceId = JsonUtil.getString((Map)rawBootstrap, (String)"grpc_server_resource_name_id");
        return new BootstrapInfo(servers, nodeBuilder.build(), certProviders, grpcServerResourceId);
    }

    static <T> T checkForNull(T value, String fieldName) throws XdsInitializationException {
        if (value == null) {
            throw new XdsInitializationException("Invalid bootstrap: '" + fieldName + "' does not exist.");
        }
        return value;
    }

    @Internal
    @Immutable
    public static class BootstrapInfo {
        private List<ServerInfo> servers;
        private final EnvoyProtoData.Node node;
        @Nullable
        private final Map<String, CertificateProviderInfo> certProviders;
        @Nullable
        private final String grpcServerResourceId;

        @VisibleForTesting
        BootstrapInfo(List<ServerInfo> servers, EnvoyProtoData.Node node, Map<String, CertificateProviderInfo> certProviders, String grpcServerResourceId) {
            this.servers = servers;
            this.node = node;
            this.certProviders = certProviders;
            this.grpcServerResourceId = grpcServerResourceId;
        }

        List<ServerInfo> getServers() {
            return Collections.unmodifiableList(this.servers);
        }

        public EnvoyProtoData.Node getNode() {
            return this.node;
        }

        public Map<String, CertificateProviderInfo> getCertProviders() {
            return Collections.unmodifiableMap(this.certProviders);
        }

        @Nullable
        public String getGrpcServerResourceId() {
            return this.grpcServerResourceId;
        }
    }

    @Internal
    @Immutable
    public static class CertificateProviderInfo {
        private final String pluginName;
        private final Map<String, ?> config;

        CertificateProviderInfo(String pluginName, Map<String, ?> config) {
            this.pluginName = (String)Preconditions.checkNotNull((Object)pluginName, (Object)"pluginName");
            this.config = (Map)Preconditions.checkNotNull(config, (Object)"config");
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public Map<String, ?> getConfig() {
            return this.config;
        }
    }

    @Immutable
    static class ServerInfo {
        private final String serverUri;
        private final List<ChannelCreds> channelCredsList;
        @Nullable
        private final List<String> serverFeatures;

        @VisibleForTesting
        ServerInfo(String serverUri, List<ChannelCreds> channelCredsList, List<String> serverFeatures) {
            this.serverUri = serverUri;
            this.channelCredsList = channelCredsList;
            this.serverFeatures = serverFeatures;
        }

        String getServerUri() {
            return this.serverUri;
        }

        List<ChannelCreds> getChannelCredentials() {
            return Collections.unmodifiableList(this.channelCredsList);
        }

        List<String> getServerFeatures() {
            return this.serverFeatures == null ? Collections.emptyList() : Collections.unmodifiableList(this.serverFeatures);
        }
    }

    @Immutable
    static class ChannelCreds {
        private final String type;
        @Nullable
        private final Map<String, ?> config;

        @VisibleForTesting
        ChannelCreds(String type, @Nullable Map<String, ?> config) {
            this.type = type;
            this.config = config;
        }

        String getType() {
            return this.type;
        }

        @Nullable
        Map<String, ?> getConfig() {
            if (this.config != null) {
                return Collections.unmodifiableMap(this.config);
            }
            return null;
        }
    }
}

