/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingClientStreamTracer;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.EdsLoadBalancerProvider;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.LrsLoadBalancerProvider;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.SharedCallCounterMap;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.WeightedTargetLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

final class EdsLoadBalancer2
extends LoadBalancer {
    @VisibleForTesting
    static final long DEFAULT_PER_CLUSTER_MAX_CONCURRENT_REQUESTS = 1024L;
    @VisibleForTesting
    static boolean enableCircuitBreaking = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_CIRCUIT_BREAKING"));
    private final XdsLogger logger;
    private final SynchronizationContext syncContext;
    private final LoadBalancerRegistry lbRegistry;
    private final ThreadSafeRandom random;
    private final CallCounterProvider callCounterProvider;
    private final GracefulSwitchLoadBalancer switchingLoadBalancer;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private String cluster;
    private EdsLbState edsLbState;

    EdsLoadBalancer2(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry(), ThreadSafeRandom.ThreadSafeRandomImpl.instance, SharedCallCounterMap.getInstance());
    }

    @VisibleForTesting
    EdsLoadBalancer2(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, ThreadSafeRandom random, CallCounterProvider callCounterProvider) {
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
        this.syncContext = ((LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper")).getSynchronizationContext();
        this.callCounterProvider = (CallCounterProvider)Preconditions.checkNotNull((Object)callCounterProvider, (Object)"callCounterProvider");
        this.switchingLoadBalancer = new GracefulSwitchLoadBalancer(helper);
        InternalLogId logId = InternalLogId.allocate((String)"eds-lb", (String)helper.getAuthority());
        this.logger = XdsLogger.withLogId(logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.xdsClientPool == null) {
            this.xdsClientPool = (ObjectPool)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        EdsLoadBalancerProvider.EdsConfig config = (EdsLoadBalancerProvider.EdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received EDS lb config: cluster={0}, eds_service_name={1}, max_concurrent_requests={2}, locality_picking_policy={3}, endpoint_picking_policy={4}, report_load={5}", config.clusterName, config.edsServiceName, config.maxConcurrentRequests, config.localityPickingPolicy.getProvider().getPolicyName(), config.endpointPickingPolicy.getProvider().getPolicyName(), config.lrsServerName != null);
        }
        if (this.cluster == null) {
            this.cluster = config.clusterName;
        }
        if (this.edsLbState == null || !Objects.equals(this.edsLbState.edsServiceName, config.edsServiceName)) {
            this.edsLbState = new EdsLbState(config.edsServiceName, config.lrsServerName);
            this.switchingLoadBalancer.switchTo((LoadBalancer.Factory)this.edsLbState);
        }
        this.switchingLoadBalancer.handleResolvedAddresses(resolvedAddresses);
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchingLoadBalancer.handleNameResolutionError(error);
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        this.switchingLoadBalancer.shutdown();
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    @VisibleForTesting
    static PriorityLoadBalancerProvider.PriorityLbConfig generatePriorityLbConfig(String cluster, String edsServiceName, String lrsServerName, ServiceConfigUtil.PolicySelection localityPickingPolicy, ServiceConfigUtil.PolicySelection endpointPickingPolicy, LoadBalancerRegistry lbRegistry, Map<Integer, Map<EnvoyProtoData.Locality, Integer>> prioritizedLocalityWeights) {
        HashMap<String, ServiceConfigUtil.PolicySelection> childPolicies = new HashMap<String, ServiceConfigUtil.PolicySelection>();
        ArrayList<String> priorities = new ArrayList<String>();
        for (Integer priority : prioritizedLocalityWeights.keySet()) {
            WeightedTargetLoadBalancerProvider.WeightedTargetConfig childConfig = EdsLoadBalancer2.generateWeightedTargetLbConfig(cluster, edsServiceName, lrsServerName, endpointPickingPolicy, lbRegistry, prioritizedLocalityWeights.get(priority));
            ServiceConfigUtil.PolicySelection childPolicySelection = new ServiceConfigUtil.PolicySelection(localityPickingPolicy.getProvider(), (Object)childConfig);
            String childName = EdsLoadBalancer2.priorityName(priority);
            childPolicies.put(childName, childPolicySelection);
            priorities.add(childName);
        }
        Collections.sort(priorities);
        return new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(childPolicies), Collections.unmodifiableList(priorities));
    }

    @VisibleForTesting
    static WeightedTargetLoadBalancerProvider.WeightedTargetConfig generateWeightedTargetLbConfig(String cluster, String edsServiceName, String lrsServerName, ServiceConfigUtil.PolicySelection endpointPickingPolicy, LoadBalancerRegistry lbRegistry, Map<EnvoyProtoData.Locality, Integer> localityWeights) {
        HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> targets = new HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection>();
        for (EnvoyProtoData.Locality locality : localityWeights.keySet()) {
            ServiceConfigUtil.PolicySelection childPolicy;
            int weight = localityWeights.get(locality);
            if (lrsServerName != null) {
                LrsLoadBalancerProvider.LrsConfig childConfig = new LrsLoadBalancerProvider.LrsConfig(cluster, edsServiceName, lrsServerName, locality, endpointPickingPolicy);
                LoadBalancerProvider childPolicyProvider = lbRegistry.getProvider("lrs_experimental");
                childPolicy = new ServiceConfigUtil.PolicySelection(childPolicyProvider, (Object)childConfig);
            } else {
                childPolicy = endpointPickingPolicy;
            }
            targets.put(EdsLoadBalancer2.localityName(locality), new WeightedTargetLoadBalancerProvider.WeightedPolicySelection(weight, childPolicy));
        }
        return new WeightedTargetLoadBalancerProvider.WeightedTargetConfig(Collections.unmodifiableMap(targets));
    }

    private static String priorityName(int priority) {
        return "priority" + priority;
    }

    private static String localityName(EnvoyProtoData.Locality locality) {
        return locality.toString();
    }

    static interface CallCounterProvider {
        public AtomicLong getOrCreate(String var1, @Nullable String var2);
    }

    private static final class RequestCountingStreamTracerFactory
    extends ClientStreamTracer.Factory {
        @Nullable
        private final ClientStreamTracer.Factory delegate;
        private final AtomicLong counter;

        private RequestCountingStreamTracerFactory(@Nullable ClientStreamTracer.Factory delegate, AtomicLong counter) {
            this.delegate = delegate;
            this.counter = counter;
        }

        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            this.counter.incrementAndGet();
            if (this.delegate == null) {
                return new ClientStreamTracer(){

                    public void streamClosed(Status status) {
                        RequestCountingStreamTracerFactory.this.counter.decrementAndGet();
                    }
                };
            }
            final ClientStreamTracer delegatedTracer = this.delegate.newClientStreamTracer(info, headers);
            return new ForwardingClientStreamTracer(){

                protected ClientStreamTracer delegate() {
                    return delegatedTracer;
                }

                public void streamClosed(Status status) {
                    RequestCountingStreamTracerFactory.this.counter.decrementAndGet();
                    this.delegate().streamClosed(status);
                }
            };
        }
    }

    private final class EdsLbState
    extends LoadBalancer.Factory {
        @Nullable
        private final String edsServiceName;
        @Nullable
        private final String lrsServerName;
        private final String resourceName;

        private EdsLbState(@Nullable String edsServiceName, String lrsServerName) {
            this.edsServiceName = edsServiceName;
            this.lrsServerName = lrsServerName;
            this.resourceName = edsServiceName == null ? EdsLoadBalancer2.this.cluster : edsServiceName;
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new ChildLbState(helper);
        }

        private final class ChildLbState
        extends LoadBalancer
        implements XdsClient.EdsResourceWatcher {
            private final AtomicLong requestCount;
            @Nullable
            private final LoadStatsManager.LoadStatsStore loadStatsStore;
            private final RequestLimitingLbHelper lbHelper;
            private List<EquivalentAddressGroup> endpointAddresses = Collections.emptyList();
            private Map<Integer, Map<EnvoyProtoData.Locality, Integer>> prioritizedLocalityWeights = Collections.emptyMap();
            private LoadBalancer.ResolvedAddresses resolvedAddresses;
            private ServiceConfigUtil.PolicySelection localityPickingPolicy;
            private ServiceConfigUtil.PolicySelection endpointPickingPolicy;
            private boolean shutdown;
            @Nullable
            private LoadBalancer lb;

            private ChildLbState(LoadBalancer.Helper helper) {
                this.requestCount = EdsLoadBalancer2.this.callCounterProvider.getOrCreate(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName);
                this.loadStatsStore = EdsLbState.this.lrsServerName != null ? EdsLoadBalancer2.this.xdsClient.addClientStats(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName) : null;
                this.lbHelper = new RequestLimitingLbHelper(helper);
                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start endpoint watcher on {0} with xDS client {1}", EdsLbState.this.resourceName, EdsLoadBalancer2.this.xdsClient);
                EdsLoadBalancer2.this.xdsClient.watchEdsResource(EdsLbState.this.resourceName, this);
            }

            public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
                this.resolvedAddresses = resolvedAddresses;
                EdsLoadBalancerProvider.EdsConfig config = (EdsLoadBalancerProvider.EdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
                if (config.maxConcurrentRequests != null) {
                    this.lbHelper.updateMaxConcurrentRequests(config.maxConcurrentRequests);
                }
                if (!(this.lb == null || config.localityPickingPolicy.equals((Object)this.localityPickingPolicy) && config.endpointPickingPolicy.equals((Object)this.endpointPickingPolicy))) {
                    PriorityLoadBalancerProvider.PriorityLbConfig childConfig = EdsLoadBalancer2.generatePriorityLbConfig(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName, EdsLbState.this.lrsServerName, config.localityPickingPolicy, config.endpointPickingPolicy, EdsLoadBalancer2.this.lbRegistry, this.prioritizedLocalityWeights);
                    Attributes attributes = EdsLbState.this.lrsServerName != null ? resolvedAddresses.getAttributes().toBuilder().set(XdsAttributes.ATTR_CLUSTER_SERVICE_LOAD_STATS_STORE, (Object)this.loadStatsStore).build() : resolvedAddresses.getAttributes();
                    this.lb.handleResolvedAddresses(resolvedAddresses.toBuilder().setAddresses(this.endpointAddresses).setAttributes(attributes).setLoadBalancingPolicyConfig((Object)childConfig).build());
                }
                this.localityPickingPolicy = config.localityPickingPolicy;
                this.endpointPickingPolicy = config.endpointPickingPolicy;
            }

            public void handleNameResolutionError(Status error) {
                if (this.lb != null) {
                    this.lb.handleNameResolutionError(error);
                } else {
                    this.lbHelper.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                }
            }

            public void shutdown() {
                this.shutdown = true;
                if (EdsLbState.this.lrsServerName != null) {
                    EdsLoadBalancer2.this.xdsClient.removeClientStats(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName);
                }
                EdsLoadBalancer2.this.xdsClient.cancelEdsResourceWatch(EdsLbState.this.resourceName, this);
                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cancelled endpoint watcher on {0} with xDS client {1}", EdsLbState.this.resourceName, EdsLoadBalancer2.this.xdsClient);
                if (this.lb != null) {
                    this.lb.shutdown();
                }
            }

            public boolean canHandleEmptyAddressListFromNameResolution() {
                return true;
            }

            @Override
            public void onChanged(final XdsClient.EdsUpdate update) {
                EdsLoadBalancer2.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ChildLbState.this.shutdown) {
                            return;
                        }
                        EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update from xDS client {0}: {1}", EdsLoadBalancer2.this.xdsClient, update);
                        if (EdsLoadBalancer2.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                            EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received endpoint update: cluster_name={0}, {1} localities, {2} drop categories", update.getClusterName(), update.getLocalityLbEndpointsMap().size(), update.getDropPolicies().size());
                        }
                        ChildLbState.this.lbHelper.updateDropPolicies(update.getDropPolicies());
                        Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpoints = update.getLocalityLbEndpointsMap();
                        ChildLbState.this.endpointAddresses = new ArrayList();
                        ChildLbState.this.prioritizedLocalityWeights = new HashMap();
                        for (EnvoyProtoData.Locality locality : localityLbEndpoints.keySet()) {
                            EnvoyProtoData.LocalityLbEndpoints localityLbInfo = localityLbEndpoints.get(locality);
                            int priority = localityLbInfo.getPriority();
                            boolean discard = true;
                            for (EnvoyProtoData.LbEndpoint endpoint : localityLbInfo.getEndpoints()) {
                                if (!endpoint.isHealthy()) continue;
                                discard = false;
                                EquivalentAddressGroup eag = AddressFilter.setPathFilter(endpoint.getAddress(), Arrays.asList(EdsLoadBalancer2.priorityName(priority), EdsLoadBalancer2.localityName(locality)));
                                ChildLbState.this.endpointAddresses.add(eag);
                            }
                            if (discard) {
                                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Discard locality {0} with 0 healthy endpoints");
                                continue;
                            }
                            if (!ChildLbState.this.prioritizedLocalityWeights.containsKey(priority)) {
                                ChildLbState.this.prioritizedLocalityWeights.put(priority, new HashMap());
                            }
                            ((Map)ChildLbState.this.prioritizedLocalityWeights.get(priority)).put(locality, localityLbInfo.getLocalityWeight());
                        }
                        if (ChildLbState.this.prioritizedLocalityWeights.isEmpty()) {
                            ChildLbState.this.propagateResourceError(Status.UNAVAILABLE.withDescription("No usable priority/locality/endpoint"));
                            return;
                        }
                        if (ChildLbState.this.lb == null) {
                            ChildLbState.this.lb = EdsLoadBalancer2.this.lbRegistry.getProvider("priority_experimental").newLoadBalancer((LoadBalancer.Helper)ChildLbState.this.lbHelper);
                        }
                        if (ChildLbState.this.localityPickingPolicy != null && ChildLbState.this.endpointPickingPolicy != null) {
                            PriorityLoadBalancerProvider.PriorityLbConfig config = EdsLoadBalancer2.generatePriorityLbConfig(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName, EdsLbState.this.lrsServerName, ChildLbState.this.localityPickingPolicy, ChildLbState.this.endpointPickingPolicy, EdsLoadBalancer2.this.lbRegistry, ChildLbState.this.prioritizedLocalityWeights);
                            Attributes attributes = EdsLbState.this.lrsServerName != null ? ChildLbState.this.resolvedAddresses.getAttributes().toBuilder().set(XdsAttributes.ATTR_CLUSTER_SERVICE_LOAD_STATS_STORE, (Object)ChildLbState.this.loadStatsStore).build() : ChildLbState.this.resolvedAddresses.getAttributes();
                            ChildLbState.this.lb.handleResolvedAddresses(ChildLbState.this.resolvedAddresses.toBuilder().setAddresses(ChildLbState.this.endpointAddresses).setAttributes(attributes).setLoadBalancingPolicyConfig((Object)config).build());
                        }
                    }
                });
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                EdsLoadBalancer2.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ChildLbState.this.shutdown) {
                            return;
                        }
                        EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} is unavailable", resourceName);
                        ChildLbState.this.propagateResourceError(Status.UNAVAILABLE.withDescription("Resource " + resourceName + " is unavailable"));
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                EdsLoadBalancer2.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ChildLbState.this.shutdown) {
                            return;
                        }
                        EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}", EdsLoadBalancer2.this.xdsClient, error);
                        if (ChildLbState.this.lb == null) {
                            ChildLbState.this.lbHelper.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                        }
                    }
                });
            }

            private void propagateResourceError(Status error) {
                if (this.lb != null) {
                    this.lb.shutdown();
                    this.lb = null;
                }
                this.lbHelper.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
            }

            private final class RequestLimitingLbHelper
            extends ForwardingLoadBalancerHelper {
                private final LoadBalancer.Helper helper;
                private ConnectivityState currentState = ConnectivityState.CONNECTING;
                private LoadBalancer.SubchannelPicker currentPicker = XdsSubchannelPickers.BUFFER_PICKER;
                private List<EnvoyProtoData.DropOverload> dropPolicies = Collections.emptyList();
                private long maxConcurrentRequests = 1024L;

                private RequestLimitingLbHelper(LoadBalancer.Helper helper) {
                    this.helper = helper;
                }

                public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                    this.currentState = newState;
                    this.currentPicker = newPicker;
                    RequestLimitingSubchannelPicker picker = new RequestLimitingSubchannelPicker(newPicker, this.dropPolicies, this.maxConcurrentRequests);
                    this.delegate().updateBalancingState(newState, (LoadBalancer.SubchannelPicker)picker);
                }

                protected LoadBalancer.Helper delegate() {
                    return this.helper;
                }

                private void updateDropPolicies(List<EnvoyProtoData.DropOverload> dropOverloads) {
                    this.dropPolicies = dropOverloads;
                    this.updateBalancingState(this.currentState, this.currentPicker);
                }

                private void updateMaxConcurrentRequests(long maxConcurrentRequests) {
                    this.maxConcurrentRequests = maxConcurrentRequests;
                    this.updateBalancingState(this.currentState, this.currentPicker);
                }

                private final class RequestLimitingSubchannelPicker
                extends LoadBalancer.SubchannelPicker {
                    private final LoadBalancer.SubchannelPicker delegate;
                    private final List<EnvoyProtoData.DropOverload> dropPolicies;
                    private final long maxConcurrentRequests;

                    private RequestLimitingSubchannelPicker(LoadBalancer.SubchannelPicker delegate, List<EnvoyProtoData.DropOverload> dropPolicies, long maxConcurrentRequests) {
                        this.delegate = delegate;
                        this.dropPolicies = dropPolicies;
                        this.maxConcurrentRequests = maxConcurrentRequests;
                    }

                    public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                        for (EnvoyProtoData.DropOverload dropOverload : this.dropPolicies) {
                            int rand = EdsLoadBalancer2.this.random.nextInt(1000000);
                            if (rand >= dropOverload.getDropsPerMillion()) continue;
                            EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Drop request with category: {0}", dropOverload.getCategory());
                            if (ChildLbState.this.loadStatsStore != null) {
                                ChildLbState.this.loadStatsStore.recordDroppedRequest(dropOverload.getCategory());
                            }
                            return LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Dropped: " + dropOverload.getCategory()));
                        }
                        LoadBalancer.PickResult result = this.delegate.pickSubchannel(args);
                        if (enableCircuitBreaking && result.getStatus().isOk() && result.getSubchannel() != null) {
                            if (ChildLbState.this.requestCount.get() >= this.maxConcurrentRequests) {
                                if (ChildLbState.this.loadStatsStore != null) {
                                    ChildLbState.this.loadStatsStore.recordDroppedRequest();
                                }
                                return LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Cluster max concurrent requests limit exceeded"));
                            }
                            RequestCountingStreamTracerFactory tracerFactory = new RequestCountingStreamTracerFactory(result.getStreamTracerFactory(), ChildLbState.this.requestCount);
                            return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)result.getSubchannel(), (ClientStreamTracer.Factory)tracerFactory);
                        }
                        return result;
                    }
                }
            }
        }
    }
}

