/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.ClientXdsClient;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.XdsChannelFactory;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsNameResolverProvider;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SharedXdsClientPoolProvider
implements XdsNameResolverProvider.XdsClientPoolFactory {
    private final Bootstrapper bootstrapper;
    private final XdsChannelFactory channelFactory;
    private final Object lock = new Object();
    private volatile ObjectPool<XdsClient> xdsClientPool;

    private SharedXdsClientPoolProvider() {
        this(Bootstrapper.getInstance(), XdsChannelFactory.getInstance());
    }

    @VisibleForTesting
    SharedXdsClientPoolProvider(Bootstrapper bootstrapper, XdsChannelFactory channelFactory) {
        this.bootstrapper = (Bootstrapper)Preconditions.checkNotNull((Object)bootstrapper, (Object)"bootstrapper");
        this.channelFactory = (XdsChannelFactory)Preconditions.checkNotNull((Object)channelFactory, (Object)"channelFactory");
    }

    static SharedXdsClientPoolProvider getDefaultProvider() {
        return SharedXdsClientPoolProviderHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectPool<XdsClient> getXdsClientPool() throws XdsInitializationException {
        RefCountedXdsClientObjectPool ref = this.xdsClientPool;
        if (ref == null) {
            Object object = this.lock;
            synchronized (object) {
                ref = this.xdsClientPool;
                if (ref == null) {
                    Bootstrapper.BootstrapInfo bootstrapInfo = this.bootstrapper.readBootstrap();
                    XdsClient.XdsChannel channel = this.channelFactory.createChannel(bootstrapInfo.getServers());
                    ref = this.xdsClientPool = new RefCountedXdsClientObjectPool(channel, bootstrapInfo.getNode());
                }
            }
        }
        return ref;
    }

    @ThreadSafe
    @VisibleForTesting
    static class RefCountedXdsClientObjectPool
    implements ObjectPool<XdsClient> {
        private final XdsClient.XdsChannel channel;
        private final EnvoyProtoData.Node node;
        private final XdsClientFactory factory;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private ScheduledExecutorService scheduler;
        @GuardedBy(value="lock")
        private XdsClient xdsClient;
        @GuardedBy(value="lock")
        private int refCount;

        RefCountedXdsClientObjectPool(XdsClient.XdsChannel channel, EnvoyProtoData.Node node) {
            this(channel, node, XdsClientFactory.INSTANCE);
        }

        @VisibleForTesting
        RefCountedXdsClientObjectPool(XdsClient.XdsChannel channel, EnvoyProtoData.Node node, XdsClientFactory factory) {
            this.channel = (XdsClient.XdsChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
            this.node = (EnvoyProtoData.Node)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.factory = (XdsClientFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XdsClient getObject() {
            Object object = this.lock;
            synchronized (object) {
                if (this.xdsClient == null) {
                    this.scheduler = (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
                    this.xdsClient = this.factory.newXdsClient(this.channel, this.node, this.scheduler);
                }
                ++this.refCount;
                return this.xdsClient;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XdsClient returnObject(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                --this.refCount;
                if (this.refCount == 0) {
                    this.xdsClient.shutdown();
                    this.xdsClient = null;
                    this.scheduler = (ScheduledExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.scheduler);
                }
                return null;
            }
        }

        @VisibleForTesting
        static abstract class XdsClientFactory {
            private static final XdsClientFactory INSTANCE = new XdsClientFactory(){

                @Override
                XdsClient newXdsClient(XdsClient.XdsChannel channel, EnvoyProtoData.Node node, ScheduledExecutorService timeService) {
                    return new ClientXdsClient(channel, node, timeService, (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider(), (Supplier<Stopwatch>)GrpcUtil.STOPWATCH_SUPPLIER);
                }
            };

            XdsClientFactory() {
            }

            abstract XdsClient newXdsClient(XdsClient.XdsChannel var1, EnvoyProtoData.Node var2, ScheduledExecutorService var3);
        }
    }

    private static class SharedXdsClientPoolProviderHolder {
        private static final SharedXdsClientPoolProvider instance = new SharedXdsClientPoolProvider();

        private SharedXdsClientPoolProviderHolder() {
        }
    }
}

