/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.internal.GrpcUtil;
import io.grpc.xds.ClientLoadCounter;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.ReferenceCounted;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class LoadStatsStoreImpl
implements LoadStatsManager.LoadStatsStore {
    private final String clusterName;
    @Nullable
    private final String clusterServiceName;
    @GuardedBy(value="this")
    private final Map<EnvoyProtoData.Locality, ReferenceCounted<ClientLoadCounter>> localityLoadCounters = new HashMap<EnvoyProtoData.Locality, ReferenceCounted<ClientLoadCounter>>();
    private final AtomicLong uncategorizedDrops = new AtomicLong();
    private final ConcurrentMap<String, AtomicLong> dropCounters = new ConcurrentHashMap<String, AtomicLong>();
    private final Stopwatch stopwatch;

    LoadStatsStoreImpl(String clusterName, @Nullable String clusterServiceName) {
        this(clusterName, clusterServiceName, (Stopwatch)GrpcUtil.STOPWATCH_SUPPLIER.get());
    }

    @VisibleForTesting
    LoadStatsStoreImpl(String clusterName, @Nullable String clusterServiceName, Stopwatch stopwatch) {
        this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
        this.clusterServiceName = clusterServiceName;
        this.stopwatch = (Stopwatch)Preconditions.checkNotNull((Object)stopwatch, (Object)"stopwatch");
        stopwatch.reset().start();
    }

    @Override
    public synchronized EnvoyProtoData.ClusterStats generateLoadReport() {
        EnvoyProtoData.ClusterStats.Builder statsBuilder = EnvoyProtoData.ClusterStats.newBuilder();
        statsBuilder.setClusterName(this.clusterName);
        if (this.clusterServiceName != null) {
            statsBuilder.setClusterServiceName(this.clusterServiceName);
        }
        HashSet<EnvoyProtoData.Locality> untrackedLocalities = new HashSet<EnvoyProtoData.Locality>();
        for (Map.Entry<EnvoyProtoData.Locality, ReferenceCounted<ClientLoadCounter>> entry : this.localityLoadCounters.entrySet()) {
            ClientLoadCounter.ClientLoadSnapshot snapshot = entry.getValue().get().snapshot();
            EnvoyProtoData.UpstreamLocalityStats.Builder localityStatsBuilder = EnvoyProtoData.UpstreamLocalityStats.newBuilder().setLocality(entry.getKey());
            localityStatsBuilder.setTotalSuccessfulRequests(snapshot.getCallsSucceeded()).setTotalErrorRequests(snapshot.getCallsFailed()).setTotalRequestsInProgress(snapshot.getCallsInProgress()).setTotalIssuedRequests(snapshot.getCallsIssued());
            for (Map.Entry<String, ClientLoadCounter.MetricValue> metric : snapshot.getMetricValues().entrySet()) {
                localityStatsBuilder.addLoadMetricStats(EnvoyProtoData.EndpointLoadMetricStats.newBuilder().setMetricName(metric.getKey()).setNumRequestsFinishedWithMetric(metric.getValue().getNumReports()).setTotalMetricValue(metric.getValue().getTotalValue()).build());
            }
            statsBuilder.addUpstreamLocalityStats(localityStatsBuilder.build());
            if (entry.getValue().getReferenceCount() != 0 || snapshot.getCallsInProgress() != 0L) continue;
            untrackedLocalities.add(entry.getKey());
        }
        this.localityLoadCounters.keySet().removeAll(untrackedLocalities);
        long totalDrops = this.uncategorizedDrops.getAndSet(0L);
        for (Map.Entry entry : this.dropCounters.entrySet()) {
            long drops = ((AtomicLong)entry.getValue()).getAndSet(0L);
            totalDrops += drops;
            statsBuilder.addDroppedRequests(new EnvoyProtoData.ClusterStats.DroppedRequests((String)entry.getKey(), drops));
        }
        statsBuilder.setTotalDroppedRequests(totalDrops);
        statsBuilder.setLoadReportIntervalNanos(this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.stopwatch.reset().start();
        return statsBuilder.build();
    }

    @Override
    public synchronized ClientLoadCounter addLocality(EnvoyProtoData.Locality locality) {
        ReferenceCounted<ClientLoadCounter> counter = this.localityLoadCounters.get(locality);
        if (counter == null) {
            counter = ReferenceCounted.wrap(new ClientLoadCounter());
            this.localityLoadCounters.put(locality, counter);
        }
        counter.retain();
        return counter.get();
    }

    @Override
    public synchronized void removeLocality(EnvoyProtoData.Locality locality) {
        ReferenceCounted<ClientLoadCounter> counter = this.localityLoadCounters.get(locality);
        counter.release();
    }

    @Override
    public void recordDroppedRequest(String category) {
        AtomicLong counter = (AtomicLong)this.dropCounters.get(category);
        if (counter == null && (counter = this.dropCounters.putIfAbsent(category, new AtomicLong())) == null) {
            counter = (AtomicLong)this.dropCounters.get(category);
        }
        counter.getAndIncrement();
    }

    @Override
    public void recordDroppedRequest() {
        this.uncategorizedDrops.getAndIncrement();
    }

    static LoadStatsManager.LoadStatsStoreFactory getDefaultFactory() {
        return new LoadStatsManager.LoadStatsStoreFactory(){

            @Override
            public LoadStatsManager.LoadStatsStore newLoadStatsStore(String cluster, String clusterService) {
                return new LoadStatsStoreImpl(cluster, clusterService);
            }
        };
    }
}

