/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.xds.AbstractXdsClient;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.TrafficDirection;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChainMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ServerXdsClient
extends AbstractXdsClient {
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    @Nullable
    private XdsClient.ListenerWatcher listenerWatcher;
    private int listenerPort = -1;
    private final boolean useNewApiForListenerQuery;
    @Nullable
    private final String instanceIp;
    private String grpcServerResourceId;
    @Nullable
    private SynchronizationContext.ScheduledHandle ldsRespTimer;

    ServerXdsClient(XdsClient.XdsChannel channel, EnvoyProtoData.Node node, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, boolean useNewApiForListenerQuery, String instanceIp, String grpcServerResourceId) {
        super(channel, node, timeService, backoffPolicyProvider, stopwatchSupplier);
        this.useNewApiForListenerQuery = channel.isUseProtocolV3() && useNewApiForListenerQuery;
        this.instanceIp = instanceIp != null ? instanceIp : "0.0.0.0";
        this.grpcServerResourceId = grpcServerResourceId != null ? grpcServerResourceId : "grpc/server";
    }

    @Override
    void watchListenerData(final int port, XdsClient.ListenerWatcher watcher) {
        Preconditions.checkState((this.listenerWatcher == null ? 1 : 0) != 0, (Object)"ListenerWatcher already registered");
        this.listenerWatcher = (XdsClient.ListenerWatcher)Preconditions.checkNotNull((Object)watcher, (Object)"watcher");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port needs to be > 0");
        this.listenerPort = port;
        if (this.useNewApiForListenerQuery) {
            String listeningAddress = this.instanceIp + ":" + this.listenerPort;
            this.grpcServerResourceId = this.grpcServerResourceId + "?udpa.resource.listening_address=" + listeningAddress;
        } else {
            this.grpcServerResourceId = ":" + this.listenerPort;
        }
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ServerXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Started watching listener for port {0}", port);
                if (!ServerXdsClient.this.useNewApiForListenerQuery) {
                    ServerXdsClient.this.updateNodeMetadataForListenerRequest(port);
                }
                ServerXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.LDS);
                if (!ServerXdsClient.this.isInBackoff()) {
                    ServerXdsClient.this.ldsRespTimer = ServerXdsClient.this.getSyncContext().schedule((Runnable)new ListenerResourceFetchTimeoutTask(ServerXdsClient.this.grpcServerResourceId), 15L, TimeUnit.SECONDS, ServerXdsClient.this.getTimeService());
                }
            }
        });
    }

    @Override
    @Nullable
    Collection<String> getSubscribedResources(AbstractXdsClient.ResourceType type) {
        if (type != AbstractXdsClient.ResourceType.LDS) {
            return null;
        }
        if (this.useNewApiForListenerQuery) {
            return ImmutableList.of((Object)this.grpcServerResourceId);
        }
        return Collections.emptyList();
    }

    private void updateNodeMetadataForListenerRequest(int port) {
        HashMap<String, Object> newMetadata = new HashMap<String, Object>();
        if (this.node.getMetadata() != null) {
            newMetadata.putAll(this.node.getMetadata());
        }
        newMetadata.put("TRAFFICDIRECTOR_INBOUND_INTERCEPTION_PORT", "15001");
        newMetadata.put("TRAFFICDIRECTOR_INBOUND_BACKEND_PORTS", "" + port);
        newMetadata.put("INSTANCE_IP", this.instanceIp);
        this.node = this.node.toBuilder().setMetadata(newMetadata).build();
    }

    @Override
    protected void handleLdsResponse(String versionInfo, List<Any> resources, String nonce) {
        Listener requestedListener = null;
        this.getLogger().log(XdsLogger.XdsLogLevel.DEBUG, "Listener count: {0}", resources.size());
        try {
            for (Any res : resources) {
                if (res.getTypeUrl().equals(AbstractXdsClient.ResourceType.LDS.typeUrlV2())) {
                    res = res.toBuilder().setTypeUrl(AbstractXdsClient.ResourceType.LDS.typeUrl()).build();
                }
                Listener listener = (Listener)res.unpack(Listener.class);
                this.getLogger().log(XdsLogger.XdsLogLevel.DEBUG, "Found listener {0}", listener.toString());
                if (!this.isRequestedListener(listener)) continue;
                requestedListener = listener;
                this.getLogger().log(XdsLogger.XdsLogLevel.DEBUG, "Requested listener found: {0}", listener.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listeners in LDS response {0}", new Object[]{e});
            this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Malformed LDS response: " + (Object)((Object)e));
            return;
        }
        XdsClient.ListenerUpdate listenerUpdate = null;
        if (requestedListener != null) {
            if (this.ldsRespTimer != null) {
                this.ldsRespTimer.cancel();
                this.ldsRespTimer = null;
            }
            try {
                listenerUpdate = XdsClient.ListenerUpdate.newBuilder().setListener(EnvoyServerProtoData.Listener.fromEnvoyProtoListener(requestedListener)).build();
            }
            catch (InvalidProtocolBufferException e) {
                this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listener in LDS response {0}", new Object[]{e});
                this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Malformed LDS response: " + (Object)((Object)e));
                return;
            }
        } else if (this.ldsRespTimer == null) {
            this.listenerWatcher.onResourceDoesNotExist(this.grpcServerResourceId);
        }
        this.ackResponse(AbstractXdsClient.ResourceType.LDS, versionInfo, nonce);
        if (listenerUpdate != null) {
            this.listenerWatcher.onListenerChanged(listenerUpdate);
        }
    }

    private boolean isRequestedListener(Listener listener) {
        if (this.useNewApiForListenerQuery) {
            return this.grpcServerResourceId.equals(listener.getName()) && listener.getTrafficDirection().equals((Object)TrafficDirection.INBOUND) && this.isAddressMatching(listener.getAddress(), this.listenerPort);
        }
        return this.isAddressMatching(listener.getAddress(), 15001) && this.hasMatchingFilter(listener.getFilterChainsList());
    }

    private boolean isAddressMatching(Address address, int portToMatch) {
        return address.hasSocketAddress() && address.getSocketAddress().getPortValue() == portToMatch;
    }

    private boolean hasMatchingFilter(List<FilterChain> filterChainsList) {
        for (FilterChain filterChain : filterChainsList) {
            FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            if (this.listenerPort != filterChainMatch.getDestinationPort().getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void handleStreamClosed(Status error) {
        this.cleanUpResourceTimer();
        if (this.listenerWatcher != null) {
            this.listenerWatcher.onError(error);
        }
    }

    @Override
    protected void handleStreamRestarted() {
        if (this.listenerWatcher != null) {
            this.ldsRespTimer = this.getSyncContext().schedule((Runnable)new ListenerResourceFetchTimeoutTask(this.grpcServerResourceId), 15L, TimeUnit.SECONDS, this.getTimeService());
        }
    }

    @Override
    protected void handleShutdown() {
        this.cleanUpResourceTimer();
    }

    private void cleanUpResourceTimer() {
        if (this.ldsRespTimer != null) {
            this.ldsRespTimer.cancel();
            this.ldsRespTimer = null;
        }
    }

    @VisibleForTesting
    final class ListenerResourceFetchTimeoutTask
    implements Runnable {
        private String resourceName;

        ListenerResourceFetchTimeoutTask(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public void run() {
            ServerXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Did not receive resource info {0} after {1} seconds, conclude it absent", this.resourceName, 15);
            ServerXdsClient.this.ldsRespTimer = null;
            ServerXdsClient.this.listenerWatcher.onResourceDoesNotExist(this.resourceName);
        }
    }
}

