/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.TlsChannelCredentials;
import io.grpc.alts.GoogleDefaultChannelCredentials;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsLogger;
import java.util.List;
import java.util.concurrent.TimeUnit;

abstract class XdsChannelFactory {
    @VisibleForTesting
    static boolean experimentalV3SupportEnvVar = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_V3_SUPPORT"));
    private static final String XDS_V3_SERVER_FEATURE = "xds_v3";
    private static final XdsChannelFactory DEFAULT_INSTANCE = new XdsChannelFactory(){

        @Override
        XdsClient.XdsChannel createChannel(List<Bootstrapper.ServerInfo> servers) throws XdsInitializationException {
            if (servers.isEmpty()) {
                throw new XdsInitializationException("No server provided");
            }
            XdsLogger logger = XdsLogger.withPrefix("xds-client-channel-factory");
            Bootstrapper.ServerInfo serverInfo = servers.get(0);
            String serverUri = serverInfo.getServerUri();
            logger.log(XdsLogger.XdsLogLevel.INFO, "Creating channel to {0}", serverUri);
            List<Bootstrapper.ChannelCreds> channelCredsList = serverInfo.getChannelCredentials();
            ChannelCredentials channelCreds = null;
            for (Bootstrapper.ChannelCreds creds : channelCredsList) {
                switch (creds.getType()) {
                    case "google_default": {
                        logger.log(XdsLogger.XdsLogLevel.INFO, "Using channel credentials: google_default");
                        channelCreds = GoogleDefaultChannelCredentials.create();
                        break;
                    }
                    case "insecure": {
                        logger.log(XdsLogger.XdsLogLevel.INFO, "Using channel credentials: insecure");
                        channelCreds = InsecureChannelCredentials.create();
                        break;
                    }
                    case "tls": {
                        logger.log(XdsLogger.XdsLogLevel.INFO, "Using channel credentials: tls");
                        channelCreds = TlsChannelCredentials.create();
                        break;
                    }
                }
                if (channelCreds == null) continue;
                break;
            }
            if (channelCreds == null) {
                throw new XdsInitializationException("No server with supported channel creds found");
            }
            ManagedChannel channel = Grpc.newChannelBuilder((String)serverUri, channelCreds).keepAliveTime(5L, TimeUnit.MINUTES).build();
            boolean useProtocolV3 = experimentalV3SupportEnvVar && serverInfo.getServerFeatures().contains(XdsChannelFactory.XDS_V3_SERVER_FEATURE);
            return new XdsClient.XdsChannel(channel, useProtocolV3);
        }
    };

    XdsChannelFactory() {
    }

    static XdsChannelFactory getInstance() {
        return DEFAULT_INSTANCE;
    }

    abstract XdsClient.XdsChannel createChannel(List<Bootstrapper.ServerInfo> var1) throws XdsInitializationException;
}

