/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Attributes;
import io.grpc.ForwardingServerBuilder;
import io.grpc.Internal;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.Status;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.xds.XdsClientWrapperForServerSds;
import io.grpc.xds.internal.sds.SdsProtocolNegotiators;
import io.grpc.xds.internal.sds.ServerWrapperForXds;

public final class XdsServerBuilder
extends ForwardingServerBuilder<XdsServerBuilder> {
    private final NettyServerBuilder delegate;
    private final int port;
    private ErrorNotifier errorNotifier;

    private XdsServerBuilder(NettyServerBuilder nettyDelegate, int port) {
        this.delegate = nettyDelegate;
        this.port = port;
    }

    @Internal
    protected ServerBuilder<?> delegate() {
        return this.delegate;
    }

    public XdsServerBuilder errorNotifier(ErrorNotifier errorNotifier) {
        this.errorNotifier = errorNotifier;
        return this;
    }

    public static ServerBuilder<?> forPort(int port) {
        throw new UnsupportedOperationException("Unsupported call - use forPort(int, ServerCredentials)");
    }

    public static XdsServerBuilder forPort(int port, ServerCredentials serverCredentials) {
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forPort((int)port, (ServerCredentials)serverCredentials);
        return new XdsServerBuilder(nettyDelegate, port);
    }

    public Server build() {
        return this.buildServer(new XdsClientWrapperForServerSds(this.port));
    }

    @VisibleForTesting
    ServerWrapperForXds buildServer(XdsClientWrapperForServerSds xdsClient) {
        InternalNettyServerBuilder.eagAttributes((NettyServerBuilder)this.delegate, (Attributes)Attributes.newBuilder().set(SdsProtocolNegotiators.SERVER_XDS_CLIENT, (Object)xdsClient).build());
        return new ServerWrapperForXds(this.delegate.build(), xdsClient, this.errorNotifier);
    }

    public static interface ErrorNotifier {
        public void onError(Status var1);
    }
}

