/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.internal.certprovider.CertProviderClientSslContextProvider;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.ReferenceCountingMap;
import io.grpc.xds.internal.sds.SdsClientSslContextProvider;
import io.grpc.xds.internal.sds.SecretVolumeClientSslContextProvider;
import io.grpc.xds.internal.sds.SslContextProvider;
import java.util.concurrent.Executors;

final class ClientSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> {
    private final Bootstrapper bootstrapper;
    private final CertProviderClientSslContextProvider.Factory certProviderClientSslContextProviderFactory;

    ClientSslContextProviderFactory(Bootstrapper bootstrapper) {
        this(bootstrapper, CertProviderClientSslContextProvider.Factory.getInstance());
    }

    ClientSslContextProviderFactory(Bootstrapper bootstrapper, CertProviderClientSslContextProvider.Factory factory) {
        this.bootstrapper = bootstrapper;
        this.certProviderClientSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        Preconditions.checkNotNull((Object)upstreamTlsContext.getCommonTlsContext(), (Object)"upstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(upstreamTlsContext.getCommonTlsContext())) {
            try {
                Bootstrapper.BootstrapInfo bootstrapInfo = this.bootstrapper.readBootstrap();
                return this.certProviderClientSslContextProviderFactory.getProvider(upstreamTlsContext, bootstrapInfo.getNode().toEnvoyProtoNode(), bootstrapInfo.getCertProviders());
            }
            catch (XdsInitializationException e) {
                throw new RuntimeException(e);
            }
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingFilename(upstreamTlsContext.getCommonTlsContext())) {
            return SecretVolumeClientSslContextProvider.getProvider(upstreamTlsContext);
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingSds(upstreamTlsContext.getCommonTlsContext())) {
            try {
                return SdsClientSslContextProvider.getProvider(upstreamTlsContext, this.bootstrapper.readBootstrap().getNode().toEnvoyProtoNodeV2(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("client-sds-sslcontext-provider-%d").setDaemon(true).build()), null);
            }
            catch (XdsInitializationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("Unsupported configurations in UpstreamTlsContext!");
    }
}

