/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.ObjectPool;
import io.grpc.util.ForwardingClientStreamTracer;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.xds.ClusterImplLoadBalancerProvider;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.XdsSubchannelPickers;
import io.grpc.xds.internal.sds.SslContextProviderSupplier;
import io.grpc.xds.internal.sds.TlsContextManager;
import io.grpc.xds.internal.sds.TlsContextManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

final class ClusterImplLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    static final long DEFAULT_PER_CLUSTER_MAX_CONCURRENT_REQUESTS = 1024L;
    @VisibleForTesting
    static boolean enableCircuitBreaking = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_CIRCUIT_BREAKING"));
    @VisibleForTesting
    static boolean enableSecurity = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_SECURITY_SUPPORT"));
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final ThreadSafeRandom random;
    private final TlsContextManager tlsContextManager;
    private String cluster;
    @Nullable
    private String edsServiceName;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private XdsNameResolverProvider.CallCounterProvider callCounterProvider;
    private LoadStatsManager.LoadStatsStore loadStatsStore;
    private ClusterImplLbHelper childLbHelper;
    private LoadBalancer childLb;

    ClusterImplLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, ThreadSafeRandom.ThreadSafeRandomImpl.instance, TlsContextManagerImpl.getInstance());
    }

    ClusterImplLoadBalancer(LoadBalancer.Helper helper, ThreadSafeRandom random, TlsContextManager tlsContextManager) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
        this.tlsContextManager = (TlsContextManager)Preconditions.checkNotNull((Object)tlsContextManager, (Object)"tlsContextManager");
        InternalLogId logId = InternalLogId.allocate((String)"cluster-impl-lb", (String)helper.getAuthority());
        this.logger = XdsLogger.withLogId(logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        Attributes attributes = resolvedAddresses.getAttributes();
        if (this.xdsClientPool == null) {
            this.xdsClientPool = (ObjectPool)attributes.get(XdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        if (this.callCounterProvider == null) {
            this.callCounterProvider = (XdsNameResolverProvider.CallCounterProvider)attributes.get(XdsAttributes.CALL_COUNTER_PROVIDER);
        }
        ClusterImplLoadBalancerProvider.ClusterImplConfig config = (ClusterImplLoadBalancerProvider.ClusterImplConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (this.cluster == null) {
            this.cluster = config.cluster;
            this.edsServiceName = config.edsServiceName;
            this.childLbHelper = new ClusterImplLbHelper(this.callCounterProvider.getOrCreate(config.cluster, config.edsServiceName));
            this.childLb = config.childPolicy.getProvider().newLoadBalancer((LoadBalancer.Helper)this.childLbHelper);
            if (config.lrsServerName != null) {
                if (config.lrsServerName.isEmpty()) {
                    this.loadStatsStore = this.xdsClient.addClientStats(this.cluster, this.edsServiceName);
                } else {
                    this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Can only report load to the same management server");
                }
            }
        }
        this.childLbHelper.updateDropPolicies(config.dropCategories);
        this.childLbHelper.updateMaxConcurrentRequests(config.maxConcurrentRequests);
        this.childLbHelper.updateSslContextProviderSupplier(config.tlsContext);
        if (this.loadStatsStore != null) {
            attributes = attributes.toBuilder().set(XdsAttributes.ATTR_CLUSTER_SERVICE_LOAD_STATS_STORE, (Object)this.loadStatsStore).build();
        }
        this.childLb.handleResolvedAddresses(resolvedAddresses.toBuilder().setAttributes(attributes).setLoadBalancingPolicyConfig(config.childPolicy.getConfig()).build());
    }

    public void handleNameResolutionError(Status error) {
        if (this.childLb != null) {
            this.childLb.handleNameResolutionError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    public void shutdown() {
        if (this.loadStatsStore != null) {
            this.xdsClient.removeClientStats(this.cluster, this.edsServiceName);
        }
        if (this.childLb != null) {
            this.childLb.shutdown();
            this.childLbHelper = null;
        }
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    private static final class RequestCountingStreamTracerFactory
    extends ClientStreamTracer.Factory {
        @Nullable
        private final ClientStreamTracer.Factory delegate;
        private final AtomicLong counter;

        private RequestCountingStreamTracerFactory(@Nullable ClientStreamTracer.Factory delegate, AtomicLong counter) {
            this.delegate = delegate;
            this.counter = counter;
        }

        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            this.counter.incrementAndGet();
            if (this.delegate == null) {
                return new ClientStreamTracer(){

                    public void streamClosed(Status status) {
                        RequestCountingStreamTracerFactory.this.counter.decrementAndGet();
                    }
                };
            }
            final ClientStreamTracer delegatedTracer = this.delegate.newClientStreamTracer(info, headers);
            return new ForwardingClientStreamTracer(){

                protected ClientStreamTracer delegate() {
                    return delegatedTracer;
                }

                public void streamClosed(Status status) {
                    RequestCountingStreamTracerFactory.this.counter.decrementAndGet();
                    this.delegate().streamClosed(status);
                }
            };
        }
    }

    private final class ClusterImplLbHelper
    extends ForwardingLoadBalancerHelper {
        private final AtomicLong requestCount;
        private ConnectivityState currentState = ConnectivityState.IDLE;
        private LoadBalancer.SubchannelPicker currentPicker = XdsSubchannelPickers.BUFFER_PICKER;
        private List<EnvoyProtoData.DropOverload> dropPolicies = Collections.emptyList();
        private long maxConcurrentRequests = 1024L;
        @Nullable
        private SslContextProviderSupplier sslContextProviderSupplier;

        private ClusterImplLbHelper(AtomicLong requestCount) {
            this.requestCount = requestCount;
        }

        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.currentState = newState;
            this.currentPicker = newPicker;
            RequestLimitingSubchannelPicker picker = new RequestLimitingSubchannelPicker(newPicker, this.dropPolicies, this.maxConcurrentRequests);
            this.delegate().updateBalancingState(newState, (LoadBalancer.SubchannelPicker)picker);
        }

        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            if (enableSecurity && this.sslContextProviderSupplier != null) {
                ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                for (EquivalentAddressGroup eag : args.getAddresses()) {
                    Attributes attributes = eag.getAttributes().toBuilder().set(XdsAttributes.ATTR_SSL_CONTEXT_PROVIDER_SUPPLIER, (Object)this.sslContextProviderSupplier).build();
                    addresses.add(new EquivalentAddressGroup(eag.getAddresses(), attributes));
                }
                args = args.toBuilder().setAddresses(addresses).build();
            }
            return this.delegate().createSubchannel(args);
        }

        protected LoadBalancer.Helper delegate() {
            return ClusterImplLoadBalancer.this.helper;
        }

        private void updateDropPolicies(List<EnvoyProtoData.DropOverload> dropOverloads) {
            if (!this.dropPolicies.equals(dropOverloads)) {
                this.dropPolicies = dropOverloads;
                this.updateBalancingState(this.currentState, this.currentPicker);
            }
        }

        private void updateMaxConcurrentRequests(@Nullable Long maxConcurrentRequests) {
            if (Objects.equals(this.maxConcurrentRequests, maxConcurrentRequests)) {
                return;
            }
            this.maxConcurrentRequests = maxConcurrentRequests != null ? maxConcurrentRequests : 1024L;
            this.updateBalancingState(this.currentState, this.currentPicker);
        }

        private void updateSslContextProviderSupplier(@Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
            EnvoyServerProtoData.UpstreamTlsContext currentTlsContext;
            EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = currentTlsContext = this.sslContextProviderSupplier != null ? this.sslContextProviderSupplier.getUpstreamTlsContext() : null;
            if (Objects.equals(currentTlsContext, tlsContext)) {
                return;
            }
            if (this.sslContextProviderSupplier != null) {
                this.sslContextProviderSupplier.close();
            }
            this.sslContextProviderSupplier = tlsContext != null ? new SslContextProviderSupplier(tlsContext, ClusterImplLoadBalancer.this.tlsContextManager) : null;
        }

        private class RequestLimitingSubchannelPicker
        extends LoadBalancer.SubchannelPicker {
            private final LoadBalancer.SubchannelPicker delegate;
            private final List<EnvoyProtoData.DropOverload> dropPolicies;
            private final long maxConcurrentRequests;

            private RequestLimitingSubchannelPicker(LoadBalancer.SubchannelPicker delegate, List<EnvoyProtoData.DropOverload> dropPolicies, long maxConcurrentRequests) {
                this.delegate = delegate;
                this.dropPolicies = dropPolicies;
                this.maxConcurrentRequests = maxConcurrentRequests;
            }

            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                for (EnvoyProtoData.DropOverload dropOverload : this.dropPolicies) {
                    int rand = ClusterImplLoadBalancer.this.random.nextInt(1000000);
                    if (rand >= dropOverload.getDropsPerMillion()) continue;
                    ClusterImplLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Drop request with category: {0}", dropOverload.getCategory());
                    if (ClusterImplLoadBalancer.this.loadStatsStore != null) {
                        ClusterImplLoadBalancer.this.loadStatsStore.recordDroppedRequest(dropOverload.getCategory());
                    }
                    return LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Dropped: " + dropOverload.getCategory()));
                }
                LoadBalancer.PickResult result = this.delegate.pickSubchannel(args);
                if (enableCircuitBreaking && result.getStatus().isOk() && result.getSubchannel() != null) {
                    if (ClusterImplLbHelper.this.requestCount.get() >= this.maxConcurrentRequests) {
                        if (ClusterImplLoadBalancer.this.loadStatsStore != null) {
                            ClusterImplLoadBalancer.this.loadStatsStore.recordDroppedRequest();
                        }
                        return LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Cluster max concurrent requests limit exceeded"));
                    }
                    RequestCountingStreamTracerFactory tracerFactory = new RequestCountingStreamTracerFactory(result.getStreamTracerFactory(), ClusterImplLbHelper.this.requestCount);
                    return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)result.getSubchannel(), (ClientStreamTracer.Factory)tracerFactory);
                }
                return result;
            }
        }
    }
}

