/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.ClusterImplLoadBalancerProvider;
import io.grpc.xds.ClusterResolverLoadBalancerProvider;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.LrsLoadBalancerProvider;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.WeightedTargetLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClusterResolverLoadBalancer
extends LoadBalancer {
    private static final EnvoyProtoData.Locality LOGICAL_DNS_CLUSTER_LOCALITY = new EnvoyProtoData.Locality("", "", "");
    private final XdsLogger logger;
    private final String authority;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final LoadBalancerRegistry lbRegistry;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final GracefulSwitchLoadBalancer delegate;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private ClusterResolverLoadBalancerProvider.ClusterResolverConfig config;

    ClusterResolverLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry(), (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider());
    }

    @VisibleForTesting
    ClusterResolverLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, BackoffPolicy.Provider backoffPolicyProvider) {
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.authority = (String)Preconditions.checkNotNull((Object)((LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper")).getAuthority(), (Object)"authority");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.delegate = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cluster-resolver-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        ClusterResolverLoadBalancerProvider.ClusterResolverConfig config;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.xdsClientPool == null) {
            this.xdsClientPool = (ObjectPool)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        if (!Objects.equals(this.config, config = (ClusterResolverLoadBalancerProvider.ClusterResolverConfig)resolvedAddresses.getLoadBalancingPolicyConfig())) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Config: {0}", config);
            this.delegate.switchTo((LoadBalancer.Factory)new ClusterResolverLbStateFactory());
            this.config = config;
            this.delegate.handleResolvedAddresses(resolvedAddresses);
        }
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.delegate.handleNameResolutionError(error);
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        this.delegate.shutdown();
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    private ServiceConfigUtil.PolicySelection generateClusterPriorityLbPolicy(String cluster, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, ServiceConfigUtil.PolicySelection endpointPickingPolicy, LoadBalancerRegistry lbRegistry, EnvoyProtoData.Locality locality, List<EnvoyProtoData.DropOverload> dropOverloads) {
        ServiceConfigUtil.PolicySelection localityLbPolicy = ClusterResolverLoadBalancer.generateLocalityLbConfig(locality, cluster, edsServiceName, lrsServerName, endpointPickingPolicy, lbRegistry);
        ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(cluster, edsServiceName, lrsServerName, maxConcurrentRequests, dropOverloads, localityLbPolicy, tlsContext);
        LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
        return new ServiceConfigUtil.PolicySelection(clusterImplLbProvider, (Object)clusterImplConfig);
    }

    private static Map<String, ServiceConfigUtil.PolicySelection> generateClusterPriorityLbPolicies(String cluster, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, ServiceConfigUtil.PolicySelection localityPickingPolicy, ServiceConfigUtil.PolicySelection endpointPickingPolicy, LoadBalancerRegistry lbRegistry, Map<String, Map<EnvoyProtoData.Locality, Integer>> prioritizedLocalityWeights, List<EnvoyProtoData.DropOverload> dropOverloads) {
        HashMap<String, ServiceConfigUtil.PolicySelection> policies = new HashMap<String, ServiceConfigUtil.PolicySelection>();
        for (String priority : prioritizedLocalityWeights.keySet()) {
            WeightedTargetLoadBalancerProvider.WeightedTargetConfig localityPickingLbConfig = ClusterResolverLoadBalancer.generateLocalityPickingLbConfig(cluster, edsServiceName, lrsServerName, endpointPickingPolicy, lbRegistry, prioritizedLocalityWeights.get(priority));
            ServiceConfigUtil.PolicySelection localityPicking = new ServiceConfigUtil.PolicySelection(localityPickingPolicy.getProvider(), (Object)localityPickingLbConfig);
            ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(cluster, edsServiceName, lrsServerName, maxConcurrentRequests, dropOverloads, localityPicking, tlsContext);
            LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
            ServiceConfigUtil.PolicySelection clusterImplPolicy = new ServiceConfigUtil.PolicySelection(clusterImplLbProvider, (Object)clusterImplConfig);
            policies.put(priority, clusterImplPolicy);
        }
        return policies;
    }

    private static WeightedTargetLoadBalancerProvider.WeightedTargetConfig generateLocalityPickingLbConfig(String cluster, @Nullable String edsServiceName, @Nullable String lrsServerName, ServiceConfigUtil.PolicySelection endpointPickingPolicy, LoadBalancerRegistry lbRegistry, Map<EnvoyProtoData.Locality, Integer> localityWeights) {
        HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> targets = new HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection>();
        for (EnvoyProtoData.Locality locality : localityWeights.keySet()) {
            int weight = localityWeights.get(locality);
            ServiceConfigUtil.PolicySelection childPolicy = ClusterResolverLoadBalancer.generateLocalityLbConfig(locality, cluster, edsServiceName, lrsServerName, endpointPickingPolicy, lbRegistry);
            targets.put(ClusterResolverLoadBalancer.localityName(locality), new WeightedTargetLoadBalancerProvider.WeightedPolicySelection(weight, childPolicy));
        }
        return new WeightedTargetLoadBalancerProvider.WeightedTargetConfig(Collections.unmodifiableMap(targets));
    }

    private static ServiceConfigUtil.PolicySelection generateLocalityLbConfig(EnvoyProtoData.Locality locality, String cluster, @Nullable String edsServiceName, @Nullable String lrsServerName, ServiceConfigUtil.PolicySelection endpointPickingPolicy, LoadBalancerRegistry lbRegistry) {
        ServiceConfigUtil.PolicySelection policy;
        if (lrsServerName != null) {
            LrsLoadBalancerProvider.LrsConfig childConfig = new LrsLoadBalancerProvider.LrsConfig(cluster, edsServiceName, lrsServerName, locality, endpointPickingPolicy);
            LoadBalancerProvider childPolicyProvider = lbRegistry.getProvider("lrs_experimental");
            policy = new ServiceConfigUtil.PolicySelection(childPolicyProvider, (Object)childConfig);
        } else {
            policy = endpointPickingPolicy;
        }
        return policy;
    }

    private static String priorityName(String cluster, int priority) {
        return cluster + "[priority" + priority + "]";
    }

    private static String localityName(EnvoyProtoData.Locality locality) {
        return locality.toString();
    }

    private static class ClusterResolutionResult {
        private final List<EquivalentAddressGroup> addresses;
        private final Map<String, ServiceConfigUtil.PolicySelection> priorityLbPolicies;
        private final List<String> priorities;

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, String priority, ServiceConfigUtil.PolicySelection priorityLbPolicy) {
            this(addresses, Collections.singletonMap(priority, priorityLbPolicy), Collections.singletonList(priority));
        }

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, Map<String, ServiceConfigUtil.PolicySelection> priorityLbPolicies, List<String> priorities) {
            this.addresses = addresses;
            this.priorityLbPolicies = priorityLbPolicies;
            this.priorities = priorities;
        }
    }

    private final class ClusterResolverLbState
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private final List<String> clusters = new ArrayList<String>();
        private final Map<String, ClusterState> clusterStates = new HashMap<String, ClusterState>();
        private ServiceConfigUtil.PolicySelection localityPickingPolicy;
        private ServiceConfigUtil.PolicySelection endpointPickingPolicy;
        private LoadBalancer.ResolvedAddresses resolvedAddresses;
        private LoadBalancer childLb;

        ClusterResolverLbState(LoadBalancer.Helper helper) {
            this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "New ClusterResolverLbState");
        }

        public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.resolvedAddresses = resolvedAddresses;
            ClusterResolverLoadBalancerProvider.ClusterResolverConfig config = (ClusterResolverLoadBalancerProvider.ClusterResolverConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            this.localityPickingPolicy = config.localityPickingPolicy;
            this.endpointPickingPolicy = config.endpointPickingPolicy;
            for (ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism instance : config.discoveryMechanisms) {
                ClusterState state;
                this.clusters.add(instance.cluster);
                if (instance.type == ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.Type.EDS) {
                    state = new EdsClusterState(instance.cluster, instance.edsServiceName, instance.lrsServerName, instance.maxConcurrentRequests, instance.tlsContext);
                    this.clusterStates.put(instance.cluster, state);
                } else {
                    state = new LogicalDnsClusterState(instance.cluster, instance.lrsServerName, instance.maxConcurrentRequests, instance.tlsContext);
                    this.clusterStates.put(instance.cluster, state);
                }
                state.start();
            }
        }

        public void handleNameResolutionError(Status error) {
            if (this.childLb != null) {
                this.childLb.handleNameResolutionError(error);
            } else {
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
            }
        }

        public void shutdown() {
            for (ClusterState state : this.clusterStates.values()) {
                state.shutdown();
            }
            if (this.childLb != null) {
                this.childLb.shutdown();
            }
        }

        private void handleEndpointResourceUpdate() {
            ArrayList addresses = new ArrayList();
            HashMap priorityLbPolicies = new HashMap();
            ArrayList priorities = new ArrayList();
            boolean allResolved = true;
            for (String cluster : this.clusters) {
                ClusterState state = this.clusterStates.get(cluster);
                if (!state.resolved) {
                    allResolved = false;
                    continue;
                }
                if (state.result == null) continue;
                addresses.addAll(state.result.addresses);
                priorityLbPolicies.putAll(state.result.priorityLbPolicies);
                priorities.addAll(state.result.priorities);
            }
            if (addresses.isEmpty()) {
                if (this.childLb != null) {
                    this.childLb.shutdown();
                    this.childLb = null;
                }
                if (allResolved) {
                    Status unavailable = Status.UNAVAILABLE.withDescription("No usable endpoint");
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(unavailable));
                } else {
                    this.helper.updateBalancingState(ConnectivityState.CONNECTING, XdsSubchannelPickers.BUFFER_PICKER);
                }
                return;
            }
            PriorityLoadBalancerProvider.PriorityLbConfig childConfig = new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(priorityLbPolicies), Collections.unmodifiableList(priorities));
            if (this.childLb == null) {
                this.childLb = ClusterResolverLoadBalancer.this.lbRegistry.getProvider("priority_experimental").newLoadBalancer(this.helper);
            }
            this.childLb.handleResolvedAddresses(this.resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig((Object)childConfig).setAddresses(Collections.unmodifiableList(addresses)).build());
        }

        private void handleEndpointResolutionError() {
            boolean allInError = true;
            for (ClusterState state : this.clusterStates.values()) {
                if (!state.status.isOk()) continue;
                allInError = false;
            }
            if (allInError) {
                Status error = this.clusterStates.get((Object)this.clusters.get((int)(this.clusters.size() - 1))).status;
                if (this.childLb != null) {
                    this.childLb.handleNameResolutionError(error);
                } else {
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                }
            }
        }

        private class LogicalDnsClusterState
        extends ClusterState {
            private final NameResolver resolver;
            @Nullable
            private BackoffPolicy backoffPolicy;
            @Nullable
            private SynchronizationContext.ScheduledHandle scheduledRefresh;

            private LogicalDnsClusterState(@Nullable String name, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
                URI uri;
                super(name, null, lrsServerName, maxConcurrentRequests, tlsContext);
                NameResolver.Args args = ClusterResolverLbState.this.helper.getNameResolverArgs();
                try {
                    uri = new URI(ClusterResolverLoadBalancer.this.authority);
                }
                catch (URISyntaxException e) {
                    throw new AssertionError("Bug, invalid authority: " + ClusterResolverLoadBalancer.this.authority, e);
                }
                this.resolver = ClusterResolverLbState.this.helper.getNameResolverRegistry().asFactory().newNameResolver(uri, args);
            }

            @Override
            void start() {
                this.resolver.start((NameResolver.Listener2)new NameResolverListener());
            }

            @Override
            void shutdown() {
                super.shutdown();
                this.resolver.shutdown();
                if (this.scheduledRefresh != null) {
                    this.scheduledRefresh.cancel();
                }
            }

            private class NameResolverListener
            extends NameResolver.Listener2 {
                private NameResolverListener() {
                }

                public void onResult(final NameResolver.ResolutionResult resolutionResult) {
                    class NameResolved
                    implements Runnable {
                        NameResolved() {
                        }

                        @Override
                        public void run() {
                            if (LogicalDnsClusterState.this.shutdown) {
                                return;
                            }
                            LogicalDnsClusterState.this.backoffPolicy = null;
                            String priorityName = ClusterResolverLoadBalancer.priorityName(LogicalDnsClusterState.this.name, 0);
                            ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                            for (EquivalentAddressGroup eag : resolutionResult.getAddresses()) {
                                EquivalentAddressGroup annotatedAddr = AddressFilter.setPathFilter(eag, Arrays.asList(priorityName, LOGICAL_DNS_CLUSTER_LOCALITY.toString()));
                                addresses.add(annotatedAddr);
                            }
                            LoadBalancerProvider endpointPickingLbProvider = ClusterResolverLoadBalancer.this.lbRegistry.getProvider("pick_first");
                            ServiceConfigUtil.PolicySelection endpointPickingPolicy = new ServiceConfigUtil.PolicySelection(endpointPickingLbProvider, null);
                            ServiceConfigUtil.PolicySelection priorityLbPolicy = ClusterResolverLoadBalancer.this.generateClusterPriorityLbPolicy(LogicalDnsClusterState.this.name, LogicalDnsClusterState.this.edsServiceName, LogicalDnsClusterState.this.lrsServerName, LogicalDnsClusterState.this.maxConcurrentRequests, LogicalDnsClusterState.this.tlsContext, endpointPickingPolicy, ClusterResolverLoadBalancer.this.lbRegistry, LOGICAL_DNS_CLUSTER_LOCALITY, Collections.emptyList());
                            LogicalDnsClusterState.this.status = Status.OK;
                            LogicalDnsClusterState.this.resolved = true;
                            LogicalDnsClusterState.this.result = new ClusterResolutionResult(addresses, priorityName, priorityLbPolicy);
                            ClusterResolverLbState.this.handleEndpointResourceUpdate();
                        }
                    }
                    ClusterResolverLoadBalancer.this.syncContext.execute((Runnable)new NameResolved());
                }

                public void onError(final Status error) {
                    ClusterResolverLoadBalancer.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (LogicalDnsClusterState.this.shutdown) {
                                return;
                            }
                            LogicalDnsClusterState.this.status = error;
                            LogicalDnsClusterState.this.resolved = true;
                            ClusterResolverLbState.this.handleEndpointResolutionError();
                            if (LogicalDnsClusterState.this.scheduledRefresh != null && LogicalDnsClusterState.this.scheduledRefresh.isPending()) {
                                return;
                            }
                            if (LogicalDnsClusterState.this.backoffPolicy == null) {
                                LogicalDnsClusterState.this.backoffPolicy = ClusterResolverLoadBalancer.this.backoffPolicyProvider.get();
                            }
                            long delayNanos = LogicalDnsClusterState.this.backoffPolicy.nextBackoffNanos();
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Scheduling DNS resolution backoff for {0} ns", delayNanos);
                            LogicalDnsClusterState.this.scheduledRefresh = ClusterResolverLoadBalancer.this.syncContext.schedule((Runnable)new DelayedNameResolverRefresh(), delayNanos, TimeUnit.NANOSECONDS, ClusterResolverLoadBalancer.this.timeService);
                        }
                    });
                }
            }

            private class DelayedNameResolverRefresh
            implements Runnable {
                private DelayedNameResolverRefresh() {
                }

                @Override
                public void run() {
                    LogicalDnsClusterState.this.scheduledRefresh = null;
                    if (!LogicalDnsClusterState.this.shutdown) {
                        LogicalDnsClusterState.this.resolver.refresh();
                    }
                }
            }
        }

        private class EdsClusterState
        extends ClusterState
        implements XdsClient.EdsResourceWatcher {
            private EdsClusterState(@Nullable String name, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
                super(name, edsServiceName, lrsServerName, maxConcurrentRequests, tlsContext);
            }

            @Override
            void start() {
                String resourceName = this.edsServiceName != null ? this.edsServiceName : this.name;
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching EDS resource {0}", resourceName);
                ClusterResolverLoadBalancer.this.xdsClient.watchEdsResource(resourceName, this);
            }

            @Override
            protected void shutdown() {
                super.shutdown();
                String resourceName = this.edsServiceName != null ? this.edsServiceName : this.name;
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching EDS resource {0}", resourceName);
                ClusterResolverLoadBalancer.this.xdsClient.cancelEdsResourceWatch(resourceName, this);
            }

            @Override
            public void onChanged(final XdsClient.EdsUpdate update) {
                class EndpointsUpdated
                implements Runnable {
                    EndpointsUpdated() {
                    }

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update {0}", update);
                        if (ClusterResolverLoadBalancer.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0}: {1} localities, {2} drop categories", update.getClusterName(), update.getLocalityLbEndpointsMap().size(), update.getDropPolicies().size());
                        }
                        Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpoints = update.getLocalityLbEndpointsMap();
                        List<EnvoyProtoData.DropOverload> dropOverloads = update.getDropPolicies();
                        ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                        HashMap prioritizedLocalityWeights = new HashMap();
                        for (EnvoyProtoData.Locality locality : localityLbEndpoints.keySet()) {
                            EnvoyProtoData.LocalityLbEndpoints localityLbInfo = localityLbEndpoints.get(locality);
                            int priority = localityLbInfo.getPriority();
                            String priorityName = ClusterResolverLoadBalancer.priorityName(EdsClusterState.this.name, priority);
                            boolean discard = true;
                            for (EnvoyProtoData.LbEndpoint endpoint : localityLbInfo.getEndpoints()) {
                                if (!endpoint.isHealthy()) continue;
                                discard = false;
                                EquivalentAddressGroup eag = AddressFilter.setPathFilter(endpoint.getAddress(), Arrays.asList(priorityName, ClusterResolverLoadBalancer.localityName(locality)));
                                addresses.add(eag);
                            }
                            if (discard) {
                                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Discard locality {0} with 0 healthy endpoints", locality);
                                continue;
                            }
                            if (!prioritizedLocalityWeights.containsKey(priorityName)) {
                                prioritizedLocalityWeights.put(priorityName, new HashMap());
                            }
                            ((Map)prioritizedLocalityWeights.get(priorityName)).put(locality, localityLbInfo.getLocalityWeight());
                        }
                        if (prioritizedLocalityWeights.isEmpty()) {
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0} has no usable priority/locality/endpoint", update.getClusterName());
                        }
                        ArrayList<String> priorities = new ArrayList<String>(prioritizedLocalityWeights.keySet());
                        Collections.sort(priorities);
                        Map priorityLbPolicies = ClusterResolverLoadBalancer.generateClusterPriorityLbPolicies(EdsClusterState.this.name, EdsClusterState.this.edsServiceName, EdsClusterState.this.lrsServerName, EdsClusterState.this.maxConcurrentRequests, EdsClusterState.this.tlsContext, ClusterResolverLbState.this.localityPickingPolicy, ClusterResolverLbState.this.endpointPickingPolicy, ClusterResolverLoadBalancer.this.lbRegistry, prioritizedLocalityWeights, dropOverloads);
                        EdsClusterState.this.status = Status.OK;
                        EdsClusterState.this.resolved = true;
                        EdsClusterState.this.result = new ClusterResolutionResult(addresses, priorityLbPolicies, priorities);
                        ClusterResolverLbState.this.handleEndpointResourceUpdate();
                    }
                }
                ClusterResolverLoadBalancer.this.syncContext.execute((Runnable)new EndpointsUpdated());
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                ClusterResolverLoadBalancer.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} unavailable", resourceName);
                        EdsClusterState.this.status = Status.OK;
                        EdsClusterState.this.resolved = true;
                        EdsClusterState.this.result = null;
                        ClusterResolverLbState.this.handleEndpointResourceUpdate();
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                ClusterResolverLoadBalancer.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        EdsClusterState.this.status = error;
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received EDS error: {0}", error);
                        ClusterResolverLbState.this.handleEndpointResolutionError();
                    }
                });
            }
        }

        private abstract class ClusterState {
            protected final String name;
            @Nullable
            protected final String edsServiceName;
            @Nullable
            protected final String lrsServerName;
            @Nullable
            protected final Long maxConcurrentRequests;
            @Nullable
            protected final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
            protected Status status = Status.OK;
            protected boolean resolved;
            @Nullable
            protected ClusterResolutionResult result;
            protected boolean shutdown;

            private ClusterState(@Nullable String name, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
                this.name = name;
                this.edsServiceName = edsServiceName;
                this.lrsServerName = lrsServerName;
                this.maxConcurrentRequests = maxConcurrentRequests;
                this.tlsContext = tlsContext;
            }

            abstract void start();

            void shutdown() {
                this.shutdown = true;
            }
        }
    }

    private final class ClusterResolverLbStateFactory
    extends LoadBalancer.Factory {
        private ClusterResolverLbStateFactory() {
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new ClusterResolverLbState(helper);
        }
    }
}

