/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.ClientXdsClient;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsNameResolverProvider;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SharedXdsClientPoolProvider
implements XdsNameResolverProvider.XdsClientPoolFactory {
    private final Bootstrapper bootstrapper;
    private final Object lock = new Object();
    private volatile ObjectPool<XdsClient> xdsClientPool;

    private SharedXdsClientPoolProvider() {
        this(Bootstrapper.getInstance());
    }

    @VisibleForTesting
    SharedXdsClientPoolProvider(Bootstrapper bootstrapper) {
        this.bootstrapper = (Bootstrapper)Preconditions.checkNotNull((Object)bootstrapper, (Object)"bootstrapper");
    }

    static SharedXdsClientPoolProvider getDefaultProvider() {
        return SharedXdsClientPoolProviderHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectPool<XdsClient> getXdsClientPool() throws XdsInitializationException {
        RefCountedXdsClientObjectPool ref = this.xdsClientPool;
        if (ref == null) {
            Object object = this.lock;
            synchronized (object) {
                ref = this.xdsClientPool;
                if (ref == null) {
                    Bootstrapper.BootstrapInfo bootstrapInfo = this.bootstrapper.bootstrap();
                    if (bootstrapInfo.getServers().isEmpty()) {
                        throw new XdsInitializationException("No xDS server provided");
                    }
                    Bootstrapper.ServerInfo serverInfo = bootstrapInfo.getServers().get(0);
                    ref = this.xdsClientPool = new RefCountedXdsClientObjectPool(serverInfo.getTarget(), serverInfo.getChannelCredentials(), serverInfo.isUseProtocolV3(), bootstrapInfo.getNode());
                }
            }
        }
        return ref;
    }

    @ThreadSafe
    @VisibleForTesting
    static class RefCountedXdsClientObjectPool
    implements ObjectPool<XdsClient> {
        private final String target;
        private final ChannelCredentials channelCredentials;
        private final EnvoyProtoData.Node node;
        private final boolean useProtocolV3;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private ScheduledExecutorService scheduler;
        @GuardedBy(value="lock")
        private ManagedChannel channel;
        @GuardedBy(value="lock")
        private XdsClient xdsClient;
        @GuardedBy(value="lock")
        private int refCount;

        @VisibleForTesting
        RefCountedXdsClientObjectPool(String target, ChannelCredentials channelCredentials, boolean useProtocolV3, EnvoyProtoData.Node node) {
            this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
            this.channelCredentials = (ChannelCredentials)Preconditions.checkNotNull((Object)channelCredentials, (Object)"channelCredentials");
            this.useProtocolV3 = useProtocolV3;
            this.node = (EnvoyProtoData.Node)Preconditions.checkNotNull((Object)node, (Object)"node");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XdsClient getObject() {
            Object object = this.lock;
            synchronized (object) {
                if (this.refCount == 0) {
                    this.channel = Grpc.newChannelBuilder((String)this.target, (ChannelCredentials)this.channelCredentials).keepAliveTime(5L, TimeUnit.MINUTES).build();
                    this.scheduler = (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
                    this.xdsClient = new ClientXdsClient(this.channel, this.useProtocolV3, this.node, this.scheduler, (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider(), (Supplier<Stopwatch>)GrpcUtil.STOPWATCH_SUPPLIER);
                }
                ++this.refCount;
                return this.xdsClient;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XdsClient returnObject(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                --this.refCount;
                if (this.refCount == 0) {
                    this.xdsClient.shutdown();
                    this.xdsClient = null;
                    this.channel.shutdown();
                    this.scheduler = (ScheduledExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.scheduler);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @VisibleForTesting
        ManagedChannel getChannelForTest() {
            Object object = this.lock;
            synchronized (object) {
                return this.channel;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @VisibleForTesting
        XdsClient getXdsClientForTest() {
            Object object = this.lock;
            synchronized (object) {
                return this.xdsClient;
            }
        }
    }

    private static class SharedXdsClientPoolProviderHolder {
        private static final SharedXdsClientPoolProvider instance = new SharedXdsClientPoolProvider();

        private SharedXdsClientPoolProviderHolder() {
        }
    }
}

