/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.Status;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.LoadStatsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class XdsClient {
    XdsClient() {
    }

    void shutdown() {
    }

    boolean isShutDown() {
        throw new UnsupportedOperationException();
    }

    void watchLdsResource(String resourceName, LdsResourceWatcher watcher) {
    }

    void cancelLdsResourceWatch(String resourceName, LdsResourceWatcher watcher) {
    }

    void watchRdsResource(String resourceName, RdsResourceWatcher watcher) {
    }

    void cancelRdsResourceWatch(String resourceName, RdsResourceWatcher watcher) {
    }

    void watchCdsResource(String resourceName, CdsResourceWatcher watcher) {
    }

    void cancelCdsResourceWatch(String resourceName, CdsResourceWatcher watcher) {
    }

    void watchEdsResource(String resourceName, EdsResourceWatcher watcher) {
    }

    void cancelEdsResourceWatch(String resourceName, EdsResourceWatcher watcher) {
    }

    void watchListenerData(int port, ListenerWatcher watcher) {
    }

    LoadStatsManager.LoadStatsStore addClientStats(String clusterName, @Nullable String clusterServiceName) {
        throw new UnsupportedOperationException();
    }

    void removeClientStats(String clusterName, @Nullable String clusterServiceName) {
        throw new UnsupportedOperationException();
    }

    static interface ListenerWatcher
    extends ResourceWatcher {
        public void onListenerChanged(ListenerUpdate var1);
    }

    static interface EdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(EdsUpdate var1);
    }

    static interface CdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(CdsUpdate var1);
    }

    static interface RdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(RdsUpdate var1);
    }

    static interface LdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(LdsUpdate var1);
    }

    static interface ResourceWatcher {
        public void onError(Status var1);

        public void onResourceDoesNotExist(String var1);
    }

    static interface ResourceUpdate {
    }

    static final class ListenerUpdate
    implements ResourceUpdate {
        private final EnvoyServerProtoData.Listener listener;

        private ListenerUpdate(EnvoyServerProtoData.Listener listener) {
            this.listener = listener;
        }

        public EnvoyServerProtoData.Listener getListener() {
            return this.listener;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("listener", (Object)this.listener).toString();
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class Builder {
            private EnvoyServerProtoData.Listener listener;

            private Builder() {
            }

            Builder setListener(EnvoyServerProtoData.Listener listener) {
                this.listener = listener;
                return this;
            }

            ListenerUpdate build() {
                Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"listener is not set");
                return new ListenerUpdate(this.listener);
            }
        }
    }

    static final class EdsUpdate
    implements ResourceUpdate {
        private final String clusterName;
        private final Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpointsMap;
        private final List<EnvoyProtoData.DropOverload> dropPolicies;

        private EdsUpdate(String clusterName, Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpoints, List<EnvoyProtoData.DropOverload> dropPolicies) {
            this.clusterName = clusterName;
            this.localityLbEndpointsMap = localityLbEndpoints;
            this.dropPolicies = dropPolicies;
        }

        static Builder newBuilder() {
            return new Builder();
        }

        String getClusterName() {
            return this.clusterName;
        }

        Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> getLocalityLbEndpointsMap() {
            return Collections.unmodifiableMap(this.localityLbEndpointsMap);
        }

        List<EnvoyProtoData.DropOverload> getDropPolicies() {
            return Collections.unmodifiableList(this.dropPolicies);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdsUpdate that = (EdsUpdate)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.localityLbEndpointsMap, that.localityLbEndpointsMap) && Objects.equals(this.dropPolicies, that.dropPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.localityLbEndpointsMap, this.dropPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("localityLbEndpointsMap", this.localityLbEndpointsMap).add("dropPolicies", this.dropPolicies).toString();
        }

        static final class Builder {
            private String clusterName;
            private Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpointsMap = new LinkedHashMap<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints>();
            private List<EnvoyProtoData.DropOverload> dropPolicies = new ArrayList<EnvoyProtoData.DropOverload>();

            private Builder() {
            }

            Builder setClusterName(String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            Builder addLocalityLbEndpoints(EnvoyProtoData.Locality locality, EnvoyProtoData.LocalityLbEndpoints info) {
                this.localityLbEndpointsMap.put(locality, info);
                return this;
            }

            Builder addDropPolicy(EnvoyProtoData.DropOverload policy) {
                this.dropPolicies.add(policy);
                return this;
            }

            EdsUpdate build() {
                Preconditions.checkState((this.clusterName != null ? 1 : 0) != 0, (Object)"clusterName is not set");
                return new EdsUpdate(this.clusterName, (Map)ImmutableMap.copyOf(this.localityLbEndpointsMap), (List)ImmutableList.copyOf(this.dropPolicies));
            }
        }
    }

    static final class CdsUpdate
    implements ResourceUpdate {
        final String clusterName;
        final ClusterType clusterType;
        final ClusterConfig clusterConfig;

        CdsUpdate(String clusterName, ClusterType clusterType, ClusterConfig clusterConfig) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.clusterType = (ClusterType)((Object)Preconditions.checkNotNull((Object)((Object)clusterType), (Object)"clusterType"));
            this.clusterConfig = (ClusterConfig)Preconditions.checkNotNull((Object)clusterConfig, (Object)"clusterConfig");
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.clusterName, this.clusterType, this.clusterConfig});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CdsUpdate that = (CdsUpdate)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals((Object)this.clusterType, (Object)that.clusterType) && Objects.equals(this.clusterConfig, that.clusterConfig);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("clusterType", (Object)this.clusterType).add("clusterConfig", (Object)this.clusterConfig).toString();
        }

        static final class LogicalDnsClusterConfig
        extends NonAggregateClusterConfig {
            LogicalDnsClusterConfig(String lbPolicy, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
                super(lbPolicy, lrsServerName, maxConcurrentRequests, upstreamTlsContext);
            }

            public int hashCode() {
                return Objects.hash(this.lbPolicy, this.lrsServerName, this.maxConcurrentRequests, this.upstreamTlsContext);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogicalDnsClusterConfig that = (LogicalDnsClusterConfig)o;
                return Objects.equals(this.lbPolicy, that.lbPolicy) && Objects.equals(this.lrsServerName, that.lrsServerName) && Objects.equals(this.maxConcurrentRequests, that.maxConcurrentRequests) && Objects.equals(this.upstreamTlsContext, that.upstreamTlsContext);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("lbPolicy", (Object)this.lbPolicy).add("lrsServerName", (Object)this.lrsServerName).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests).toString();
            }
        }

        static final class EdsClusterConfig
        extends NonAggregateClusterConfig {
            @Nullable
            final String edsServiceName;

            EdsClusterConfig(String lbPolicy, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
                super(lbPolicy, lrsServerName, maxConcurrentRequests, upstreamTlsContext);
                this.edsServiceName = edsServiceName;
            }

            public int hashCode() {
                return Objects.hash(this.lbPolicy, this.edsServiceName, this.lrsServerName, this.maxConcurrentRequests, this.upstreamTlsContext);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EdsClusterConfig that = (EdsClusterConfig)o;
                return Objects.equals(this.lbPolicy, that.lbPolicy) && Objects.equals(this.edsServiceName, that.edsServiceName) && Objects.equals(this.lrsServerName, that.lrsServerName) && Objects.equals(this.maxConcurrentRequests, that.maxConcurrentRequests) && Objects.equals(this.upstreamTlsContext, that.upstreamTlsContext);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("lbPolicy", (Object)this.lbPolicy).add("edsServiceName", (Object)this.edsServiceName).add("lrsServerName", (Object)this.lrsServerName).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests).toString();
            }
        }

        private static abstract class NonAggregateClusterConfig
        extends ClusterConfig {
            @Nullable
            final String lrsServerName;
            @Nullable
            final Long maxConcurrentRequests;
            @Nullable
            final EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext;

            private NonAggregateClusterConfig(String lbPolicy, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
                super(lbPolicy);
                this.lrsServerName = lrsServerName;
                this.maxConcurrentRequests = maxConcurrentRequests;
                this.upstreamTlsContext = upstreamTlsContext;
            }
        }

        static final class AggregateClusterConfig
        extends ClusterConfig {
            final List<String> prioritizedClusterNames;

            AggregateClusterConfig(String lbPolicy, List<String> prioritizedClusterNames) {
                super(lbPolicy);
                this.prioritizedClusterNames = Collections.unmodifiableList(new ArrayList<String>(prioritizedClusterNames));
            }

            public int hashCode() {
                return Objects.hash(this.lbPolicy, this.prioritizedClusterNames);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                AggregateClusterConfig that = (AggregateClusterConfig)o;
                return Objects.equals(this.lbPolicy, that.lbPolicy) && Objects.equals(this.prioritizedClusterNames, that.prioritizedClusterNames);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("lbPolicy", (Object)this.lbPolicy).add("prioritizedClusterNames", this.prioritizedClusterNames).toString();
            }
        }

        static abstract class ClusterConfig {
            final String lbPolicy;

            private ClusterConfig(String lbPolicy) {
                this.lbPolicy = (String)Preconditions.checkNotNull((Object)lbPolicy, (Object)"lbPolicy");
            }
        }

        static enum ClusterType {
            EDS,
            LOGICAL_DNS,
            AGGREGATE;

        }
    }

    static final class RdsUpdate
    implements ResourceUpdate {
        private final List<EnvoyProtoData.VirtualHost> virtualHosts;

        private RdsUpdate(List<EnvoyProtoData.VirtualHost> virtualHosts) {
            this.virtualHosts = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(virtualHosts, (Object)"virtualHosts")));
        }

        static RdsUpdate fromVirtualHosts(List<EnvoyProtoData.VirtualHost> virtualHosts) {
            return new RdsUpdate(virtualHosts);
        }

        List<EnvoyProtoData.VirtualHost> getVirtualHosts() {
            return this.virtualHosts;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("virtualHosts", this.virtualHosts).toString();
        }

        public int hashCode() {
            return Objects.hash(this.virtualHosts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RdsUpdate that = (RdsUpdate)o;
            return Objects.equals(this.virtualHosts, that.virtualHosts);
        }
    }

    static final class LdsUpdate
    implements ResourceUpdate {
        private final long httpMaxStreamDurationNano;
        @Nullable
        private final String rdsName;
        @Nullable
        private final List<EnvoyProtoData.VirtualHost> virtualHosts;

        private LdsUpdate(long httpMaxStreamDurationNano, @Nullable String rdsName, @Nullable List<EnvoyProtoData.VirtualHost> virtualHosts) {
            this.httpMaxStreamDurationNano = httpMaxStreamDurationNano;
            this.rdsName = rdsName;
            this.virtualHosts = virtualHosts == null ? null : Collections.unmodifiableList(new ArrayList<EnvoyProtoData.VirtualHost>(virtualHosts));
        }

        long getHttpMaxStreamDurationNano() {
            return this.httpMaxStreamDurationNano;
        }

        @Nullable
        String getRdsName() {
            return this.rdsName;
        }

        @Nullable
        List<EnvoyProtoData.VirtualHost> getVirtualHosts() {
            return this.virtualHosts;
        }

        public int hashCode() {
            return Objects.hash(this.httpMaxStreamDurationNano, this.rdsName, this.virtualHosts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LdsUpdate that = (LdsUpdate)o;
            return Objects.equals(this.httpMaxStreamDurationNano, that.httpMaxStreamDurationNano) && Objects.equals(this.rdsName, that.rdsName) && Objects.equals(this.virtualHosts, that.virtualHosts);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("httpMaxStreamDurationNano", this.httpMaxStreamDurationNano);
            if (this.rdsName != null) {
                toStringHelper.add("rdsName", (Object)this.rdsName);
            } else {
                toStringHelper.add("virtualHosts", this.virtualHosts);
            }
            return toStringHelper.toString();
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static class Builder {
            private long httpMaxStreamDurationNano;
            @Nullable
            private String rdsName;
            @Nullable
            private List<EnvoyProtoData.VirtualHost> virtualHosts;

            private Builder() {
            }

            Builder setHttpMaxStreamDurationNano(long httpMaxStreamDurationNano) {
                this.httpMaxStreamDurationNano = httpMaxStreamDurationNano;
                return this;
            }

            Builder setRdsName(String rdsName) {
                this.rdsName = rdsName;
                return this;
            }

            Builder addVirtualHost(EnvoyProtoData.VirtualHost virtualHost) {
                if (this.virtualHosts == null) {
                    this.virtualHosts = new ArrayList<EnvoyProtoData.VirtualHost>();
                }
                this.virtualHosts.add(virtualHost);
                return this;
            }

            LdsUpdate build() {
                Preconditions.checkState((this.rdsName == null != (this.virtualHosts == null) ? 1 : 0) != 0, (Object)"one of rdsName and virtualHosts");
                return new LdsUpdate(this.httpMaxStreamDurationNano, this.rdsName, this.virtualHosts);
            }
        }
    }
}

