/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.internal.certprovider.CertificateProvider;
import io.grpc.xds.internal.certprovider.CertificateProviderProvider;
import io.grpc.xds.internal.certprovider.MeshCaCertificateProvider;
import io.grpc.xds.internal.sts.StsCredentials;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MeshCaCertificateProviderProvider
implements CertificateProviderProvider {
    private static final String SERVER_CONFIG_KEY = "server";
    private static final String MESHCA_URL_KEY = "target_uri";
    private static final String RPC_TIMEOUT_SECONDS_KEY = "time_out";
    private static final String GKECLUSTER_URL_KEY = "location";
    private static final String CERT_VALIDITY_SECONDS_KEY = "certificate_lifetime";
    private static final String RENEWAL_GRACE_PERIOD_SECONDS_KEY = "renewal_grace_period";
    private static final String KEY_ALGO_KEY = "key_type";
    private static final String KEY_SIZE_KEY = "key_size";
    private static final String STS_SERVICE_KEY = "sts_service";
    private static final String TOKEN_EXCHANGE_SERVICE_KEY = "token_exchange_service";
    private static final String GKE_SA_JWT_LOCATION_KEY = "subject_token_path";
    @VisibleForTesting
    static final String MESHCA_URL_DEFAULT = "meshca.googleapis.com";
    @VisibleForTesting
    static final long RPC_TIMEOUT_SECONDS_DEFAULT = 5L;
    @VisibleForTesting
    static final long CERT_VALIDITY_SECONDS_DEFAULT = 32400L;
    @VisibleForTesting
    static final long RENEWAL_GRACE_PERIOD_SECONDS_DEFAULT = 3600L;
    @VisibleForTesting
    static final String KEY_ALGO_DEFAULT = "RSA";
    @VisibleForTesting
    static final int KEY_SIZE_DEFAULT = 2048;
    @VisibleForTesting
    static final String SIGNATURE_ALGO_DEFAULT = "SHA256withRSA";
    @VisibleForTesting
    static final int MAX_RETRY_ATTEMPTS_DEFAULT = 3;
    @VisibleForTesting
    static final String STS_URL_DEFAULT = "https://securetoken.googleapis.com/v1/identitybindingtoken";
    @VisibleForTesting
    static final long RPC_TIMEOUT_SECONDS = 10L;
    private static final Pattern CLUSTER_URL_PATTERN = Pattern.compile(".*/projects/(.*)/(?:locations|zones)/(.*)/clusters/.*");
    private static final String TRUST_DOMAIN_SUFFIX = ".svc.id.goog";
    private static final String AUDIENCE_PREFIX = "identitynamespace:";
    static final String MESH_CA_NAME = "meshCA";
    final StsCredentials.Factory stsCredentialsFactory;
    final MeshCaCertificateProvider.MeshCaChannelFactory meshCaChannelFactory;
    final BackoffPolicy.Provider backoffPolicyProvider;
    final MeshCaCertificateProvider.Factory meshCaCertificateProviderFactory;
    final ScheduledExecutorServiceFactory scheduledExecutorServiceFactory;
    final TimeProvider timeProvider;

    MeshCaCertificateProviderProvider() {
        this(StsCredentials.Factory.getInstance(), MeshCaCertificateProvider.MeshCaChannelFactory.getInstance(), (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider(), MeshCaCertificateProvider.Factory.getInstance(), ScheduledExecutorServiceFactory.DEFAULT_INSTANCE, TimeProvider.SYSTEM_TIME_PROVIDER);
    }

    @VisibleForTesting
    MeshCaCertificateProviderProvider(StsCredentials.Factory stsCredentialsFactory, MeshCaCertificateProvider.MeshCaChannelFactory meshCaChannelFactory, BackoffPolicy.Provider backoffPolicyProvider, MeshCaCertificateProvider.Factory meshCaCertificateProviderFactory, ScheduledExecutorServiceFactory scheduledExecutorServiceFactory, TimeProvider timeProvider) {
        this.stsCredentialsFactory = stsCredentialsFactory;
        this.meshCaChannelFactory = meshCaChannelFactory;
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.meshCaCertificateProviderFactory = meshCaCertificateProviderFactory;
        this.scheduledExecutorServiceFactory = scheduledExecutorServiceFactory;
        this.timeProvider = timeProvider;
    }

    @Override
    public String getName() {
        return MESH_CA_NAME;
    }

    @Override
    public CertificateProvider createCertificateProvider(Object config, CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates) {
        Config configObj = MeshCaCertificateProviderProvider.validateAndTranslateConfig(config);
        String audience = AUDIENCE_PREFIX + configObj.project + TRUST_DOMAIN_SUFFIX + ":" + configObj.gkeClusterUrl;
        StsCredentials stsCredentials = this.stsCredentialsFactory.create(configObj.stsUrl, audience, configObj.gkeSaJwtLocation);
        return this.meshCaCertificateProviderFactory.create(watcher, notifyCertUpdates, configObj.meshCaUrl, configObj.zone, configObj.certValiditySeconds, configObj.keySize, configObj.keyAlgo, configObj.signatureAlgo, this.meshCaChannelFactory, this.backoffPolicyProvider, configObj.renewalGracePeriodSeconds, configObj.maxRetryAttempts, stsCredentials, this.scheduledExecutorServiceFactory.create(configObj.meshCaUrl), this.timeProvider, TimeUnit.SECONDS.toMillis(10L));
    }

    private static Config validateAndTranslateConfig(Object config) {
        Preconditions.checkArgument((boolean)(config instanceof Map), (Object)"Only Map supported for config");
        Map map = (Map)config;
        Config configObj = new Config();
        MeshCaCertificateProviderProvider.extractMeshCaServerConfig(configObj, JsonUtil.getObject((Map)map, (String)SERVER_CONFIG_KEY));
        configObj.certValiditySeconds = MeshCaCertificateProviderProvider.getSeconds(JsonUtil.getObject((Map)map, (String)CERT_VALIDITY_SECONDS_KEY), 32400L);
        configObj.renewalGracePeriodSeconds = MeshCaCertificateProviderProvider.getSeconds(JsonUtil.getObject((Map)map, (String)RENEWAL_GRACE_PERIOD_SECONDS_KEY), 3600L);
        String keyType = JsonUtil.getString((Map)map, (String)KEY_ALGO_KEY);
        Preconditions.checkArgument((keyType == null || keyType.equals(KEY_ALGO_DEFAULT) ? 1 : 0) != 0, (Object)"key_type can only be null or 'RSA'");
        configObj.maxRetryAttempts = 3;
        configObj.keyAlgo = KEY_ALGO_DEFAULT;
        configObj.signatureAlgo = SIGNATURE_ALGO_DEFAULT;
        configObj.keySize = JsonUtil.getNumberAsInteger((Map)map, (String)KEY_SIZE_KEY);
        if (configObj.keySize == null) {
            configObj.keySize = 2048;
        }
        configObj.gkeClusterUrl = (String)Preconditions.checkNotNull((Object)JsonUtil.getString((Map)map, (String)GKECLUSTER_URL_KEY), (Object)"'location' is required in the config");
        MeshCaCertificateProviderProvider.parseProjectAndZone(configObj.gkeClusterUrl, configObj);
        return configObj;
    }

    private static void extractMeshCaServerConfig(Config configObj, Map<String, ?> serverConfig) {
        configObj.meshCaUrl = MESHCA_URL_DEFAULT;
        configObj.rpcTimeoutSeconds = 5L;
        configObj.stsUrl = STS_URL_DEFAULT;
        if (serverConfig != null) {
            Preconditions.checkArgument((boolean)"GRPC".equals(JsonUtil.getString(serverConfig, (String)"api_type")), (Object)"Only GRPC api_type supported");
            List grpcServices = (List)Preconditions.checkNotNull((Object)JsonUtil.getListOfObjects(serverConfig, (String)"grpc_services"), (Object)"grpc_services not found");
            for (Map grpcService : grpcServices) {
                Map channelCreds;
                Map googleGrpcConfig = JsonUtil.getObject((Map)grpcService, (String)"google_grpc");
                if (googleGrpcConfig == null) continue;
                String value = JsonUtil.getString((Map)googleGrpcConfig, (String)MESHCA_URL_KEY);
                if (value != null) {
                    configObj.meshCaUrl = value;
                }
                if ((channelCreds = JsonUtil.getObject((Map)googleGrpcConfig, (String)"channel_credentials")) != null) {
                    Map googleDefaultChannelCreds = (Map)Preconditions.checkNotNull((Object)JsonUtil.getObject((Map)channelCreds, (String)"google_default"), (Object)"channel_credentials need to be google_default!");
                    Preconditions.checkArgument((boolean)googleDefaultChannelCreds.isEmpty(), (Object)"google_default credentials contain illegal value");
                }
                List callCreds = JsonUtil.getListOfObjects((Map)googleGrpcConfig, (String)"call_credentials");
                for (Map callCred : callCreds) {
                    Map stsCreds = JsonUtil.getObject((Map)callCred, (String)STS_SERVICE_KEY);
                    if (stsCreds == null) continue;
                    value = JsonUtil.getString((Map)stsCreds, (String)TOKEN_EXCHANGE_SERVICE_KEY);
                    if (value != null) {
                        configObj.stsUrl = value;
                    }
                    configObj.gkeSaJwtLocation = JsonUtil.getString((Map)stsCreds, (String)GKE_SA_JWT_LOCATION_KEY);
                }
                configObj.rpcTimeoutSeconds = MeshCaCertificateProviderProvider.getSeconds(JsonUtil.getObject((Map)grpcService, (String)RPC_TIMEOUT_SECONDS_KEY), 5L);
            }
        }
        Preconditions.checkNotNull((Object)configObj.gkeSaJwtLocation, (Object)"'subject_token_path' is required in the config");
    }

    private static Long getSeconds(Map<String, ?> duration, long defaultValue) {
        if (duration != null) {
            return JsonUtil.getNumberAsLong(duration, (String)"seconds");
        }
        return defaultValue;
    }

    private static void parseProjectAndZone(String gkeClusterUrl, Config configObj) {
        Matcher matcher = CLUSTER_URL_PATTERN.matcher(gkeClusterUrl);
        Preconditions.checkState((boolean)matcher.find(), (Object)"gkeClusterUrl does not have correct format");
        Preconditions.checkState((matcher.groupCount() == 2 ? 1 : 0) != 0, (Object)"gkeClusterUrl does not have project and location parts");
        configObj.project = matcher.group(1);
        configObj.zone = matcher.group(2);
    }

    @VisibleForTesting
    static class Config {
        String meshCaUrl;
        Long rpcTimeoutSeconds;
        String gkeClusterUrl;
        Long certValiditySeconds;
        Long renewalGracePeriodSeconds;
        String keyAlgo;
        Integer keySize;
        String signatureAlgo;
        Integer maxRetryAttempts;
        String stsUrl;
        String gkeSaJwtLocation;
        String zone;
        String project;

        Config() {
        }
    }

    static abstract class ScheduledExecutorServiceFactory {
        private static final ScheduledExecutorServiceFactory DEFAULT_INSTANCE = new ScheduledExecutorServiceFactory(){

            @Override
            ScheduledExecutorService create(String serverUri) {
                return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("meshca-" + serverUri + "-%d").setDaemon(true).build());
            }
        };

        ScheduledExecutorServiceFactory() {
        }

        static ScheduledExecutorServiceFactory getInstance() {
            return DEFAULT_INSTANCE;
        }

        abstract ScheduledExecutorService create(String var1);
    }
}

