/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.ClientSslContextProviderFactory;
import io.grpc.xds.internal.sds.ReferenceCountingMap;
import io.grpc.xds.internal.sds.ServerSslContextProviderFactory;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.TlsContextManager;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;

public final class TlsContextManagerImpl
implements TlsContextManager {
    public static final String GOOGLE_CLOUD_PRIVATE_SPIFFE = "google_cloud_private_spiffe";
    private static TlsContextManagerImpl instance;
    private static final boolean CERT_INSTANCE_OVERRIDE;
    private final ReferenceCountingMap<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> mapForClients;
    private final ReferenceCountingMap<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> mapForServers;
    private final boolean hasCertInstanceOverride;

    @VisibleForTesting
    public TlsContextManagerImpl(Bootstrapper bootstrapper) {
        this(new ClientSslContextProviderFactory(bootstrapper), new ServerSslContextProviderFactory(bootstrapper), CERT_INSTANCE_OVERRIDE);
    }

    @VisibleForTesting
    TlsContextManagerImpl(ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> clientFactory, ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> serverFactory, boolean certInstanceOverride) {
        Preconditions.checkNotNull(clientFactory, (Object)"clientFactory");
        Preconditions.checkNotNull(serverFactory, (Object)"serverFactory");
        this.mapForClients = new ReferenceCountingMap<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider>(clientFactory);
        this.mapForServers = new ReferenceCountingMap<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider>(serverFactory);
        this.hasCertInstanceOverride = certInstanceOverride;
    }

    public static synchronized TlsContextManagerImpl getInstance() {
        if (instance == null) {
            instance = new TlsContextManagerImpl(Bootstrapper.getInstance());
        }
        return instance;
    }

    @Override
    public SslContextProvider findOrCreateServerSslContextProvider(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        CommonTlsContext.Builder builder = downstreamTlsContext.getCommonTlsContext().toBuilder();
        builder = this.performCertInstanceOverride(builder);
        downstreamTlsContext = new EnvoyServerProtoData.DownstreamTlsContext(builder.build(), downstreamTlsContext.isRequireClientCertificate());
        return this.mapForServers.get(downstreamTlsContext);
    }

    @Override
    public SslContextProvider findOrCreateClientSslContextProvider(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        CommonTlsContext.Builder builder = upstreamTlsContext.getCommonTlsContext().toBuilder();
        builder = this.performCertInstanceOverride(builder);
        upstreamTlsContext = new EnvoyServerProtoData.UpstreamTlsContext(builder.build());
        return this.mapForClients.get(upstreamTlsContext);
    }

    @VisibleForTesting
    CommonTlsContext.Builder performCertInstanceOverride(CommonTlsContext.Builder builder) {
        if (this.hasCertInstanceOverride) {
            if (builder.getTlsCertificateSdsSecretConfigsCount() > 0) {
                builder.setTlsCertificateCertificateProviderInstance(CommonTlsContext.CertificateProviderInstance.newBuilder().setInstanceName(GOOGLE_CLOUD_PRIVATE_SPIFFE));
            }
            if (builder.hasCombinedValidationContext()) {
                CommonTlsContext.CombinedCertificateValidationContext.Builder ccvcBuilder = builder.getCombinedValidationContextBuilder();
                if (ccvcBuilder.hasValidationContextSdsSecretConfig()) {
                    ccvcBuilder = ccvcBuilder.setValidationContextCertificateProviderInstance(CommonTlsContext.CertificateProviderInstance.newBuilder().setInstanceName(GOOGLE_CLOUD_PRIVATE_SPIFFE));
                    builder.setCombinedValidationContext(ccvcBuilder);
                }
            } else if (builder.hasValidationContextSdsSecretConfig()) {
                builder.setValidationContextCertificateProviderInstance(CommonTlsContext.CertificateProviderInstance.newBuilder().setInstanceName(GOOGLE_CLOUD_PRIVATE_SPIFFE));
            }
        }
        return builder;
    }

    @Override
    public SslContextProvider releaseClientSslContextProvider(SslContextProvider clientSslContextProvider) {
        Preconditions.checkNotNull((Object)clientSslContextProvider, (Object)"clientSslContextProvider");
        return this.mapForClients.release(clientSslContextProvider.getUpstreamTlsContext(), clientSslContextProvider);
    }

    @Override
    public SslContextProvider releaseServerSslContextProvider(SslContextProvider serverSslContextProvider) {
        Preconditions.checkNotNull((Object)serverSslContextProvider, (Object)"serverSslContextProvider");
        return this.mapForServers.release(serverSslContextProvider.getDownstreamTlsContext(), serverSslContextProvider);
    }

    static {
        CERT_INSTANCE_OVERRIDE = Boolean.parseBoolean(System.getenv("GRPC_XDS_CERT_INSTANCE_OVERRIDE"));
    }
}

