/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.CdsLoadBalancerProvider;
import io.grpc.xds.EdsLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import javax.annotation.Nullable;

final class CdsLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final LoadBalancerRegistry lbRegistry;
    private String clusterName;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private CdsLbState cdsLbState;
    private LoadBalancer.ResolvedAddresses resolvedAddresses;

    CdsLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry());
    }

    @VisibleForTesting
    CdsLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.lbRegistry = lbRegistry;
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cds-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (this.clusterName != null) {
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        this.resolvedAddresses = resolvedAddresses;
        this.xdsClientPool = (ObjectPool)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLIENT_POOL);
        Preconditions.checkNotNull(this.xdsClientPool, (Object)"missing xDS client pool");
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull((Object)lbConfig, (Object)"missing CDS lb config");
        CdsLoadBalancerProvider.CdsConfig newCdsConfig = (CdsLoadBalancerProvider.CdsConfig)lbConfig;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received CDS lb config: cluster={0}", newCdsConfig.name);
        this.clusterName = newCdsConfig.name;
        this.cdsLbState = new CdsLbState();
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.cdsLbState != null) {
            this.cdsLbState.propagateError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        if (this.cdsLbState != null) {
            this.cdsLbState.shutdown();
        }
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    private final class CdsLbState
    implements XdsClient.CdsResourceWatcher {
        private boolean shutdown;
        @Nullable
        LoadBalancer edsBalancer;

        private CdsLbState() {
            CdsLoadBalancer.this.xdsClient.watchCdsResource(CdsLoadBalancer.this.clusterName, this);
            CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Started watcher for cluster {0} with xDS client {1}", CdsLoadBalancer.this.clusterName, CdsLoadBalancer.this.xdsClient);
        }

        @Override
        public void onChanged(final XdsClient.CdsUpdate update) {
            CdsLoadBalancer.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (CdsLbState.this.shutdown) {
                        return;
                    }
                    if (update.clusterType != XdsClient.CdsUpdate.ClusterType.EDS) {
                        CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Unsupported cluster type: {0}", new Object[]{update.clusterType});
                        return;
                    }
                    XdsClient.CdsUpdate.EdsClusterConfig clusterConfig = (XdsClient.CdsUpdate.EdsClusterConfig)update.clusterConfig;
                    CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "EDS cluster {0}, edsServiceName: {1}", update.clusterName, clusterConfig.edsServiceName);
                    CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Cluster config: {0}", clusterConfig);
                    LoadBalancerProvider endpointPickingPolicyProvider = CdsLoadBalancer.this.lbRegistry.getProvider(clusterConfig.lbPolicy);
                    LoadBalancerProvider localityPickingPolicyProvider = CdsLoadBalancer.this.lbRegistry.getProvider("weighted_target_experimental");
                    EdsLoadBalancerProvider.EdsConfig edsConfig = new EdsLoadBalancerProvider.EdsConfig(update.clusterName, clusterConfig.edsServiceName, clusterConfig.lrsServerName, clusterConfig.maxConcurrentRequests, clusterConfig.upstreamTlsContext, new ServiceConfigUtil.PolicySelection(localityPickingPolicyProvider, null), new ServiceConfigUtil.PolicySelection(endpointPickingPolicyProvider, null));
                    if (CdsLbState.this.edsBalancer == null) {
                        CdsLbState.this.edsBalancer = CdsLoadBalancer.this.lbRegistry.getProvider("eds_experimental").newLoadBalancer(CdsLoadBalancer.this.helper);
                    }
                    CdsLbState.this.edsBalancer.handleResolvedAddresses(CdsLoadBalancer.this.resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig((Object)edsConfig).build());
                }
            });
        }

        @Override
        public void onResourceDoesNotExist(final String resourceName) {
            CdsLoadBalancer.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (CdsLbState.this.shutdown) {
                        return;
                    }
                    CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} is unavailable", resourceName);
                    if (CdsLbState.this.edsBalancer != null) {
                        CdsLbState.this.edsBalancer.shutdown();
                        CdsLbState.this.edsBalancer = null;
                    }
                    CdsLoadBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Resource " + resourceName + " is unavailable")));
                }
            });
        }

        @Override
        public void onError(final Status error) {
            CdsLoadBalancer.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (CdsLbState.this.shutdown) {
                        return;
                    }
                    CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}: {2}", CdsLoadBalancer.this.xdsClient, error.getCode(), error.getDescription());
                    if (CdsLbState.this.edsBalancer == null) {
                        CdsLoadBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                    }
                }
            });
        }

        void shutdown() {
            this.shutdown = true;
            CdsLoadBalancer.this.xdsClient.cancelCdsResourceWatch(CdsLoadBalancer.this.clusterName, this);
            CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cancelled watcher for cluster {0} with xDS client {1}", CdsLoadBalancer.this.clusterName, CdsLoadBalancer.this.xdsClient);
            if (this.edsBalancer != null) {
                this.edsBalancer.shutdown();
            }
        }

        void propagateError(Status error) {
            if (this.edsBalancer != null) {
                this.edsBalancer.handleNameResolutionError(error);
            } else {
                CdsLoadBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
            }
        }
    }
}

