/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.Durations;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.xds.AbstractXdsClient;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.LoadReportClient;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.CircuitBreakers;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HttpProtocolOptions;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.RoutingPriority;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.clusters.aggregate.v3.ClusterConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.Rds;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClientXdsClient
extends AbstractXdsClient {
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    @VisibleForTesting
    static final String AGGREGATE_CLUSTER_TYPE_NAME = "envoy.clusters.aggregate";
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER_V2 = "type.googleapis.com/envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager";
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER = "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT = "type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT_V2 = "type.googleapis.com/envoy.api.v2.auth.UpstreamTlsContext";
    private static final String TYPE_URL_CLUSTER_CONFIG_V2 = "type.googleapis.com/envoy.config.cluster.aggregate.v2alpha.ClusterConfig";
    private static final String TYPE_URL_CLUSTER_CONFIG = "type.googleapis.com/envoy.extensions.clusters.aggregate.v3.ClusterConfig";
    private final Map<String, ResourceSubscriber> ldsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> rdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> cdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> edsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final LoadStatsManager loadStatsManager = new LoadStatsManager();
    private final LoadReportClient lrsClient;
    private boolean reportingLoad;

    ClientXdsClient(ManagedChannel channel, boolean useProtocolV3, EnvoyProtoData.Node node, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        super(channel, useProtocolV3, node, timeService, backoffPolicyProvider, stopwatchSupplier);
        this.lrsClient = new LoadReportClient(this.loadStatsManager, channel, useProtocolV3, node, this.getSyncContext(), timeService, backoffPolicyProvider, stopwatchSupplier);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleLdsResponse(String versionInfo, List<Any> resources, String nonce) {
        ResourceSubscriber subscriber;
        ArrayList<Listener> listeners = new ArrayList<Listener>(resources.size());
        ArrayList<String> listenerNames = new ArrayList<String>(resources.size());
        try {
            for (Any any : resources) {
                void var7_8;
                if (any.getTypeUrl().equals(AbstractXdsClient.ResourceType.LDS.typeUrlV2())) {
                    Any any2 = any.toBuilder().setTypeUrl(AbstractXdsClient.ResourceType.LDS.typeUrl()).build();
                }
                Listener listener = (Listener)var7_8.unpack(Listener.class);
                listeners.add(listener);
                listenerNames.add(listener.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listeners in LDS response {0}", new Object[]{e});
            this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Malformed LDS response: " + (Object)((Object)e));
            return;
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received LDS response for resources: {0}", listenerNames);
        HashMap<String, HttpConnectionManager> httpConnectionManagers = new HashMap<String, HttpConnectionManager>(listeners.size());
        try {
            for (Listener listener : listeners) {
                Any apiListener = listener.getApiListener().getApiListener();
                if (apiListener.getTypeUrl().equals(TYPE_URL_HTTP_CONNECTION_MANAGER_V2)) {
                    apiListener = apiListener.toBuilder().setTypeUrl(TYPE_URL_HTTP_CONNECTION_MANAGER).build();
                }
                HttpConnectionManager hcm = (HttpConnectionManager)apiListener.unpack(HttpConnectionManager.class);
                httpConnectionManagers.put(listener.getName(), hcm);
            }
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack HttpConnectionManagers in Listeners of LDS response {0}", new Object[]{invalidProtocolBufferException});
            this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Malformed LDS response: " + (Object)((Object)invalidProtocolBufferException));
            return;
        }
        HashMap<String, XdsClient.LdsUpdate> hashMap = new HashMap<String, XdsClient.LdsUpdate>();
        HashSet<String> rdsNames = new HashSet<String>();
        String errorMessage = null;
        for (Map.Entry entry : httpConnectionManagers.entrySet()) {
            HttpProtocolOptions options;
            String listenerName = (String)entry.getKey();
            HttpConnectionManager hcm = (HttpConnectionManager)entry.getValue();
            XdsClient.LdsUpdate.Builder updateBuilder = XdsClient.LdsUpdate.newBuilder();
            if (hcm.hasRouteConfig()) {
                for (VirtualHost virtualHostProto : hcm.getRouteConfig().getVirtualHostsList()) {
                    EnvoyProtoData.StructOrError<EnvoyProtoData.VirtualHost> virtualHost = EnvoyProtoData.VirtualHost.fromEnvoyProtoVirtualHost(virtualHostProto);
                    if (virtualHost.getErrorDetail() != null) {
                        errorMessage = "Listener " + listenerName + " contains invalid virtual host: " + virtualHost.getErrorDetail();
                        break;
                    }
                    updateBuilder.addVirtualHost(virtualHost.getStruct());
                }
            } else if (hcm.hasRds()) {
                Rds rds = hcm.getRds();
                if (!rds.getConfigSource().hasAds()) {
                    errorMessage = "Listener " + listenerName + " with RDS config_source not set to ADS";
                } else {
                    updateBuilder.setRdsName(rds.getRouteConfigName());
                    rdsNames.add(rds.getRouteConfigName());
                }
            } else {
                errorMessage = "Listener " + listenerName + " without inline RouteConfiguration or RDS";
            }
            if (errorMessage != null) break;
            if (hcm.hasCommonHttpProtocolOptions() && (options = hcm.getCommonHttpProtocolOptions()).hasMaxStreamDuration()) {
                updateBuilder.setHttpMaxStreamDurationNano(Durations.toNanos((Duration)options.getMaxStreamDuration()));
            }
            hashMap.put(listenerName, updateBuilder.build());
        }
        if (errorMessage != null) {
            this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, errorMessage);
            return;
        }
        this.ackResponse(AbstractXdsClient.ResourceType.LDS, versionInfo, nonce);
        for (String resource : this.ldsResourceSubscribers.keySet()) {
            subscriber = this.ldsResourceSubscribers.get(resource);
            if (hashMap.containsKey(resource)) {
                subscriber.onData((XdsClient.ResourceUpdate)hashMap.get(resource));
                continue;
            }
            subscriber.onAbsent();
        }
        for (String resource : this.rdsResourceSubscribers.keySet()) {
            if (rdsNames.contains(resource)) continue;
            subscriber = this.rdsResourceSubscribers.get(resource);
            subscriber.onAbsent();
        }
    }

    @Override
    protected void handleRdsResponse(String versionInfo, List<Any> resources, String nonce) {
        HashMap<String, RouteConfiguration> routeConfigs = new HashMap<String, RouteConfiguration>(resources.size());
        try {
            for (Any res : resources) {
                if (res.getTypeUrl().equals(AbstractXdsClient.ResourceType.RDS.typeUrlV2())) {
                    res = res.toBuilder().setTypeUrl(AbstractXdsClient.ResourceType.RDS.typeUrl()).build();
                }
                RouteConfiguration rc = (RouteConfiguration)res.unpack(RouteConfiguration.class);
                routeConfigs.put(rc.getName(), rc);
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack RouteConfiguration in RDS response {0}", new Object[]{e});
            this.nackResponse(AbstractXdsClient.ResourceType.RDS, nonce, "Malformed RDS response: " + (Object)((Object)e));
            return;
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received RDS response for resources: {0}", routeConfigs.keySet());
        HashMap<String, XdsClient.RdsUpdate> rdsUpdates = new HashMap<String, XdsClient.RdsUpdate>();
        String errorMessage = null;
        for (Map.Entry entry : routeConfigs.entrySet()) {
            String routeConfigName = (String)entry.getKey();
            RouteConfiguration routeConfig = (RouteConfiguration)entry.getValue();
            ArrayList<EnvoyProtoData.VirtualHost> virtualHosts = new ArrayList<EnvoyProtoData.VirtualHost>(routeConfig.getVirtualHostsCount());
            for (VirtualHost virtualHostProto : routeConfig.getVirtualHostsList()) {
                EnvoyProtoData.StructOrError<EnvoyProtoData.VirtualHost> virtualHost = EnvoyProtoData.VirtualHost.fromEnvoyProtoVirtualHost(virtualHostProto);
                if (virtualHost.getErrorDetail() != null) {
                    errorMessage = "RouteConfiguration " + routeConfigName + " contains invalid virtual host: " + virtualHost.getErrorDetail();
                    break;
                }
                virtualHosts.add(virtualHost.getStruct());
            }
            if (errorMessage != null) break;
            rdsUpdates.put(routeConfigName, XdsClient.RdsUpdate.fromVirtualHosts(virtualHosts));
        }
        if (errorMessage != null) {
            this.nackResponse(AbstractXdsClient.ResourceType.RDS, nonce, errorMessage);
            return;
        }
        this.ackResponse(AbstractXdsClient.ResourceType.RDS, versionInfo, nonce);
        for (String resource : this.rdsResourceSubscribers.keySet()) {
            if (!rdsUpdates.containsKey(resource)) continue;
            ResourceSubscriber subscriber = this.rdsResourceSubscribers.get(resource);
            subscriber.onData((XdsClient.ResourceUpdate)rdsUpdates.get(resource));
        }
    }

    @Override
    protected void handleCdsResponse(String versionInfo, List<Any> resources, String nonce) {
        ResourceSubscriber subscriber;
        ArrayList<Cluster> clusters = new ArrayList<Cluster>(resources.size());
        ArrayList<String> clusterNames = new ArrayList<String>(resources.size());
        try {
            for (Any res : resources) {
                if (res.getTypeUrl().equals(AbstractXdsClient.ResourceType.CDS.typeUrlV2())) {
                    res = res.toBuilder().setTypeUrl(AbstractXdsClient.ResourceType.CDS.typeUrl()).build();
                }
                Cluster cluster = (Cluster)res.unpack(Cluster.class);
                clusters.add(cluster);
                clusterNames.add(cluster.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Clusters in CDS response {0}", new Object[]{e});
            this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Malformed CDS response: " + (Object)((Object)e));
            return;
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received CDS response for resources: {0}", clusterNames);
        HashMap<String, XdsClient.CdsUpdate> cdsUpdates = new HashMap<String, XdsClient.CdsUpdate>();
        HashSet<String> edsResources = new HashSet<String>();
        for (Cluster cluster : clusters) {
            String clusterName = cluster.getName();
            if (!this.cdsResourceSubscribers.containsKey(clusterName)) continue;
            if (!cluster.getLbPolicy().equals((Object)Cluster.LbPolicy.ROUND_ROBIN)) {
                this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": unsupported Lb policy: " + (Object)((Object)cluster.getLbPolicy()));
                return;
            }
            String lbPolicy = "round_robin";
            XdsClient.CdsUpdate update = null;
            switch (cluster.getClusterDiscoveryTypeCase()) {
                case TYPE: {
                    update = this.parseNonAggregateCluster(cluster, nonce, lbPolicy, edsResources);
                    break;
                }
                case CLUSTER_TYPE: {
                    update = this.parseAggregateCluster(cluster, nonce, lbPolicy);
                    break;
                }
                default: {
                    this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": cluster discovery type unspecified");
                }
            }
            if (update == null) {
                return;
            }
            cdsUpdates.put(clusterName, update);
        }
        this.ackResponse(AbstractXdsClient.ResourceType.CDS, versionInfo, nonce);
        for (String resource : this.cdsResourceSubscribers.keySet()) {
            subscriber = this.cdsResourceSubscribers.get(resource);
            if (cdsUpdates.containsKey(resource)) {
                subscriber.onData((XdsClient.ResourceUpdate)cdsUpdates.get(resource));
                continue;
            }
            subscriber.onAbsent();
        }
        for (String resource : this.edsResourceSubscribers.keySet()) {
            subscriber = this.edsResourceSubscribers.get(resource);
            if (edsResources.contains(resource)) continue;
            subscriber.onAbsent();
        }
    }

    private XdsClient.CdsUpdate parseAggregateCluster(Cluster cluster, String nonce, String lbPolicy) {
        ClusterConfig clusterConfig;
        String clusterName = cluster.getName();
        Cluster.CustomClusterType customType = cluster.getClusterType();
        String typeName = customType.getName();
        if (!typeName.equals(AGGREGATE_CLUSTER_TYPE_NAME)) {
            this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": unsupported custom cluster type: " + typeName);
            return null;
        }
        Any unpackedClusterConfig = customType.getTypedConfig();
        if (unpackedClusterConfig.getTypeUrl().equals(TYPE_URL_CLUSTER_CONFIG_V2)) {
            unpackedClusterConfig = unpackedClusterConfig.toBuilder().setTypeUrl(TYPE_URL_CLUSTER_CONFIG).build();
        }
        try {
            clusterConfig = (ClusterConfig)unpackedClusterConfig.unpack(ClusterConfig.class);
        }
        catch (InvalidProtocolBufferException e) {
            this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": invalid cluster config: " + (Object)((Object)e));
            return null;
        }
        XdsClient.CdsUpdate.AggregateClusterConfig config = new XdsClient.CdsUpdate.AggregateClusterConfig(lbPolicy, (List<String>)clusterConfig.getClustersList());
        return new XdsClient.CdsUpdate(clusterName, XdsClient.CdsUpdate.ClusterType.AGGREGATE, config);
    }

    private XdsClient.CdsUpdate parseNonAggregateCluster(Cluster cluster, String nonce, String lbPolicy, Set<String> edsResources) {
        Cluster.DiscoveryType type;
        String clusterName = cluster.getName();
        String lrsServerName = null;
        Long maxConcurrentRequests = null;
        EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = null;
        if (cluster.hasLrsServer()) {
            if (!cluster.getLrsServer().hasSelf()) {
                this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": only support LRS for the same management server");
                return null;
            }
            lrsServerName = "";
        }
        if (cluster.hasCircuitBreakers()) {
            List<CircuitBreakers.Thresholds> thresholds = cluster.getCircuitBreakers().getThresholdsList();
            for (CircuitBreakers.Thresholds threshold : thresholds) {
                if (threshold.getPriority() != RoutingPriority.DEFAULT || !threshold.hasMaxRequests()) continue;
                maxConcurrentRequests = threshold.getMaxRequests().getValue();
            }
        }
        if (cluster.hasTransportSocket() && "envoy.transport_sockets.tls".equals(cluster.getTransportSocket().getName())) {
            UpstreamTlsContext unpacked;
            Any any = cluster.getTransportSocket().getTypedConfig();
            if (any.getTypeUrl().equals(TYPE_URL_UPSTREAM_TLS_CONTEXT_V2)) {
                any = any.toBuilder().setTypeUrl(TYPE_URL_UPSTREAM_TLS_CONTEXT).build();
            }
            try {
                unpacked = (UpstreamTlsContext)any.unpack(UpstreamTlsContext.class);
            }
            catch (InvalidProtocolBufferException e) {
                this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": invalid upstream TLS context: " + (Object)((Object)e));
                return null;
            }
            upstreamTlsContext = EnvoyServerProtoData.UpstreamTlsContext.fromEnvoyProtoUpstreamTlsContext(unpacked);
        }
        if ((type = cluster.getType()) == Cluster.DiscoveryType.EDS) {
            String edsServiceName = null;
            Cluster.EdsClusterConfig edsClusterConfig = cluster.getEdsClusterConfig();
            if (!edsClusterConfig.getEdsConfig().hasAds()) {
                this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": field eds_cluster_config must be set to indicate to use EDS over ADS.");
                return null;
            }
            if (!edsClusterConfig.getServiceName().isEmpty()) {
                edsServiceName = edsClusterConfig.getServiceName();
                edsResources.add(edsServiceName);
            } else {
                edsResources.add(clusterName);
            }
            XdsClient.CdsUpdate.EdsClusterConfig config = new XdsClient.CdsUpdate.EdsClusterConfig(lbPolicy, edsServiceName, lrsServerName, maxConcurrentRequests, upstreamTlsContext);
            return new XdsClient.CdsUpdate(clusterName, XdsClient.CdsUpdate.ClusterType.EDS, config);
        }
        if (type.equals((Object)Cluster.DiscoveryType.LOGICAL_DNS)) {
            XdsClient.CdsUpdate.LogicalDnsClusterConfig config = new XdsClient.CdsUpdate.LogicalDnsClusterConfig(lbPolicy, lrsServerName, maxConcurrentRequests, upstreamTlsContext);
            return new XdsClient.CdsUpdate(clusterName, XdsClient.CdsUpdate.ClusterType.LOGICAL_DNS, config);
        }
        this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": unsupported built-in discovery type: " + (Object)((Object)type));
        return null;
    }

    @Override
    protected void handleEdsResponse(String versionInfo, List<Any> resources, String nonce) {
        ArrayList<ClusterLoadAssignment> clusterLoadAssignments = new ArrayList<ClusterLoadAssignment>(resources.size());
        ArrayList<String> claNames = new ArrayList<String>(resources.size());
        try {
            for (Any res : resources) {
                if (res.getTypeUrl().equals(AbstractXdsClient.ResourceType.EDS.typeUrlV2())) {
                    res = res.toBuilder().setTypeUrl(AbstractXdsClient.ResourceType.EDS.typeUrl()).build();
                }
                ClusterLoadAssignment assignment = (ClusterLoadAssignment)res.unpack(ClusterLoadAssignment.class);
                clusterLoadAssignments.add(assignment);
                claNames.add(assignment.getClusterName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack ClusterLoadAssignments in EDS response {0}", new Object[]{e});
            this.nackResponse(AbstractXdsClient.ResourceType.EDS, nonce, "Malformed EDS response: " + (Object)((Object)e));
            return;
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received EDS response for resources: {0}", claNames);
        String errorMessage = null;
        HashMap<String, XdsClient.EdsUpdate> edsUpdates = new HashMap<String, XdsClient.EdsUpdate>();
        for (ClusterLoadAssignment assignment : clusterLoadAssignments) {
            String clusterName = assignment.getClusterName();
            if (!this.edsResourceSubscribers.containsKey(clusterName)) continue;
            XdsClient.EdsUpdate.Builder updateBuilder = XdsClient.EdsUpdate.newBuilder();
            updateBuilder.setClusterName(clusterName);
            HashSet<Integer> priorities = new HashSet<Integer>();
            int maxPriority = -1;
            for (LocalityLbEndpoints localityLbEndpoints : assignment.getEndpointsList()) {
                if (!localityLbEndpoints.hasLoadBalancingWeight() || localityLbEndpoints.getLoadBalancingWeight().getValue() < 1) continue;
                int localityPriority = localityLbEndpoints.getPriority();
                if (localityPriority < 0) {
                    errorMessage = "ClusterLoadAssignment " + clusterName + " : locality with negative priority.";
                    break;
                }
                maxPriority = Math.max(maxPriority, localityPriority);
                priorities.add(localityPriority);
                for (LbEndpoint lbEndpoint : localityLbEndpoints.getLbEndpointsList()) {
                    if (lbEndpoint.getEndpoint().hasAddress()) continue;
                    errorMessage = "ClusterLoadAssignment " + clusterName + " : endpoint with no address.";
                    break;
                }
                if (errorMessage != null) break;
                updateBuilder.addLocalityLbEndpoints(EnvoyProtoData.Locality.fromEnvoyProtoLocality(localityLbEndpoints.getLocality()), EnvoyProtoData.LocalityLbEndpoints.fromEnvoyProtoLocalityLbEndpoints(localityLbEndpoints));
            }
            if (errorMessage != null) break;
            if (priorities.size() != maxPriority + 1) {
                errorMessage = "ClusterLoadAssignment " + clusterName + " : sparse priorities.";
                break;
            }
            for (ClusterLoadAssignment.Policy.DropOverload dropOverload : assignment.getPolicy().getDropOverloadsList()) {
                updateBuilder.addDropPolicy(EnvoyProtoData.DropOverload.fromEnvoyProtoDropOverload(dropOverload));
            }
            XdsClient.EdsUpdate update = updateBuilder.build();
            edsUpdates.put(clusterName, update);
        }
        if (errorMessage != null) {
            this.nackResponse(AbstractXdsClient.ResourceType.EDS, nonce, errorMessage);
            return;
        }
        this.ackResponse(AbstractXdsClient.ResourceType.EDS, versionInfo, nonce);
        for (String resource : this.edsResourceSubscribers.keySet()) {
            ResourceSubscriber subscriber = this.edsResourceSubscribers.get(resource);
            if (!edsUpdates.containsKey(resource)) continue;
            subscriber.onData((XdsClient.ResourceUpdate)edsUpdates.get(resource));
        }
    }

    @Override
    protected void handleStreamClosed(Status error) {
        this.cleanUpResourceTimers();
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
    }

    @Override
    protected void handleStreamRestarted() {
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
    }

    @Override
    protected void handleShutdown() {
        if (this.reportingLoad) {
            this.lrsClient.stopLoadReporting();
        }
        this.cleanUpResourceTimers();
    }

    @Override
    @Nullable
    Collection<String> getSubscribedResources(AbstractXdsClient.ResourceType type) {
        switch (type) {
            case LDS: {
                return this.ldsResourceSubscribers.isEmpty() ? null : this.ldsResourceSubscribers.keySet();
            }
            case RDS: {
                return this.rdsResourceSubscribers.isEmpty() ? null : this.rdsResourceSubscribers.keySet();
            }
            case CDS: {
                return this.cdsResourceSubscribers.isEmpty() ? null : this.cdsResourceSubscribers.keySet();
            }
            case EDS: {
                return this.edsResourceSubscribers.isEmpty() ? null : this.edsResourceSubscribers.keySet();
            }
        }
        throw new AssertionError((Object)"Unknown resource type");
    }

    @Override
    void watchLdsResource(final String resourceName, final XdsClient.LdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.ldsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe LDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.LDS, resourceName);
                    ClientXdsClient.this.ldsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.LDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelLdsResourceWatch(final String resourceName, final XdsClient.LdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.ldsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe LDS resource {0}", resourceName);
                    ClientXdsClient.this.ldsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.LDS);
                }
            }
        });
    }

    @Override
    void watchRdsResource(final String resourceName, final XdsClient.RdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.rdsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe RDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.RDS, resourceName);
                    ClientXdsClient.this.rdsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.RDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelRdsResourceWatch(final String resourceName, final XdsClient.RdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.rdsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe RDS resource {0}", resourceName);
                    ClientXdsClient.this.rdsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.RDS);
                }
            }
        });
    }

    @Override
    void watchCdsResource(final String resourceName, final XdsClient.CdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.cdsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe CDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.CDS, resourceName);
                    ClientXdsClient.this.cdsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.CDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelCdsResourceWatch(final String resourceName, final XdsClient.CdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.cdsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe CDS resource {0}", resourceName);
                    ClientXdsClient.this.cdsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.CDS);
                }
            }
        });
    }

    @Override
    void watchEdsResource(final String resourceName, final XdsClient.EdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.edsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe EDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.EDS, resourceName);
                    ClientXdsClient.this.edsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.EDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelEdsResourceWatch(final String resourceName, final XdsClient.EdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.edsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe EDS resource {0}", resourceName);
                    ClientXdsClient.this.edsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.EDS);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LoadStatsManager.LoadStatsStore addClientStats(String clusterName, @Nullable String clusterServiceName) {
        LoadStatsManager.LoadStatsStore loadStatsStore;
        ClientXdsClient clientXdsClient = this;
        synchronized (clientXdsClient) {
            loadStatsStore = this.loadStatsManager.addLoadStats(clusterName, clusterServiceName);
        }
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                if (!ClientXdsClient.this.reportingLoad) {
                    ClientXdsClient.this.lrsClient.startLoadReporting();
                    ClientXdsClient.this.reportingLoad = true;
                }
            }
        });
        return loadStatsStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeClientStats(String clusterName, @Nullable String clusterServiceName) {
        ClientXdsClient clientXdsClient = this;
        synchronized (clientXdsClient) {
            this.loadStatsManager.removeLoadStats(clusterName, clusterServiceName);
        }
    }

    private void cleanUpResourceTimers() {
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
    }

    private final class ResourceSubscriber {
        private final AbstractXdsClient.ResourceType type;
        private final String resource;
        private final Set<XdsClient.ResourceWatcher> watchers = new HashSet<XdsClient.ResourceWatcher>();
        private XdsClient.ResourceUpdate data;
        private boolean absent;
        private SynchronizationContext.ScheduledHandle respTimer;

        ResourceSubscriber(AbstractXdsClient.ResourceType type, String resource) {
            this.type = type;
            this.resource = resource;
            if (ClientXdsClient.this.isInBackoff()) {
                return;
            }
            this.restartTimer();
        }

        void addWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument((!this.watchers.contains(watcher) ? 1 : 0) != 0, (String)"watcher %s already registered", (Object)watcher);
            this.watchers.add(watcher);
            if (this.data != null) {
                this.notifyWatcher(watcher, this.data);
            } else if (this.absent) {
                watcher.onResourceDoesNotExist(this.resource);
            }
        }

        void removeWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument((boolean)this.watchers.contains(watcher), (String)"watcher %s not registered", (Object)watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            if (this.data != null || this.absent) {
                return;
            }
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", new Object[]{ResourceSubscriber.this.type, ResourceSubscriber.this.resource});
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent();
                }

                public String toString() {
                    return (Object)((Object)ResourceSubscriber.this.type) + this.getClass().getSimpleName();
                }
            }
            this.respTimer = ClientXdsClient.this.getSyncContext().schedule((Runnable)new ResourceNotFound(), 15L, TimeUnit.SECONDS, ClientXdsClient.this.getTimeService());
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        void onData(XdsClient.ResourceUpdate data) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            XdsClient.ResourceUpdate oldData = this.data;
            this.data = data;
            this.absent = false;
            if (!Objects.equals(oldData, data)) {
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    this.notifyWatcher(watcher, data);
                }
            }
        }

        void onAbsent() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", new Object[]{this.type, this.resource});
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            }
        }

        void onError(Status error) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            for (XdsClient.ResourceWatcher watcher : this.watchers) {
                watcher.onError(error);
            }
        }

        private void notifyWatcher(XdsClient.ResourceWatcher watcher, XdsClient.ResourceUpdate update) {
            switch (this.type) {
                case LDS: {
                    ((XdsClient.LdsResourceWatcher)watcher).onChanged((XdsClient.LdsUpdate)update);
                    break;
                }
                case RDS: {
                    ((XdsClient.RdsResourceWatcher)watcher).onChanged((XdsClient.RdsUpdate)update);
                    break;
                }
                case CDS: {
                    ((XdsClient.CdsResourceWatcher)watcher).onChanged((XdsClient.CdsUpdate)update);
                    break;
                }
                case EDS: {
                    ((XdsClient.EdsResourceWatcher)watcher).onChanged((XdsClient.EdsUpdate)update);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"should never be here");
                }
            }
        }
    }
}

