/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.ClusterImplLoadBalancer;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class ClusterImplLoadBalancerProvider
extends LoadBalancerProvider {
    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "cluster_impl_experimental";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        throw new UnsupportedOperationException("not supported as top-level LB policy");
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterImplLoadBalancer(helper);
    }

    static final class ClusterImplConfig {
        final String cluster;
        @Nullable
        final String edsServiceName;
        @Nullable
        final String lrsServerName;
        @Nullable
        final Long maxConcurrentRequests;
        @Nullable
        final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
        final List<EnvoyProtoData.DropOverload> dropCategories;
        final ServiceConfigUtil.PolicySelection childPolicy;

        ClusterImplConfig(String cluster, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, List<EnvoyProtoData.DropOverload> dropCategories, ServiceConfigUtil.PolicySelection childPolicy, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
            this.cluster = (String)Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
            this.edsServiceName = edsServiceName;
            this.lrsServerName = lrsServerName;
            this.maxConcurrentRequests = maxConcurrentRequests;
            this.tlsContext = tlsContext;
            this.dropCategories = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(dropCategories, (Object)"dropCategories")));
            this.childPolicy = (ServiceConfigUtil.PolicySelection)Preconditions.checkNotNull((Object)childPolicy, (Object)"childPolicy");
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("edsServiceName", (Object)this.edsServiceName).add("lrsServerName", (Object)this.lrsServerName).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests).add("dropCategories", this.dropCategories).add("childPolicy", (Object)this.childPolicy).toString();
        }
    }
}

