/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.ClusterImplLoadBalancerProvider;
import io.grpc.xds.EdsLoadBalancerProvider;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LrsLoadBalancerProvider;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.WeightedTargetLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class EdsLoadBalancer2
extends LoadBalancer {
    private final XdsLogger logger;
    private final SynchronizationContext syncContext;
    private final LoadBalancerRegistry lbRegistry;
    private final GracefulSwitchLoadBalancer switchingLoadBalancer;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private String cluster;
    private EdsLbState edsLbState;

    EdsLoadBalancer2(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry());
    }

    @VisibleForTesting
    EdsLoadBalancer2(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.syncContext = ((LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper")).getSynchronizationContext();
        this.switchingLoadBalancer = new GracefulSwitchLoadBalancer(helper);
        InternalLogId logId = InternalLogId.allocate((String)"eds-lb", (String)helper.getAuthority());
        this.logger = XdsLogger.withLogId(logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.xdsClientPool == null) {
            this.xdsClientPool = (ObjectPool)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        EdsLoadBalancerProvider.EdsConfig config = (EdsLoadBalancerProvider.EdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received EDS lb config: cluster={0}, eds_service_name={1}, max_concurrent_requests={2}, locality_picking_policy={3}, endpoint_picking_policy={4}, report_load={5}", config.clusterName, config.edsServiceName, config.maxConcurrentRequests, config.localityPickingPolicy.getProvider().getPolicyName(), config.endpointPickingPolicy.getProvider().getPolicyName(), config.lrsServerName != null);
        }
        if (this.cluster == null) {
            this.cluster = config.clusterName;
        }
        if (this.edsLbState == null || !Objects.equals(this.edsLbState.edsServiceName, config.edsServiceName)) {
            this.edsLbState = new EdsLbState(config.edsServiceName, config.lrsServerName);
            this.switchingLoadBalancer.switchTo((LoadBalancer.Factory)this.edsLbState);
        }
        this.switchingLoadBalancer.handleResolvedAddresses(resolvedAddresses);
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchingLoadBalancer.handleNameResolutionError(error);
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        this.switchingLoadBalancer.shutdown();
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    @VisibleForTesting
    static WeightedTargetLoadBalancerProvider.WeightedTargetConfig generateWeightedTargetLbConfig(String cluster, @Nullable String edsServiceName, @Nullable String lrsServerName, ServiceConfigUtil.PolicySelection endpointPickingPolicy, LoadBalancerRegistry lbRegistry, Map<EnvoyProtoData.Locality, Integer> localityWeights) {
        HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> targets = new HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection>();
        for (EnvoyProtoData.Locality locality : localityWeights.keySet()) {
            ServiceConfigUtil.PolicySelection childPolicy;
            int weight = localityWeights.get(locality);
            if (lrsServerName != null) {
                LrsLoadBalancerProvider.LrsConfig childConfig = new LrsLoadBalancerProvider.LrsConfig(cluster, edsServiceName, lrsServerName, locality, endpointPickingPolicy);
                LoadBalancerProvider childPolicyProvider = lbRegistry.getProvider("lrs_experimental");
                childPolicy = new ServiceConfigUtil.PolicySelection(childPolicyProvider, (Object)childConfig);
            } else {
                childPolicy = endpointPickingPolicy;
            }
            targets.put(EdsLoadBalancer2.localityName(locality), new WeightedTargetLoadBalancerProvider.WeightedPolicySelection(weight, childPolicy));
        }
        return new WeightedTargetLoadBalancerProvider.WeightedTargetConfig(Collections.unmodifiableMap(targets));
    }

    private static String priorityName(int priority) {
        return "priority" + priority;
    }

    private static String localityName(EnvoyProtoData.Locality locality) {
        return locality.toString();
    }

    private final class EdsLbState
    extends LoadBalancer.Factory {
        @Nullable
        private final String edsServiceName;
        @Nullable
        private final String lrsServerName;
        private final String resourceName;

        private EdsLbState(@Nullable String edsServiceName, String lrsServerName) {
            this.edsServiceName = edsServiceName;
            this.lrsServerName = lrsServerName;
            this.resourceName = edsServiceName == null ? EdsLoadBalancer2.this.cluster : edsServiceName;
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new ChildLbState(helper);
        }

        private final class ChildLbState
        extends LoadBalancer
        implements XdsClient.EdsResourceWatcher {
            private final LoadBalancer.Helper lbHelper;
            private LoadBalancer.ResolvedAddresses resolvedAddresses;
            private boolean shutdown;
            private LoadBalancer lb;
            private List<EquivalentAddressGroup> endpointAddresses;
            private Map<Integer, Map<EnvoyProtoData.Locality, Integer>> prioritizedLocalityWeights;
            private List<EnvoyProtoData.DropOverload> dropOverloads;

            private ChildLbState(LoadBalancer.Helper helper) {
                this.lbHelper = helper;
                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start endpoint watcher on {0} with xDS client {1}", EdsLbState.this.resourceName, EdsLoadBalancer2.this.xdsClient);
                EdsLoadBalancer2.this.xdsClient.watchEdsResource(EdsLbState.this.resourceName, this);
            }

            public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
                boolean updated = !Objects.equals(this.resolvedAddresses, resolvedAddresses);
                this.resolvedAddresses = resolvedAddresses;
                if (this.lb != null && updated) {
                    this.handleResourceUpdate();
                }
            }

            public void handleNameResolutionError(Status error) {
                if (this.lb != null) {
                    this.lb.handleNameResolutionError(error);
                } else {
                    this.lbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                }
            }

            public void shutdown() {
                this.shutdown = true;
                EdsLoadBalancer2.this.xdsClient.cancelEdsResourceWatch(EdsLbState.this.resourceName, this);
                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cancelled endpoint watcher on {0} with xDS client {1}", EdsLbState.this.resourceName, EdsLoadBalancer2.this.xdsClient);
                if (this.lb != null) {
                    this.lb.shutdown();
                }
            }

            public boolean canHandleEmptyAddressListFromNameResolution() {
                return true;
            }

            @Override
            public void onChanged(final XdsClient.EdsUpdate update) {
                EdsLoadBalancer2.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ChildLbState.this.shutdown) {
                            return;
                        }
                        EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update from xDS client {0}: {1}", EdsLoadBalancer2.this.xdsClient, update);
                        if (EdsLoadBalancer2.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                            EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received endpoint update: cluster_name={0}, {1} localities, {2} drop categories", update.getClusterName(), update.getLocalityLbEndpointsMap().size(), update.getDropPolicies().size());
                        }
                        ChildLbState.this.dropOverloads = update.getDropPolicies();
                        Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpoints = update.getLocalityLbEndpointsMap();
                        ChildLbState.this.endpointAddresses = new ArrayList();
                        ChildLbState.this.prioritizedLocalityWeights = new HashMap();
                        for (EnvoyProtoData.Locality locality : localityLbEndpoints.keySet()) {
                            EnvoyProtoData.LocalityLbEndpoints localityLbInfo = localityLbEndpoints.get(locality);
                            int priority = localityLbInfo.getPriority();
                            boolean discard = true;
                            for (EnvoyProtoData.LbEndpoint endpoint : localityLbInfo.getEndpoints()) {
                                if (!endpoint.isHealthy()) continue;
                                discard = false;
                                EquivalentAddressGroup eag = AddressFilter.setPathFilter(endpoint.getAddress(), Arrays.asList(EdsLoadBalancer2.priorityName(priority), EdsLoadBalancer2.localityName(locality)));
                                ChildLbState.this.endpointAddresses.add(eag);
                            }
                            if (discard) {
                                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Discard locality {0} with 0 healthy endpoints");
                                continue;
                            }
                            if (!ChildLbState.this.prioritizedLocalityWeights.containsKey(priority)) {
                                ChildLbState.this.prioritizedLocalityWeights.put(priority, new HashMap());
                            }
                            ((Map)ChildLbState.this.prioritizedLocalityWeights.get(priority)).put(locality, localityLbInfo.getLocalityWeight());
                        }
                        if (ChildLbState.this.prioritizedLocalityWeights.isEmpty()) {
                            ChildLbState.this.propagateResourceError(Status.UNAVAILABLE.withDescription("No usable priority/locality/endpoint"));
                            return;
                        }
                        if (ChildLbState.this.lb == null) {
                            ChildLbState.this.lb = EdsLoadBalancer2.this.lbRegistry.getProvider("priority_experimental").newLoadBalancer(ChildLbState.this.lbHelper);
                        }
                        ChildLbState.this.handleResourceUpdate();
                    }
                });
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                EdsLoadBalancer2.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ChildLbState.this.shutdown) {
                            return;
                        }
                        EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} is unavailable", resourceName);
                        ChildLbState.this.propagateResourceError(Status.UNAVAILABLE.withDescription("Resource " + resourceName + " is unavailable"));
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                EdsLoadBalancer2.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ChildLbState.this.shutdown) {
                            return;
                        }
                        EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}", EdsLoadBalancer2.this.xdsClient, error);
                        if (ChildLbState.this.lb == null) {
                            ChildLbState.this.lbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                        }
                    }
                });
            }

            private void handleResourceUpdate() {
                EdsLoadBalancerProvider.EdsConfig config = (EdsLoadBalancerProvider.EdsConfig)this.resolvedAddresses.getLoadBalancingPolicyConfig();
                HashMap<String, ServiceConfigUtil.PolicySelection> priorityChildPolicies = new HashMap<String, ServiceConfigUtil.PolicySelection>();
                ArrayList<String> priorities = new ArrayList<String>();
                for (Integer priority : this.prioritizedLocalityWeights.keySet()) {
                    WeightedTargetLoadBalancerProvider.WeightedTargetConfig weightedTargetConfig = EdsLoadBalancer2.generateWeightedTargetLbConfig(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName, EdsLbState.this.lrsServerName, config.endpointPickingPolicy, EdsLoadBalancer2.this.lbRegistry, this.prioritizedLocalityWeights.get(priority));
                    ServiceConfigUtil.PolicySelection localityPicking = new ServiceConfigUtil.PolicySelection(config.localityPickingPolicy.getProvider(), (Object)weightedTargetConfig);
                    ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName, EdsLbState.this.lrsServerName, config.maxConcurrentRequests, this.dropOverloads, localityPicking, config.tlsContext);
                    LoadBalancerProvider clusterImplLbProvider = EdsLoadBalancer2.this.lbRegistry.getProvider("cluster_impl_experimental");
                    ServiceConfigUtil.PolicySelection clusterImplPolicy = new ServiceConfigUtil.PolicySelection(clusterImplLbProvider, (Object)clusterImplConfig);
                    String priorityName = EdsLoadBalancer2.priorityName(priority);
                    priorityChildPolicies.put(priorityName, clusterImplPolicy);
                    priorities.add(priorityName);
                }
                Collections.sort(priorities);
                PriorityLoadBalancerProvider.PriorityLbConfig priorityLbConfig = new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(priorityChildPolicies), Collections.unmodifiableList(priorities));
                this.lb.handleResolvedAddresses(this.resolvedAddresses.toBuilder().setAddresses(this.endpointAddresses).setLoadBalancingPolicyConfig((Object)priorityLbConfig).build());
            }

            private void propagateResourceError(Status error) {
                if (this.lb != null) {
                    this.lb.shutdown();
                    this.lb = null;
                }
                this.lbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
            }
        }
    }
}

