/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.EdsLoadBalancer2;
import io.grpc.xds.EnvoyServerProtoData;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public class EdsLoadBalancerProvider
extends LoadBalancerProvider {
    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "eds_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new EdsLoadBalancer2(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        throw new UnsupportedOperationException("not supported as top-level LB policy");
    }

    static final class EdsConfig {
        final String clusterName;
        @Nullable
        final String edsServiceName;
        @Nullable
        final String lrsServerName;
        @Nullable
        final Long maxConcurrentRequests;
        @Nullable
        final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
        final ServiceConfigUtil.PolicySelection localityPickingPolicy;
        final ServiceConfigUtil.PolicySelection endpointPickingPolicy;

        EdsConfig(String clusterName, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, ServiceConfigUtil.PolicySelection localityPickingPolicy, ServiceConfigUtil.PolicySelection endpointPickingPolicy) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.edsServiceName = edsServiceName;
            this.lrsServerName = lrsServerName;
            this.maxConcurrentRequests = maxConcurrentRequests;
            this.tlsContext = tlsContext;
            this.localityPickingPolicy = (ServiceConfigUtil.PolicySelection)Preconditions.checkNotNull((Object)localityPickingPolicy, (Object)"localityPickingPolicy");
            this.endpointPickingPolicy = (ServiceConfigUtil.PolicySelection)Preconditions.checkNotNull((Object)endpointPickingPolicy, (Object)"endpointPickingPolicy");
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.edsServiceName, this.lrsServerName, this.maxConcurrentRequests, this.tlsContext, this.localityPickingPolicy, this.endpointPickingPolicy);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdsConfig that = (EdsConfig)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.edsServiceName, that.edsServiceName) && Objects.equals(this.lrsServerName, that.lrsServerName) && Objects.equals(this.maxConcurrentRequests, that.maxConcurrentRequests) && Objects.equals(this.tlsContext, that.tlsContext) && Objects.equals(this.localityPickingPolicy, that.localityPickingPolicy) && Objects.equals(this.endpointPickingPolicy, that.endpointPickingPolicy);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("edsServiceName", (Object)this.edsServiceName).add("lrsServerName", (Object)this.lrsServerName).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests).add("localityPickingPolicy", (Object)this.localityPickingPolicy).add("endpointPickingPolicy", (Object)this.endpointPickingPolicy).toString();
        }
    }
}

