/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.util.Durations;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.xds.AbstractXdsClient;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.HttpFault;
import io.grpc.xds.LoadReportClient;
import io.grpc.xds.LoadStatsManager2;
import io.grpc.xds.Matchers;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.CircuitBreakers;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HttpProtocolOptions;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.RoutingPriority;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.Route;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteAction;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.WeightedCluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.clusters.aggregate.v3.ClusterConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.common.fault.v3.FaultDelay;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.fault.v3.FaultAbort;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.fault.v3.HTTPFault;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpFilter;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.Rds;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClientXdsClient
extends AbstractXdsClient {
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    @VisibleForTesting
    static final String AGGREGATE_CLUSTER_TYPE_NAME = "envoy.clusters.aggregate";
    private static final String HTTP_FAULT_FILTER_NAME = "envoy.fault";
    @VisibleForTesting
    static boolean enableFaultInjection = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_FAULT_INJECTION"));
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER_V2 = "type.googleapis.com/envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager";
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER = "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT = "type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT_V2 = "type.googleapis.com/envoy.api.v2.auth.UpstreamTlsContext";
    private static final String TYPE_URL_CLUSTER_CONFIG_V2 = "type.googleapis.com/envoy.config.cluster.aggregate.v2alpha.ClusterConfig";
    private static final String TYPE_URL_CLUSTER_CONFIG = "type.googleapis.com/envoy.extensions.clusters.aggregate.v3.ClusterConfig";
    private final Map<String, ResourceSubscriber> ldsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> rdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> cdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> edsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final LoadStatsManager2 loadStatsManager;
    private final LoadReportClient lrsClient;
    private boolean reportingLoad;

    ClientXdsClient(ManagedChannel channel, boolean useProtocolV3, EnvoyProtoData.Node node, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        super(channel, useProtocolV3, node, timeService, backoffPolicyProvider, stopwatchSupplier);
        this.loadStatsManager = new LoadStatsManager2(stopwatchSupplier);
        this.lrsClient = new LoadReportClient(this.loadStatsManager, channel, useProtocolV3, node, this.getSyncContext(), timeService, backoffPolicyProvider, stopwatchSupplier);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleLdsResponse(String versionInfo, List<Any> resources, String nonce) {
        ResourceSubscriber subscriber;
        ArrayList<Listener> listeners = new ArrayList<Listener>(resources.size());
        ArrayList<String> listenerNames = new ArrayList<String>(resources.size());
        try {
            for (Any any : resources) {
                void var7_8;
                if (any.getTypeUrl().equals(AbstractXdsClient.ResourceType.LDS.typeUrlV2())) {
                    Any any2 = any.toBuilder().setTypeUrl(AbstractXdsClient.ResourceType.LDS.typeUrl()).build();
                }
                Listener listener = (Listener)var7_8.unpack(Listener.class);
                listeners.add(listener);
                listenerNames.add(listener.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listeners in LDS response {0}", new Object[]{e});
            this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Malformed LDS response: " + (Object)((Object)e));
            return;
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received LDS response for resources: {0}", listenerNames);
        HashMap<String, HttpConnectionManager> httpConnectionManagers = new HashMap<String, HttpConnectionManager>(listeners.size());
        try {
            for (Listener listener : listeners) {
                Any apiListener = listener.getApiListener().getApiListener();
                if (apiListener.getTypeUrl().equals(TYPE_URL_HTTP_CONNECTION_MANAGER_V2)) {
                    apiListener = apiListener.toBuilder().setTypeUrl(TYPE_URL_HTTP_CONNECTION_MANAGER).build();
                }
                HttpConnectionManager hcm = (HttpConnectionManager)apiListener.unpack(HttpConnectionManager.class);
                httpConnectionManagers.put(listener.getName(), hcm);
            }
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack HttpConnectionManagers in Listeners of LDS response {0}", new Object[]{invalidProtocolBufferException});
            this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Malformed LDS response: " + (Object)((Object)invalidProtocolBufferException));
            return;
        }
        HashMap<String, XdsClient.LdsUpdate> hashMap = new HashMap<String, XdsClient.LdsUpdate>();
        HashSet<String> rdsNames = new HashSet<String>();
        for (Map.Entry entry : httpConnectionManagers.entrySet()) {
            XdsClient.LdsUpdate update;
            HttpProtocolOptions options;
            String listenerName = (String)entry.getKey();
            HttpConnectionManager hcm = (HttpConnectionManager)entry.getValue();
            long maxStreamDuration = 0L;
            if (hcm.hasCommonHttpProtocolOptions() && (options = hcm.getCommonHttpProtocolOptions()).hasMaxStreamDuration()) {
                maxStreamDuration = Durations.toNanos((Duration)options.getMaxStreamDuration());
            }
            boolean hasFaultInjection = false;
            HttpFault httpFault = null;
            if (enableFaultInjection) {
                List<HttpFilter> httpFilters = hcm.getHttpFiltersList();
                for (HttpFilter httpFilter : httpFilters) {
                    StructOrError<HttpFault> httpFaultOrError;
                    if (!HTTP_FAULT_FILTER_NAME.equals(httpFilter.getName())) continue;
                    hasFaultInjection = true;
                    if (!httpFilter.hasTypedConfig() || (httpFaultOrError = ClientXdsClient.decodeFaultFilterConfig(httpFilter.getTypedConfig())) == null) break;
                    if (httpFaultOrError.getErrorDetail() != null) {
                        this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Listener " + listenerName + " contains invalid HttpFault filter: " + httpFaultOrError.getErrorDetail());
                        return;
                    }
                    httpFault = httpFaultOrError.getStruct();
                    break;
                }
            }
            if (hcm.hasRouteConfig()) {
                ArrayList<io.grpc.xds.VirtualHost> virtualHosts = new ArrayList<io.grpc.xds.VirtualHost>();
                for (VirtualHost virtualHostProto : hcm.getRouteConfig().getVirtualHostsList()) {
                    StructOrError<io.grpc.xds.VirtualHost> virtualHost = ClientXdsClient.parseVirtualHost(virtualHostProto);
                    if (virtualHost.getErrorDetail() != null) {
                        this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Listener " + listenerName + " contains invalid virtual host: " + virtualHost.getErrorDetail());
                        return;
                    }
                    virtualHosts.add(virtualHost.getStruct());
                }
                update = new XdsClient.LdsUpdate(maxStreamDuration, virtualHosts, hasFaultInjection, httpFault);
            } else if (hcm.hasRds()) {
                Rds rds = hcm.getRds();
                if (!rds.getConfigSource().hasAds()) {
                    this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Listener " + listenerName + " with RDS config_source not set to ADS");
                    return;
                }
                update = new XdsClient.LdsUpdate(maxStreamDuration, rds.getRouteConfigName(), hasFaultInjection, httpFault);
                rdsNames.add(rds.getRouteConfigName());
            } else {
                this.nackResponse(AbstractXdsClient.ResourceType.LDS, nonce, "Listener " + listenerName + " without inline RouteConfiguration or RDS");
                return;
            }
            hashMap.put(listenerName, update);
        }
        this.ackResponse(AbstractXdsClient.ResourceType.LDS, versionInfo, nonce);
        for (String resource : this.ldsResourceSubscribers.keySet()) {
            subscriber = this.ldsResourceSubscribers.get(resource);
            if (hashMap.containsKey(resource)) {
                subscriber.onData((XdsClient.ResourceUpdate)hashMap.get(resource));
                continue;
            }
            subscriber.onAbsent();
        }
        for (String resource : this.rdsResourceSubscribers.keySet()) {
            if (rdsNames.contains(resource)) continue;
            subscriber = this.rdsResourceSubscribers.get(resource);
            subscriber.onAbsent();
        }
    }

    private static StructOrError<io.grpc.xds.VirtualHost> parseVirtualHost(VirtualHost proto) {
        Any rawFaultFilterConfig;
        StructOrError<HttpFault> httpFaultOrError;
        String name = proto.getName();
        ArrayList<VirtualHost.Route> routes = new ArrayList<VirtualHost.Route>(proto.getRoutesCount());
        for (Route routeProto : proto.getRoutesList()) {
            StructOrError<VirtualHost.Route> route = ClientXdsClient.parseRoute(routeProto);
            if (route == null) continue;
            if (route.getErrorDetail() != null) {
                return StructOrError.fromError("Virtual host [" + name + "] contains invalid route : " + route.getErrorDetail());
            }
            routes.add(route.getStruct());
        }
        HttpFault httpFault = null;
        Map<String, Any> filterConfigMap = proto.getTypedPerFilterConfigMap();
        if (filterConfigMap.containsKey(HTTP_FAULT_FILTER_NAME) && (httpFaultOrError = ClientXdsClient.decodeFaultFilterConfig(rawFaultFilterConfig = filterConfigMap.get(HTTP_FAULT_FILTER_NAME))) != null) {
            if (httpFaultOrError.getErrorDetail() != null) {
                return StructOrError.fromError("Virtual host [" + name + "] contains invalid HttpFault filter : " + httpFaultOrError.getErrorDetail());
            }
            httpFault = httpFaultOrError.getStruct();
        }
        return StructOrError.fromStruct(io.grpc.xds.VirtualHost.create(name, (List<String>)proto.getDomainsList(), routes, httpFault));
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route> parseRoute(Route proto) {
        Any rawFaultFilterConfig;
        StructOrError<HttpFault> httpFaultOrError;
        StructOrError<VirtualHost.Route.RouteAction> routeAction;
        StructOrError<VirtualHost.Route.RouteMatch> routeMatch = ClientXdsClient.parseRouteMatch(proto.getMatch());
        if (routeMatch == null) {
            return null;
        }
        if (routeMatch.getErrorDetail() != null) {
            return StructOrError.fromError("Invalid route [" + proto.getName() + "]: " + routeMatch.getErrorDetail());
        }
        switch (proto.getActionCase()) {
            case ROUTE: {
                routeAction = ClientXdsClient.parseRouteAction(proto.getRoute());
                break;
            }
            case REDIRECT: {
                return StructOrError.fromError("Unsupported action type: redirect");
            }
            case DIRECT_RESPONSE: {
                return StructOrError.fromError("Unsupported action type: direct_response");
            }
            case FILTER_ACTION: {
                return StructOrError.fromError("Unsupported action type: filter_action");
            }
            default: {
                return StructOrError.fromError("Unknown action type: " + (Object)((Object)proto.getActionCase()));
            }
        }
        if (routeAction == null) {
            return null;
        }
        if (routeAction.getErrorDetail() != null) {
            return StructOrError.fromError("Invalid route [" + proto.getName() + "]: " + routeAction.getErrorDetail());
        }
        HttpFault httpFault = null;
        Map<String, Any> filterConfigMap = proto.getTypedPerFilterConfigMap();
        if (filterConfigMap.containsKey(HTTP_FAULT_FILTER_NAME) && (httpFaultOrError = ClientXdsClient.decodeFaultFilterConfig(rawFaultFilterConfig = filterConfigMap.get(HTTP_FAULT_FILTER_NAME))) != null) {
            if (httpFaultOrError.getErrorDetail() != null) {
                return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid HttpFault filter: " + httpFaultOrError.getErrorDetail());
            }
            httpFault = httpFaultOrError.getStruct();
        }
        return StructOrError.fromStruct(VirtualHost.Route.create(routeMatch.getStruct(), routeAction.getStruct(), httpFault));
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteMatch> parseRouteMatch(RouteMatch proto) {
        if (proto.getQueryParametersCount() != 0) {
            return null;
        }
        StructOrError<Matchers.PathMatcher> pathMatch = ClientXdsClient.parsePathMatcher(proto);
        if (pathMatch.getErrorDetail() != null) {
            return StructOrError.fromError(pathMatch.getErrorDetail());
        }
        Matchers.FractionMatcher fractionMatch = null;
        if (proto.hasRuntimeFraction()) {
            StructOrError<Matchers.FractionMatcher> parsedFraction = ClientXdsClient.parseFractionMatcher(proto.getRuntimeFraction().getDefaultValue());
            if (parsedFraction.getErrorDetail() != null) {
                return StructOrError.fromError(parsedFraction.getErrorDetail());
            }
            fractionMatch = parsedFraction.getStruct();
        }
        ArrayList<Matchers.HeaderMatcher> headerMatchers = new ArrayList<Matchers.HeaderMatcher>();
        for (HeaderMatcher hmProto : proto.getHeadersList()) {
            StructOrError<Matchers.HeaderMatcher> headerMatcher = ClientXdsClient.parseHeaderMatcher(hmProto);
            if (headerMatcher.getErrorDetail() != null) {
                return StructOrError.fromError(headerMatcher.getErrorDetail());
            }
            headerMatchers.add(headerMatcher.getStruct());
        }
        return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.create(pathMatch.getStruct(), headerMatchers, fractionMatch));
    }

    @VisibleForTesting
    static StructOrError<Matchers.PathMatcher> parsePathMatcher(RouteMatch proto) {
        boolean caseSensitive = proto.getCaseSensitive().getValue();
        switch (proto.getPathSpecifierCase()) {
            case PREFIX: {
                return StructOrError.fromStruct(Matchers.PathMatcher.fromPrefix(proto.getPrefix(), caseSensitive));
            }
            case PATH: {
                return StructOrError.fromStruct(Matchers.PathMatcher.fromPath(proto.getPath(), caseSensitive));
            }
            case SAFE_REGEX: {
                Pattern safeRegEx;
                String rawPattern = proto.getSafeRegex().getRegex();
                try {
                    safeRegEx = Pattern.compile((String)rawPattern);
                }
                catch (PatternSyntaxException e) {
                    return StructOrError.fromError("Malformed safe regex pattern: " + e.getMessage());
                }
                return StructOrError.fromStruct(Matchers.PathMatcher.fromRegEx(safeRegEx));
            }
        }
        return StructOrError.fromError("Unknown path match type");
    }

    private static StructOrError<Matchers.FractionMatcher> parseFractionMatcher(FractionalPercent proto) {
        int numerator = proto.getNumerator();
        int denominator = 0;
        switch (proto.getDenominator()) {
            case HUNDRED: {
                denominator = 100;
                break;
            }
            case TEN_THOUSAND: {
                denominator = 10000;
                break;
            }
            case MILLION: {
                denominator = 1000000;
                break;
            }
            default: {
                return StructOrError.fromError("Unrecognized fractional percent denominator: " + (Object)((Object)proto.getDenominator()));
            }
        }
        return StructOrError.fromStruct(Matchers.FractionMatcher.create(numerator, denominator));
    }

    @VisibleForTesting
    static StructOrError<Matchers.HeaderMatcher> parseHeaderMatcher(HeaderMatcher proto) {
        switch (proto.getHeaderMatchSpecifierCase()) {
            case EXACT_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forExactValue(proto.getName(), proto.getExactMatch(), proto.getInvertMatch()));
            }
            case SAFE_REGEX_MATCH: {
                Pattern safeRegExMatch;
                String rawPattern = proto.getSafeRegexMatch().getRegex();
                try {
                    safeRegExMatch = Pattern.compile((String)rawPattern);
                }
                catch (PatternSyntaxException e) {
                    return StructOrError.fromError("HeaderMatcher [" + proto.getName() + "] contains malformed safe regex pattern: " + e.getMessage());
                }
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forSafeRegEx(proto.getName(), safeRegExMatch, proto.getInvertMatch()));
            }
            case RANGE_MATCH: {
                Matchers.HeaderMatcher.Range rangeMatch = Matchers.HeaderMatcher.Range.create(proto.getRangeMatch().getStart(), proto.getRangeMatch().getEnd());
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forRange(proto.getName(), rangeMatch, proto.getInvertMatch()));
            }
            case PRESENT_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forPresent(proto.getName(), proto.getPresentMatch(), proto.getInvertMatch()));
            }
            case PREFIX_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forPrefix(proto.getName(), proto.getPrefixMatch(), proto.getInvertMatch()));
            }
            case SUFFIX_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forSuffix(proto.getName(), proto.getSuffixMatch(), proto.getInvertMatch()));
            }
        }
        return StructOrError.fromError("Unknown header matcher type");
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteAction> parseRouteAction(RouteAction proto) {
        Long timeoutNano = null;
        if (proto.hasMaxStreamDuration()) {
            RouteAction.MaxStreamDuration maxStreamDuration = proto.getMaxStreamDuration();
            if (maxStreamDuration.hasGrpcTimeoutHeaderMax()) {
                timeoutNano = Durations.toNanos((Duration)maxStreamDuration.getGrpcTimeoutHeaderMax());
            } else if (maxStreamDuration.hasMaxStreamDuration()) {
                timeoutNano = Durations.toNanos((Duration)maxStreamDuration.getMaxStreamDuration());
            }
        }
        switch (proto.getClusterSpecifierCase()) {
            case CLUSTER: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forCluster(proto.getCluster(), timeoutNano));
            }
            case CLUSTER_HEADER: {
                return null;
            }
            case WEIGHTED_CLUSTERS: {
                List<WeightedCluster.ClusterWeight> clusterWeights = proto.getWeightedClusters().getClustersList();
                if (clusterWeights.isEmpty()) {
                    return StructOrError.fromError("No cluster found in weighted cluster list");
                }
                ArrayList<VirtualHost.Route.RouteAction.ClusterWeight> weightedClusters = new ArrayList<VirtualHost.Route.RouteAction.ClusterWeight>();
                for (WeightedCluster.ClusterWeight clusterWeight : clusterWeights) {
                    StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> clusterWeightOrError = ClientXdsClient.parseClusterWeight(clusterWeight);
                    if (clusterWeightOrError.getErrorDetail() != null) {
                        return StructOrError.fromError("RouteAction contains invalid ClusterWeight: " + clusterWeightOrError.getErrorDetail());
                    }
                    weightedClusters.add(clusterWeightOrError.getStruct());
                }
                return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forWeightedClusters(weightedClusters, timeoutNano));
            }
        }
        return StructOrError.fromError("Unknown cluster specifier: " + (Object)((Object)proto.getClusterSpecifierCase()));
    }

    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> parseClusterWeight(WeightedCluster.ClusterWeight proto) {
        Any rawFaultFilterConfig;
        StructOrError<HttpFault> httpFaultOrError;
        HttpFault httpFault = null;
        Map<String, Any> filterConfigMap = proto.getTypedPerFilterConfigMap();
        if (filterConfigMap.containsKey(HTTP_FAULT_FILTER_NAME) && (httpFaultOrError = ClientXdsClient.decodeFaultFilterConfig(rawFaultFilterConfig = filterConfigMap.get(HTTP_FAULT_FILTER_NAME))) != null) {
            if (httpFaultOrError.getErrorDetail() != null) {
                return StructOrError.fromError("ClusterWeight [" + proto.getName() + "] contains invalid HttpFault filter: " + httpFaultOrError.getErrorDetail());
            }
            httpFault = httpFaultOrError.getStruct();
        }
        return StructOrError.fromStruct(VirtualHost.Route.RouteAction.ClusterWeight.create(proto.getName(), proto.getWeight().getValue(), httpFault));
    }

    @Nullable
    private static StructOrError<HttpFault> decodeFaultFilterConfig(Any rawFaultFilterConfig) {
        HTTPFault httpFaultProto;
        if (!rawFaultFilterConfig.getTypeUrl().equals("type.googleapis.com/envoy.extensions.filters.http.fault.v3.HTTPFault")) {
            return null;
        }
        try {
            httpFaultProto = (HTTPFault)rawFaultFilterConfig.unpack(HTTPFault.class);
        }
        catch (InvalidProtocolBufferException e) {
            return StructOrError.fromError("Invalid proto: " + (Object)((Object)e));
        }
        return ClientXdsClient.parseHttpFault(httpFaultProto);
    }

    private static StructOrError<HttpFault> parseHttpFault(HTTPFault httpFault) {
        HttpFault.FaultDelay faultDelay = null;
        HttpFault.FaultAbort faultAbort = null;
        if (httpFault.hasDelay()) {
            faultDelay = ClientXdsClient.parseFaultDelay(httpFault.getDelay());
        }
        if (httpFault.hasAbort()) {
            StructOrError<HttpFault.FaultAbort> faultAbortOrError = ClientXdsClient.parseFaultAbort(httpFault.getAbort());
            if (faultAbortOrError.getErrorDetail() != null) {
                return StructOrError.fromError("HttpFault contains invalid FaultAbort: " + faultAbortOrError.getErrorDetail());
            }
            faultAbort = faultAbortOrError.getStruct();
        }
        if (faultDelay == null && faultAbort == null) {
            return StructOrError.fromError("Invalid HttpFault: neither fault_delay nor fault_abort is specified");
        }
        String upstreamCluster = httpFault.getUpstreamCluster();
        ProtocolStringList downstreamNodes = httpFault.getDownstreamNodesList();
        ArrayList<Matchers.HeaderMatcher> headers = new ArrayList<Matchers.HeaderMatcher>();
        for (HeaderMatcher proto : httpFault.getHeadersList()) {
            StructOrError<Matchers.HeaderMatcher> headerMatcherOrError = ClientXdsClient.parseHeaderMatcher(proto);
            if (headerMatcherOrError.getErrorDetail() != null) {
                return StructOrError.fromError("HttpFault contains invalid header matcher: " + headerMatcherOrError.getErrorDetail());
            }
            headers.add(headerMatcherOrError.getStruct());
        }
        Integer maxActiveFaults = null;
        if (httpFault.hasMaxActiveFaults() && (maxActiveFaults = Integer.valueOf(httpFault.getMaxActiveFaults().getValue())) < 0) {
            maxActiveFaults = Integer.MAX_VALUE;
        }
        return StructOrError.fromStruct(HttpFault.create(faultDelay, faultAbort, upstreamCluster, (List<String>)downstreamNodes, headers, maxActiveFaults));
    }

    private static HttpFault.FaultDelay parseFaultDelay(FaultDelay faultDelay) {
        int rate = ClientXdsClient.getRatePerMillion(faultDelay.getPercentage());
        if (faultDelay.hasHeaderDelay()) {
            return HttpFault.FaultDelay.forHeader(rate);
        }
        return HttpFault.FaultDelay.forFixedDelay(Durations.toNanos((Duration)faultDelay.getFixedDelay()), rate);
    }

    @VisibleForTesting
    static StructOrError<HttpFault.FaultAbort> parseFaultAbort(FaultAbort faultAbort) {
        int rate = ClientXdsClient.getRatePerMillion(faultAbort.getPercentage());
        switch (faultAbort.getErrorTypeCase()) {
            case HEADER_ABORT: {
                return StructOrError.fromStruct(HttpFault.FaultAbort.forHeader(rate));
            }
            case HTTP_STATUS: {
                return StructOrError.fromStruct(HttpFault.FaultAbort.forStatus(ClientXdsClient.convertHttpStatus(faultAbort.getHttpStatus()), rate));
            }
            case GRPC_STATUS: {
                return StructOrError.fromStruct(HttpFault.FaultAbort.forStatus(Status.fromCodeValue((int)faultAbort.getGrpcStatus()), rate));
            }
        }
        return StructOrError.fromError("Unknown error type case: " + (Object)((Object)faultAbort.getErrorTypeCase()));
    }

    private static Status convertHttpStatus(int httpCode) {
        Status status;
        switch (httpCode) {
            case 400: {
                status = Status.INTERNAL;
                break;
            }
            case 401: {
                status = Status.UNAUTHENTICATED;
                break;
            }
            case 403: {
                status = Status.PERMISSION_DENIED;
                break;
            }
            case 404: {
                status = Status.UNIMPLEMENTED;
                break;
            }
            case 429: 
            case 502: 
            case 503: 
            case 504: {
                status = Status.UNAVAILABLE;
                break;
            }
            default: {
                status = Status.UNKNOWN;
            }
        }
        return status.withDescription("HTTP code: " + httpCode);
    }

    @Override
    protected void handleRdsResponse(String versionInfo, List<Any> resources, String nonce) {
        HashMap<String, RouteConfiguration> routeConfigs = new HashMap<String, RouteConfiguration>(resources.size());
        try {
            for (Any res : resources) {
                if (res.getTypeUrl().equals(AbstractXdsClient.ResourceType.RDS.typeUrlV2())) {
                    res = res.toBuilder().setTypeUrl(AbstractXdsClient.ResourceType.RDS.typeUrl()).build();
                }
                RouteConfiguration rc = (RouteConfiguration)res.unpack(RouteConfiguration.class);
                routeConfigs.put(rc.getName(), rc);
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack RouteConfiguration in RDS response {0}", new Object[]{e});
            this.nackResponse(AbstractXdsClient.ResourceType.RDS, nonce, "Malformed RDS response: " + (Object)((Object)e));
            return;
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received RDS response for resources: {0}", routeConfigs.keySet());
        HashMap<String, XdsClient.RdsUpdate> rdsUpdates = new HashMap<String, XdsClient.RdsUpdate>();
        for (Map.Entry entry : routeConfigs.entrySet()) {
            String routeConfigName = (String)entry.getKey();
            RouteConfiguration routeConfig = (RouteConfiguration)entry.getValue();
            ArrayList<io.grpc.xds.VirtualHost> virtualHosts = new ArrayList<io.grpc.xds.VirtualHost>(routeConfig.getVirtualHostsCount());
            for (VirtualHost virtualHostProto : routeConfig.getVirtualHostsList()) {
                StructOrError<io.grpc.xds.VirtualHost> virtualHost = ClientXdsClient.parseVirtualHost(virtualHostProto);
                if (virtualHost.getErrorDetail() != null) {
                    this.nackResponse(AbstractXdsClient.ResourceType.RDS, nonce, "RouteConfiguration " + routeConfigName + " contains invalid virtual host: " + virtualHost.getErrorDetail());
                    return;
                }
                virtualHosts.add(virtualHost.getStruct());
            }
            rdsUpdates.put(routeConfigName, new XdsClient.RdsUpdate(virtualHosts));
        }
        this.ackResponse(AbstractXdsClient.ResourceType.RDS, versionInfo, nonce);
        for (String resource : this.rdsResourceSubscribers.keySet()) {
            if (!rdsUpdates.containsKey(resource)) continue;
            ResourceSubscriber subscriber = this.rdsResourceSubscribers.get(resource);
            subscriber.onData((XdsClient.ResourceUpdate)rdsUpdates.get(resource));
        }
    }

    @Override
    protected void handleCdsResponse(String versionInfo, List<Any> resources, String nonce) {
        ResourceSubscriber subscriber;
        ArrayList<Cluster> clusters = new ArrayList<Cluster>(resources.size());
        ArrayList<String> clusterNames = new ArrayList<String>(resources.size());
        try {
            for (Any res : resources) {
                if (res.getTypeUrl().equals(AbstractXdsClient.ResourceType.CDS.typeUrlV2())) {
                    res = res.toBuilder().setTypeUrl(AbstractXdsClient.ResourceType.CDS.typeUrl()).build();
                }
                Cluster cluster = (Cluster)res.unpack(Cluster.class);
                clusters.add(cluster);
                clusterNames.add(cluster.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Clusters in CDS response {0}", new Object[]{e});
            this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Malformed CDS response: " + (Object)((Object)e));
            return;
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received CDS response for resources: {0}", clusterNames);
        HashMap<String, XdsClient.CdsUpdate> cdsUpdates = new HashMap<String, XdsClient.CdsUpdate>();
        HashSet<String> edsResources = new HashSet<String>();
        for (Cluster cluster : clusters) {
            String clusterName = cluster.getName();
            if (!this.cdsResourceSubscribers.containsKey(clusterName)) continue;
            if (!cluster.getLbPolicy().equals((Object)Cluster.LbPolicy.ROUND_ROBIN)) {
                this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": unsupported Lb policy: " + (Object)((Object)cluster.getLbPolicy()));
                return;
            }
            String lbPolicy = "round_robin";
            XdsClient.CdsUpdate update = null;
            switch (cluster.getClusterDiscoveryTypeCase()) {
                case TYPE: {
                    update = this.parseNonAggregateCluster(cluster, nonce, lbPolicy, edsResources);
                    break;
                }
                case CLUSTER_TYPE: {
                    update = this.parseAggregateCluster(cluster, nonce, lbPolicy);
                    break;
                }
                default: {
                    this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": cluster discovery type unspecified");
                }
            }
            if (update == null) {
                return;
            }
            cdsUpdates.put(clusterName, update);
        }
        this.ackResponse(AbstractXdsClient.ResourceType.CDS, versionInfo, nonce);
        for (String resource : this.cdsResourceSubscribers.keySet()) {
            subscriber = this.cdsResourceSubscribers.get(resource);
            if (cdsUpdates.containsKey(resource)) {
                subscriber.onData((XdsClient.ResourceUpdate)cdsUpdates.get(resource));
                continue;
            }
            subscriber.onAbsent();
        }
        for (String resource : this.edsResourceSubscribers.keySet()) {
            subscriber = this.edsResourceSubscribers.get(resource);
            if (edsResources.contains(resource)) continue;
            subscriber.onAbsent();
        }
    }

    private XdsClient.CdsUpdate parseAggregateCluster(Cluster cluster, String nonce, String lbPolicy) {
        ClusterConfig clusterConfig;
        String clusterName = cluster.getName();
        Cluster.CustomClusterType customType = cluster.getClusterType();
        String typeName = customType.getName();
        if (!typeName.equals(AGGREGATE_CLUSTER_TYPE_NAME)) {
            this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": unsupported custom cluster type: " + typeName);
            return null;
        }
        Any unpackedClusterConfig = customType.getTypedConfig();
        if (unpackedClusterConfig.getTypeUrl().equals(TYPE_URL_CLUSTER_CONFIG_V2)) {
            unpackedClusterConfig = unpackedClusterConfig.toBuilder().setTypeUrl(TYPE_URL_CLUSTER_CONFIG).build();
        }
        try {
            clusterConfig = (ClusterConfig)unpackedClusterConfig.unpack(ClusterConfig.class);
        }
        catch (InvalidProtocolBufferException e) {
            this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": invalid cluster config: " + (Object)((Object)e));
            return null;
        }
        XdsClient.CdsUpdate.AggregateClusterConfig config = new XdsClient.CdsUpdate.AggregateClusterConfig(lbPolicy, (List<String>)clusterConfig.getClustersList());
        return new XdsClient.CdsUpdate(clusterName, XdsClient.CdsUpdate.ClusterType.AGGREGATE, config);
    }

    private XdsClient.CdsUpdate parseNonAggregateCluster(Cluster cluster, String nonce, String lbPolicy, Set<String> edsResources) {
        Cluster.DiscoveryType type;
        String clusterName = cluster.getName();
        String lrsServerName = null;
        Long maxConcurrentRequests = null;
        EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = null;
        if (cluster.hasLrsServer()) {
            if (!cluster.getLrsServer().hasSelf()) {
                this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": only support LRS for the same management server");
                return null;
            }
            lrsServerName = "";
        }
        if (cluster.hasCircuitBreakers()) {
            List<CircuitBreakers.Thresholds> thresholds = cluster.getCircuitBreakers().getThresholdsList();
            for (CircuitBreakers.Thresholds threshold : thresholds) {
                if (threshold.getPriority() != RoutingPriority.DEFAULT || !threshold.hasMaxRequests()) continue;
                maxConcurrentRequests = threshold.getMaxRequests().getValue();
            }
        }
        if (cluster.hasTransportSocket() && "envoy.transport_sockets.tls".equals(cluster.getTransportSocket().getName())) {
            UpstreamTlsContext unpacked;
            Any any = cluster.getTransportSocket().getTypedConfig();
            if (any.getTypeUrl().equals(TYPE_URL_UPSTREAM_TLS_CONTEXT_V2)) {
                any = any.toBuilder().setTypeUrl(TYPE_URL_UPSTREAM_TLS_CONTEXT).build();
            }
            try {
                unpacked = (UpstreamTlsContext)any.unpack(UpstreamTlsContext.class);
            }
            catch (InvalidProtocolBufferException e) {
                this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": invalid upstream TLS context: " + (Object)((Object)e));
                return null;
            }
            upstreamTlsContext = EnvoyServerProtoData.UpstreamTlsContext.fromEnvoyProtoUpstreamTlsContext(unpacked);
        }
        if ((type = cluster.getType()) == Cluster.DiscoveryType.EDS) {
            String edsServiceName = null;
            Cluster.EdsClusterConfig edsClusterConfig = cluster.getEdsClusterConfig();
            if (!edsClusterConfig.getEdsConfig().hasAds()) {
                this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": field eds_cluster_config must be set to indicate to use EDS over ADS.");
                return null;
            }
            if (!edsClusterConfig.getServiceName().isEmpty()) {
                edsServiceName = edsClusterConfig.getServiceName();
                edsResources.add(edsServiceName);
            } else {
                edsResources.add(clusterName);
            }
            XdsClient.CdsUpdate.EdsClusterConfig config = new XdsClient.CdsUpdate.EdsClusterConfig(lbPolicy, edsServiceName, lrsServerName, maxConcurrentRequests, upstreamTlsContext);
            return new XdsClient.CdsUpdate(clusterName, XdsClient.CdsUpdate.ClusterType.EDS, config);
        }
        if (type.equals((Object)Cluster.DiscoveryType.LOGICAL_DNS)) {
            XdsClient.CdsUpdate.LogicalDnsClusterConfig config = new XdsClient.CdsUpdate.LogicalDnsClusterConfig(lbPolicy, lrsServerName, maxConcurrentRequests, upstreamTlsContext);
            return new XdsClient.CdsUpdate(clusterName, XdsClient.CdsUpdate.ClusterType.LOGICAL_DNS, config);
        }
        this.nackResponse(AbstractXdsClient.ResourceType.CDS, nonce, "Cluster " + clusterName + ": unsupported built-in discovery type: " + (Object)((Object)type));
        return null;
    }

    @Override
    protected void handleEdsResponse(String versionInfo, List<Any> resources, String nonce) {
        ArrayList<ClusterLoadAssignment> clusterLoadAssignments = new ArrayList<ClusterLoadAssignment>(resources.size());
        ArrayList<String> claNames = new ArrayList<String>(resources.size());
        try {
            for (Any res : resources) {
                if (res.getTypeUrl().equals(AbstractXdsClient.ResourceType.EDS.typeUrlV2())) {
                    res = res.toBuilder().setTypeUrl(AbstractXdsClient.ResourceType.EDS.typeUrl()).build();
                }
                ClusterLoadAssignment assignment = (ClusterLoadAssignment)res.unpack(ClusterLoadAssignment.class);
                clusterLoadAssignments.add(assignment);
                claNames.add(assignment.getClusterName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack ClusterLoadAssignments in EDS response {0}", new Object[]{e});
            this.nackResponse(AbstractXdsClient.ResourceType.EDS, nonce, "Malformed EDS response: " + (Object)((Object)e));
            return;
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received EDS response for resources: {0}", claNames);
        HashMap<String, XdsClient.EdsUpdate> edsUpdates = new HashMap<String, XdsClient.EdsUpdate>();
        for (ClusterLoadAssignment assignment : clusterLoadAssignments) {
            String clusterName = assignment.getClusterName();
            if (!this.edsResourceSubscribers.containsKey(clusterName)) continue;
            HashSet<Integer> priorities = new HashSet<Integer>();
            LinkedHashMap<io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap = new LinkedHashMap<io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints>();
            ArrayList<Endpoints.DropOverload> dropOverloads = new ArrayList<Endpoints.DropOverload>();
            int maxPriority = -1;
            for (LocalityLbEndpoints localityLbEndpointsProto : assignment.getEndpointsList()) {
                StructOrError<Endpoints.LocalityLbEndpoints> localityLbEndpoints = ClientXdsClient.parseLocalityLbEndpoints(localityLbEndpointsProto);
                if (localityLbEndpoints == null) continue;
                if (localityLbEndpoints.getErrorDetail() != null) {
                    this.nackResponse(AbstractXdsClient.ResourceType.EDS, nonce, "ClusterLoadAssignment " + clusterName + ": " + localityLbEndpoints.getErrorDetail());
                    return;
                }
                maxPriority = Math.max(maxPriority, localityLbEndpoints.getStruct().priority());
                priorities.add(localityLbEndpoints.getStruct().priority());
                localityLbEndpointsMap.put(ClientXdsClient.parseLocality(localityLbEndpointsProto.getLocality()), localityLbEndpoints.getStruct());
            }
            if (priorities.size() != maxPriority + 1) {
                this.nackResponse(AbstractXdsClient.ResourceType.EDS, nonce, "ClusterLoadAssignment " + clusterName + " : sparse priorities.");
                return;
            }
            for (ClusterLoadAssignment.Policy.DropOverload dropOverloadProto : assignment.getPolicy().getDropOverloadsList()) {
                dropOverloads.add(ClientXdsClient.parseDropOverload(dropOverloadProto));
            }
            XdsClient.EdsUpdate update = new XdsClient.EdsUpdate(clusterName, localityLbEndpointsMap, dropOverloads);
            edsUpdates.put(clusterName, update);
        }
        this.ackResponse(AbstractXdsClient.ResourceType.EDS, versionInfo, nonce);
        for (String resource : this.edsResourceSubscribers.keySet()) {
            ResourceSubscriber subscriber = this.edsResourceSubscribers.get(resource);
            if (!edsUpdates.containsKey(resource)) continue;
            subscriber.onData((XdsClient.ResourceUpdate)edsUpdates.get(resource));
        }
    }

    private static io.grpc.xds.Locality parseLocality(Locality proto) {
        return io.grpc.xds.Locality.create(proto.getRegion(), proto.getZone(), proto.getSubZone());
    }

    private static Endpoints.DropOverload parseDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
        return Endpoints.DropOverload.create(proto.getCategory(), ClientXdsClient.getRatePerMillion(proto.getDropPercentage()));
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<Endpoints.LocalityLbEndpoints> parseLocalityLbEndpoints(LocalityLbEndpoints proto) {
        if (!proto.hasLoadBalancingWeight() || proto.getLoadBalancingWeight().getValue() < 1) {
            return null;
        }
        if (proto.getPriority() < 0) {
            return StructOrError.fromError("negative priority");
        }
        ArrayList<Endpoints.LbEndpoint> endpoints = new ArrayList<Endpoints.LbEndpoint>(proto.getLbEndpointsCount());
        for (LbEndpoint endpoint : proto.getLbEndpointsList()) {
            if (!endpoint.hasEndpoint() || !endpoint.getEndpoint().hasAddress()) {
                return StructOrError.fromError("LbEndpoint with no endpoint/address");
            }
            SocketAddress socketAddress = endpoint.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            boolean isHealthy = endpoint.getHealthStatus() == HealthStatus.HEALTHY || endpoint.getHealthStatus() == HealthStatus.UNKNOWN;
            endpoints.add(Endpoints.LbEndpoint.create(new EquivalentAddressGroup((List)ImmutableList.of((Object)addr)), endpoint.getLoadBalancingWeight().getValue(), isHealthy));
        }
        return StructOrError.fromStruct(Endpoints.LocalityLbEndpoints.create(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority()));
    }

    private static int getRatePerMillion(FractionalPercent percent) {
        int numerator = percent.getNumerator();
        FractionalPercent.DenominatorType type = percent.getDenominator();
        switch (type) {
            case TEN_THOUSAND: {
                numerator *= 100;
                break;
            }
            case HUNDRED: {
                numerator *= 10000;
                break;
            }
            case MILLION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown denominator type of " + percent);
            }
        }
        if (numerator > 1000000 || numerator < 0) {
            numerator = 1000000;
        }
        return numerator;
    }

    @Override
    protected void handleStreamClosed(Status error) {
        this.cleanUpResourceTimers();
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
    }

    @Override
    protected void handleStreamRestarted() {
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
    }

    @Override
    protected void handleShutdown() {
        if (this.reportingLoad) {
            this.lrsClient.stopLoadReporting();
        }
        this.cleanUpResourceTimers();
    }

    @Override
    @Nullable
    Collection<String> getSubscribedResources(AbstractXdsClient.ResourceType type) {
        switch (type) {
            case LDS: {
                return this.ldsResourceSubscribers.isEmpty() ? null : this.ldsResourceSubscribers.keySet();
            }
            case RDS: {
                return this.rdsResourceSubscribers.isEmpty() ? null : this.rdsResourceSubscribers.keySet();
            }
            case CDS: {
                return this.cdsResourceSubscribers.isEmpty() ? null : this.cdsResourceSubscribers.keySet();
            }
            case EDS: {
                return this.edsResourceSubscribers.isEmpty() ? null : this.edsResourceSubscribers.keySet();
            }
        }
        throw new AssertionError((Object)"Unknown resource type");
    }

    @Override
    void watchLdsResource(final String resourceName, final XdsClient.LdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.ldsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe LDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.LDS, resourceName);
                    ClientXdsClient.this.ldsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.LDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelLdsResourceWatch(final String resourceName, final XdsClient.LdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.ldsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe LDS resource {0}", resourceName);
                    ClientXdsClient.this.ldsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.LDS);
                }
            }
        });
    }

    @Override
    void watchRdsResource(final String resourceName, final XdsClient.RdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.rdsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe RDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.RDS, resourceName);
                    ClientXdsClient.this.rdsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.RDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelRdsResourceWatch(final String resourceName, final XdsClient.RdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.rdsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe RDS resource {0}", resourceName);
                    ClientXdsClient.this.rdsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.RDS);
                }
            }
        });
    }

    @Override
    void watchCdsResource(final String resourceName, final XdsClient.CdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.cdsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe CDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.CDS, resourceName);
                    ClientXdsClient.this.cdsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.CDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelCdsResourceWatch(final String resourceName, final XdsClient.CdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.cdsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe CDS resource {0}", resourceName);
                    ClientXdsClient.this.cdsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.CDS);
                }
            }
        });
    }

    @Override
    void watchEdsResource(final String resourceName, final XdsClient.EdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.edsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe EDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.EDS, resourceName);
                    ClientXdsClient.this.edsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.EDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelEdsResourceWatch(final String resourceName, final XdsClient.EdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.edsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe EDS resource {0}", resourceName);
                    ClientXdsClient.this.edsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.EDS);
                }
            }
        });
    }

    @Override
    LoadStatsManager2.ClusterDropStats addClusterDropStats(String clusterName, @Nullable String edsServiceName) {
        LoadStatsManager2.ClusterDropStats dropCounter = this.loadStatsManager.getClusterDropStats(clusterName, edsServiceName);
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                if (!ClientXdsClient.this.reportingLoad) {
                    ClientXdsClient.this.lrsClient.startLoadReporting();
                    ClientXdsClient.this.reportingLoad = true;
                }
            }
        });
        return dropCounter;
    }

    @Override
    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(String clusterName, @Nullable String edsServiceName, io.grpc.xds.Locality locality) {
        LoadStatsManager2.ClusterLocalityStats loadCounter = this.loadStatsManager.getClusterLocalityStats(clusterName, edsServiceName, locality);
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                if (!ClientXdsClient.this.reportingLoad) {
                    ClientXdsClient.this.lrsClient.startLoadReporting();
                    ClientXdsClient.this.reportingLoad = true;
                }
            }
        });
        return loadCounter;
    }

    private void cleanUpResourceTimers() {
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
    }

    @VisibleForTesting
    static final class StructOrError<T> {
        private final String errorDetail;
        private final T struct;

        private static <T> StructOrError<T> fromStruct(T struct) {
            return new StructOrError<T>(struct);
        }

        private static <T> StructOrError<T> fromError(String errorDetail) {
            return new StructOrError<T>(errorDetail);
        }

        private StructOrError(T struct) {
            this.struct = Preconditions.checkNotNull(struct, (Object)"struct");
            this.errorDetail = null;
        }

        private StructOrError(String errorDetail) {
            this.struct = null;
            this.errorDetail = (String)Preconditions.checkNotNull((Object)errorDetail, (Object)"errorDetail");
        }

        @Nullable
        @VisibleForTesting
        T getStruct() {
            return this.struct;
        }

        @Nullable
        @VisibleForTesting
        String getErrorDetail() {
            return this.errorDetail;
        }
    }

    private final class ResourceSubscriber {
        private final AbstractXdsClient.ResourceType type;
        private final String resource;
        private final Set<XdsClient.ResourceWatcher> watchers = new HashSet<XdsClient.ResourceWatcher>();
        private XdsClient.ResourceUpdate data;
        private boolean absent;
        private SynchronizationContext.ScheduledHandle respTimer;

        ResourceSubscriber(AbstractXdsClient.ResourceType type, String resource) {
            this.type = type;
            this.resource = resource;
            if (ClientXdsClient.this.isInBackoff()) {
                return;
            }
            this.restartTimer();
        }

        void addWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument((!this.watchers.contains(watcher) ? 1 : 0) != 0, (String)"watcher %s already registered", (Object)watcher);
            this.watchers.add(watcher);
            if (this.data != null) {
                this.notifyWatcher(watcher, this.data);
            } else if (this.absent) {
                watcher.onResourceDoesNotExist(this.resource);
            }
        }

        void removeWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument((boolean)this.watchers.contains(watcher), (String)"watcher %s not registered", (Object)watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            if (this.data != null || this.absent) {
                return;
            }
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", new Object[]{ResourceSubscriber.this.type, ResourceSubscriber.this.resource});
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent();
                }

                public String toString() {
                    return (Object)((Object)ResourceSubscriber.this.type) + this.getClass().getSimpleName();
                }
            }
            this.respTimer = ClientXdsClient.this.getSyncContext().schedule((Runnable)new ResourceNotFound(), 15L, TimeUnit.SECONDS, ClientXdsClient.this.getTimeService());
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        void onData(XdsClient.ResourceUpdate data) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            XdsClient.ResourceUpdate oldData = this.data;
            this.data = data;
            this.absent = false;
            if (!Objects.equals(oldData, data)) {
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    this.notifyWatcher(watcher, data);
                }
            }
        }

        void onAbsent() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", new Object[]{this.type, this.resource});
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            }
        }

        void onError(Status error) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            for (XdsClient.ResourceWatcher watcher : this.watchers) {
                watcher.onError(error);
            }
        }

        private void notifyWatcher(XdsClient.ResourceWatcher watcher, XdsClient.ResourceUpdate update) {
            switch (this.type) {
                case LDS: {
                    ((XdsClient.LdsResourceWatcher)watcher).onChanged((XdsClient.LdsUpdate)update);
                    break;
                }
                case RDS: {
                    ((XdsClient.RdsResourceWatcher)watcher).onChanged((XdsClient.RdsUpdate)update);
                    break;
                }
                case CDS: {
                    ((XdsClient.CdsResourceWatcher)watcher).onChanged((XdsClient.CdsUpdate)update);
                    break;
                }
                case EDS: {
                    ((XdsClient.EdsResourceWatcher)watcher).onChanged((XdsClient.EdsUpdate)update);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"should never be here");
                }
            }
        }
    }
}

