/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.ClusterManagerLoadBalancerProvider;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsNameResolver;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class ClusterManagerLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    static final int DELAYED_CHILD_DELETION_TIME_MINUTES = 15;
    private final Map<String, ChildLbState> childLbStates = new HashMap<String, ChildLbState>();
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final XdsLogger logger;

    ClusterManagerLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cluster_manager-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        Map<String, ServiceConfigUtil.PolicySelection> newChildPolicies = config.childPolicies;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster_manager lb config: child names={0}", newChildPolicies.keySet());
        for (Map.Entry<String, ServiceConfigUtil.PolicySelection> entry : newChildPolicies.entrySet()) {
            String name = entry.getKey();
            LoadBalancerProvider childPolicyProvider = entry.getValue().getProvider();
            Object childConfig = entry.getValue().getConfig();
            if (!this.childLbStates.containsKey(name)) {
                this.childLbStates.put(name, new ChildLbState(name, childPolicyProvider));
            } else {
                this.childLbStates.get(name).reactivate(childPolicyProvider);
            }
            GracefulSwitchLoadBalancer childLb = this.childLbStates.get(name).lb;
            LoadBalancer.ResolvedAddresses childAddresses = resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(childConfig).build();
            childLb.handleResolvedAddresses(childAddresses);
        }
        for (String name : this.childLbStates.keySet()) {
            if (newChildPolicies.containsKey(name)) continue;
            this.childLbStates.get(name).deactivate();
        }
        this.updateOverallBalancingState();
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        boolean gotoTransientFailure = true;
        for (ChildLbState state : this.childLbStates.values()) {
            if (state.deactivated) continue;
            gotoTransientFailure = false;
            state.lb.handleNameResolutionError(error);
        }
        if (gotoTransientFailure) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        for (ChildLbState state : this.childLbStates.values()) {
            state.shutdown();
        }
    }

    private void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        final HashMap<String, LoadBalancer.SubchannelPicker> childPickers = new HashMap<String, LoadBalancer.SubchannelPicker>();
        for (ChildLbState childLbState : this.childLbStates.values()) {
            if (childLbState.deactivated) continue;
            childPickers.put(childLbState.name, childLbState.currentPicker);
            overallState = ClusterManagerLoadBalancer.aggregateState(overallState, childLbState.currentState);
        }
        if (overallState != null) {
            LoadBalancer.SubchannelPicker picker = new LoadBalancer.SubchannelPicker(){

                public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                    String clusterName = (String)args.getCallOptions().getOption(XdsNameResolver.CLUSTER_SELECTION_KEY);
                    LoadBalancer.SubchannelPicker delegate = (LoadBalancer.SubchannelPicker)childPickers.get(clusterName);
                    if (delegate == null) {
                        return LoadBalancer.PickResult.withError((Status)Status.UNAVAILABLE.withDescription("Unable to find cluster " + clusterName));
                    }
                    return delegate.pickSubchannel(args);
                }
            };
            this.helper.updateBalancingState(overallState, picker);
        }
    }

    @Nullable
    private static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    private final class ChildLbState {
        private final String name;
        private final GracefulSwitchLoadBalancer lb;
        private LoadBalancerProvider policyProvider;
        private ConnectivityState currentState = ConnectivityState.CONNECTING;
        private LoadBalancer.SubchannelPicker currentPicker = XdsSubchannelPickers.BUFFER_PICKER;
        private boolean deactivated;
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;

        ChildLbState(String name, LoadBalancerProvider policyProvider) {
            this.name = name;
            this.policyProvider = policyProvider;
            this.lb = new GracefulSwitchLoadBalancer((LoadBalancer.Helper)new ChildLbStateHelper());
            this.lb.switchTo((LoadBalancer.Factory)policyProvider);
        }

        void deactivate() {
            if (this.deactivated) {
                return;
            }
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ChildLbState.this.shutdown();
                    ClusterManagerLoadBalancer.this.childLbStates.remove(ChildLbState.this.name);
                }
            }
            this.deletionTimer = ClusterManagerLoadBalancer.this.syncContext.schedule((Runnable)new DeletionTask(), 15L, TimeUnit.MINUTES, ClusterManagerLoadBalancer.this.timeService);
            this.deactivated = true;
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} deactivated", this.name);
        }

        void reactivate(LoadBalancerProvider policyProvider) {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
                this.deactivated = false;
                ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} reactivated", this.name);
            }
            if (!this.policyProvider.getPolicyName().equals(policyProvider.getPolicyName())) {
                ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} switching policy from {1} to {2}", this.name, this.policyProvider.getPolicyName(), policyProvider.getPolicyName());
                this.lb.switchTo((LoadBalancer.Factory)policyProvider);
                this.policyProvider = policyProvider;
            }
        }

        void shutdown() {
            this.deactivated = true;
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
            }
            this.lb.shutdown();
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} deleted", this.name);
        }

        private final class ChildLbStateHelper
        extends ForwardingLoadBalancerHelper {
            private ChildLbStateHelper() {
            }

            public void updateBalancingState(final ConnectivityState newState, final LoadBalancer.SubchannelPicker newPicker) {
                ClusterManagerLoadBalancer.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        ChildLbState.this.currentState = newState;
                        ChildLbState.this.currentPicker = newPicker;
                        if (!ChildLbState.this.deactivated) {
                            ClusterManagerLoadBalancer.this.updateOverallBalancingState();
                        }
                    }
                });
            }

            protected LoadBalancer.Helper delegate() {
                return ClusterManagerLoadBalancer.this.helper;
            }
        }
    }
}

