/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.xds.AutoValue_VirtualHost;
import io.grpc.xds.AutoValue_VirtualHost_Route;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteAction;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteAction_ClusterWeight;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteMatch;
import io.grpc.xds.HttpFault;
import io.grpc.xds.Matchers;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
abstract class VirtualHost {
    VirtualHost() {
    }

    abstract String name();

    abstract ImmutableList<String> domains();

    abstract ImmutableList<Route> routes();

    @Nullable
    abstract HttpFault httpFault();

    public static VirtualHost create(String name, List<String> domains, List<Route> routes, @Nullable HttpFault httpFault) {
        return new AutoValue_VirtualHost(name, (ImmutableList<String>)ImmutableList.copyOf(domains), (ImmutableList<Route>)ImmutableList.copyOf(routes), httpFault);
    }

    @AutoValue
    static abstract class Route {
        Route() {
        }

        abstract RouteMatch routeMatch();

        abstract RouteAction routeAction();

        @Nullable
        abstract HttpFault httpFault();

        static Route create(RouteMatch routeMatch, RouteAction routeAction, @Nullable HttpFault httpFault) {
            return new AutoValue_VirtualHost_Route(routeMatch, routeAction, httpFault);
        }

        @AutoValue
        static abstract class RouteAction {
            RouteAction() {
            }

            @Nullable
            abstract Long timeoutNano();

            @Nullable
            abstract String cluster();

            @Nullable
            abstract ImmutableList<ClusterWeight> weightedClusters();

            static RouteAction forCluster(String cluster, @Nullable Long timeoutNano) {
                Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
                return RouteAction.create(timeoutNano, cluster, null);
            }

            static RouteAction forWeightedClusters(List<ClusterWeight> weightedClusters, @Nullable Long timeoutNano) {
                Preconditions.checkNotNull(weightedClusters, (Object)"weightedClusters");
                Preconditions.checkArgument((!weightedClusters.isEmpty() ? 1 : 0) != 0, (Object)"empty cluster list");
                return RouteAction.create(timeoutNano, null, weightedClusters);
            }

            private static RouteAction create(@Nullable Long timeoutNano, @Nullable String cluster, @Nullable List<ClusterWeight> weightedClusters) {
                return new AutoValue_VirtualHost_Route_RouteAction(timeoutNano, cluster, (ImmutableList<ClusterWeight>)(weightedClusters == null ? null : ImmutableList.copyOf(weightedClusters)));
            }

            @AutoValue
            static abstract class ClusterWeight {
                ClusterWeight() {
                }

                abstract String name();

                abstract int weight();

                @Nullable
                abstract HttpFault httpFault();

                static ClusterWeight create(String name, int weight, @Nullable HttpFault httpFault) {
                    return new AutoValue_VirtualHost_Route_RouteAction_ClusterWeight(name, weight, httpFault);
                }
            }
        }

        @AutoValue
        static abstract class RouteMatch {
            RouteMatch() {
            }

            abstract Matchers.PathMatcher pathMatcher();

            abstract ImmutableList<Matchers.HeaderMatcher> headerMatchers();

            @Nullable
            abstract Matchers.FractionMatcher fractionMatcher();

            @VisibleForTesting
            static RouteMatch withPathExactOnly(String path) {
                return RouteMatch.create(Matchers.PathMatcher.fromPath(path, true), Collections.emptyList(), null);
            }

            static RouteMatch create(Matchers.PathMatcher pathMatcher, List<Matchers.HeaderMatcher> headerMatchers, @Nullable Matchers.FractionMatcher fractionMatcher) {
                return new AutoValue_VirtualHost_Route_RouteMatch(pathMatcher, (ImmutableList<Matchers.HeaderMatcher>)ImmutableList.copyOf(headerMatchers), fractionMatcher);
            }
        }
    }
}

