/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingServerBuilder;
import io.grpc.Internal;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.Status;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.xds.XdsClientWrapperForServerSds;
import io.grpc.xds.internal.sds.SdsProtocolNegotiators;
import io.grpc.xds.internal.sds.ServerWrapperForXds;
import java.util.concurrent.atomic.AtomicBoolean;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7514")
public final class XdsServerBuilder
extends ForwardingServerBuilder<XdsServerBuilder> {
    private final NettyServerBuilder delegate;
    private final int port;
    private ErrorNotifier errorNotifier;
    private AtomicBoolean isServerBuilt = new AtomicBoolean(false);

    private XdsServerBuilder(NettyServerBuilder nettyDelegate, int port) {
        this.delegate = nettyDelegate;
        this.port = port;
    }

    @Internal
    protected ServerBuilder<?> delegate() {
        return this.delegate;
    }

    public XdsServerBuilder errorNotifier(ErrorNotifier errorNotifier) {
        this.errorNotifier = errorNotifier;
        return this;
    }

    public static ServerBuilder<?> forPort(int port) {
        throw new UnsupportedOperationException("Unsupported call - use forPort(int, ServerCredentials)");
    }

    public static XdsServerBuilder forPort(int port, ServerCredentials serverCredentials) {
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forPort((int)port, (ServerCredentials)serverCredentials);
        return new XdsServerBuilder(nettyDelegate, port);
    }

    public Server build() {
        return this.buildServer(new XdsClientWrapperForServerSds(this.port));
    }

    @VisibleForTesting
    ServerWrapperForXds buildServer(XdsClientWrapperForServerSds xdsClient) {
        Preconditions.checkState((boolean)this.isServerBuilt.compareAndSet(false, true), (Object)"Server already built!");
        InternalNettyServerBuilder.eagAttributes((NettyServerBuilder)this.delegate, (Attributes)Attributes.newBuilder().set(SdsProtocolNegotiators.SERVER_XDS_CLIENT, (Object)xdsClient).build());
        return new ServerWrapperForXds(this.delegate.build(), xdsClient, this.errorNotifier);
    }

    public ServerBuilder<?> transportBuilder() {
        return this.delegate;
    }

    public static interface ErrorNotifier {
        public void onError(Status var1);
    }
}

