/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.internal.certprovider.CertificateProvider;
import io.grpc.xds.internal.sds.trust.CertificateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DynamicReloadingCertificateProvider
extends CertificateProvider {
    private static final Logger logger = Logger.getLogger(DynamicReloadingCertificateProvider.class.getName());
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService scheduledExecutorService;
    private final TimeProvider timeProvider;
    private final Path directory;
    private final String certFile;
    private final String privateKeyFile;
    private final String trustFile;
    private final long refreshIntervalInSeconds;
    @VisibleForTesting
    SynchronizationContext.ScheduledHandle scheduledHandle;
    private Path lastModifiedTarget;

    DynamicReloadingCertificateProvider(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String directory, String certFile, String privateKeyFile, String trustFile, long refreshIntervalInSeconds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider) {
        super(watcher, notifyCertUpdates);
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService");
        this.timeProvider = (TimeProvider)Preconditions.checkNotNull((Object)timeProvider, (Object)"timeProvider");
        this.directory = Paths.get((String)Preconditions.checkNotNull((Object)directory, (Object)"diretory"), new String[0]);
        this.certFile = (String)Preconditions.checkNotNull((Object)certFile, (Object)"certFile");
        this.privateKeyFile = (String)Preconditions.checkNotNull((Object)privateKeyFile, (Object)"privateKeyFile");
        this.trustFile = (String)Preconditions.checkNotNull((Object)trustFile, (Object)"trustFile");
        this.refreshIntervalInSeconds = refreshIntervalInSeconds;
        this.syncContext = this.createSynchronizationContext(directory);
    }

    private SynchronizationContext createSynchronizationContext(String details) {
        final InternalLogId logId = InternalLogId.allocate((String)"DynamicReloadingCertificateProvider", (String)details);
        return new SynchronizationContext(new Thread.UncaughtExceptionHandler(){
            private boolean panicMode;

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "[" + logId + "] Uncaught exception in the SynchronizationContext. Panic!", e);
                this.panic(e);
            }

            void panic(Throwable t) {
                if (this.panicMode) {
                    return;
                }
                this.panicMode = true;
                DynamicReloadingCertificateProvider.this.close();
            }
        });
    }

    @Override
    public void start() {
        this.scheduleNextRefreshCertificate(0L);
    }

    @Override
    public void close() {
        if (this.scheduledHandle != null) {
            this.scheduledHandle.cancel();
            this.scheduledHandle = null;
        }
        this.getWatcher().close();
    }

    private void scheduleNextRefreshCertificate(long delayInSeconds) {
        RefreshCertificateTask runnable = new RefreshCertificateTask();
        this.scheduledHandle = this.syncContext.schedule((Runnable)runnable, delayInSeconds, TimeUnit.SECONDS, this.scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void checkAndReloadCertificates() {
        try {
            Path targetPath = Files.readSymbolicLink(this.directory);
            if (targetPath.equals(this.lastModifiedTarget)) {
                return;
            }
            try (FileInputStream privateKeyStream = new FileInputStream(new File(targetPath.toFile(), this.privateKeyFile));
                 FileInputStream certsStream = new FileInputStream(new File(targetPath.toFile(), this.certFile));
                 FileInputStream caCertsStream = new FileInputStream(new File(targetPath.toFile(), this.trustFile));){
                PrivateKey privateKey = CertificateUtils.getPrivateKey(privateKeyStream);
                X509Certificate[] certs = CertificateUtils.toX509Certificates(certsStream);
                X509Certificate[] caCerts = CertificateUtils.toX509Certificates(caCertsStream);
                this.getWatcher().updateCertificate(privateKey, Arrays.asList(certs));
                this.getWatcher().updateTrustedRoots(Arrays.asList(caCerts));
            }
            this.lastModifiedTarget = targetPath;
        }
        catch (Throwable t) {
            this.generateErrorIfCurrentCertExpired(t);
        }
        finally {
            this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
        }
    }

    private void generateErrorIfCurrentCertExpired(Throwable t) {
        X509Certificate currentCert = this.getWatcher().getLastIdentityCert();
        if (currentCert != null) {
            long delaySeconds = this.computeDelaySecondsToCertExpiry(currentCert);
            if (delaySeconds > this.refreshIntervalInSeconds) {
                logger.log(Level.FINER, "reload certificate error", t);
                return;
            }
            this.getWatcher().clearValues();
        }
        this.getWatcher().onError(Status.fromThrowable((Throwable)t));
    }

    private long computeDelaySecondsToCertExpiry(X509Certificate lastCert) {
        Preconditions.checkNotNull((Object)lastCert, (Object)"lastCert");
        return TimeUnit.NANOSECONDS.toSeconds(TimeUnit.MILLISECONDS.toNanos(lastCert.getNotAfter().getTime()) - this.timeProvider.currentTimeNanos());
    }

    static abstract class Factory {
        private static final Factory DEFAULT_INSTANCE = new Factory(){

            @Override
            DynamicReloadingCertificateProvider create(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String directory, String certFile, String privateKeyFile, String trustFile, long refreshIntervalInSeconds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider) {
                return new DynamicReloadingCertificateProvider(watcher, notifyCertUpdates, directory, certFile, privateKeyFile, trustFile, refreshIntervalInSeconds, scheduledExecutorService, timeProvider);
            }
        };

        Factory() {
        }

        static Factory getInstance() {
            return DEFAULT_INSTANCE;
        }

        abstract DynamicReloadingCertificateProvider create(CertificateProvider.DistributorWatcher var1, boolean var2, String var3, String var4, String var5, String var6, long var7, ScheduledExecutorService var9, TimeProvider var10);
    }

    @VisibleForTesting
    class RefreshCertificateTask
    implements Runnable {
        RefreshCertificateTask() {
        }

        @Override
        public void run() {
            DynamicReloadingCertificateProvider.this.checkAndReloadCertificates();
        }
    }
}

