/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.re2j.Pattern;
import io.grpc.xds.AutoValue_VirtualHost;
import io.grpc.xds.AutoValue_VirtualHost_Route;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteAction;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteAction_ClusterWeight;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteAction_HashPolicy;
import io.grpc.xds.AutoValue_VirtualHost_Route_RouteMatch;
import io.grpc.xds.Filter;
import io.grpc.xds.Matchers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
abstract class VirtualHost {
    VirtualHost() {
    }

    abstract String name();

    abstract ImmutableList<String> domains();

    abstract ImmutableList<Route> routes();

    abstract ImmutableMap<String, Filter.FilterConfig> filterConfigOverrides();

    public static VirtualHost create(String name, List<String> domains, List<Route> routes, Map<String, Filter.FilterConfig> filterConfigOverrides) {
        return new AutoValue_VirtualHost(name, (ImmutableList<String>)ImmutableList.copyOf(domains), (ImmutableList<Route>)ImmutableList.copyOf(routes), (ImmutableMap<String, Filter.FilterConfig>)ImmutableMap.copyOf(filterConfigOverrides));
    }

    @AutoValue
    static abstract class Route {
        Route() {
        }

        abstract RouteMatch routeMatch();

        abstract RouteAction routeAction();

        abstract ImmutableMap<String, Filter.FilterConfig> filterConfigOverrides();

        static Route create(RouteMatch routeMatch, RouteAction routeAction, Map<String, Filter.FilterConfig> filterConfigOverrides) {
            return new AutoValue_VirtualHost_Route(routeMatch, routeAction, (ImmutableMap<String, Filter.FilterConfig>)ImmutableMap.copyOf(filterConfigOverrides));
        }

        @AutoValue
        static abstract class RouteAction {
            RouteAction() {
            }

            abstract ImmutableList<HashPolicy> hashPolicies();

            @Nullable
            abstract Long timeoutNano();

            @Nullable
            abstract String cluster();

            @Nullable
            abstract ImmutableList<ClusterWeight> weightedClusters();

            static RouteAction forCluster(String cluster, List<HashPolicy> hashPolicies, @Nullable Long timeoutNano) {
                Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
                return RouteAction.create(hashPolicies, timeoutNano, cluster, null);
            }

            static RouteAction forWeightedClusters(List<ClusterWeight> weightedClusters, List<HashPolicy> hashPolicies, @Nullable Long timeoutNano) {
                Preconditions.checkNotNull(weightedClusters, (Object)"weightedClusters");
                Preconditions.checkArgument((!weightedClusters.isEmpty() ? 1 : 0) != 0, (Object)"empty cluster list");
                return RouteAction.create(hashPolicies, timeoutNano, null, weightedClusters);
            }

            private static RouteAction create(List<HashPolicy> hashPolicies, @Nullable Long timeoutNano, @Nullable String cluster, @Nullable List<ClusterWeight> weightedClusters) {
                return new AutoValue_VirtualHost_Route_RouteAction((ImmutableList<HashPolicy>)ImmutableList.copyOf(hashPolicies), timeoutNano, cluster, (ImmutableList<ClusterWeight>)(weightedClusters == null ? null : ImmutableList.copyOf(weightedClusters)));
            }

            @AutoValue
            static abstract class HashPolicy {
                HashPolicy() {
                }

                abstract Type type();

                abstract boolean isTerminal();

                @Nullable
                abstract String headerName();

                @Nullable
                abstract Pattern regEx();

                @Nullable
                abstract String regExSubstitution();

                static HashPolicy forHeader(boolean isTerminal, String headerName, @Nullable Pattern regEx, @Nullable String regExSubstitution) {
                    Preconditions.checkNotNull((Object)headerName, (Object)"headerName");
                    return HashPolicy.create(Type.HEADER, isTerminal, headerName, regEx, regExSubstitution);
                }

                static HashPolicy forChannelId(boolean isTerminal) {
                    return HashPolicy.create(Type.CHANNEL_ID, isTerminal, null, null, null);
                }

                private static HashPolicy create(Type type, boolean isTerminal, @Nullable String headerName, @Nullable Pattern regEx, @Nullable String regExSubstitution) {
                    return new AutoValue_VirtualHost_Route_RouteAction_HashPolicy(type, isTerminal, headerName, regEx, regExSubstitution);
                }

                static enum Type {
                    HEADER,
                    CHANNEL_ID;

                }
            }

            @AutoValue
            static abstract class ClusterWeight {
                ClusterWeight() {
                }

                abstract String name();

                abstract int weight();

                abstract ImmutableMap<String, Filter.FilterConfig> filterConfigOverrides();

                static ClusterWeight create(String name, int weight, Map<String, Filter.FilterConfig> filterConfigOverrides) {
                    return new AutoValue_VirtualHost_Route_RouteAction_ClusterWeight(name, weight, (ImmutableMap<String, Filter.FilterConfig>)ImmutableMap.copyOf(filterConfigOverrides));
                }
            }
        }

        @AutoValue
        static abstract class RouteMatch {
            RouteMatch() {
            }

            abstract Matchers.PathMatcher pathMatcher();

            abstract ImmutableList<Matchers.HeaderMatcher> headerMatchers();

            @Nullable
            abstract Matchers.FractionMatcher fractionMatcher();

            @VisibleForTesting
            static RouteMatch withPathExactOnly(String path) {
                return RouteMatch.create(Matchers.PathMatcher.fromPath(path, true), Collections.emptyList(), null);
            }

            static RouteMatch create(Matchers.PathMatcher pathMatcher, List<Matchers.HeaderMatcher> headerMatchers, @Nullable Matchers.FractionMatcher fractionMatcher) {
                return new AutoValue_VirtualHost_Route_RouteMatch(pathMatcher, (ImmutableList<Matchers.HeaderMatcher>)ImmutableList.copyOf(headerMatchers), fractionMatcher);
            }
        }
    }
}

