/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.util.Timestamps;
import io.grpc.ExperimentalApi;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.internal.ObjectPool;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.AbstractXdsClient;
import io.grpc.xds.SharedXdsClientPoolProvider;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.ClientResourceStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.ClustersConfigDump;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.EndpointsConfigDump;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.ListenersConfigDump;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.RoutesConfigDump;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.UpdateFailureState;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusResponse;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.PerXdsConfig;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8016")
public final class CsdsService
extends ClientStatusDiscoveryServiceGrpc.ClientStatusDiscoveryServiceImplBase {
    private static final Logger logger = Logger.getLogger(CsdsService.class.getName());
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;

    @VisibleForTesting
    CsdsService(XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory) {
        this.xdsClientPoolFactory = (XdsNameResolverProvider.XdsClientPoolFactory)Preconditions.checkNotNull((Object)xdsClientPoolFactory, (Object)"xdsClientPoolProvider");
    }

    private CsdsService() {
        this(SharedXdsClientPoolProvider.getDefaultProvider());
    }

    public static CsdsService newInstance() {
        return new CsdsService();
    }

    @Override
    public void fetchClientStatus(ClientStatusRequest request, StreamObserver<ClientStatusResponse> responseObserver) {
        if (this.handleRequest(request, responseObserver)) {
            responseObserver.onCompleted();
        }
    }

    @Override
    public StreamObserver<ClientStatusRequest> streamClientStatus(final StreamObserver<ClientStatusResponse> responseObserver) {
        return new StreamObserver<ClientStatusRequest>(){

            public void onNext(ClientStatusRequest request) {
                CsdsService.this.handleRequest(request, (StreamObserver<ClientStatusResponse>)responseObserver);
            }

            public void onError(Throwable t) {
                this.onCompleted();
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private boolean handleRequest(ClientStatusRequest request, StreamObserver<ClientStatusResponse> responseObserver) {
        try {
            responseObserver.onNext((Object)this.getConfigDumpForRequest(request));
            return true;
        }
        catch (StatusException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unexpected error while building CSDS config dump", e);
            responseObserver.onError((Throwable)new StatusException(Status.INTERNAL.withDescription("Unexpected internal error").withCause((Throwable)e)));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientStatusResponse getConfigDumpForRequest(ClientStatusRequest request) throws StatusException {
        if (request.getNodeMatchersCount() > 0) {
            throw new StatusException(Status.INVALID_ARGUMENT.withDescription("node_matchers not supported"));
        }
        ObjectPool<XdsClient> xdsClientPool = this.xdsClientPoolFactory.get();
        if (xdsClientPool == null) {
            return ClientStatusResponse.getDefaultInstance();
        }
        XdsClient xdsClient = null;
        try {
            xdsClient = (XdsClient)xdsClientPool.getObject();
            ClientStatusResponse clientStatusResponse = ClientStatusResponse.newBuilder().addConfig(CsdsService.getClientConfigForXdsClient(xdsClient)).build();
            return clientStatusResponse;
        }
        finally {
            if (xdsClient != null) {
                xdsClientPool.returnObject((Object)xdsClient);
            }
        }
    }

    @VisibleForTesting
    static ClientConfig getClientConfigForXdsClient(XdsClient xdsClient) {
        ListenersConfigDump ldsConfig = CsdsService.dumpLdsConfig(xdsClient.getSubscribedResourcesMetadata(AbstractXdsClient.ResourceType.LDS), xdsClient.getCurrentVersion(AbstractXdsClient.ResourceType.LDS));
        RoutesConfigDump rdsConfig = CsdsService.dumpRdsConfig(xdsClient.getSubscribedResourcesMetadata(AbstractXdsClient.ResourceType.RDS));
        ClustersConfigDump cdsConfig = CsdsService.dumpCdsConfig(xdsClient.getSubscribedResourcesMetadata(AbstractXdsClient.ResourceType.CDS), xdsClient.getCurrentVersion(AbstractXdsClient.ResourceType.CDS));
        EndpointsConfigDump edsConfig = CsdsService.dumpEdsConfig(xdsClient.getSubscribedResourcesMetadata(AbstractXdsClient.ResourceType.EDS));
        return ClientConfig.newBuilder().setNode(xdsClient.getNode().toEnvoyProtoNode()).addXdsConfig(PerXdsConfig.newBuilder().setListenerConfig(ldsConfig)).addXdsConfig(PerXdsConfig.newBuilder().setRouteConfig(rdsConfig)).addXdsConfig(PerXdsConfig.newBuilder().setClusterConfig(cdsConfig)).addXdsConfig(PerXdsConfig.newBuilder().setEndpointConfig(edsConfig)).build();
    }

    @VisibleForTesting
    static ListenersConfigDump dumpLdsConfig(Map<String, XdsClient.ResourceMetadata> resourcesMetadata, String version) {
        ListenersConfigDump.Builder ldsConfig = ListenersConfigDump.newBuilder();
        for (Map.Entry<String, XdsClient.ResourceMetadata> entry : resourcesMetadata.entrySet()) {
            ldsConfig.addDynamicListeners(CsdsService.buildDynamicListener(entry.getKey(), entry.getValue()));
        }
        return ldsConfig.setVersionInfo(version).build();
    }

    @VisibleForTesting
    static ListenersConfigDump.DynamicListener buildDynamicListener(String name, XdsClient.ResourceMetadata metadata) {
        ListenersConfigDump.DynamicListener.Builder dynamicListener = ListenersConfigDump.DynamicListener.newBuilder().setName(name).setClientStatus(CsdsService.metadataStatusToClientStatus(metadata.getStatus()));
        if (metadata.getErrorState() != null) {
            dynamicListener.setErrorState(CsdsService.metadataUpdateFailureStateToProto(metadata.getErrorState()));
        }
        ListenersConfigDump.DynamicListenerState.Builder dynamicListenerState = ListenersConfigDump.DynamicListenerState.newBuilder().setVersionInfo(metadata.getVersion()).setLastUpdated(Timestamps.fromNanos((long)metadata.getUpdateTimeNanos()));
        if (metadata.getRawResource() != null) {
            dynamicListenerState.setListener(metadata.getRawResource());
        }
        return dynamicListener.setActiveState(dynamicListenerState).build();
    }

    @VisibleForTesting
    static RoutesConfigDump dumpRdsConfig(Map<String, XdsClient.ResourceMetadata> resourcesMetadata) {
        RoutesConfigDump.Builder rdsConfig = RoutesConfigDump.newBuilder();
        for (XdsClient.ResourceMetadata metadata : resourcesMetadata.values()) {
            rdsConfig.addDynamicRouteConfigs(CsdsService.buildDynamicRouteConfig(metadata));
        }
        return rdsConfig.build();
    }

    @VisibleForTesting
    static RoutesConfigDump.DynamicRouteConfig buildDynamicRouteConfig(XdsClient.ResourceMetadata metadata) {
        RoutesConfigDump.DynamicRouteConfig.Builder dynamicRouteConfig = RoutesConfigDump.DynamicRouteConfig.newBuilder().setVersionInfo(metadata.getVersion()).setClientStatus(CsdsService.metadataStatusToClientStatus(metadata.getStatus())).setLastUpdated(Timestamps.fromNanos((long)metadata.getUpdateTimeNanos()));
        if (metadata.getErrorState() != null) {
            dynamicRouteConfig.setErrorState(CsdsService.metadataUpdateFailureStateToProto(metadata.getErrorState()));
        }
        if (metadata.getRawResource() != null) {
            dynamicRouteConfig.setRouteConfig(metadata.getRawResource());
        }
        return dynamicRouteConfig.build();
    }

    @VisibleForTesting
    static ClustersConfigDump dumpCdsConfig(Map<String, XdsClient.ResourceMetadata> resourcesMetadata, String version) {
        ClustersConfigDump.Builder cdsConfig = ClustersConfigDump.newBuilder();
        for (XdsClient.ResourceMetadata metadata : resourcesMetadata.values()) {
            cdsConfig.addDynamicActiveClusters(CsdsService.buildDynamicCluster(metadata));
        }
        return cdsConfig.setVersionInfo(version).build();
    }

    @VisibleForTesting
    static ClustersConfigDump.DynamicCluster buildDynamicCluster(XdsClient.ResourceMetadata metadata) {
        ClustersConfigDump.DynamicCluster.Builder dynamicCluster = ClustersConfigDump.DynamicCluster.newBuilder().setVersionInfo(metadata.getVersion()).setClientStatus(CsdsService.metadataStatusToClientStatus(metadata.getStatus())).setLastUpdated(Timestamps.fromNanos((long)metadata.getUpdateTimeNanos()));
        if (metadata.getErrorState() != null) {
            dynamicCluster.setErrorState(CsdsService.metadataUpdateFailureStateToProto(metadata.getErrorState()));
        }
        if (metadata.getRawResource() != null) {
            dynamicCluster.setCluster(metadata.getRawResource());
        }
        return dynamicCluster.build();
    }

    @VisibleForTesting
    static EndpointsConfigDump dumpEdsConfig(Map<String, XdsClient.ResourceMetadata> resourcesMetadata) {
        EndpointsConfigDump.Builder edsConfig = EndpointsConfigDump.newBuilder();
        for (XdsClient.ResourceMetadata metadata : resourcesMetadata.values()) {
            edsConfig.addDynamicEndpointConfigs(CsdsService.buildDynamicEndpointConfig(metadata));
        }
        return edsConfig.build();
    }

    @VisibleForTesting
    static EndpointsConfigDump.DynamicEndpointConfig buildDynamicEndpointConfig(XdsClient.ResourceMetadata metadata) {
        EndpointsConfigDump.DynamicEndpointConfig.Builder dynamicRouteConfig = EndpointsConfigDump.DynamicEndpointConfig.newBuilder().setVersionInfo(metadata.getVersion()).setClientStatus(CsdsService.metadataStatusToClientStatus(metadata.getStatus())).setLastUpdated(Timestamps.fromNanos((long)metadata.getUpdateTimeNanos()));
        if (metadata.getErrorState() != null) {
            dynamicRouteConfig.setErrorState(CsdsService.metadataUpdateFailureStateToProto(metadata.getErrorState()));
        }
        if (metadata.getRawResource() != null) {
            dynamicRouteConfig.setEndpointConfig(metadata.getRawResource());
        }
        return dynamicRouteConfig.build();
    }

    @VisibleForTesting
    static ClientResourceStatus metadataStatusToClientStatus(XdsClient.ResourceMetadata.ResourceMetadataStatus status) {
        switch (status) {
            case UNKNOWN: {
                return ClientResourceStatus.UNKNOWN;
            }
            case DOES_NOT_EXIST: {
                return ClientResourceStatus.DOES_NOT_EXIST;
            }
            case REQUESTED: {
                return ClientResourceStatus.REQUESTED;
            }
            case ACKED: {
                return ClientResourceStatus.ACKED;
            }
            case NACKED: {
                return ClientResourceStatus.NACKED;
            }
        }
        throw new AssertionError((Object)("Unexpected ResourceMetadataStatus: " + (Object)((Object)status)));
    }

    private static UpdateFailureState metadataUpdateFailureStateToProto(XdsClient.ResourceMetadata.UpdateFailureState errorState) {
        return UpdateFailureState.newBuilder().setLastUpdateAttempt(Timestamps.fromNanos((long)errorState.getFailedUpdateTimeNanos())).setDetails(errorState.getFailedDetails()).setVersionInfo(errorState.getFailedVersion()).build();
    }
}

