/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.DelayedClientCall;
import io.grpc.internal.GrpcUtil;
import io.grpc.xds.FaultConfig;
import io.grpc.xds.Filter;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.common.fault.v3.FaultDelay;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.fault.v3.FaultAbort;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.fault.v3.HTTPFault;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

final class FaultFilter
implements Filter,
Filter.ClientInterceptorBuilder {
    static final FaultFilter INSTANCE = new FaultFilter(ThreadSafeRandom.ThreadSafeRandomImpl.instance, new AtomicLong());
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_DELAY_KEY = Metadata.Key.of((String)"x-envoy-fault-delay-request", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_DELAY_PERCENTAGE_KEY = Metadata.Key.of((String)"x-envoy-fault-delay-request-percentage", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_ABORT_HTTP_STATUS_KEY = Metadata.Key.of((String)"x-envoy-fault-abort-request", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_ABORT_GRPC_STATUS_KEY = Metadata.Key.of((String)"x-envoy-fault-abort-grpc-request", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_ABORT_PERCENTAGE_KEY = Metadata.Key.of((String)"x-envoy-fault-abort-request-percentage", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    static final String TYPE_URL = "type.googleapis.com/envoy.extensions.filters.http.fault.v3.HTTPFault";
    private final ThreadSafeRandom random;
    private final AtomicLong activeFaultCounter;

    @VisibleForTesting
    FaultFilter(ThreadSafeRandom random, AtomicLong activeFaultCounter) {
        this.random = random;
        this.activeFaultCounter = activeFaultCounter;
    }

    @Override
    public String[] typeUrls() {
        return new String[]{TYPE_URL};
    }

    public Filter.ConfigOrError<FaultConfig> parseFilterConfig(Message rawProtoMessage) {
        HTTPFault httpFaultProto;
        if (!(rawProtoMessage instanceof Any)) {
            return Filter.ConfigOrError.fromError("Invalid config type: " + rawProtoMessage.getClass());
        }
        Any anyMessage = (Any)rawProtoMessage;
        try {
            httpFaultProto = (HTTPFault)anyMessage.unpack(HTTPFault.class);
        }
        catch (InvalidProtocolBufferException e) {
            return Filter.ConfigOrError.fromError("Invalid proto: " + (Object)((Object)e));
        }
        return FaultFilter.parseHttpFault(httpFaultProto);
    }

    private static Filter.ConfigOrError<FaultConfig> parseHttpFault(HTTPFault httpFault) {
        FaultConfig.FaultDelay faultDelay = null;
        FaultConfig.FaultAbort faultAbort = null;
        if (httpFault.hasDelay()) {
            faultDelay = FaultFilter.parseFaultDelay(httpFault.getDelay());
        }
        if (httpFault.hasAbort()) {
            Filter.ConfigOrError<FaultConfig.FaultAbort> faultAbortOrError = FaultFilter.parseFaultAbort(httpFault.getAbort());
            if (faultAbortOrError.errorDetail != null) {
                return Filter.ConfigOrError.fromError("HttpFault contains invalid FaultAbort: " + faultAbortOrError.errorDetail);
            }
            faultAbort = (FaultConfig.FaultAbort)faultAbortOrError.config;
        }
        Integer maxActiveFaults = null;
        if (httpFault.hasMaxActiveFaults() && (maxActiveFaults = Integer.valueOf(httpFault.getMaxActiveFaults().getValue())) < 0) {
            maxActiveFaults = Integer.MAX_VALUE;
        }
        return Filter.ConfigOrError.fromConfig(FaultConfig.create(faultDelay, faultAbort, maxActiveFaults));
    }

    private static FaultConfig.FaultDelay parseFaultDelay(FaultDelay faultDelay) {
        FaultConfig.FractionalPercent percent = FaultFilter.parsePercent(faultDelay.getPercentage());
        if (faultDelay.hasHeaderDelay()) {
            return FaultConfig.FaultDelay.forHeader(percent);
        }
        return FaultConfig.FaultDelay.forFixedDelay(Durations.toNanos((Duration)faultDelay.getFixedDelay()), percent);
    }

    @VisibleForTesting
    static Filter.ConfigOrError<FaultConfig.FaultAbort> parseFaultAbort(FaultAbort faultAbort) {
        FaultConfig.FractionalPercent percent = FaultFilter.parsePercent(faultAbort.getPercentage());
        switch (faultAbort.getErrorTypeCase()) {
            case HEADER_ABORT: {
                return Filter.ConfigOrError.fromConfig(FaultConfig.FaultAbort.forHeader(percent));
            }
            case HTTP_STATUS: {
                return Filter.ConfigOrError.fromConfig(FaultConfig.FaultAbort.forStatus(GrpcUtil.httpStatusToGrpcStatus((int)faultAbort.getHttpStatus()), percent));
            }
            case GRPC_STATUS: {
                return Filter.ConfigOrError.fromConfig(FaultConfig.FaultAbort.forStatus(Status.fromCodeValue((int)faultAbort.getGrpcStatus()), percent));
            }
        }
        return Filter.ConfigOrError.fromError("Unknown error type case: " + (Object)((Object)faultAbort.getErrorTypeCase()));
    }

    private static FaultConfig.FractionalPercent parsePercent(FractionalPercent proto) {
        switch (proto.getDenominator()) {
            case HUNDRED: {
                return FaultConfig.FractionalPercent.perHundred(proto.getNumerator());
            }
            case TEN_THOUSAND: {
                return FaultConfig.FractionalPercent.perTenThousand(proto.getNumerator());
            }
            case MILLION: {
                return FaultConfig.FractionalPercent.perMillion(proto.getNumerator());
            }
        }
        throw new IllegalArgumentException("Unknown denominator type: " + (Object)((Object)proto.getDenominator()));
    }

    public Filter.ConfigOrError<FaultConfig> parseFilterConfigOverride(Message rawProtoMessage) {
        return this.parseFilterConfig(rawProtoMessage);
    }

    @Override
    @Nullable
    public ClientInterceptor buildClientInterceptor(Filter.FilterConfig config, @Nullable Filter.FilterConfig overrideConfig, LoadBalancer.PickSubchannelArgs args, final ScheduledExecutorService scheduler) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        if (overrideConfig != null) {
            config = overrideConfig;
        }
        FaultConfig faultConfig = (FaultConfig)config;
        Long delayNanos = null;
        Status abortStatus = null;
        if (faultConfig.maxActiveFaults() == null || this.activeFaultCounter.get() < (long)faultConfig.maxActiveFaults().intValue()) {
            Metadata headers = args.getHeaders();
            if (faultConfig.faultDelay() != null) {
                delayNanos = this.determineFaultDelayNanos(faultConfig.faultDelay(), headers);
            }
            if (faultConfig.faultAbort() != null) {
                abortStatus = this.determineFaultAbortStatus(faultConfig.faultAbort(), headers);
            }
        }
        if (delayNanos == null && abortStatus == null) {
            return null;
        }
        final Long finalDelayNanos = delayNanos;
        final Status finalAbortStatus = abortStatus;
        final class FaultInjectionInterceptor
        implements ClientInterceptor {
            FaultInjectionInterceptor() {
            }

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, final Channel next) {
                Executor callExecutor = callOptions.getExecutor();
                if (callExecutor == null) {
                    callExecutor = MoreExecutors.directExecutor();
                }
                if (finalDelayNanos != null && finalAbortStatus != null) {
                    return new DelayInjectedCall(finalDelayNanos, callExecutor, scheduler, callOptions.getDeadline(), Suppliers.ofInstance(new FailingClientCall(finalAbortStatus, callExecutor)));
                }
                if (finalAbortStatus != null) {
                    return new FailingClientCall(finalAbortStatus, callExecutor);
                }
                return new DelayInjectedCall(finalDelayNanos, callExecutor, scheduler, callOptions.getDeadline(), new Supplier<ClientCall<ReqT, RespT>>(){

                    public ClientCall<ReqT, RespT> get() {
                        return next.newCall(method, callOptions);
                    }
                });
            }
        }
        return new FaultInjectionInterceptor();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private Long determineFaultDelayNanos(FaultConfig.FaultDelay faultDelay, Metadata headers) {
        fractionalPercent = faultDelay.percent();
        if (faultDelay.headerDelay()) {
            try {
                delayMillis = Integer.parseInt((String)headers.get(FaultFilter.HEADER_DELAY_KEY));
                delayNanos = TimeUnit.MILLISECONDS.toNanos(delayMillis);
                delayPercentageStr = (String)headers.get(FaultFilter.HEADER_DELAY_PERCENTAGE_KEY);
                if (delayPercentageStr == null || (delayPercentage = Integer.parseInt(delayPercentageStr)) < 0 || delayPercentage >= fractionalPercent.numerator()) ** GOTO lbl13
                fractionalPercent = FaultConfig.FractionalPercent.create(delayPercentage, fractionalPercent.denominatorType());
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            delayNanos = faultDelay.delayNanos();
        }
lbl13:
        // 3 sources

        if (this.random.nextInt(1000000) >= FaultFilter.getRatePerMillion(fractionalPercent)) {
            return null;
        }
        return delayNanos;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private Status determineFaultAbortStatus(FaultConfig.FaultAbort faultAbort, Metadata headers) {
        abortStatus = null;
        fractionalPercent = faultAbort.percent();
        if (faultAbort.headerAbort()) {
            try {
                grpcCodeStr = (String)headers.get(FaultFilter.HEADER_ABORT_GRPC_STATUS_KEY);
                if (grpcCodeStr != null) {
                    grpcCode = Integer.parseInt(grpcCodeStr);
                    abortStatus = Status.fromCodeValue((int)grpcCode);
                }
                if ((httpCodeStr = (String)headers.get(FaultFilter.HEADER_ABORT_HTTP_STATUS_KEY)) != null) {
                    httpCode = Integer.parseInt(httpCodeStr);
                    abortStatus = GrpcUtil.httpStatusToGrpcStatus((int)httpCode);
                }
                if ((abortPercentageStr = (String)headers.get(FaultFilter.HEADER_ABORT_PERCENTAGE_KEY)) == null || (abortPercentage = Integer.parseInt((String)headers.get(FaultFilter.HEADER_ABORT_PERCENTAGE_KEY))) < 0 || abortPercentage >= fractionalPercent.numerator()) ** GOTO lbl18
                fractionalPercent = FaultConfig.FractionalPercent.create(abortPercentage, fractionalPercent.denominatorType());
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            abortStatus = faultAbort.status();
        }
lbl18:
        // 3 sources

        if (this.random.nextInt(1000000) >= FaultFilter.getRatePerMillion(fractionalPercent)) {
            return null;
        }
        return abortStatus;
    }

    private static int getRatePerMillion(FaultConfig.FractionalPercent percent) {
        int numerator = percent.numerator();
        FaultConfig.FractionalPercent.DenominatorType type = percent.denominatorType();
        switch (type) {
            case TEN_THOUSAND: {
                numerator *= 100;
                break;
            }
            case HUNDRED: {
                numerator *= 10000;
                break;
            }
        }
        if (numerator > 1000000 || numerator < 0) {
            numerator = 1000000;
        }
        return numerator;
    }

    private final class FailingClientCall<ReqT, RespT>
    extends ClientCall<ReqT, RespT> {
        final Status error;
        final Executor callExecutor;
        final Context context;

        FailingClientCall(Status error, Executor callExecutor) {
            this.error = error;
            this.callExecutor = callExecutor;
            this.context = Context.current();
        }

        public void start(final ClientCall.Listener<RespT> listener, Metadata headers) {
            FaultFilter.this.activeFaultCounter.incrementAndGet();
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Context previous = FailingClientCall.this.context.attach();
                    try {
                        listener.onClose(FailingClientCall.this.error, new Metadata());
                        FaultFilter.this.activeFaultCounter.decrementAndGet();
                    }
                    finally {
                        FailingClientCall.this.context.detach(previous);
                    }
                }
            });
        }

        public void request(int numMessages) {
        }

        public void cancel(String message, Throwable cause) {
        }

        public void halfClose() {
        }

        public void sendMessage(ReqT message) {
        }
    }

    private final class DelayInjectedCall<ReqT, RespT>
    extends DelayedClientCall<ReqT, RespT> {
        final Object lock;
        ScheduledFuture<?> delayTask;
        boolean cancelled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DelayInjectedCall(long delayNanos, Executor callExecutor, @Nullable ScheduledExecutorService scheduler, Deadline deadline, final Supplier<? extends ClientCall<ReqT, RespT>> callSupplier) {
            super(callExecutor, scheduler, deadline);
            this.lock = new Object();
            FaultFilter.this.activeFaultCounter.incrementAndGet();
            ScheduledFuture<?> task = scheduler.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = DelayInjectedCall.this.lock;
                    synchronized (object) {
                        if (!DelayInjectedCall.this.cancelled) {
                            FaultFilter.this.activeFaultCounter.decrementAndGet();
                        }
                    }
                    DelayInjectedCall.this.setCall((ClientCall)callSupplier.get());
                }
            }, delayNanos, TimeUnit.NANOSECONDS);
            Object object = this.lock;
            synchronized (object) {
                if (!this.cancelled) {
                    this.delayTask = task;
                    return;
                }
            }
            task.cancel(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void callCancelled() {
            ScheduledFuture<?> savedDelayTask;
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
                FaultFilter.this.activeFaultCounter.decrementAndGet();
                savedDelayTask = this.delayTask;
            }
            if (savedDelayTask != null) {
                savedDelayTask.cancel(false);
            }
        }
    }
}

