/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.RingHashLoadBalancer;
import java.util.Map;

@Internal
public final class RingHashLoadBalancerProvider
extends LoadBalancerProvider {
    private static final boolean enableRingHash = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH"));

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RingHashLoadBalancer(helper);
    }

    public boolean isAvailable() {
        return enableRingHash;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "ring_hash";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        Long minRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, (String)"minRingSize");
        Long maxRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, (String)"maxRingSize");
        if (minRingSize == null || maxRingSize == null) {
            return NameResolver.ConfigOrError.fromError((Status)Status.INVALID_ARGUMENT.withDescription("Missing 'mingRingSize'/'maxRingSize'"));
        }
        if (minRingSize <= 0L || maxRingSize <= 0L || minRingSize > maxRingSize) {
            return NameResolver.ConfigOrError.fromError((Status)Status.INVALID_ARGUMENT.withDescription("Invalid 'mingRingSize'/'maxRingSize'"));
        }
        return NameResolver.ConfigOrError.fromConfig((Object)new RingHashLoadBalancer.RingHashConfig(minRingSize, maxRingSize));
    }
}

