/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.grpc.Attributes;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.ObjectPool;
import io.grpc.util.ForwardingClientStreamTracer;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.ForwardingSubchannel;
import io.grpc.xds.ClusterImplLoadBalancerProvider;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.InternalXdsAttributes;
import io.grpc.xds.LoadStatsManager2;
import io.grpc.xds.Locality;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.XdsSubchannelPickers;
import io.grpc.xds.internal.sds.SslContextProviderSupplier;
import io.grpc.xds.internal.sds.TlsContextManager;
import io.grpc.xds.internal.sds.TlsContextManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

final class ClusterImplLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    static final long DEFAULT_PER_CLUSTER_MAX_CONCURRENT_REQUESTS = 1024L;
    @VisibleForTesting
    static boolean enableCircuitBreaking = Strings.isNullOrEmpty((String)System.getenv("GRPC_XDS_EXPERIMENTAL_CIRCUIT_BREAKING")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_CIRCUIT_BREAKING"));
    @VisibleForTesting
    static boolean enableSecurity = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_SECURITY_SUPPORT"));
    private static final Attributes.Key<LoadStatsManager2.ClusterLocalityStats> ATTR_CLUSTER_LOCALITY_STATS = Attributes.Key.create((String)"io.grpc.xds.ClusterImplLoadBalancer.clusterLocalityStats");
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final ThreadSafeRandom random;
    private final TlsContextManager tlsContextManager;
    private String cluster;
    @Nullable
    private String edsServiceName;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private XdsNameResolverProvider.CallCounterProvider callCounterProvider;
    private LoadStatsManager2.ClusterDropStats dropStats;
    private ClusterImplLbHelper childLbHelper;
    private LoadBalancer childLb;

    ClusterImplLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, ThreadSafeRandom.ThreadSafeRandomImpl.instance, TlsContextManagerImpl.getInstance());
    }

    ClusterImplLoadBalancer(LoadBalancer.Helper helper, ThreadSafeRandom random, TlsContextManager tlsContextManager) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
        this.tlsContextManager = (TlsContextManager)Preconditions.checkNotNull((Object)tlsContextManager, (Object)"tlsContextManager");
        InternalLogId logId = InternalLogId.allocate((String)"cluster-impl-lb", (String)helper.getAuthority());
        this.logger = XdsLogger.withLogId(logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        Attributes attributes = resolvedAddresses.getAttributes();
        if (this.xdsClientPool == null) {
            this.xdsClientPool = (ObjectPool)attributes.get(InternalXdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        if (this.callCounterProvider == null) {
            this.callCounterProvider = (XdsNameResolverProvider.CallCounterProvider)attributes.get(InternalXdsAttributes.CALL_COUNTER_PROVIDER);
        }
        ClusterImplLoadBalancerProvider.ClusterImplConfig config = (ClusterImplLoadBalancerProvider.ClusterImplConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (this.cluster == null) {
            this.cluster = config.cluster;
            this.edsServiceName = config.edsServiceName;
            this.childLbHelper = new ClusterImplLbHelper(this.callCounterProvider.getOrCreate(config.cluster, config.edsServiceName));
            this.childLb = config.childPolicy.getProvider().newLoadBalancer((LoadBalancer.Helper)this.childLbHelper);
            if (config.lrsServerName != null) {
                if (config.lrsServerName.isEmpty()) {
                    this.dropStats = this.xdsClient.addClusterDropStats(this.cluster, this.edsServiceName);
                } else {
                    this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Can only report load to the same management server");
                }
            }
        }
        this.childLbHelper.updateDropPolicies(config.dropCategories);
        this.childLbHelper.updateMaxConcurrentRequests(config.maxConcurrentRequests);
        this.childLbHelper.updateSslContextProviderSupplier(config.tlsContext);
        this.childLb.handleResolvedAddresses(resolvedAddresses.toBuilder().setAttributes(attributes).setLoadBalancingPolicyConfig(config.childPolicy.getConfig()).build());
    }

    public void handleNameResolutionError(Status error) {
        if (this.childLb != null) {
            this.childLb.handleNameResolutionError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    public void shutdown() {
        if (this.dropStats != null) {
            this.dropStats.release();
        }
        if (this.childLb != null) {
            this.childLb.shutdown();
            this.childLbHelper = null;
        }
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    private static final class CountingStreamTracerFactory
    extends ClientStreamTracer.Factory {
        private LoadStatsManager2.ClusterLocalityStats stats;
        private final AtomicLong inFlights;
        @Nullable
        private final ClientStreamTracer.Factory delegate;

        private CountingStreamTracerFactory(LoadStatsManager2.ClusterLocalityStats stats, AtomicLong inFlights, @Nullable ClientStreamTracer.Factory delegate) {
            this.stats = (LoadStatsManager2.ClusterLocalityStats)Preconditions.checkNotNull((Object)stats, (Object)"stats");
            this.inFlights = (AtomicLong)Preconditions.checkNotNull((Object)inFlights, (Object)"inFlights");
            this.delegate = delegate;
        }

        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            this.stats.recordCallStarted();
            this.inFlights.incrementAndGet();
            if (this.delegate == null) {
                return new ClientStreamTracer(){

                    public void streamClosed(Status status) {
                        CountingStreamTracerFactory.this.stats.recordCallFinished(status);
                        CountingStreamTracerFactory.this.inFlights.decrementAndGet();
                    }
                };
            }
            final ClientStreamTracer delegatedTracer = this.delegate.newClientStreamTracer(info, headers);
            return new ForwardingClientStreamTracer(){

                protected ClientStreamTracer delegate() {
                    return delegatedTracer;
                }

                public void streamClosed(Status status) {
                    CountingStreamTracerFactory.this.stats.recordCallFinished(status);
                    CountingStreamTracerFactory.this.inFlights.decrementAndGet();
                    this.delegate().streamClosed(status);
                }
            };
        }
    }

    private final class ClusterImplLbHelper
    extends ForwardingLoadBalancerHelper {
        private final AtomicLong inFlights;
        private ConnectivityState currentState = ConnectivityState.IDLE;
        private LoadBalancer.SubchannelPicker currentPicker = XdsSubchannelPickers.BUFFER_PICKER;
        private List<Endpoints.DropOverload> dropPolicies = Collections.emptyList();
        private long maxConcurrentRequests = 1024L;
        @Nullable
        private SslContextProviderSupplier sslContextProviderSupplier;

        private ClusterImplLbHelper(AtomicLong inFlights) {
            this.inFlights = (AtomicLong)Preconditions.checkNotNull((Object)inFlights, (Object)"inFlights");
        }

        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.currentState = newState;
            this.currentPicker = newPicker;
            RequestLimitingSubchannelPicker picker = new RequestLimitingSubchannelPicker(newPicker, this.dropPolicies, this.maxConcurrentRequests);
            this.delegate().updateBalancingState(newState, (LoadBalancer.SubchannelPicker)picker);
        }

        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
            for (EquivalentAddressGroup eag : args.getAddresses()) {
                Attributes.Builder attrBuilder = eag.getAttributes().toBuilder().set(InternalXdsAttributes.ATTR_CLUSTER_NAME, (Object)ClusterImplLoadBalancer.this.cluster);
                if (enableSecurity && this.sslContextProviderSupplier != null) {
                    attrBuilder.set(InternalXdsAttributes.ATTR_SSL_CONTEXT_PROVIDER_SUPPLIER, (Object)this.sslContextProviderSupplier);
                }
                addresses.add(new EquivalentAddressGroup(eag.getAddresses(), attrBuilder.build()));
            }
            Locality locality = (Locality)((EquivalentAddressGroup)args.getAddresses().get(0)).getAttributes().get(InternalXdsAttributes.ATTR_LOCALITY);
            if (locality == null) {
                locality = Locality.create("", "", "");
            }
            final LoadStatsManager2.ClusterLocalityStats localityStats = ClusterImplLoadBalancer.this.xdsClient.addClusterLocalityStats(ClusterImplLoadBalancer.this.cluster, ClusterImplLoadBalancer.this.edsServiceName, locality);
            Attributes attrs = args.getAttributes().toBuilder().set(ATTR_CLUSTER_LOCALITY_STATS, (Object)localityStats).build();
            args = args.toBuilder().setAddresses(addresses).setAttributes(attrs).build();
            final LoadBalancer.Subchannel subchannel = this.delegate().createSubchannel(args);
            return new ForwardingSubchannel(){

                public void shutdown() {
                    localityStats.release();
                    this.delegate().shutdown();
                }

                protected LoadBalancer.Subchannel delegate() {
                    return subchannel;
                }
            };
        }

        protected LoadBalancer.Helper delegate() {
            return ClusterImplLoadBalancer.this.helper;
        }

        private void updateDropPolicies(List<Endpoints.DropOverload> dropOverloads) {
            if (!this.dropPolicies.equals(dropOverloads)) {
                this.dropPolicies = dropOverloads;
                this.updateBalancingState(this.currentState, this.currentPicker);
            }
        }

        private void updateMaxConcurrentRequests(@Nullable Long maxConcurrentRequests) {
            if (Objects.equals(this.maxConcurrentRequests, maxConcurrentRequests)) {
                return;
            }
            this.maxConcurrentRequests = maxConcurrentRequests != null ? maxConcurrentRequests : 1024L;
            this.updateBalancingState(this.currentState, this.currentPicker);
        }

        private void updateSslContextProviderSupplier(@Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
            EnvoyServerProtoData.UpstreamTlsContext currentTlsContext;
            EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = currentTlsContext = this.sslContextProviderSupplier != null ? (EnvoyServerProtoData.UpstreamTlsContext)this.sslContextProviderSupplier.getTlsContext() : null;
            if (Objects.equals(currentTlsContext, tlsContext)) {
                return;
            }
            if (this.sslContextProviderSupplier != null) {
                this.sslContextProviderSupplier.close();
            }
            this.sslContextProviderSupplier = tlsContext != null ? new SslContextProviderSupplier(tlsContext, ClusterImplLoadBalancer.this.tlsContextManager) : null;
        }

        private class RequestLimitingSubchannelPicker
        extends LoadBalancer.SubchannelPicker {
            private final LoadBalancer.SubchannelPicker delegate;
            private final List<Endpoints.DropOverload> dropPolicies;
            private final long maxConcurrentRequests;

            private RequestLimitingSubchannelPicker(LoadBalancer.SubchannelPicker delegate, List<Endpoints.DropOverload> dropPolicies, long maxConcurrentRequests) {
                this.delegate = delegate;
                this.dropPolicies = dropPolicies;
                this.maxConcurrentRequests = maxConcurrentRequests;
            }

            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                for (Endpoints.DropOverload dropOverload : this.dropPolicies) {
                    int rand = ClusterImplLoadBalancer.this.random.nextInt(1000000);
                    if (rand >= dropOverload.dropsPerMillion()) continue;
                    ClusterImplLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Drop request with category: {0}", dropOverload.category());
                    if (ClusterImplLoadBalancer.this.dropStats != null) {
                        ClusterImplLoadBalancer.this.dropStats.recordDroppedRequest(dropOverload.category());
                    }
                    return LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Dropped: " + dropOverload.category()));
                }
                LoadBalancer.PickResult result = this.delegate.pickSubchannel(args);
                if (result.getStatus().isOk() && result.getSubchannel() != null) {
                    if (enableCircuitBreaking && ClusterImplLbHelper.this.inFlights.get() >= this.maxConcurrentRequests) {
                        if (ClusterImplLoadBalancer.this.dropStats != null) {
                            ClusterImplLoadBalancer.this.dropStats.recordDroppedRequest();
                        }
                        return LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Cluster max concurrent requests limit exceeded"));
                    }
                    LoadStatsManager2.ClusterLocalityStats stats = (LoadStatsManager2.ClusterLocalityStats)result.getSubchannel().getAttributes().get(ATTR_CLUSTER_LOCALITY_STATS);
                    CountingStreamTracerFactory tracerFactory = new CountingStreamTracerFactory(stats, ClusterImplLbHelper.this.inFlights, result.getStreamTracerFactory());
                    return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)result.getSubchannel(), (ClientStreamTracer.Factory)tracerFactory);
                }
                return result;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).add("delegate", (Object)this.delegate).toString();
            }
        }
    }
}

