/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.UInt32Value;
import io.grpc.Internal;
import io.grpc.Status;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.SharedXdsClientPoolProvider;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsNameResolverProvider;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Internal
public final class XdsClientWrapperForServerSds {
    private static final Logger logger = Logger.getLogger(XdsClientWrapperForServerSds.class.getName());
    private static final TimeServiceResource timeServiceResource = new TimeServiceResource("GrpcServerXdsClient");
    private AtomicReference<EnvoyServerProtoData.Listener> curListener = new AtomicReference();
    private ObjectPool<XdsClient> xdsClientPool;
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;
    @Nullable
    private XdsClient xdsClient;
    private final int port;
    private ScheduledExecutorService timeService;
    private XdsClient.LdsResourceWatcher listenerWatcher;
    private boolean newServerApi;
    @VisibleForTesting
    final Set<ServerWatcher> serverWatchers = new HashSet<ServerWatcher>();

    XdsClientWrapperForServerSds(int port) {
        this(port, SharedXdsClientPoolProvider.getDefaultProvider());
    }

    @VisibleForTesting
    XdsClientWrapperForServerSds(int port, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory) {
        this.port = port;
        this.xdsClientPoolFactory = (XdsNameResolverProvider.XdsClientPoolFactory)Preconditions.checkNotNull((Object)xdsClientPoolFactory, (Object)"xdsClientPoolFactory");
    }

    @VisibleForTesting
    XdsClient getXdsClient() {
        return this.xdsClient;
    }

    @VisibleForTesting
    public void start() {
        try {
            this.xdsClientPool = this.xdsClientPoolFactory.getOrCreate();
        }
        catch (Exception e) {
            this.reportError(e, true);
            return;
        }
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        this.listenerWatcher = new XdsClient.LdsResourceWatcher(){

            @Override
            public void onChanged(XdsClient.LdsUpdate update) {
                XdsClientWrapperForServerSds.this.curListener.set(update.listener);
                XdsClientWrapperForServerSds.this.reportSuccess();
            }

            @Override
            public void onResourceDoesNotExist(String resourceName) {
                logger.log(Level.WARNING, "Resource {0} is unavailable", resourceName);
                XdsClientWrapperForServerSds.this.curListener.set(null);
                XdsClientWrapperForServerSds.this.reportError(Status.NOT_FOUND.asException(), true);
            }

            @Override
            public void onError(Status error) {
                logger.log(Level.WARNING, "LdsResourceWatcher in XdsClientWrapperForServerSds: {0}", error);
                XdsClientWrapperForServerSds.this.reportError(error.asException(), XdsClientWrapperForServerSds.isResourceAbsent(error));
            }
        };
        String grpcServerResourceId = this.xdsClient.getBootstrapInfo().getServerListenerResourceNameTemplate();
        this.newServerApi = this.xdsClient.getBootstrapInfo().getServers().get(0).isUseProtocolV3();
        if (this.newServerApi && grpcServerResourceId == null) {
            this.reportError(new XdsInitializationException("missing server_listener_resource_name_template value in xds bootstrap"), true);
        }
        grpcServerResourceId = grpcServerResourceId.replaceAll("%s", "0.0.0.0:" + this.port);
        this.xdsClient.watchLdsResource(grpcServerResourceId, this.listenerWatcher);
    }

    private static boolean isResourceAbsent(Status status) {
        Status.Code code = status.getCode();
        switch (code) {
            case NOT_FOUND: 
            case INVALID_ARGUMENT: 
            case PERMISSION_DENIED: 
            case UNIMPLEMENTED: 
            case UNAUTHENTICATED: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public EnvoyServerProtoData.DownstreamTlsContext getDownstreamTlsContext(Channel channel) {
        EnvoyServerProtoData.Listener copyListener = this.curListener.get();
        if (copyListener != null && channel != null) {
            SocketAddress localAddress = channel.localAddress();
            SocketAddress remoteAddress = channel.remoteAddress();
            if (localAddress instanceof InetSocketAddress && remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress localInetAddr = (InetSocketAddress)localAddress;
                InetSocketAddress remoteInetAddr = (InetSocketAddress)remoteAddress;
                Preconditions.checkState((this.port == localInetAddr.getPort() ? 1 : 0) != 0, (Object)"Channel localAddress port does not match requested listener port");
                return XdsClientWrapperForServerSds.getDownstreamTlsContext(localInetAddr, remoteInetAddr, copyListener);
            }
        }
        return null;
    }

    private static EnvoyServerProtoData.DownstreamTlsContext getDownstreamTlsContext(InetSocketAddress localInetAddr, InetSocketAddress remoteInetAddr, EnvoyServerProtoData.Listener listener) {
        List<EnvoyServerProtoData.FilterChain> filterChains = listener.getFilterChains();
        filterChains = XdsClientWrapperForServerSds.filterOnDestinationPort(filterChains);
        filterChains = XdsClientWrapperForServerSds.filterOnIpAddress(filterChains, localInetAddr.getAddress(), true);
        filterChains = XdsClientWrapperForServerSds.filterOnSourceType(filterChains, remoteInetAddr.getAddress(), localInetAddr.getAddress());
        filterChains = XdsClientWrapperForServerSds.filterOnIpAddress(filterChains, remoteInetAddr.getAddress(), false);
        if ((filterChains = XdsClientWrapperForServerSds.filterOnSourcePort(filterChains, remoteInetAddr.getPort())).size() > 1) {
            throw new IllegalStateException("Found 2 matching filter-chains");
        }
        if (filterChains.size() == 1) {
            return filterChains.get(0).getDownstreamTlsContext();
        }
        return listener.getDefaultFilterChain().getDownstreamTlsContext();
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnDestinationPort(List<EnvoyServerProtoData.FilterChain> filterChains) {
        ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            if (filterChainMatch.getDestinationPort() != UInt32Value.getDefaultInstance().getValue()) continue;
            filtered.add(filterChain);
        }
        return filtered;
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnSourcePort(List<EnvoyServerProtoData.FilterChain> filterChains, int sourcePort) {
        ArrayList<EnvoyServerProtoData.FilterChain> filteredOnMatch = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        ArrayList<EnvoyServerProtoData.FilterChain> filteredOnEmpty = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            List<Integer> sourcePortsToMatch = filterChainMatch.getSourcePorts();
            if (sourcePortsToMatch.isEmpty()) {
                filteredOnEmpty.add(filterChain);
                continue;
            }
            if (!sourcePortsToMatch.contains(sourcePort)) continue;
            filteredOnMatch.add(filterChain);
        }
        return filteredOnMatch.isEmpty() ? filteredOnEmpty : filteredOnMatch;
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnSourceType(List<EnvoyServerProtoData.FilterChain> filterChains, InetAddress sourceAddress, InetAddress destAddress) {
        ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            EnvoyServerProtoData.ConnectionSourceType sourceType = filterChainMatch.getConnectionSourceType();
            boolean matching = false;
            matching = sourceType == EnvoyServerProtoData.ConnectionSourceType.SAME_IP_OR_LOOPBACK ? sourceAddress.isLoopbackAddress() || sourceAddress.isAnyLocalAddress() || sourceAddress.equals(destAddress) : (sourceType == EnvoyServerProtoData.ConnectionSourceType.EXTERNAL ? !sourceAddress.isLoopbackAddress() && !sourceAddress.isAnyLocalAddress() : true);
            if (!matching) continue;
            filtered.add(filterChain);
        }
        return filtered;
    }

    private static boolean isCidrMatching(byte[] cidrBytes, byte[] addressBytes, int prefixLen) {
        BigInteger cidrInt = new BigInteger(cidrBytes);
        BigInteger addrInt = new BigInteger(addressBytes);
        int shiftAmount = 8 * cidrBytes.length - prefixLen;
        cidrInt = cidrInt.shiftRight(shiftAmount);
        addrInt = addrInt.shiftRight(shiftAmount);
        return cidrInt.equals(addrInt);
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnIpAddress(List<EnvoyServerProtoData.FilterChain> filterChains, InetAddress address, boolean forDestination) {
        QueueElement element;
        PriorityQueue<QueueElement> heap = new PriorityQueue<QueueElement>(10, new QueueElementComparator());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            element = new QueueElement(filterChain, address, forDestination);
            if (element.matchingPrefixLength < 0) continue;
            heap.add(element);
        }
        ArrayList<EnvoyServerProtoData.FilterChain> topOnes = new ArrayList<EnvoyServerProtoData.FilterChain>(heap.size());
        int topMatchingPrefixLen = -1;
        while (!heap.isEmpty()) {
            element = (QueueElement)heap.remove();
            if (topMatchingPrefixLen == -1) {
                topMatchingPrefixLen = element.matchingPrefixLength;
            } else if (element.matchingPrefixLength < topMatchingPrefixLen) break;
            topOnes.add(element.filterChain);
        }
        return topOnes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerWatcher(ServerWatcher serverWatcher) {
        Preconditions.checkNotNull((Object)serverWatcher, (Object)"serverWatcher");
        Set<ServerWatcher> set = this.serverWatchers;
        synchronized (set) {
            this.serverWatchers.add(serverWatcher);
        }
        EnvoyServerProtoData.Listener copyListener = this.curListener.get();
        if (copyListener != null) {
            serverWatcher.onListenerUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerWatcher(ServerWatcher serverWatcher) {
        Preconditions.checkNotNull((Object)serverWatcher, (Object)"serverWatcher");
        Set<ServerWatcher> set = this.serverWatchers;
        synchronized (set) {
            this.serverWatchers.remove(serverWatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ServerWatcher> getServerWatchers() {
        Set<ServerWatcher> set = this.serverWatchers;
        synchronized (set) {
            return ImmutableSet.copyOf(this.serverWatchers);
        }
    }

    private void reportError(Throwable throwable, boolean isAbsent) {
        for (ServerWatcher watcher : this.getServerWatchers()) {
            watcher.onError(throwable, isAbsent);
        }
    }

    private void reportSuccess() {
        for (ServerWatcher watcher : this.getServerWatchers()) {
            watcher.onListenerUpdate();
        }
    }

    @VisibleForTesting
    XdsClient.LdsResourceWatcher getListenerWatcher() {
        return this.listenerWatcher;
    }

    public void shutdown() {
        logger.log(Level.FINER, "Shutdown");
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
        if (this.timeService != null) {
            this.timeService = (ScheduledExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)timeServiceResource, (Object)this.timeService);
        }
    }

    private static final class TimeServiceResource
    implements SharedResourceHolder.Resource<ScheduledExecutorService> {
        private final String name;

        TimeServiceResource(String name) {
            this.name = name;
        }

        public ScheduledExecutorService create() {
            DefaultThreadFactory threadFactory = new DefaultThreadFactory(this.name, true);
            if (Epoll.isAvailable()) {
                return new EpollEventLoopGroup(1, (ThreadFactory)threadFactory);
            }
            return Executors.newSingleThreadScheduledExecutor((ThreadFactory)threadFactory);
        }

        public void close(ScheduledExecutorService instance) {
            try {
                if (instance instanceof EpollEventLoopGroup) {
                    ((EpollEventLoopGroup)instance).shutdownGracefully(0L, 0L, TimeUnit.SECONDS).sync();
                } else {
                    instance.shutdown();
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "Interrupted during shutdown", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface ServerWatcher {
        public void onError(Throwable var1, boolean var2);

        public void onListenerUpdate();
    }

    private static final class QueueElementComparator
    implements Comparator<QueueElement> {
        private QueueElementComparator() {
        }

        @Override
        public int compare(QueueElement o1, QueueElement o2) {
            return o2.matchingPrefixLength - o1.matchingPrefixLength;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof QueueElementComparator;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class QueueElement {
        EnvoyServerProtoData.FilterChain filterChain;
        int indexOfMatchingPrefixRange;
        int matchingPrefixLength;

        public QueueElement(EnvoyServerProtoData.FilterChain filterChain, InetAddress address, boolean forDestination) {
            this.filterChain = filterChain;
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            byte[] addressBytes = address.getAddress();
            boolean isIPv6 = address instanceof Inet6Address;
            List<EnvoyServerProtoData.CidrRange> cidrRanges = forDestination ? filterChainMatch.getPrefixRanges() : filterChainMatch.getSourcePrefixRanges();
            this.indexOfMatchingPrefixRange = -1;
            if (cidrRanges.isEmpty()) {
                this.matchingPrefixLength = 0;
            } else {
                this.matchingPrefixLength = -1;
                int index = 0;
                for (EnvoyServerProtoData.CidrRange cidrRange : cidrRanges) {
                    int prefixLen;
                    byte[] cidrBytes;
                    InetAddress cidrAddr = cidrRange.getAddressPrefix();
                    boolean cidrIsIpv6 = cidrAddr instanceof Inet6Address;
                    if (isIPv6 == cidrIsIpv6 && XdsClientWrapperForServerSds.isCidrMatching(cidrBytes = cidrAddr.getAddress(), addressBytes, prefixLen = cidrRange.getPrefixLen()) && prefixLen > this.matchingPrefixLength) {
                        this.matchingPrefixLength = prefixLen;
                        this.indexOfMatchingPrefixRange = index;
                    }
                    ++index;
                }
            }
        }
    }
}

