/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.internal.certprovider.CertProviderServerSslContextProvider;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.ReferenceCountingMap;
import io.grpc.xds.internal.sds.SdsServerSslContextProvider;
import io.grpc.xds.internal.sds.SecretVolumeServerSslContextProvider;
import io.grpc.xds.internal.sds.SslContextProvider;
import java.util.concurrent.Executors;

final class ServerSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> {
    private final Bootstrapper bootstrapper;
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderServerSslContextProvider.Factory certProviderServerSslContextProviderFactory;

    ServerSslContextProviderFactory(Bootstrapper bootstrapper) {
        this(bootstrapper, CertProviderServerSslContextProvider.Factory.getInstance());
    }

    ServerSslContextProviderFactory(Bootstrapper bootstrapper, CertProviderServerSslContextProvider.Factory factory) {
        this.bootstrapper = bootstrapper;
        this.certProviderServerSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        Preconditions.checkNotNull((Object)downstreamTlsContext.getCommonTlsContext(), (Object)"downstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(downstreamTlsContext.getCommonTlsContext())) {
            try {
                if (this.bootstrapInfo == null) {
                    this.bootstrapInfo = this.bootstrapper.bootstrap();
                }
                return this.certProviderServerSslContextProviderFactory.getProvider(downstreamTlsContext, this.bootstrapInfo.getNode().toEnvoyProtoNode(), this.bootstrapInfo.getCertProviders());
            }
            catch (XdsInitializationException e) {
                throw new RuntimeException(e);
            }
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingFilename(downstreamTlsContext.getCommonTlsContext())) {
            return SecretVolumeServerSslContextProvider.getProvider(downstreamTlsContext);
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingSds(downstreamTlsContext.getCommonTlsContext())) {
            try {
                if (this.bootstrapInfo == null) {
                    this.bootstrapInfo = this.bootstrapper.bootstrap();
                }
                return SdsServerSslContextProvider.getProvider(downstreamTlsContext, this.bootstrapInfo.getNode().toEnvoyProtoNodeV2(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("server-sds-sslcontext-provider-%d").setDaemon(true).build()), null);
            }
            catch (XdsInitializationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("Unsupported configurations in DownstreamTlsContext!");
    }
}

