/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.Closeable;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.TlsContextManager;

public final class SslContextProviderSupplier
implements Closeable {
    private final EnvoyServerProtoData.BaseTlsContext tlsContext;
    private final TlsContextManager tlsContextManager;
    private SslContextProvider sslContextProvider;
    private boolean shutdown;

    public SslContextProviderSupplier(EnvoyServerProtoData.BaseTlsContext tlsContext, TlsContextManager tlsContextManager) {
        this.tlsContext = (EnvoyServerProtoData.BaseTlsContext)Preconditions.checkNotNull((Object)tlsContext, (Object)"tlsContext");
        this.tlsContextManager = (TlsContextManager)Preconditions.checkNotNull((Object)tlsContextManager, (Object)"tlsContextManager");
    }

    public EnvoyServerProtoData.BaseTlsContext getTlsContext() {
        return this.tlsContext;
    }

    public synchronized void updateSslContext(final SslContextProvider.Callback callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"Supplier is shutdown!");
        if (this.sslContextProvider == null) {
            this.sslContextProvider = this.getSslContextProvider();
        }
        final SslContextProvider toRelease = this.getSslContextProvider();
        this.sslContextProvider.addCallback(new SslContextProvider.Callback(callback.getExecutor()){

            @Override
            public void updateSecret(SslContext sslContext) {
                callback.updateSecret(sslContext);
                SslContextProviderSupplier.this.releaseSslContextProvider(toRelease);
            }

            @Override
            public void onException(Throwable throwable) {
                callback.onException(throwable);
                SslContextProviderSupplier.this.releaseSslContextProvider(toRelease);
            }
        });
    }

    private void releaseSslContextProvider(SslContextProvider toRelease) {
        if (this.tlsContext instanceof EnvoyServerProtoData.UpstreamTlsContext) {
            this.tlsContextManager.releaseClientSslContextProvider(toRelease);
        } else {
            this.tlsContextManager.releaseServerSslContextProvider(toRelease);
        }
    }

    private SslContextProvider getSslContextProvider() {
        return this.tlsContext instanceof EnvoyServerProtoData.UpstreamTlsContext ? this.tlsContextManager.findOrCreateClientSslContextProvider((EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext) : this.tlsContextManager.findOrCreateServerSslContextProvider((EnvoyServerProtoData.DownstreamTlsContext)this.tlsContext);
    }

    @Override
    public synchronized void close() {
        if (this.sslContextProvider != null) {
            if (this.tlsContext instanceof EnvoyServerProtoData.UpstreamTlsContext) {
                this.tlsContextManager.releaseClientSslContextProvider(this.sslContextProvider);
            } else {
                this.tlsContextManager.releaseServerSslContextProvider(this.sslContextProvider);
            }
        }
        this.shutdown = true;
    }
}

