/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.Internal;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.internal.sds.SslContextProviderSupplier;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.TrafficDirection;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Filter;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpFilter;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public final class EnvoyServerProtoData {
    static final String TRANSPORT_SOCKET_NAME_TLS = "envoy.transport_sockets.tls";

    private EnvoyServerProtoData() {
    }

    static final class Listener {
        private final String name;
        @Nullable
        private final String address;
        private final List<FilterChain> filterChains;
        private final FilterChain defaultFilterChain;

        @VisibleForTesting
        Listener(String name, String address, List<FilterChain> filterChains, FilterChain defaultFilterChain) {
            this.name = name;
            this.address = address;
            this.filterChains = Collections.unmodifiableList(filterChains);
            this.defaultFilterChain = defaultFilterChain;
        }

        private static String convertEnvoyAddressToString(Address proto) {
            if (proto.hasSocketAddress()) {
                SocketAddress socketAddress = proto.getSocketAddress();
                String address = socketAddress.getAddress();
                switch (socketAddress.getPortSpecifierCase()) {
                    case NAMED_PORT: {
                        return address + ":" + socketAddress.getNamedPort();
                    }
                    case PORT_VALUE: {
                        return address + ":" + socketAddress.getPortValue();
                    }
                }
                return address;
            }
            return null;
        }

        static Listener fromEnvoyProtoListener(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener proto, TlsContextManager tlsContextManager) throws InvalidProtocolBufferException {
            if (!proto.getTrafficDirection().equals((Object)TrafficDirection.INBOUND)) {
                throw new IllegalArgumentException("Listener " + proto.getName() + " is not INBOUND");
            }
            if (!proto.getListenerFiltersList().isEmpty()) {
                throw new IllegalArgumentException("Listener " + proto.getName() + " cannot have listener_filters");
            }
            if (proto.hasUseOriginalDst()) {
                throw new IllegalArgumentException("Listener " + proto.getName() + " cannot have use_original_dst set to true");
            }
            List<FilterChain> filterChains = Listener.validateAndSelectFilterChains(proto.getFilterChainsList(), tlsContextManager);
            return new Listener(proto.getName(), Listener.convertEnvoyAddressToString(proto.getAddress()), filterChains, FilterChain.fromEnvoyProtoFilterChain(proto.getDefaultFilterChain(), tlsContextManager, true));
        }

        private static List<FilterChain> validateAndSelectFilterChains(List<io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain> inputFilterChains, TlsContextManager tlsContextManager) throws InvalidProtocolBufferException {
            ArrayList<FilterChain> filterChains = new ArrayList<FilterChain>(inputFilterChains.size());
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain filterChain : inputFilterChains) {
                filterChains.add(FilterChain.fromEnvoyProtoFilterChain(filterChain, tlsContextManager, false));
            }
            return filterChains;
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public List<FilterChain> getFilterChains() {
            return this.filterChains;
        }

        public FilterChain getDefaultFilterChain() {
            return this.defaultFilterChain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Listener listener = (Listener)o;
            return Objects.equals(this.name, listener.name) && Objects.equals(this.address, listener.address) && Objects.equals(this.filterChains, listener.filterChains) && Objects.equals(this.defaultFilterChain, listener.defaultFilterChain);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.address, this.filterChains, this.defaultFilterChain);
        }

        public String toString() {
            return "Listener{name='" + this.name + '\'' + ", address='" + this.address + '\'' + ", filterChains=" + this.filterChains + ", defaultFilterChain=" + this.defaultFilterChain + '}';
        }
    }

    static final class FilterChain {
        private final FilterChainMatch filterChainMatch;
        @Nullable
        private final SslContextProviderSupplier sslContextProviderSupplier;

        @VisibleForTesting
        FilterChain(FilterChainMatch filterChainMatch, @Nullable DownstreamTlsContext downstreamTlsContext, TlsContextManager tlsContextManager) {
            SslContextProviderSupplier sslContextProviderSupplier1 = downstreamTlsContext == null ? null : new SslContextProviderSupplier(downstreamTlsContext, tlsContextManager);
            this.filterChainMatch = filterChainMatch;
            this.sslContextProviderSupplier = sslContextProviderSupplier1;
        }

        static FilterChain fromEnvoyProtoFilterChain(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain proto, TlsContextManager tlsContextManager, boolean isDefaultFilterChain) throws InvalidProtocolBufferException {
            if (!isDefaultFilterChain && proto.getFiltersList().isEmpty()) {
                throw new IllegalArgumentException("filerChain " + proto.getName() + " has to have envoy.http_connection_manager");
            }
            HashSet<String> uniqueNames = new HashSet<String>();
            for (Filter filter : proto.getFiltersList()) {
                if (!uniqueNames.add(filter.getName())) {
                    throw new IllegalArgumentException("filerChain " + proto.getName() + " has non-unique filter name:" + filter.getName());
                }
                FilterChain.validateFilter(filter);
            }
            return new FilterChain(FilterChainMatch.fromEnvoyProtoFilterChainMatch(proto.getFilterChainMatch()), FilterChain.getTlsContextFromFilterChain(proto), tlsContextManager);
        }

        private static void validateFilter(Filter filter) throws InvalidProtocolBufferException, IllegalArgumentException {
            if (filter.hasConfigDiscovery()) {
                throw new IllegalArgumentException("filter " + filter.getName() + " with config_discovery not supported");
            }
            if (!filter.hasTypedConfig()) {
                throw new IllegalArgumentException("filter " + filter.getName() + " expected to have typed_config");
            }
            Any any = filter.getTypedConfig();
            if (!any.getTypeUrl().equals("type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager")) {
                throw new IllegalArgumentException("filter " + filter.getName() + " with unsupported typed_config type:" + any.getTypeUrl());
            }
            FilterChain.validateHttpConnectionManager((HttpConnectionManager)any.unpack(HttpConnectionManager.class));
        }

        private static void validateHttpConnectionManager(HttpConnectionManager hcm) throws IllegalArgumentException {
            List<HttpFilter> httpFilters = hcm.getHttpFiltersList();
            HashSet<String> uniqueNames = new HashSet<String>();
            for (HttpFilter httpFilter : httpFilters) {
                String httpFilterName = httpFilter.getName();
                if (!uniqueNames.add(httpFilterName)) {
                    throw new IllegalArgumentException("http-connection-manager has non-unique http-filter name:" + httpFilterName);
                }
                if (httpFilter.getIsOptional()) continue;
                if (httpFilter.hasConfigDiscovery()) {
                    throw new IllegalArgumentException("http-connection-manager http-filter " + httpFilterName + " uses config-discovery which is unsupported");
                }
                if (httpFilter.hasTypedConfig()) {
                    Any any = httpFilter.getTypedConfig();
                    if (any.getTypeUrl().equals("type.googleapis.com/envoy.extensions.filters.http.router.v3.Router")) continue;
                    throw new IllegalArgumentException("http-connection-manager http-filter " + httpFilterName + " has unsupported typed-config type:" + any.getTypeUrl());
                }
                throw new IllegalArgumentException("http-connection-manager http-filter " + httpFilterName + " should have typed-config type type.googleapis.com/envoy.extensions.filters.http.router.v3.Router");
            }
        }

        @Nullable
        private static DownstreamTlsContext getTlsContextFromFilterChain(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain filterChain) throws InvalidProtocolBufferException {
            if (filterChain.hasTransportSocket() && EnvoyServerProtoData.TRANSPORT_SOCKET_NAME_TLS.equals(filterChain.getTransportSocket().getName())) {
                Any any = filterChain.getTransportSocket().getTypedConfig();
                return DownstreamTlsContext.fromEnvoyProtoDownstreamTlsContext(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.DownstreamTlsContext.parseFrom(any.getValue()));
            }
            return null;
        }

        public FilterChainMatch getFilterChainMatch() {
            return this.filterChainMatch;
        }

        public SslContextProviderSupplier getSslContextProviderSupplier() {
            return this.sslContextProviderSupplier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterChain that = (FilterChain)o;
            return Objects.equals(this.filterChainMatch, that.filterChainMatch) && Objects.equals(this.sslContextProviderSupplier, that.sslContextProviderSupplier);
        }

        public int hashCode() {
            return Objects.hash(this.filterChainMatch, this.sslContextProviderSupplier);
        }

        public String toString() {
            return "FilterChain{filterChainMatch=" + this.filterChainMatch + ", sslContextProviderSupplier=" + this.sslContextProviderSupplier + '}';
        }
    }

    static final class FilterChainMatch {
        private final int destinationPort;
        private final List<CidrRange> prefixRanges;
        private final List<String> applicationProtocols;
        private final List<CidrRange> sourcePrefixRanges;
        private final ConnectionSourceType sourceType;
        private final List<Integer> sourcePorts;
        private final List<String> serverNames;
        private final String transportProtocol;

        @VisibleForTesting
        FilterChainMatch(int destinationPort, List<CidrRange> prefixRanges, List<String> applicationProtocols, List<CidrRange> sourcePrefixRanges, ConnectionSourceType sourceType, List<Integer> sourcePorts, List<String> serverNames, String transportProtocol) {
            this.destinationPort = destinationPort;
            this.prefixRanges = Collections.unmodifiableList(prefixRanges);
            this.applicationProtocols = Collections.unmodifiableList(applicationProtocols);
            this.sourcePrefixRanges = sourcePrefixRanges;
            this.sourceType = sourceType;
            this.sourcePorts = sourcePorts;
            this.serverNames = Collections.unmodifiableList(serverNames);
            this.transportProtocol = transportProtocol;
        }

        /*
         * WARNING - void declaration
         */
        static FilterChainMatch fromEnvoyProtoFilterChainMatch(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChainMatch proto) throws InvalidProtocolBufferException {
            void var4_12;
            ArrayList<CidrRange> prefixRanges = new ArrayList<CidrRange>();
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.CidrRange cidrRange : proto.getPrefixRangesList()) {
                prefixRanges.add(CidrRange.fromEnvoyProtoCidrRange(cidrRange));
            }
            ArrayList<CidrRange> sourcePrefixRanges = new ArrayList<CidrRange>();
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.CidrRange cidrRange : proto.getSourcePrefixRangesList()) {
                sourcePrefixRanges.add(CidrRange.fromEnvoyProtoCidrRange(cidrRange));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String appProtocol : proto.getApplicationProtocolsList()) {
                arrayList.add(appProtocol);
            }
            Object var4_8 = null;
            switch (proto.getSourceType()) {
                case ANY: {
                    ConnectionSourceType connectionSourceType = ConnectionSourceType.ANY;
                    break;
                }
                case EXTERNAL: {
                    ConnectionSourceType connectionSourceType = ConnectionSourceType.EXTERNAL;
                    break;
                }
                case SAME_IP_OR_LOOPBACK: {
                    ConnectionSourceType connectionSourceType = ConnectionSourceType.SAME_IP_OR_LOOPBACK;
                    break;
                }
                default: {
                    throw new InvalidProtocolBufferException("Unknown source-type:" + (Object)((Object)proto.getSourceType()));
                }
            }
            ArrayList<String> serverNames = new ArrayList<String>();
            for (String serverName : proto.getServerNamesList()) {
                serverNames.add(serverName);
            }
            return new FilterChainMatch(proto.getDestinationPort().getValue(), prefixRanges, arrayList, sourcePrefixRanges, (ConnectionSourceType)var4_12, proto.getSourcePortsList(), serverNames, proto.getTransportProtocol());
        }

        public int getDestinationPort() {
            return this.destinationPort;
        }

        public List<CidrRange> getPrefixRanges() {
            return this.prefixRanges;
        }

        public List<String> getApplicationProtocols() {
            return this.applicationProtocols;
        }

        public List<CidrRange> getSourcePrefixRanges() {
            return this.sourcePrefixRanges;
        }

        public ConnectionSourceType getConnectionSourceType() {
            return this.sourceType;
        }

        public List<Integer> getSourcePorts() {
            return this.sourcePorts;
        }

        public List<String> getServerNames() {
            return this.serverNames;
        }

        public String getTransportProtocol() {
            return this.transportProtocol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterChainMatch that = (FilterChainMatch)o;
            return this.destinationPort == that.destinationPort && Objects.equals(this.prefixRanges, that.prefixRanges) && Objects.equals(this.applicationProtocols, that.applicationProtocols) && Objects.equals(this.sourcePrefixRanges, that.sourcePrefixRanges) && this.sourceType == that.sourceType && Objects.equals(this.sourcePorts, that.sourcePorts) && Objects.equals(this.serverNames, that.serverNames) && Objects.equals(this.transportProtocol, that.transportProtocol);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.destinationPort, this.prefixRanges, this.applicationProtocols, this.sourcePrefixRanges, this.sourceType, this.sourcePorts, this.serverNames, this.transportProtocol});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("destinationPort", this.destinationPort).add("prefixRanges", this.prefixRanges).add("applicationProtocols", this.applicationProtocols).add("sourcePrefixRanges", this.sourcePrefixRanges).add("sourceType", (Object)this.sourceType).add("sourcePorts", this.sourcePorts).add("serverNames", this.serverNames).add("transportProtocol", (Object)this.transportProtocol).toString();
        }
    }

    static enum ConnectionSourceType {
        ANY,
        SAME_IP_OR_LOOPBACK,
        EXTERNAL;

    }

    static final class CidrRange {
        private final InetAddress addressPrefix;
        private final int prefixLen;

        @VisibleForTesting
        CidrRange(String addressPrefix, int prefixLen) throws InvalidProtocolBufferException {
            try {
                this.addressPrefix = InetAddress.getByName(addressPrefix);
            }
            catch (UnknownHostException e) {
                throw new InvalidProtocolBufferException(e.getMessage());
            }
            this.prefixLen = prefixLen;
        }

        static CidrRange fromEnvoyProtoCidrRange(io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.CidrRange proto) throws InvalidProtocolBufferException {
            return new CidrRange(proto.getAddressPrefix(), proto.getPrefixLen().getValue());
        }

        public InetAddress getAddressPrefix() {
            return this.addressPrefix;
        }

        public int getPrefixLen() {
            return this.prefixLen;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CidrRange cidrRange = (CidrRange)o;
            return this.prefixLen == cidrRange.prefixLen && Objects.equals(this.addressPrefix, cidrRange.addressPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.addressPrefix, this.prefixLen);
        }

        public String toString() {
            return "CidrRange{addressPrefix='" + this.addressPrefix + '\'' + ", prefixLen=" + this.prefixLen + '}';
        }
    }

    public static final class DownstreamTlsContext
    extends BaseTlsContext {
        private final boolean requireClientCertificate;

        @VisibleForTesting
        public DownstreamTlsContext(CommonTlsContext commonTlsContext, boolean requireClientCertificate) {
            super(commonTlsContext);
            this.requireClientCertificate = requireClientCertificate;
        }

        public static DownstreamTlsContext fromEnvoyProtoDownstreamTlsContext(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.DownstreamTlsContext downstreamTlsContext) {
            return new DownstreamTlsContext(downstreamTlsContext.getCommonTlsContext(), downstreamTlsContext.hasRequireClientCertificate());
        }

        public boolean isRequireClientCertificate() {
            return this.requireClientCertificate;
        }

        public String toString() {
            return "DownstreamTlsContext{commonTlsContext=" + this.commonTlsContext + ", requireClientCertificate=" + this.requireClientCertificate + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DownstreamTlsContext that = (DownstreamTlsContext)o;
            return this.requireClientCertificate == that.requireClientCertificate;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.requireClientCertificate);
        }
    }

    public static final class UpstreamTlsContext
    extends BaseTlsContext {
        @VisibleForTesting
        public UpstreamTlsContext(CommonTlsContext commonTlsContext) {
            super(commonTlsContext);
        }

        public static UpstreamTlsContext fromEnvoyProtoUpstreamTlsContext(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext upstreamTlsContext) {
            return new UpstreamTlsContext(upstreamTlsContext.getCommonTlsContext());
        }

        public String toString() {
            return "UpstreamTlsContext{commonTlsContext=" + this.commonTlsContext + '}';
        }
    }

    public static abstract class BaseTlsContext {
        @Nullable
        protected final CommonTlsContext commonTlsContext;

        protected BaseTlsContext(@Nullable CommonTlsContext commonTlsContext) {
            this.commonTlsContext = commonTlsContext;
        }

        @Nullable
        public CommonTlsContext getCommonTlsContext() {
            return this.commonTlsContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BaseTlsContext)) {
                return false;
            }
            BaseTlsContext that = (BaseTlsContext)o;
            return Objects.equals(this.commonTlsContext, that.commonTlsContext);
        }

        public int hashCode() {
            return Objects.hashCode(this.commonTlsContext);
        }
    }
}

