/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Message;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.xds.Filter;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

enum LameFilter implements Filter,
Filter.ClientInterceptorBuilder
{
    INSTANCE;

    static final Filter.FilterConfig LAME_CONFIG;

    @Override
    public String[] typeUrls() {
        return new String[0];
    }

    @Override
    public Filter.ConfigOrError<? extends Filter.FilterConfig> parseFilterConfig(Message rawProtoMessage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Filter.ConfigOrError<? extends Filter.FilterConfig> parseFilterConfigOverride(Message rawProtoMessage) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public ClientInterceptor buildClientInterceptor(Filter.FilterConfig config, @Nullable Filter.FilterConfig overrideConfig, LoadBalancer.PickSubchannelArgs args, ScheduledExecutorService scheduler) {
        class LameInterceptor
        implements ClientInterceptor {
            LameInterceptor() {
            }

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, Channel next) {
                final Context context = Context.current();
                return new ClientCall<ReqT, RespT>(){

                    public void start(final ClientCall.Listener<RespT> listener, Metadata headers) {
                        Executor callExecutor = callOptions.getExecutor();
                        if (callExecutor == null) {
                            callExecutor = MoreExecutors.directExecutor();
                        }
                        callExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                Context previous = context.attach();
                                try {
                                    listener.onClose(Status.UNAVAILABLE.withDescription("No router filter"), new Metadata());
                                }
                                finally {
                                    context.detach(previous);
                                }
                            }
                        });
                    }

                    public void request(int numMessages) {
                    }

                    public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    }

                    public void halfClose() {
                    }

                    public void sendMessage(ReqT message) {
                    }
                };
            }
        }
        return new LameInterceptor();
    }

    static {
        LAME_CONFIG = new Filter.FilterConfig(){

            @Override
            public String typeUrl() {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            public String toString() {
                return "LAME_CONFIG";
            }
        };
    }
}

