/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.certprovider.CertProviderClientSslContextProvider;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.ReferenceCountingMap;
import io.grpc.xds.internal.sds.SdsClientSslContextProvider;
import io.grpc.xds.internal.sds.SecretVolumeClientSslContextProvider;
import io.grpc.xds.internal.sds.SslContextProvider;
import java.util.concurrent.Executors;

final class ClientSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> {
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderClientSslContextProvider.Factory certProviderClientSslContextProviderFactory;

    ClientSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(bootstrapInfo, CertProviderClientSslContextProvider.Factory.getInstance());
    }

    ClientSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo, CertProviderClientSslContextProvider.Factory factory) {
        this.bootstrapInfo = bootstrapInfo;
        this.certProviderClientSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        Preconditions.checkNotNull((Object)upstreamTlsContext.getCommonTlsContext(), (Object)"upstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(upstreamTlsContext.getCommonTlsContext())) {
            return this.certProviderClientSslContextProviderFactory.getProvider(upstreamTlsContext, this.bootstrapInfo.getNode().toEnvoyProtoNode(), this.bootstrapInfo.getCertProviders());
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingFilename(upstreamTlsContext.getCommonTlsContext())) {
            return SecretVolumeClientSslContextProvider.getProvider(upstreamTlsContext);
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingSds(upstreamTlsContext.getCommonTlsContext())) {
            return SdsClientSslContextProvider.getProvider(upstreamTlsContext, this.bootstrapInfo.getNode().toEnvoyProtoNodeV2(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("client-sds-sslcontext-provider-%d").setDaemon(true).build()), null);
        }
        throw new UnsupportedOperationException("Unsupported configurations in UpstreamTlsContext!");
    }
}

