/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.certprovider.CertProviderServerSslContextProvider;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.ReferenceCountingMap;
import io.grpc.xds.internal.sds.SdsServerSslContextProvider;
import io.grpc.xds.internal.sds.SecretVolumeServerSslContextProvider;
import io.grpc.xds.internal.sds.SslContextProvider;
import java.util.concurrent.Executors;

final class ServerSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> {
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderServerSslContextProvider.Factory certProviderServerSslContextProviderFactory;

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(bootstrapInfo, CertProviderServerSslContextProvider.Factory.getInstance());
    }

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo, CertProviderServerSslContextProvider.Factory factory) {
        this.bootstrapInfo = bootstrapInfo;
        this.certProviderServerSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        Preconditions.checkNotNull((Object)downstreamTlsContext.getCommonTlsContext(), (Object)"downstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(downstreamTlsContext.getCommonTlsContext())) {
            return this.certProviderServerSslContextProviderFactory.getProvider(downstreamTlsContext, this.bootstrapInfo.getNode().toEnvoyProtoNode(), this.bootstrapInfo.getCertProviders());
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingFilename(downstreamTlsContext.getCommonTlsContext())) {
            return SecretVolumeServerSslContextProvider.getProvider(downstreamTlsContext);
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingSds(downstreamTlsContext.getCommonTlsContext())) {
            return SdsServerSslContextProvider.getProvider(downstreamTlsContext, this.bootstrapInfo.getNode().toEnvoyProtoNodeV2(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("server-sds-sslcontext-provider-%d").setDaemon(true).build()), null);
        }
        throw new UnsupportedOperationException("Unsupported configurations in DownstreamTlsContext!");
    }
}

