/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import io.grpc.Context;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.AbstractXdsClient;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.Filter;
import io.grpc.xds.FilterRegistry;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.LoadReportClient;
import io.grpc.xds.LoadStatsManager2;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.internal.Matchers;
import io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.CircuitBreakers;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.CidrRange;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HttpProtocolOptions;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.RoutingPriority;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.TrafficDirection;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChainMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.FilterConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RetryPolicy;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.Route;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteAction;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.WeightedCluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.clusters.aggregate.v3.ClusterConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpFilter;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.Rds;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.DownstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClientXdsClient
extends AbstractXdsClient {
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    private static final String TRANSPORT_SOCKET_NAME_TLS = "envoy.transport_sockets.tls";
    @VisibleForTesting
    static final long DEFAULT_RING_HASH_LB_POLICY_MIN_RING_SIZE = 1024L;
    @VisibleForTesting
    static final long DEFAULT_RING_HASH_LB_POLICY_MAX_RING_SIZE = 0x800000L;
    @VisibleForTesting
    static final long MAX_RING_HASH_LB_POLICY_RING_SIZE = 0x800000L;
    @VisibleForTesting
    static final String AGGREGATE_CLUSTER_TYPE_NAME = "envoy.clusters.aggregate";
    @VisibleForTesting
    static final String HASH_POLICY_FILTER_STATE_KEY = "io.grpc.channel_id";
    @VisibleForTesting
    static boolean enableFaultInjection = Strings.isNullOrEmpty((String)System.getenv("GRPC_XDS_EXPERIMENTAL_FAULT_INJECTION")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_FAULT_INJECTION"));
    @VisibleForTesting
    static boolean enableRetry = Strings.isNullOrEmpty((String)System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RETRY")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RETRY"));
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER_V2 = "type.googleapis.com/envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager";
    static final String TYPE_URL_HTTP_CONNECTION_MANAGER = "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT = "type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT_V2 = "type.googleapis.com/envoy.api.v2.auth.UpstreamTlsContext";
    private static final String TYPE_URL_CLUSTER_CONFIG_V2 = "type.googleapis.com/envoy.config.cluster.aggregate.v2alpha.ClusterConfig";
    private static final String TYPE_URL_CLUSTER_CONFIG = "type.googleapis.com/envoy.extensions.clusters.aggregate.v3.ClusterConfig";
    private static final String TYPE_URL_TYPED_STRUCT = "type.googleapis.com/udpa.type.v1.TypedStruct";
    private static final String TYPE_URL_FILTER_CONFIG = "type.googleapis.com/envoy.config.route.v3.FilterConfig";
    private static final Set<Status.Code> SUPPORTED_RETRYABLE_CODES = Collections.unmodifiableSet(EnumSet.of(Status.Code.CANCELLED, Status.Code.DEADLINE_EXCEEDED, Status.Code.INTERNAL, Status.Code.RESOURCE_EXHAUSTED, Status.Code.UNAVAILABLE));
    private final FilterRegistry filterRegistry = FilterRegistry.getDefaultRegistry();
    private final Map<String, ResourceSubscriber> ldsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> rdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> cdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> edsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final LoadStatsManager2 loadStatsManager;
    private final LoadReportClient lrsClient;
    private final TimeProvider timeProvider;
    private boolean reportingLoad;
    private final TlsContextManager tlsContextManager;

    ClientXdsClient(ManagedChannel channel, Bootstrapper.BootstrapInfo bootstrapInfo, Context context, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, TimeProvider timeProvider, TlsContextManager tlsContextManager) {
        super(channel, bootstrapInfo, context, timeService, backoffPolicyProvider, stopwatchSupplier);
        this.loadStatsManager = new LoadStatsManager2(stopwatchSupplier);
        this.timeProvider = timeProvider;
        this.tlsContextManager = (TlsContextManager)Preconditions.checkNotNull((Object)tlsContextManager, (Object)"tlsContextManager");
        this.lrsClient = new LoadReportClient(this.loadStatsManager, channel, context, bootstrapInfo.getServers().get(0).isUseProtocolV3(), bootstrapInfo.getNode(), this.getSyncContext(), timeService, backoffPolicyProvider, stopwatchSupplier);
    }

    @Override
    protected void handleLdsResponse(String versionInfo, List<Any> resources, String nonce) {
        HashMap<String, ParsedResource> parsedResources = new HashMap<String, ParsedResource>(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<String> retainedRdsResources = new HashSet<String>();
        for (int i = 0; i < resources.size(); ++i) {
            XdsClient.LdsUpdate ldsUpdate;
            Listener listener;
            Any any = resources.get(i);
            boolean isResourceV3 = any.getTypeUrl().equals(AbstractXdsClient.ResourceType.LDS.typeUrl());
            try {
                listener = ClientXdsClient.unpackCompatibleType(any, Listener.class, AbstractXdsClient.ResourceType.LDS.typeUrl(), AbstractXdsClient.ResourceType.LDS.typeUrlV2());
            }
            catch (InvalidProtocolBufferException e) {
                errors.add("LDS response Resource index " + i + " - can't decode Listener: " + (Object)((Object)e));
                continue;
            }
            String listenerName = listener.getName();
            unpackedResources.add(listenerName);
            try {
                ldsUpdate = listener.hasApiListener() ? this.processClientSideListener(listener, retainedRdsResources, enableFaultInjection && isResourceV3) : this.processServerSideListener(listener, retainedRdsResources, enableFaultInjection && isResourceV3);
            }
            catch (ResourceInvalidException e) {
                errors.add("LDS response Listener '" + listenerName + "' validation error: " + e.getMessage());
                continue;
            }
            parsedResources.put(listenerName, new ParsedResource(ldsUpdate, any));
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received LDS Response version {0} nonce {1}. Parsed resources: {2}", versionInfo, nonce, unpackedResources);
        if (!errors.isEmpty()) {
            this.handleResourcesRejected(AbstractXdsClient.ResourceType.LDS, unpackedResources, versionInfo, nonce, errors);
            return;
        }
        this.handleResourcesAccepted(AbstractXdsClient.ResourceType.LDS, parsedResources, versionInfo, nonce);
        for (String string : this.rdsResourceSubscribers.keySet()) {
            if (retainedRdsResources.contains(string)) continue;
            ResourceSubscriber subscriber = this.rdsResourceSubscribers.get(string);
            subscriber.onAbsent();
        }
    }

    private XdsClient.LdsUpdate processClientSideListener(Listener listener, Set<String> rdsResources, boolean parseHttpFilter) throws ResourceInvalidException {
        io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager hcm;
        try {
            hcm = ClientXdsClient.unpackCompatibleType(listener.getApiListener().getApiListener(), io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.class, TYPE_URL_HTTP_CONNECTION_MANAGER, TYPE_URL_HTTP_CONNECTION_MANAGER_V2);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ResourceInvalidException("Could not parse HttpConnectionManager config from ApiListener", e);
        }
        return XdsClient.LdsUpdate.forApiListener(ClientXdsClient.parseHttpConnectionManager(hcm, rdsResources, this.filterRegistry, parseHttpFilter, true));
    }

    private XdsClient.LdsUpdate processServerSideListener(Listener proto, Set<String> rdsResources, boolean parseHttpFilter) throws ResourceInvalidException {
        return XdsClient.LdsUpdate.forTcpListener(ClientXdsClient.parseServerSideListener(proto, rdsResources, this.tlsContextManager, this.filterRegistry, parseHttpFilter));
    }

    @VisibleForTesting
    static EnvoyServerProtoData.Listener parseServerSideListener(Listener proto, Set<String> rdsResources, TlsContextManager tlsContextManager, FilterRegistry filterRegistry, boolean parseHttpFilter) throws ResourceInvalidException {
        if (!proto.getTrafficDirection().equals((Object)TrafficDirection.INBOUND)) {
            throw new ResourceInvalidException("Listener " + proto.getName() + " with invalid traffic direction: " + (Object)((Object)proto.getTrafficDirection()));
        }
        if (!proto.getListenerFiltersList().isEmpty()) {
            throw new ResourceInvalidException("Listener " + proto.getName() + " cannot have listener_filters");
        }
        if (proto.hasUseOriginalDst()) {
            throw new ResourceInvalidException("Listener " + proto.getName() + " cannot have use_original_dst set to true");
        }
        String address = null;
        if (proto.getAddress().hasSocketAddress()) {
            SocketAddress socketAddress = proto.getAddress().getSocketAddress();
            address = socketAddress.getAddress();
            switch (socketAddress.getPortSpecifierCase()) {
                case NAMED_PORT: {
                    address = address + ":" + socketAddress.getNamedPort();
                    break;
                }
                case PORT_VALUE: {
                    address = address + ":" + socketAddress.getPortValue();
                    break;
                }
            }
        }
        ArrayList<EnvoyServerProtoData.FilterChain> filterChains = new ArrayList<EnvoyServerProtoData.FilterChain>();
        HashSet<EnvoyServerProtoData.FilterChainMatch> uniqueSet = new HashSet<EnvoyServerProtoData.FilterChainMatch>();
        for (FilterChain fc : proto.getFilterChainsList()) {
            filterChains.add(ClientXdsClient.parseFilterChain(fc, rdsResources, tlsContextManager, filterRegistry, uniqueSet, parseHttpFilter));
        }
        EnvoyServerProtoData.FilterChain defaultFilterChain = null;
        if (proto.hasDefaultFilterChain()) {
            defaultFilterChain = ClientXdsClient.parseFilterChain(proto.getDefaultFilterChain(), rdsResources, tlsContextManager, filterRegistry, null, parseHttpFilter);
        }
        return new EnvoyServerProtoData.Listener(proto.getName(), address, Collections.unmodifiableList(filterChains), defaultFilterChain);
    }

    @VisibleForTesting
    static EnvoyServerProtoData.FilterChain parseFilterChain(FilterChain proto, Set<String> rdsResources, TlsContextManager tlsContextManager, FilterRegistry filterRegistry, Set<EnvoyServerProtoData.FilterChainMatch> uniqueSet, boolean parseHttpFilters) throws ResourceInvalidException {
        String name;
        HttpConnectionManager httpConnectionManager = null;
        HashSet<String> uniqueNames = new HashSet<String>();
        for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Filter filter : proto.getFiltersList()) {
            io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager hcmProto;
            if (!uniqueNames.add(filter.getName())) {
                throw new ResourceInvalidException("FilterChain " + proto.getName() + " with duplicated filter: " + filter.getName());
            }
            if (!filter.hasTypedConfig()) {
                throw new ResourceInvalidException("FilterChain " + proto.getName() + " contains filter " + filter.getName() + " without typed_config");
            }
            Any any = filter.getTypedConfig();
            if (!any.getTypeUrl().equals(TYPE_URL_HTTP_CONNECTION_MANAGER)) {
                throw new ResourceInvalidException("FilterChain " + proto.getName() + " contains filter " + filter.getName() + " with unsupported typed_config type " + any.getTypeUrl());
            }
            if (httpConnectionManager != null) continue;
            try {
                hcmProto = (io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager)any.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.class);
            }
            catch (InvalidProtocolBufferException e) {
                throw new ResourceInvalidException("FilterChain " + proto.getName() + " with filter " + filter.getName() + " failed to unpack message", e);
            }
            httpConnectionManager = ClientXdsClient.parseHttpConnectionManager(hcmProto, rdsResources, filterRegistry, parseHttpFilters, false);
        }
        if (httpConnectionManager == null) {
            throw new ResourceInvalidException("FilterChain " + proto.getName() + " missing required HttpConnectionManager filter");
        }
        EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext = null;
        if (proto.hasTransportSocket()) {
            DownstreamTlsContext downstreamTlsContextProto;
            if (!TRANSPORT_SOCKET_NAME_TLS.equals(proto.getTransportSocket().getName())) {
                throw new ResourceInvalidException("transport-socket with name " + proto.getTransportSocket().getName() + " not supported.");
            }
            try {
                downstreamTlsContextProto = (DownstreamTlsContext)proto.getTransportSocket().getTypedConfig().unpack(DownstreamTlsContext.class);
            }
            catch (InvalidProtocolBufferException e) {
                throw new ResourceInvalidException("FilterChain " + proto.getName() + " failed to unpack message", e);
            }
            downstreamTlsContext = EnvoyServerProtoData.DownstreamTlsContext.fromEnvoyProtoDownstreamTlsContext(ClientXdsClient.validateDownstreamTlsContext(downstreamTlsContextProto));
        }
        if ((name = proto.getName()).isEmpty()) {
            name = UUID.randomUUID().toString();
        }
        EnvoyServerProtoData.FilterChainMatch filterChainMatch = ClientXdsClient.parseFilterChainMatch(proto.getFilterChainMatch());
        ClientXdsClient.checkForUniqueness(uniqueSet, filterChainMatch);
        return new EnvoyServerProtoData.FilterChain(name, filterChainMatch, httpConnectionManager, downstreamTlsContext, tlsContextManager);
    }

    @VisibleForTesting
    static DownstreamTlsContext validateDownstreamTlsContext(DownstreamTlsContext downstreamTlsContext) throws ResourceInvalidException {
        if (!downstreamTlsContext.hasCommonTlsContext()) {
            throw new ResourceInvalidException("common-tls-context is required in downstream-tls-context");
        }
        ClientXdsClient.validateCommonTlsContext(downstreamTlsContext.getCommonTlsContext(), true);
        if (downstreamTlsContext.hasRequireSni()) {
            throw new ResourceInvalidException("downstream-tls-context with require-sni is not supported");
        }
        if (downstreamTlsContext.hasSessionTicketKeys()) {
            throw new ResourceInvalidException("downstream-tls-context with session_ticket_keys is not supported");
        }
        if (downstreamTlsContext.hasSessionTicketKeysSdsSecretConfig()) {
            throw new ResourceInvalidException("downstream-tls-context with session_ticket_keys_sds_secret_config is not supported");
        }
        if (downstreamTlsContext.hasDisableStatelessSessionResumption()) {
            throw new ResourceInvalidException("downstream-tls-context with disable_stateless_session_resumption is not supported");
        }
        if (downstreamTlsContext.hasSessionTimeout()) {
            throw new ResourceInvalidException("downstream-tls-context with session_timeout is not supported");
        }
        DownstreamTlsContext.OcspStaplePolicy ocspStaplePolicy = downstreamTlsContext.getOcspStaplePolicy();
        if (ocspStaplePolicy != DownstreamTlsContext.OcspStaplePolicy.UNRECOGNIZED && ocspStaplePolicy != DownstreamTlsContext.OcspStaplePolicy.LENIENT_STAPLING) {
            throw new ResourceInvalidException("downstream-tls-context with ocsp_staple_policy value " + ocspStaplePolicy.name() + " is not supported");
        }
        return downstreamTlsContext;
    }

    @VisibleForTesting
    static UpstreamTlsContext validateUpstreamTlsContext(UpstreamTlsContext upstreamTlsContext) throws ResourceInvalidException {
        if (!upstreamTlsContext.hasCommonTlsContext()) {
            throw new ResourceInvalidException("common-tls-context is required in upstream-tls-context");
        }
        ClientXdsClient.validateCommonTlsContext(upstreamTlsContext.getCommonTlsContext(), false);
        if (!Strings.isNullOrEmpty((String)upstreamTlsContext.getSni())) {
            throw new ResourceInvalidException("upstream-tls-context with sni is not supported");
        }
        if (upstreamTlsContext.getAllowRenegotiation()) {
            throw new ResourceInvalidException("upstream-tls-context with allow_renegotiation is not supported");
        }
        if (upstreamTlsContext.hasMaxSessionKeys()) {
            throw new ResourceInvalidException("upstream-tls-context with max_session_keys is not supported");
        }
        return upstreamTlsContext;
    }

    @VisibleForTesting
    static void validateCommonTlsContext(CommonTlsContext commonTlsContext, boolean server) throws ResourceInvalidException {
        if (commonTlsContext.hasCustomHandshaker()) {
            throw new ResourceInvalidException("common-tls-context with custom_handshaker is not supported");
        }
        if (commonTlsContext.hasTlsParams()) {
            throw new ResourceInvalidException("common-tls-context with tls_params is not supported");
        }
        if (commonTlsContext.hasValidationContext()) {
            throw new ResourceInvalidException("common-tls-context with validation_context is not supported");
        }
        if (commonTlsContext.hasValidationContextSdsSecretConfig()) {
            throw new ResourceInvalidException("common-tls-context with validation_context_sds_secret_config is not supported");
        }
        if (commonTlsContext.hasValidationContextCertificateProvider()) {
            throw new ResourceInvalidException("common-tls-context with validation_context_certificate_provider is not supported");
        }
        if (commonTlsContext.hasValidationContextCertificateProviderInstance()) {
            throw new ResourceInvalidException("common-tls-context with validation_context_certificate_provider_instance is not supported");
        }
        if (!commonTlsContext.hasTlsCertificateCertificateProviderInstance()) {
            if (server) {
                throw new ResourceInvalidException("tls_certificate_certificate_provider_instance is required in downstream-tls-context");
            }
            if (commonTlsContext.getTlsCertificatesCount() > 0) {
                throw new ResourceInvalidException("common-tls-context with tls_certificates is not supported");
            }
            if (commonTlsContext.getTlsCertificateSdsSecretConfigsCount() > 0) {
                throw new ResourceInvalidException("common-tls-context with tls_certificate_sds_secret_configs is not supported");
            }
            if (commonTlsContext.hasTlsCertificateCertificateProvider()) {
                throw new ResourceInvalidException("common-tls-context with tls_certificate_certificate_provider is not supported");
            }
        }
        if (!commonTlsContext.hasCombinedValidationContext()) {
            if (!server) {
                throw new ResourceInvalidException("combined_validation_context is required in upstream-tls-context");
            }
        } else {
            CommonTlsContext.CombinedCertificateValidationContext combinedCertificateValidationContext = commonTlsContext.getCombinedValidationContext();
            if (!combinedCertificateValidationContext.hasValidationContextCertificateProviderInstance()) {
                throw new ResourceInvalidException("validation_context_certificate_provider_instance is required in combined_validation_context");
            }
            if (combinedCertificateValidationContext.hasDefaultValidationContext()) {
                CertificateValidationContext certificateValidationContext = combinedCertificateValidationContext.getDefaultValidationContext();
                if (certificateValidationContext.getMatchSubjectAltNamesCount() > 0 && server) {
                    throw new ResourceInvalidException("match_subject_alt_names only allowed in upstream_tls_context");
                }
                if (certificateValidationContext.hasTrustedCa()) {
                    throw new ResourceInvalidException("trusted_ca in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasWatchedDirectory()) {
                    throw new ResourceInvalidException("watched_directory in default_validation_context is not supported");
                }
                if (certificateValidationContext.getVerifyCertificateSpkiCount() > 0) {
                    throw new ResourceInvalidException("verify_certificate_spki in default_validation_context is not supported");
                }
                if (certificateValidationContext.getVerifyCertificateHashCount() > 0) {
                    throw new ResourceInvalidException("verify_certificate_hash in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasRequireSignedCertificateTimestamp()) {
                    throw new ResourceInvalidException("require_signed_certificate_timestamp in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasCrl()) {
                    throw new ResourceInvalidException("crl in default_validation_context is not supported");
                }
                if (certificateValidationContext.getAllowExpiredCertificate()) {
                    throw new ResourceInvalidException("allow_expired_certificate in default_validation_context is not supported");
                }
                CertificateValidationContext.TrustChainVerification trustChainVerification = certificateValidationContext.getTrustChainVerification();
                if (trustChainVerification != CertificateValidationContext.TrustChainVerification.VERIFY_TRUST_CHAIN) {
                    throw new ResourceInvalidException("Only VERIFY_TRUST_CHAIN for trust_chain_verification supported");
                }
                if (certificateValidationContext.hasCustomValidatorConfig()) {
                    throw new ResourceInvalidException("custom_validator_config in default_validation_context is not supported");
                }
            }
        }
    }

    private static void checkForUniqueness(Set<EnvoyServerProtoData.FilterChainMatch> uniqueSet, EnvoyServerProtoData.FilterChainMatch filterChainMatch) throws ResourceInvalidException {
        if (uniqueSet != null) {
            List<EnvoyServerProtoData.FilterChainMatch> crossProduct = ClientXdsClient.getCrossProduct(filterChainMatch);
            for (EnvoyServerProtoData.FilterChainMatch cur : crossProduct) {
                if (uniqueSet.add(cur)) continue;
                throw new ResourceInvalidException("Found duplicate matcher: " + cur);
            }
        }
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> getCrossProduct(EnvoyServerProtoData.FilterChainMatch filterChainMatch) {
        List<EnvoyServerProtoData.FilterChainMatch> expandedList = ClientXdsClient.expandOnPrefixRange(filterChainMatch);
        expandedList = ClientXdsClient.expandOnApplicationProtocols(expandedList);
        expandedList = ClientXdsClient.expandOnSourcePrefixRange(expandedList);
        expandedList = ClientXdsClient.expandOnSourcePorts(expandedList);
        return ClientXdsClient.expandOnServerNames(expandedList);
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnPrefixRange(EnvoyServerProtoData.FilterChainMatch filterChainMatch) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        if (filterChainMatch.getPrefixRanges().isEmpty()) {
            expandedList.add(filterChainMatch);
        } else {
            for (EnvoyServerProtoData.CidrRange cidrRange : filterChainMatch.getPrefixRanges()) {
                expandedList.add(new EnvoyServerProtoData.FilterChainMatch(filterChainMatch.getDestinationPort(), Arrays.asList(cidrRange), Collections.unmodifiableList(filterChainMatch.getApplicationProtocols()), Collections.unmodifiableList(filterChainMatch.getSourcePrefixRanges()), filterChainMatch.getConnectionSourceType(), Collections.unmodifiableList(filterChainMatch.getSourcePorts()), Collections.unmodifiableList(filterChainMatch.getServerNames()), filterChainMatch.getTransportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnApplicationProtocols(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.getApplicationProtocols().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (String applicationProtocol : filterChainMatch.getApplicationProtocols()) {
                expandedList.add(new EnvoyServerProtoData.FilterChainMatch(filterChainMatch.getDestinationPort(), Collections.unmodifiableList(filterChainMatch.getPrefixRanges()), Arrays.asList(applicationProtocol), Collections.unmodifiableList(filterChainMatch.getSourcePrefixRanges()), filterChainMatch.getConnectionSourceType(), Collections.unmodifiableList(filterChainMatch.getSourcePorts()), Collections.unmodifiableList(filterChainMatch.getServerNames()), filterChainMatch.getTransportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnSourcePrefixRange(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.getSourcePrefixRanges().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (EnvoyServerProtoData.CidrRange cidrRange : filterChainMatch.getSourcePrefixRanges()) {
                expandedList.add(new EnvoyServerProtoData.FilterChainMatch(filterChainMatch.getDestinationPort(), Collections.unmodifiableList(filterChainMatch.getPrefixRanges()), Collections.unmodifiableList(filterChainMatch.getApplicationProtocols()), Arrays.asList(cidrRange), filterChainMatch.getConnectionSourceType(), Collections.unmodifiableList(filterChainMatch.getSourcePorts()), Collections.unmodifiableList(filterChainMatch.getServerNames()), filterChainMatch.getTransportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnSourcePorts(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.getSourcePorts().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (Integer sourcePort : filterChainMatch.getSourcePorts()) {
                expandedList.add(new EnvoyServerProtoData.FilterChainMatch(filterChainMatch.getDestinationPort(), Collections.unmodifiableList(filterChainMatch.getPrefixRanges()), Collections.unmodifiableList(filterChainMatch.getApplicationProtocols()), Collections.unmodifiableList(filterChainMatch.getSourcePrefixRanges()), filterChainMatch.getConnectionSourceType(), Arrays.asList(sourcePort), Collections.unmodifiableList(filterChainMatch.getServerNames()), filterChainMatch.getTransportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnServerNames(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.getServerNames().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (String serverName : filterChainMatch.getServerNames()) {
                expandedList.add(new EnvoyServerProtoData.FilterChainMatch(filterChainMatch.getDestinationPort(), Collections.unmodifiableList(filterChainMatch.getPrefixRanges()), Collections.unmodifiableList(filterChainMatch.getApplicationProtocols()), Collections.unmodifiableList(filterChainMatch.getSourcePrefixRanges()), filterChainMatch.getConnectionSourceType(), Collections.unmodifiableList(filterChainMatch.getSourcePorts()), Arrays.asList(serverName), filterChainMatch.getTransportProtocol()));
            }
        }
        return expandedList;
    }

    private static EnvoyServerProtoData.FilterChainMatch parseFilterChainMatch(FilterChainMatch proto) throws ResourceInvalidException {
        EnvoyServerProtoData.ConnectionSourceType sourceType;
        ArrayList<EnvoyServerProtoData.CidrRange> prefixRanges = new ArrayList<EnvoyServerProtoData.CidrRange>();
        ArrayList<EnvoyServerProtoData.CidrRange> sourcePrefixRanges = new ArrayList<EnvoyServerProtoData.CidrRange>();
        try {
            for (CidrRange range : proto.getPrefixRangesList()) {
                prefixRanges.add(new EnvoyServerProtoData.CidrRange(range.getAddressPrefix(), range.getPrefixLen().getValue()));
            }
            for (CidrRange range : proto.getSourcePrefixRangesList()) {
                sourcePrefixRanges.add(new EnvoyServerProtoData.CidrRange(range.getAddressPrefix(), range.getPrefixLen().getValue()));
            }
        }
        catch (UnknownHostException e) {
            throw new ResourceInvalidException("Failed to create CidrRange", e);
        }
        switch (proto.getSourceType()) {
            case ANY: {
                sourceType = EnvoyServerProtoData.ConnectionSourceType.ANY;
                break;
            }
            case EXTERNAL: {
                sourceType = EnvoyServerProtoData.ConnectionSourceType.EXTERNAL;
                break;
            }
            case SAME_IP_OR_LOOPBACK: {
                sourceType = EnvoyServerProtoData.ConnectionSourceType.SAME_IP_OR_LOOPBACK;
                break;
            }
            default: {
                throw new ResourceInvalidException("Unknown source-type: " + (Object)((Object)proto.getSourceType()));
            }
        }
        return new EnvoyServerProtoData.FilterChainMatch(proto.getDestinationPort().getValue(), prefixRanges, (List<String>)proto.getApplicationProtocolsList(), sourcePrefixRanges, sourceType, proto.getSourcePortsList(), (List<String>)proto.getServerNamesList(), proto.getTransportProtocol());
    }

    @VisibleForTesting
    static HttpConnectionManager parseHttpConnectionManager(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager proto, Set<String> rdsResources, FilterRegistry filterRegistry, boolean parseHttpFilter, boolean isForClient) throws ResourceInvalidException {
        HttpProtocolOptions options;
        if (proto.getXffNumTrustedHops() != 0) {
            throw new ResourceInvalidException("HttpConnectionManager with xff_num_trusted_hops unsupported");
        }
        long maxStreamDuration = 0L;
        if (proto.hasCommonHttpProtocolOptions() && (options = proto.getCommonHttpProtocolOptions()).hasMaxStreamDuration()) {
            maxStreamDuration = Durations.toNanos((Duration)options.getMaxStreamDuration());
        }
        ArrayList<Filter.NamedFilterConfig> filterConfigs = null;
        if (parseHttpFilter) {
            filterConfigs = new ArrayList<Filter.NamedFilterConfig>();
            HashSet<String> names = new HashSet<String>();
            for (HttpFilter httpFilter : proto.getHttpFiltersList()) {
                String filterName = httpFilter.getName();
                if (!names.add(filterName)) {
                    throw new ResourceInvalidException("HttpConnectionManager contains duplicate HttpFilter: " + filterName);
                }
                StructOrError<Filter.FilterConfig> filterConfig = ClientXdsClient.parseHttpFilter(httpFilter, filterRegistry, isForClient);
                if (filterConfig == null) continue;
                if (filterConfig.getErrorDetail() != null) {
                    throw new ResourceInvalidException("HttpConnectionManager contains invalid HttpFilter: " + filterConfig.getErrorDetail());
                }
                filterConfigs.add(new Filter.NamedFilterConfig(filterName, (Filter.FilterConfig)((StructOrError)filterConfig).struct));
            }
        }
        if (proto.hasRouteConfig()) {
            ArrayList<io.grpc.xds.VirtualHost> virtualHosts = new ArrayList<io.grpc.xds.VirtualHost>();
            for (VirtualHost virtualHostProto : proto.getRouteConfig().getVirtualHostsList()) {
                StructOrError<io.grpc.xds.VirtualHost> virtualHost = ClientXdsClient.parseVirtualHost(virtualHostProto, filterRegistry, parseHttpFilter);
                if (virtualHost.getErrorDetail() != null) {
                    throw new ResourceInvalidException("HttpConnectionManager contains invalid virtual host: " + virtualHost.getErrorDetail());
                }
                virtualHosts.add(virtualHost.getStruct());
            }
            return HttpConnectionManager.forVirtualHosts(maxStreamDuration, virtualHosts, filterConfigs);
        }
        if (proto.hasRds()) {
            Rds rds = proto.getRds();
            if (!rds.hasConfigSource()) {
                throw new ResourceInvalidException("HttpConnectionManager contains invalid RDS: missing config_source");
            }
            if (!rds.getConfigSource().hasAds()) {
                throw new ResourceInvalidException("HttpConnectionManager contains invalid RDS: must specify ADS");
            }
            rdsResources.add(rds.getRouteConfigName());
            return HttpConnectionManager.forRdsName(maxStreamDuration, rds.getRouteConfigName(), filterConfigs);
        }
        throw new ResourceInvalidException("HttpConnectionManager neither has inlined route_config nor RDS");
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<Filter.FilterConfig> parseHttpFilter(HttpFilter httpFilter, FilterRegistry filterRegistry, boolean isForClient) {
        String filterName = httpFilter.getName();
        boolean isOptional = httpFilter.getIsOptional();
        if (!httpFilter.hasTypedConfig()) {
            if (isOptional) {
                return null;
            }
            return StructOrError.fromError("HttpFilter [" + filterName + "] is not optional and has no typed config");
        }
        Any rawConfig = httpFilter.getTypedConfig();
        String typeUrl = httpFilter.getTypedConfig().getTypeUrl();
        if (typeUrl.equals(TYPE_URL_TYPED_STRUCT)) {
            TypedStruct typedStruct;
            try {
                typedStruct = (TypedStruct)httpFilter.getTypedConfig().unpack(TypedStruct.class);
            }
            catch (InvalidProtocolBufferException e) {
                return StructOrError.fromError("HttpFilter [" + filterName + "] contains invalid proto: " + (Object)((Object)e));
            }
            typeUrl = typedStruct.getTypeUrl();
            rawConfig = typedStruct.getValue();
        }
        Filter filter = filterRegistry.get(typeUrl);
        if (isForClient && !(filter instanceof Filter.ClientInterceptorBuilder) || !isForClient && !(filter instanceof Filter.ServerInterceptorBuilder)) {
            if (isOptional) {
                return null;
            }
            return StructOrError.fromError("HttpFilter [" + filterName + "](" + typeUrl + ") is required but unsupported for " + (isForClient ? "client" : "server"));
        }
        Filter.ConfigOrError<? extends Filter.FilterConfig> filterConfig = filter.parseFilterConfig((Message)rawConfig);
        if (filterConfig.errorDetail != null) {
            return StructOrError.fromError("Invalid filter config for HttpFilter [" + filterName + "]: " + filterConfig.errorDetail);
        }
        return StructOrError.fromStruct(filterConfig.config);
    }

    private static StructOrError<io.grpc.xds.VirtualHost> parseVirtualHost(VirtualHost proto, FilterRegistry filterRegistry, boolean parseHttpFilter) {
        String name = proto.getName();
        ArrayList<VirtualHost.Route> routes = new ArrayList<VirtualHost.Route>(proto.getRoutesCount());
        for (Route routeProto : proto.getRoutesList()) {
            StructOrError<VirtualHost.Route> route = ClientXdsClient.parseRoute(routeProto, filterRegistry, parseHttpFilter);
            if (route == null) continue;
            if (route.getErrorDetail() != null) {
                return StructOrError.fromError("Virtual host [" + name + "] contains invalid route : " + route.getErrorDetail());
            }
            routes.add(route.getStruct());
        }
        if (!parseHttpFilter) {
            return StructOrError.fromStruct(io.grpc.xds.VirtualHost.create(name, (List<String>)proto.getDomainsList(), routes, new HashMap<String, Filter.FilterConfig>()));
        }
        StructOrError<Map<String, Filter.FilterConfig>> overrideConfigs = ClientXdsClient.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
        if (((StructOrError)overrideConfigs).errorDetail != null) {
            return StructOrError.fromError("VirtualHost [" + proto.getName() + "] contains invalid HttpFilter config: " + ((StructOrError)overrideConfigs).errorDetail);
        }
        return StructOrError.fromStruct(io.grpc.xds.VirtualHost.create(name, (List<String>)proto.getDomainsList(), routes, (Map)((StructOrError)overrideConfigs).struct));
    }

    @VisibleForTesting
    static StructOrError<Map<String, Filter.FilterConfig>> parseOverrideFilterConfigs(Map<String, Any> rawFilterConfigMap, FilterRegistry filterRegistry) {
        HashMap overrideConfigs = new HashMap();
        for (String name : rawFilterConfigMap.keySet()) {
            Filter filter;
            Any anyConfig = rawFilterConfigMap.get(name);
            String typeUrl = anyConfig.getTypeUrl();
            boolean isOptional = false;
            if (typeUrl.equals(TYPE_URL_FILTER_CONFIG)) {
                FilterConfig filterConfig;
                try {
                    filterConfig = (FilterConfig)anyConfig.unpack(FilterConfig.class);
                }
                catch (InvalidProtocolBufferException e) {
                    return StructOrError.fromError("FilterConfig [" + name + "] contains invalid proto: " + (Object)((Object)e));
                }
                isOptional = filterConfig.getIsOptional();
                anyConfig = filterConfig.getConfig();
                typeUrl = anyConfig.getTypeUrl();
            }
            Any rawConfig = anyConfig;
            if (typeUrl.equals(TYPE_URL_TYPED_STRUCT)) {
                TypedStruct typedStruct;
                try {
                    typedStruct = (TypedStruct)anyConfig.unpack(TypedStruct.class);
                }
                catch (InvalidProtocolBufferException e) {
                    return StructOrError.fromError("FilterConfig [" + name + "] contains invalid proto: " + (Object)((Object)e));
                }
                typeUrl = typedStruct.getTypeUrl();
                rawConfig = typedStruct.getValue();
            }
            if ((filter = filterRegistry.get(typeUrl)) == null) {
                if (isOptional) continue;
                return StructOrError.fromError("HttpFilter [" + name + "](" + typeUrl + ") is required but unsupported");
            }
            Filter.ConfigOrError<? extends Filter.FilterConfig> filterConfig = filter.parseFilterConfigOverride((Message)rawConfig);
            if (filterConfig.errorDetail != null) {
                return StructOrError.fromError("Invalid filter config for HttpFilter [" + name + "]: " + filterConfig.errorDetail);
            }
            overrideConfigs.put(name, filterConfig.config);
        }
        return StructOrError.fromStruct(overrideConfigs);
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route> parseRoute(Route proto, FilterRegistry filterRegistry, boolean parseHttpFilter) {
        StructOrError<VirtualHost.Route.RouteMatch> routeMatch = ClientXdsClient.parseRouteMatch(proto.getMatch());
        if (routeMatch == null) {
            return null;
        }
        if (routeMatch.getErrorDetail() != null) {
            return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid RouteMatch: " + routeMatch.getErrorDetail());
        }
        Map overrideConfigs = Collections.emptyMap();
        if (parseHttpFilter) {
            StructOrError<Map<String, Filter.FilterConfig>> overrideConfigsOrError = ClientXdsClient.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
            if (((StructOrError)overrideConfigsOrError).errorDetail != null) {
                return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid HttpFilter config: " + ((StructOrError)overrideConfigsOrError).errorDetail);
            }
            overrideConfigs = (Map)((StructOrError)overrideConfigsOrError).struct;
        }
        switch (proto.getActionCase()) {
            case ROUTE: {
                StructOrError<VirtualHost.Route.RouteAction> routeAction = ClientXdsClient.parseRouteAction(proto.getRoute(), filterRegistry, parseHttpFilter);
                if (routeAction == null) {
                    return null;
                }
                if (((StructOrError)routeAction).errorDetail != null) {
                    return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid RouteAction: " + routeAction.getErrorDetail());
                }
                return StructOrError.fromStruct(VirtualHost.Route.forAction((VirtualHost.Route.RouteMatch)((StructOrError)routeMatch).struct, (VirtualHost.Route.RouteAction)((StructOrError)routeAction).struct, overrideConfigs));
            }
            case NON_FORWARDING_ACTION: {
                return StructOrError.fromStruct(VirtualHost.Route.forNonForwardingAction((VirtualHost.Route.RouteMatch)((StructOrError)routeMatch).struct, overrideConfigs));
            }
        }
        return StructOrError.fromError("Route [" + proto.getName() + "] with unknown action type: " + (Object)((Object)proto.getActionCase()));
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteMatch> parseRouteMatch(RouteMatch proto) {
        if (proto.getQueryParametersCount() != 0) {
            return null;
        }
        StructOrError<VirtualHost.Route.RouteMatch.PathMatcher> pathMatch = ClientXdsClient.parsePathMatcher(proto);
        if (pathMatch.getErrorDetail() != null) {
            return StructOrError.fromError(pathMatch.getErrorDetail());
        }
        Matchers.FractionMatcher fractionMatch = null;
        if (proto.hasRuntimeFraction()) {
            StructOrError<Matchers.FractionMatcher> parsedFraction = ClientXdsClient.parseFractionMatcher(proto.getRuntimeFraction().getDefaultValue());
            if (parsedFraction.getErrorDetail() != null) {
                return StructOrError.fromError(parsedFraction.getErrorDetail());
            }
            fractionMatch = parsedFraction.getStruct();
        }
        ArrayList<Matchers.HeaderMatcher> headerMatchers = new ArrayList<Matchers.HeaderMatcher>();
        for (HeaderMatcher hmProto : proto.getHeadersList()) {
            StructOrError<Matchers.HeaderMatcher> headerMatcher = ClientXdsClient.parseHeaderMatcher(hmProto);
            if (headerMatcher.getErrorDetail() != null) {
                return StructOrError.fromError(headerMatcher.getErrorDetail());
            }
            headerMatchers.add(headerMatcher.getStruct());
        }
        return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.create(pathMatch.getStruct(), headerMatchers, fractionMatch));
    }

    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteMatch.PathMatcher> parsePathMatcher(RouteMatch proto) {
        boolean caseSensitive = proto.getCaseSensitive().getValue();
        switch (proto.getPathSpecifierCase()) {
            case PREFIX: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromPrefix(proto.getPrefix(), caseSensitive));
            }
            case PATH: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromPath(proto.getPath(), caseSensitive));
            }
            case SAFE_REGEX: {
                Pattern safeRegEx;
                String rawPattern = proto.getSafeRegex().getRegex();
                try {
                    safeRegEx = Pattern.compile((String)rawPattern);
                }
                catch (PatternSyntaxException e) {
                    return StructOrError.fromError("Malformed safe regex pattern: " + e.getMessage());
                }
                return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromRegEx(safeRegEx));
            }
        }
        return StructOrError.fromError("Unknown path match type");
    }

    private static StructOrError<Matchers.FractionMatcher> parseFractionMatcher(FractionalPercent proto) {
        int numerator = proto.getNumerator();
        int denominator = 0;
        switch (proto.getDenominator()) {
            case HUNDRED: {
                denominator = 100;
                break;
            }
            case TEN_THOUSAND: {
                denominator = 10000;
                break;
            }
            case MILLION: {
                denominator = 1000000;
                break;
            }
            default: {
                return StructOrError.fromError("Unrecognized fractional percent denominator: " + (Object)((Object)proto.getDenominator()));
            }
        }
        return StructOrError.fromStruct(Matchers.FractionMatcher.create(numerator, denominator));
    }

    @VisibleForTesting
    static StructOrError<Matchers.HeaderMatcher> parseHeaderMatcher(HeaderMatcher proto) {
        switch (proto.getHeaderMatchSpecifierCase()) {
            case EXACT_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forExactValue(proto.getName(), proto.getExactMatch(), proto.getInvertMatch()));
            }
            case SAFE_REGEX_MATCH: {
                Pattern safeRegExMatch;
                String rawPattern = proto.getSafeRegexMatch().getRegex();
                try {
                    safeRegExMatch = Pattern.compile((String)rawPattern);
                }
                catch (PatternSyntaxException e) {
                    return StructOrError.fromError("HeaderMatcher [" + proto.getName() + "] contains malformed safe regex pattern: " + e.getMessage());
                }
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forSafeRegEx(proto.getName(), safeRegExMatch, proto.getInvertMatch()));
            }
            case RANGE_MATCH: {
                Matchers.HeaderMatcher.Range rangeMatch = Matchers.HeaderMatcher.Range.create(proto.getRangeMatch().getStart(), proto.getRangeMatch().getEnd());
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forRange(proto.getName(), rangeMatch, proto.getInvertMatch()));
            }
            case PRESENT_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forPresent(proto.getName(), proto.getPresentMatch(), proto.getInvertMatch()));
            }
            case PREFIX_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forPrefix(proto.getName(), proto.getPrefixMatch(), proto.getInvertMatch()));
            }
            case SUFFIX_MATCH: {
                return StructOrError.fromStruct(Matchers.HeaderMatcher.forSuffix(proto.getName(), proto.getSuffixMatch(), proto.getInvertMatch()));
            }
        }
        return StructOrError.fromError("Unknown header matcher type");
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteAction> parseRouteAction(RouteAction proto, FilterRegistry filterRegistry, boolean parseHttpFilter) {
        StructOrError<VirtualHost.Route.RouteAction.RetryPolicy> retryPolicyOrError;
        Long timeoutNano = null;
        if (proto.hasMaxStreamDuration()) {
            RouteAction.MaxStreamDuration maxStreamDuration = proto.getMaxStreamDuration();
            if (maxStreamDuration.hasGrpcTimeoutHeaderMax()) {
                timeoutNano = Durations.toNanos((Duration)maxStreamDuration.getGrpcTimeoutHeaderMax());
            } else if (maxStreamDuration.hasMaxStreamDuration()) {
                timeoutNano = Durations.toNanos((Duration)maxStreamDuration.getMaxStreamDuration());
            }
        }
        VirtualHost.Route.RouteAction.RetryPolicy retryPolicy = null;
        if (enableRetry && proto.hasRetryPolicy() && (retryPolicyOrError = ClientXdsClient.parseRetryPolicy(proto.getRetryPolicy())) != null) {
            if (((StructOrError)retryPolicyOrError).errorDetail != null) {
                return StructOrError.fromError(((StructOrError)retryPolicyOrError).errorDetail);
            }
            retryPolicy = (VirtualHost.Route.RouteAction.RetryPolicy)((StructOrError)retryPolicyOrError).struct;
        }
        ArrayList<VirtualHost.Route.RouteAction.HashPolicy> hashPolicies = new ArrayList<VirtualHost.Route.RouteAction.HashPolicy>();
        for (RouteAction.HashPolicy config : proto.getHashPolicyList()) {
            VirtualHost.Route.RouteAction.HashPolicy policy = null;
            boolean terminal = config.getTerminal();
            switch (config.getPolicySpecifierCase()) {
                case HEADER: {
                    RouteAction.HashPolicy.Header headerCfg = config.getHeader();
                    Pattern regEx = null;
                    String regExSubstitute = null;
                    if (headerCfg.hasRegexRewrite() && headerCfg.getRegexRewrite().hasPattern() && headerCfg.getRegexRewrite().getPattern().hasGoogleRe2()) {
                        regEx = Pattern.compile((String)headerCfg.getRegexRewrite().getPattern().getRegex());
                        regExSubstitute = headerCfg.getRegexRewrite().getSubstitution();
                    }
                    policy = VirtualHost.Route.RouteAction.HashPolicy.forHeader(terminal, headerCfg.getHeaderName(), regEx, regExSubstitute);
                    break;
                }
                case FILTER_STATE: {
                    if (!config.getFilterState().getKey().equals(HASH_POLICY_FILTER_STATE_KEY)) break;
                    policy = VirtualHost.Route.RouteAction.HashPolicy.forChannelId(terminal);
                    break;
                }
            }
            if (policy == null) continue;
            hashPolicies.add(policy);
        }
        switch (proto.getClusterSpecifierCase()) {
            case CLUSTER: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forCluster(proto.getCluster(), hashPolicies, timeoutNano, retryPolicy));
            }
            case CLUSTER_HEADER: {
                return null;
            }
            case WEIGHTED_CLUSTERS: {
                List<WeightedCluster.ClusterWeight> clusterWeights = proto.getWeightedClusters().getClustersList();
                if (clusterWeights.isEmpty()) {
                    return StructOrError.fromError("No cluster found in weighted cluster list");
                }
                ArrayList<VirtualHost.Route.RouteAction.ClusterWeight> weightedClusters = new ArrayList<VirtualHost.Route.RouteAction.ClusterWeight>();
                for (WeightedCluster.ClusterWeight clusterWeight : clusterWeights) {
                    StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> clusterWeightOrError = ClientXdsClient.parseClusterWeight(clusterWeight, filterRegistry, parseHttpFilter);
                    if (clusterWeightOrError.getErrorDetail() != null) {
                        return StructOrError.fromError("RouteAction contains invalid ClusterWeight: " + clusterWeightOrError.getErrorDetail());
                    }
                    weightedClusters.add(clusterWeightOrError.getStruct());
                }
                return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forWeightedClusters(weightedClusters, hashPolicies, timeoutNano, retryPolicy));
            }
        }
        return StructOrError.fromError("Unknown cluster specifier: " + (Object)((Object)proto.getClusterSpecifierCase()));
    }

    @Nullable
    private static StructOrError<VirtualHost.Route.RouteAction.RetryPolicy> parseRetryPolicy(RetryPolicy retryPolicyProto) {
        int maxAttempts = 2;
        if (retryPolicyProto.hasNumRetries()) {
            maxAttempts = retryPolicyProto.getNumRetries().getValue() + 1;
        }
        Duration initialBackoff = Durations.fromMillis((long)25L);
        Duration maxBackoff = Durations.fromMillis((long)250L);
        if (retryPolicyProto.hasRetryBackOff()) {
            RetryPolicy.RetryBackOff retryBackOff = retryPolicyProto.getRetryBackOff();
            if (!retryBackOff.hasBaseInterval()) {
                return StructOrError.fromError("No base_interval specified in retry_backoff");
            }
            Duration originalInitialBackoff = initialBackoff = retryBackOff.getBaseInterval();
            if (Durations.compare((Duration)initialBackoff, (Duration)Durations.ZERO) <= 0) {
                return StructOrError.fromError("base_interval in retry_backoff must be positive");
            }
            if (Durations.compare((Duration)initialBackoff, (Duration)Durations.fromMillis((long)1L)) < 0) {
                initialBackoff = Durations.fromMillis((long)1L);
            }
            if (retryBackOff.hasMaxInterval()) {
                maxBackoff = retryPolicyProto.getRetryBackOff().getMaxInterval();
                if (Durations.compare((Duration)maxBackoff, (Duration)originalInitialBackoff) < 0) {
                    return StructOrError.fromError("max_interval in retry_backoff cannot be less than base_interval");
                }
                if (Durations.compare((Duration)maxBackoff, (Duration)Durations.fromMillis((long)1L)) < 0) {
                    maxBackoff = Durations.fromMillis((long)1L);
                }
            } else {
                maxBackoff = Durations.fromNanos((long)(Durations.toNanos((Duration)initialBackoff) * 10L));
            }
        }
        Iterable retryOns = Splitter.on((char)',').split((CharSequence)retryPolicyProto.getRetryOn());
        ImmutableList.Builder retryableStatusCodesBuilder = ImmutableList.builder();
        for (String retryOn : retryOns) {
            Status.Code code;
            try {
                code = Status.Code.valueOf((String)retryOn.toUpperCase(Locale.US).replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            if (!SUPPORTED_RETRYABLE_CODES.contains(code)) {
                return null;
            }
            retryableStatusCodesBuilder.add((Object)code);
        }
        ImmutableList retryableStatusCodes = retryableStatusCodesBuilder.build();
        if (!retryableStatusCodes.isEmpty()) {
            return StructOrError.fromStruct(VirtualHost.Route.RouteAction.RetryPolicy.create(maxAttempts, (List<Status.Code>)retryableStatusCodes, initialBackoff, maxBackoff, null));
        }
        return null;
    }

    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> parseClusterWeight(WeightedCluster.ClusterWeight proto, FilterRegistry filterRegistry, boolean parseHttpFilter) {
        if (!parseHttpFilter) {
            return StructOrError.fromStruct(VirtualHost.Route.RouteAction.ClusterWeight.create(proto.getName(), proto.getWeight().getValue(), new HashMap<String, Filter.FilterConfig>()));
        }
        StructOrError<Map<String, Filter.FilterConfig>> overrideConfigs = ClientXdsClient.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
        if (((StructOrError)overrideConfigs).errorDetail != null) {
            return StructOrError.fromError("ClusterWeight [" + proto.getName() + "] contains invalid HttpFilter config: " + ((StructOrError)overrideConfigs).errorDetail);
        }
        return StructOrError.fromStruct(VirtualHost.Route.RouteAction.ClusterWeight.create(proto.getName(), proto.getWeight().getValue(), (Map)((StructOrError)overrideConfigs).struct));
    }

    @Override
    protected void handleRdsResponse(String versionInfo, List<Any> resources, String nonce) {
        HashMap<String, ParsedResource> parsedResources = new HashMap<String, ParsedResource>(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < resources.size(); ++i) {
            XdsClient.RdsUpdate rdsUpdate;
            RouteConfiguration routeConfig;
            Any resource = resources.get(i);
            try {
                routeConfig = ClientXdsClient.unpackCompatibleType(resource, RouteConfiguration.class, AbstractXdsClient.ResourceType.RDS.typeUrl(), AbstractXdsClient.ResourceType.RDS.typeUrlV2());
            }
            catch (InvalidProtocolBufferException e) {
                errors.add("RDS response Resource index " + i + " - can't decode RouteConfiguration: " + (Object)((Object)e));
                continue;
            }
            String routeConfigName = routeConfig.getName();
            unpackedResources.add(routeConfigName);
            boolean isResourceV3 = resource.getTypeUrl().equals(AbstractXdsClient.ResourceType.RDS.typeUrl());
            try {
                rdsUpdate = ClientXdsClient.processRouteConfiguration(routeConfig, this.filterRegistry, enableFaultInjection && isResourceV3);
            }
            catch (ResourceInvalidException e) {
                errors.add("RDS response RouteConfiguration '" + routeConfigName + "' validation error: " + e.getMessage());
                continue;
            }
            parsedResources.put(routeConfigName, new ParsedResource(rdsUpdate, resource));
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received RDS Response version {0} nonce {1}. Parsed resources: {2}", versionInfo, nonce, unpackedResources);
        if (!errors.isEmpty()) {
            this.handleResourcesRejected(AbstractXdsClient.ResourceType.RDS, unpackedResources, versionInfo, nonce, errors);
        } else {
            this.handleResourcesAccepted(AbstractXdsClient.ResourceType.RDS, parsedResources, versionInfo, nonce);
        }
    }

    private static XdsClient.RdsUpdate processRouteConfiguration(RouteConfiguration routeConfig, FilterRegistry filterRegistry, boolean parseHttpFilter) throws ResourceInvalidException {
        ArrayList<io.grpc.xds.VirtualHost> virtualHosts = new ArrayList<io.grpc.xds.VirtualHost>(routeConfig.getVirtualHostsCount());
        for (VirtualHost virtualHostProto : routeConfig.getVirtualHostsList()) {
            StructOrError<io.grpc.xds.VirtualHost> virtualHost = ClientXdsClient.parseVirtualHost(virtualHostProto, filterRegistry, parseHttpFilter);
            if (virtualHost.getErrorDetail() != null) {
                throw new ResourceInvalidException("RouteConfiguration contains invalid virtual host: " + virtualHost.getErrorDetail());
            }
            virtualHosts.add(virtualHost.getStruct());
        }
        return new XdsClient.RdsUpdate(virtualHosts);
    }

    @Override
    protected void handleCdsResponse(String versionInfo, List<Any> resources, String nonce) {
        HashMap<String, ParsedResource> parsedResources = new HashMap<String, ParsedResource>(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<String> retainedEdsResources = new HashSet<String>();
        for (int i = 0; i < resources.size(); ++i) {
            XdsClient.CdsUpdate cdsUpdate;
            Cluster cluster;
            Any any = resources.get(i);
            try {
                cluster = ClientXdsClient.unpackCompatibleType(any, Cluster.class, AbstractXdsClient.ResourceType.CDS.typeUrl(), AbstractXdsClient.ResourceType.CDS.typeUrlV2());
            }
            catch (InvalidProtocolBufferException e) {
                errors.add("CDS response Resource index " + i + " - can't decode Cluster: " + (Object)((Object)e));
                continue;
            }
            String clusterName = cluster.getName();
            if (!this.cdsResourceSubscribers.containsKey(clusterName)) continue;
            unpackedResources.add(clusterName);
            try {
                cdsUpdate = ClientXdsClient.parseCluster(cluster, retainedEdsResources);
            }
            catch (ResourceInvalidException e) {
                errors.add("CDS response Cluster '" + clusterName + "' validation error: " + e.getMessage());
                continue;
            }
            parsedResources.put(clusterName, new ParsedResource(cdsUpdate, any));
        }
        this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Received CDS Response version {0} nonce {1}. Parsed resources: {2}", versionInfo, nonce, unpackedResources);
        if (!errors.isEmpty()) {
            this.handleResourcesRejected(AbstractXdsClient.ResourceType.CDS, unpackedResources, versionInfo, nonce, errors);
            return;
        }
        this.handleResourcesAccepted(AbstractXdsClient.ResourceType.CDS, parsedResources, versionInfo, nonce);
        for (String string : this.edsResourceSubscribers.keySet()) {
            ResourceSubscriber subscriber = this.edsResourceSubscribers.get(string);
            if (retainedEdsResources.contains(string)) continue;
            subscriber.onAbsent();
        }
    }

    @VisibleForTesting
    static XdsClient.CdsUpdate parseCluster(Cluster cluster, Set<String> retainedEdsResources) throws ResourceInvalidException {
        StructOrError<XdsClient.CdsUpdate.Builder> structOrError;
        switch (cluster.getClusterDiscoveryTypeCase()) {
            case TYPE: {
                structOrError = ClientXdsClient.parseNonAggregateCluster(cluster, retainedEdsResources);
                break;
            }
            case CLUSTER_TYPE: {
                structOrError = ClientXdsClient.parseAggregateCluster(cluster);
                break;
            }
            default: {
                throw new ResourceInvalidException("Cluster " + cluster.getName() + ": unspecified cluster discovery type");
            }
        }
        if (structOrError.getErrorDetail() != null) {
            throw new ResourceInvalidException(structOrError.getErrorDetail());
        }
        XdsClient.CdsUpdate.Builder updateBuilder = structOrError.getStruct();
        if (cluster.getLbPolicy() == Cluster.LbPolicy.RING_HASH) {
            long maxRingSize;
            Cluster.RingHashLbConfig lbConfig = cluster.getRingHashLbConfig();
            long minRingSize = lbConfig.hasMinimumRingSize() ? lbConfig.getMinimumRingSize().getValue() : 1024L;
            long l = maxRingSize = lbConfig.hasMaximumRingSize() ? lbConfig.getMaximumRingSize().getValue() : 0x800000L;
            if (lbConfig.getHashFunction() != Cluster.RingHashLbConfig.HashFunction.XX_HASH || minRingSize > maxRingSize || maxRingSize > 0x800000L) {
                throw new ResourceInvalidException("Cluster " + cluster.getName() + ": invalid ring_hash_lb_config: " + lbConfig);
            }
            updateBuilder.ringHashLbPolicy(minRingSize, maxRingSize);
        } else if (cluster.getLbPolicy() == Cluster.LbPolicy.ROUND_ROBIN) {
            updateBuilder.roundRobinLbPolicy();
        } else {
            throw new ResourceInvalidException("Cluster " + cluster.getName() + ": unsupported lb policy: " + (Object)((Object)cluster.getLbPolicy()));
        }
        return updateBuilder.build();
    }

    private static StructOrError<XdsClient.CdsUpdate.Builder> parseAggregateCluster(Cluster cluster) {
        ClusterConfig clusterConfig;
        String clusterName = cluster.getName();
        Cluster.CustomClusterType customType = cluster.getClusterType();
        String typeName = customType.getName();
        if (!typeName.equals(AGGREGATE_CLUSTER_TYPE_NAME)) {
            return StructOrError.fromError("Cluster " + clusterName + ": unsupported custom cluster type: " + typeName);
        }
        try {
            clusterConfig = ClientXdsClient.unpackCompatibleType(customType.getTypedConfig(), ClusterConfig.class, TYPE_URL_CLUSTER_CONFIG, TYPE_URL_CLUSTER_CONFIG_V2);
        }
        catch (InvalidProtocolBufferException e) {
            return StructOrError.fromError("Cluster " + clusterName + ": malformed ClusterConfig: " + (Object)((Object)e));
        }
        return StructOrError.fromStruct(XdsClient.CdsUpdate.forAggregate(clusterName, (List<String>)clusterConfig.getClustersList()));
    }

    private static StructOrError<XdsClient.CdsUpdate.Builder> parseNonAggregateCluster(Cluster cluster, Set<String> edsResources) {
        Cluster.DiscoveryType type;
        String clusterName = cluster.getName();
        String lrsServerName = null;
        Long maxConcurrentRequests = null;
        EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = null;
        if (cluster.hasLrsServer()) {
            if (!cluster.getLrsServer().hasSelf()) {
                return StructOrError.fromError("Cluster " + clusterName + ": only support LRS for the same management server");
            }
            lrsServerName = "";
        }
        if (cluster.hasCircuitBreakers()) {
            List<CircuitBreakers.Thresholds> thresholds = cluster.getCircuitBreakers().getThresholdsList();
            for (CircuitBreakers.Thresholds threshold : thresholds) {
                if (threshold.getPriority() != RoutingPriority.DEFAULT || !threshold.hasMaxRequests()) continue;
                maxConcurrentRequests = threshold.getMaxRequests().getValue();
            }
        }
        if (cluster.hasTransportSocket()) {
            if (!TRANSPORT_SOCKET_NAME_TLS.equals(cluster.getTransportSocket().getName())) {
                return StructOrError.fromError("transport-socket with name " + cluster.getTransportSocket().getName() + " not supported.");
            }
            try {
                upstreamTlsContext = EnvoyServerProtoData.UpstreamTlsContext.fromEnvoyProtoUpstreamTlsContext(ClientXdsClient.validateUpstreamTlsContext(ClientXdsClient.unpackCompatibleType(cluster.getTransportSocket().getTypedConfig(), UpstreamTlsContext.class, TYPE_URL_UPSTREAM_TLS_CONTEXT, TYPE_URL_UPSTREAM_TLS_CONTEXT_V2)));
            }
            catch (InvalidProtocolBufferException | ResourceInvalidException e) {
                return StructOrError.fromError("Cluster " + clusterName + ": malformed UpstreamTlsContext: " + e);
            }
        }
        if ((type = cluster.getType()) == Cluster.DiscoveryType.EDS) {
            String edsServiceName = null;
            Cluster.EdsClusterConfig edsClusterConfig = cluster.getEdsClusterConfig();
            if (!edsClusterConfig.getEdsConfig().hasAds()) {
                return StructOrError.fromError("Cluster " + clusterName + ": field eds_cluster_config must be set to indicate to use EDS over ADS.");
            }
            if (!edsClusterConfig.getServiceName().isEmpty()) {
                edsServiceName = edsClusterConfig.getServiceName();
                edsResources.add(edsServiceName);
            } else {
                edsResources.add(clusterName);
            }
            return StructOrError.fromStruct(XdsClient.CdsUpdate.forEds(clusterName, edsServiceName, lrsServerName, maxConcurrentRequests, upstreamTlsContext));
        }
        if (type.equals((Object)Cluster.DiscoveryType.LOGICAL_DNS)) {
            if (!cluster.hasLoadAssignment()) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have a single host");
            }
            ClusterLoadAssignment assignment = cluster.getLoadAssignment();
            if (assignment.getEndpointsCount() != 1 || assignment.getEndpoints(0).getLbEndpointsCount() != 1) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have a single locality_lb_endpoint and a single lb_endpoint");
            }
            LbEndpoint lbEndpoint = assignment.getEndpoints(0).getLbEndpoints(0);
            if (!(lbEndpoint.hasEndpoint() && lbEndpoint.getEndpoint().hasAddress() && lbEndpoint.getEndpoint().getAddress().hasSocketAddress())) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have an endpoint with address and socket_address");
            }
            SocketAddress socketAddress = lbEndpoint.getEndpoint().getAddress().getSocketAddress();
            if (!socketAddress.getResolverName().isEmpty()) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL DNS clusters must NOT have a custom resolver name set");
            }
            if (socketAddress.getPortSpecifierCase() != SocketAddress.PortSpecifierCase.PORT_VALUE) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL DNS clusters socket_address must have port_value");
            }
            String dnsHostName = String.format("%s:%d", socketAddress.getAddress(), socketAddress.getPortValue());
            return StructOrError.fromStruct(XdsClient.CdsUpdate.forLogicalDns(clusterName, dnsHostName, lrsServerName, maxConcurrentRequests, upstreamTlsContext));
        }
        return StructOrError.fromError("Cluster " + clusterName + ": unsupported built-in discovery type: " + (Object)((Object)type));
    }

    @Override
    protected void handleEdsResponse(String versionInfo, List<Any> resources, String nonce) {
        HashMap<String, ParsedResource> parsedResources = new HashMap<String, ParsedResource>(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < resources.size(); ++i) {
            XdsClient.EdsUpdate edsUpdate;
            ClusterLoadAssignment assignment;
            Any resource = resources.get(i);
            try {
                assignment = ClientXdsClient.unpackCompatibleType(resource, ClusterLoadAssignment.class, AbstractXdsClient.ResourceType.EDS.typeUrl(), AbstractXdsClient.ResourceType.EDS.typeUrlV2());
            }
            catch (InvalidProtocolBufferException e) {
                errors.add("EDS response Resource index " + i + " - can't decode ClusterLoadAssignment: " + (Object)((Object)e));
                continue;
            }
            String clusterName = assignment.getClusterName();
            if (!this.edsResourceSubscribers.containsKey(clusterName)) continue;
            unpackedResources.add(clusterName);
            try {
                edsUpdate = ClientXdsClient.processClusterLoadAssignment(assignment);
            }
            catch (ResourceInvalidException e) {
                errors.add("EDS response ClusterLoadAssignment '" + clusterName + "' validation error: " + e.getMessage());
                continue;
            }
            parsedResources.put(clusterName, new ParsedResource(edsUpdate, resource));
        }
        if (!errors.isEmpty()) {
            this.handleResourcesRejected(AbstractXdsClient.ResourceType.EDS, unpackedResources, versionInfo, nonce, errors);
        } else {
            this.handleResourcesAccepted(AbstractXdsClient.ResourceType.EDS, parsedResources, versionInfo, nonce);
        }
    }

    private static XdsClient.EdsUpdate processClusterLoadAssignment(ClusterLoadAssignment assignment) throws ResourceInvalidException {
        HashSet<Integer> priorities = new HashSet<Integer>();
        LinkedHashMap<io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap = new LinkedHashMap<io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints>();
        ArrayList<Endpoints.DropOverload> dropOverloads = new ArrayList<Endpoints.DropOverload>();
        int maxPriority = -1;
        for (LocalityLbEndpoints localityLbEndpointsProto : assignment.getEndpointsList()) {
            StructOrError<Endpoints.LocalityLbEndpoints> structOrError = ClientXdsClient.parseLocalityLbEndpoints(localityLbEndpointsProto);
            if (structOrError == null) continue;
            if (structOrError.getErrorDetail() != null) {
                throw new ResourceInvalidException(structOrError.getErrorDetail());
            }
            Endpoints.LocalityLbEndpoints localityLbEndpoints = structOrError.getStruct();
            maxPriority = Math.max(maxPriority, localityLbEndpoints.priority());
            priorities.add(localityLbEndpoints.priority());
            localityLbEndpointsMap.put(ClientXdsClient.parseLocality(localityLbEndpointsProto.getLocality()), localityLbEndpoints);
        }
        if (priorities.size() != maxPriority + 1) {
            throw new ResourceInvalidException("ClusterLoadAssignment has sparse priorities");
        }
        for (ClusterLoadAssignment.Policy.DropOverload dropOverloadProto : assignment.getPolicy().getDropOverloadsList()) {
            dropOverloads.add(ClientXdsClient.parseDropOverload(dropOverloadProto));
        }
        return new XdsClient.EdsUpdate(assignment.getClusterName(), localityLbEndpointsMap, dropOverloads);
    }

    private static io.grpc.xds.Locality parseLocality(Locality proto) {
        return io.grpc.xds.Locality.create(proto.getRegion(), proto.getZone(), proto.getSubZone());
    }

    private static Endpoints.DropOverload parseDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
        return Endpoints.DropOverload.create(proto.getCategory(), ClientXdsClient.getRatePerMillion(proto.getDropPercentage()));
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<Endpoints.LocalityLbEndpoints> parseLocalityLbEndpoints(LocalityLbEndpoints proto) {
        if (!proto.hasLoadBalancingWeight() || proto.getLoadBalancingWeight().getValue() < 1) {
            return null;
        }
        if (proto.getPriority() < 0) {
            return StructOrError.fromError("negative priority");
        }
        ArrayList<Endpoints.LbEndpoint> endpoints = new ArrayList<Endpoints.LbEndpoint>(proto.getLbEndpointsCount());
        for (LbEndpoint endpoint : proto.getLbEndpointsList()) {
            if (!endpoint.hasEndpoint() || !endpoint.getEndpoint().hasAddress()) {
                return StructOrError.fromError("LbEndpoint with no endpoint/address");
            }
            SocketAddress socketAddress = endpoint.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            boolean isHealthy = endpoint.getHealthStatus() == HealthStatus.HEALTHY || endpoint.getHealthStatus() == HealthStatus.UNKNOWN;
            endpoints.add(Endpoints.LbEndpoint.create(new EquivalentAddressGroup((List)ImmutableList.of((Object)addr)), endpoint.getLoadBalancingWeight().getValue(), isHealthy));
        }
        return StructOrError.fromStruct(Endpoints.LocalityLbEndpoints.create(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority()));
    }

    private static <T extends Message> T unpackCompatibleType(Any any, Class<T> clazz, String typeUrl, String compatibleTypeUrl) throws InvalidProtocolBufferException {
        if (any.getTypeUrl().equals(compatibleTypeUrl)) {
            any = any.toBuilder().setTypeUrl(typeUrl).build();
        }
        return (T)any.unpack(clazz);
    }

    private static int getRatePerMillion(FractionalPercent percent) {
        int numerator = percent.getNumerator();
        FractionalPercent.DenominatorType type = percent.getDenominator();
        switch (type) {
            case TEN_THOUSAND: {
                numerator *= 100;
                break;
            }
            case HUNDRED: {
                numerator *= 10000;
                break;
            }
            case MILLION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown denominator type of " + percent);
            }
        }
        if (numerator > 1000000 || numerator < 0) {
            numerator = 1000000;
        }
        return numerator;
    }

    @Override
    protected void handleStreamClosed(Status error) {
        this.cleanUpResourceTimers();
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.onError(error);
        }
    }

    @Override
    protected void handleStreamRestarted() {
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.restartTimer();
        }
    }

    @Override
    protected void handleShutdown() {
        if (this.reportingLoad) {
            this.lrsClient.stopLoadReporting();
        }
        this.cleanUpResourceTimers();
    }

    private Map<String, ResourceSubscriber> getSubscribedResourcesMap(AbstractXdsClient.ResourceType type) {
        switch (type) {
            case LDS: {
                return this.ldsResourceSubscribers;
            }
            case RDS: {
                return this.rdsResourceSubscribers;
            }
            case CDS: {
                return this.cdsResourceSubscribers;
            }
            case EDS: {
                return this.edsResourceSubscribers;
            }
        }
        throw new AssertionError((Object)"Unknown resource type");
    }

    @Override
    @Nullable
    Collection<String> getSubscribedResources(AbstractXdsClient.ResourceType type) {
        Map<String, ResourceSubscriber> resources = this.getSubscribedResourcesMap(type);
        return resources.isEmpty() ? null : resources.keySet();
    }

    @Override
    Map<String, XdsClient.ResourceMetadata> getSubscribedResourcesMetadata(AbstractXdsClient.ResourceType type) {
        HashMap<String, XdsClient.ResourceMetadata> metadataMap = new HashMap<String, XdsClient.ResourceMetadata>();
        for (Map.Entry<String, ResourceSubscriber> entry : this.getSubscribedResourcesMap(type).entrySet()) {
            metadataMap.put(entry.getKey(), entry.getValue().metadata);
        }
        return metadataMap;
    }

    @Override
    TlsContextManager getTlsContextManager() {
        return this.tlsContextManager;
    }

    @Override
    void watchLdsResource(final String resourceName, final XdsClient.LdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.ldsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe LDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.LDS, resourceName);
                    ClientXdsClient.this.ldsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.LDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelLdsResourceWatch(final String resourceName, final XdsClient.LdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.ldsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe LDS resource {0}", resourceName);
                    ClientXdsClient.this.ldsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.LDS);
                }
            }
        });
    }

    @Override
    void watchRdsResource(final String resourceName, final XdsClient.RdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.rdsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe RDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.RDS, resourceName);
                    ClientXdsClient.this.rdsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.RDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelRdsResourceWatch(final String resourceName, final XdsClient.RdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.rdsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe RDS resource {0}", resourceName);
                    ClientXdsClient.this.rdsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.RDS);
                }
            }
        });
    }

    @Override
    void watchCdsResource(final String resourceName, final XdsClient.CdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.cdsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe CDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.CDS, resourceName);
                    ClientXdsClient.this.cdsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.CDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelCdsResourceWatch(final String resourceName, final XdsClient.CdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.cdsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe CDS resource {0}", resourceName);
                    ClientXdsClient.this.cdsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.CDS);
                }
            }
        });
    }

    @Override
    void watchEdsResource(final String resourceName, final XdsClient.EdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.edsResourceSubscribers.get(resourceName);
                if (subscriber == null) {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Subscribe EDS resource {0}", resourceName);
                    subscriber = new ResourceSubscriber(AbstractXdsClient.ResourceType.EDS, resourceName);
                    ClientXdsClient.this.edsResourceSubscribers.put(resourceName, subscriber);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.EDS);
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    void cancelEdsResourceWatch(final String resourceName, final XdsClient.EdsResourceWatcher watcher) {
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)ClientXdsClient.this.edsResourceSubscribers.get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.stopTimer();
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe EDS resource {0}", resourceName);
                    ClientXdsClient.this.edsResourceSubscribers.remove(resourceName);
                    ClientXdsClient.this.adjustResourceSubscription(AbstractXdsClient.ResourceType.EDS);
                }
            }
        });
    }

    @Override
    LoadStatsManager2.ClusterDropStats addClusterDropStats(String clusterName, @Nullable String edsServiceName) {
        LoadStatsManager2.ClusterDropStats dropCounter = this.loadStatsManager.getClusterDropStats(clusterName, edsServiceName);
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                if (!ClientXdsClient.this.reportingLoad) {
                    ClientXdsClient.this.lrsClient.startLoadReporting();
                    ClientXdsClient.this.reportingLoad = true;
                }
            }
        });
        return dropCounter;
    }

    @Override
    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(String clusterName, @Nullable String edsServiceName, io.grpc.xds.Locality locality) {
        LoadStatsManager2.ClusterLocalityStats loadCounter = this.loadStatsManager.getClusterLocalityStats(clusterName, edsServiceName, locality);
        this.getSyncContext().execute(new Runnable(){

            @Override
            public void run() {
                if (!ClientXdsClient.this.reportingLoad) {
                    ClientXdsClient.this.lrsClient.startLoadReporting();
                    ClientXdsClient.this.reportingLoad = true;
                }
            }
        });
        return loadCounter;
    }

    private void cleanUpResourceTimers() {
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
    }

    private void handleResourcesAccepted(AbstractXdsClient.ResourceType type, Map<String, ParsedResource> parsedResources, String version, String nonce) {
        this.ackResponse(type, version, nonce);
        long updateTime = this.timeProvider.currentTimeNanos();
        for (Map.Entry<String, ResourceSubscriber> entry : this.getSubscribedResourcesMap(type).entrySet()) {
            String resourceName = entry.getKey();
            ResourceSubscriber subscriber = entry.getValue();
            if (parsedResources.containsKey(resourceName)) {
                subscriber.onData(parsedResources.get(resourceName), version, updateTime);
                continue;
            }
            if (type != AbstractXdsClient.ResourceType.LDS && type != AbstractXdsClient.ResourceType.CDS) continue;
            subscriber.onAbsent();
        }
    }

    private void handleResourcesRejected(AbstractXdsClient.ResourceType type, Set<String> unpackedResourceNames, String version, String nonce, List<String> errors) {
        String errorDetail = Joiner.on((char)'\n').join(errors);
        this.getLogger().log(XdsLogger.XdsLogLevel.WARNING, "Failed processing {0} Response version {1} nonce {2}. Errors:\n{3}", new Object[]{type, version, nonce, errorDetail});
        this.nackResponse(type, nonce, errorDetail);
        long updateTime = this.timeProvider.currentTimeNanos();
        for (Map.Entry<String, ResourceSubscriber> entry : this.getSubscribedResourcesMap(type).entrySet()) {
            String resourceName = entry.getKey();
            ResourceSubscriber subscriber = entry.getValue();
            if (!unpackedResourceNames.contains(resourceName)) continue;
            subscriber.onRejected(version, updateTime, errorDetail);
        }
    }

    @VisibleForTesting
    static final class StructOrError<T> {
        private final String errorDetail;
        private final T struct;

        private static <T> StructOrError<T> fromStruct(T struct) {
            return new StructOrError<T>(struct);
        }

        private static <T> StructOrError<T> fromError(String errorDetail) {
            return new StructOrError<T>(errorDetail);
        }

        private StructOrError(T struct) {
            this.struct = Preconditions.checkNotNull(struct, (Object)"struct");
            this.errorDetail = null;
        }

        private StructOrError(String errorDetail) {
            this.struct = null;
            this.errorDetail = (String)Preconditions.checkNotNull((Object)errorDetail, (Object)"errorDetail");
        }

        @Nullable
        @VisibleForTesting
        T getStruct() {
            return this.struct;
        }

        @Nullable
        @VisibleForTesting
        String getErrorDetail() {
            return this.errorDetail;
        }
    }

    @VisibleForTesting
    static final class ResourceInvalidException
    extends Exception {
        private static final long serialVersionUID = 0L;

        private ResourceInvalidException(String message) {
            super(message, null, false, false);
        }

        private ResourceInvalidException(String message, Throwable cause) {
            super(cause != null ? message + ": " + cause.getMessage() : message, cause, false, false);
        }
    }

    private final class ResourceSubscriber {
        private final AbstractXdsClient.ResourceType type;
        private final String resource;
        private final Set<XdsClient.ResourceWatcher> watchers = new HashSet<XdsClient.ResourceWatcher>();
        private XdsClient.ResourceUpdate data;
        private boolean absent;
        private SynchronizationContext.ScheduledHandle respTimer;
        private XdsClient.ResourceMetadata metadata;

        ResourceSubscriber(AbstractXdsClient.ResourceType type, String resource) {
            this.type = type;
            this.resource = resource;
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataUnknown();
            if (ClientXdsClient.this.isInBackoff()) {
                return;
            }
            this.restartTimer();
        }

        void addWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument((!this.watchers.contains(watcher) ? 1 : 0) != 0, (String)"watcher %s already registered", (Object)watcher);
            this.watchers.add(watcher);
            if (this.data != null) {
                this.notifyWatcher(watcher, this.data);
            } else if (this.absent) {
                watcher.onResourceDoesNotExist(this.resource);
            }
        }

        void removeWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument((boolean)this.watchers.contains(watcher), (String)"watcher %s not registered", (Object)watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            if (this.data != null || this.absent) {
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataRequested();
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", new Object[]{ResourceSubscriber.this.type, ResourceSubscriber.this.resource});
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent();
                }

                public String toString() {
                    return (Object)((Object)ResourceSubscriber.this.type) + this.getClass().getSimpleName();
                }
            }
            this.respTimer = ClientXdsClient.this.getSyncContext().schedule((Runnable)new ResourceNotFound(), 15L, TimeUnit.SECONDS, ClientXdsClient.this.getTimeService());
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        void onData(ParsedResource parsedResource, String version, long updateTime) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataAcked(parsedResource.getRawResource(), version, updateTime);
            XdsClient.ResourceUpdate oldData = this.data;
            this.data = parsedResource.getResourceUpdate();
            this.absent = false;
            if (!Objects.equals(oldData, this.data)) {
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    this.notifyWatcher(watcher, this.data);
                }
            }
        }

        void onAbsent() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            ClientXdsClient.this.getLogger().log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", new Object[]{this.type, this.resource});
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                this.metadata = XdsClient.ResourceMetadata.newResourceMetadataDoesNotExist();
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            }
        }

        void onError(Status error) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            for (XdsClient.ResourceWatcher watcher : this.watchers) {
                watcher.onError(error);
            }
        }

        void onRejected(String rejectedVersion, long rejectedTime, String rejectedDetails) {
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataNacked(this.metadata, rejectedVersion, rejectedTime, rejectedDetails);
        }

        private void notifyWatcher(XdsClient.ResourceWatcher watcher, XdsClient.ResourceUpdate update) {
            switch (this.type) {
                case LDS: {
                    ((XdsClient.LdsResourceWatcher)watcher).onChanged((XdsClient.LdsUpdate)update);
                    break;
                }
                case RDS: {
                    ((XdsClient.RdsResourceWatcher)watcher).onChanged((XdsClient.RdsUpdate)update);
                    break;
                }
                case CDS: {
                    ((XdsClient.CdsResourceWatcher)watcher).onChanged((XdsClient.CdsUpdate)update);
                    break;
                }
                case EDS: {
                    ((XdsClient.EdsResourceWatcher)watcher).onChanged((XdsClient.EdsUpdate)update);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"should never be here");
                }
            }
        }
    }

    private static final class ParsedResource {
        private final XdsClient.ResourceUpdate resourceUpdate;
        private final Any rawResource;

        private ParsedResource(XdsClient.ResourceUpdate resourceUpdate, Any rawResource) {
            this.resourceUpdate = (XdsClient.ResourceUpdate)Preconditions.checkNotNull((Object)resourceUpdate, (Object)"resourceUpdate");
            this.rawResource = (Any)Preconditions.checkNotNull((Object)rawResource, (Object)"rawResource");
        }

        private XdsClient.ResourceUpdate getResourceUpdate() {
            return this.resourceUpdate;
        }

        private Any getRawResource() {
            return this.rawResource;
        }
    }
}

