/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.xds.XdsClientWrapperForServerSds;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsServerBuilder;
import java.io.IOException;
import java.net.BindException;
import java.net.SocketAddress;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

@VisibleForTesting
public final class ServerWrapperForXds
extends Server {
    private Server delegate;
    private final ServerBuilder<?> delegateBuilder;
    private final XdsClientWrapperForServerSds xdsClientWrapperForServerSds;
    private XdsServerBuilder.XdsServingStatusListener xdsServingStatusListener;
    @Nullable
    XdsClientWrapperForServerSds.ServerWatcher serverWatcher;
    private AtomicBoolean started = new AtomicBoolean();
    private volatile ServingState currentServingState;
    private final long delayForRetry;
    private final TimeUnit timeUnitForDelayForRetry;
    private StartRetryTask startRetryTask;

    public ServerWrapperForXds(ServerBuilder<?> delegateBuilder, XdsClientWrapperForServerSds xdsClientWrapperForServerSds, XdsServerBuilder.XdsServingStatusListener xdsServingStatusListener) {
        this(delegateBuilder, xdsClientWrapperForServerSds, xdsServingStatusListener, 1L, TimeUnit.MINUTES);
    }

    @VisibleForTesting
    public ServerWrapperForXds(ServerBuilder<?> delegateBuilder, XdsClientWrapperForServerSds xdsClientWrapperForServerSds, XdsServerBuilder.XdsServingStatusListener xdsServingStatusListener, long delayForRetry, TimeUnit timeUnitForDelayForRetry) {
        this.delegateBuilder = (ServerBuilder)Preconditions.checkNotNull(delegateBuilder, (Object)"delegateBuilder");
        this.delegate = delegateBuilder.build();
        this.xdsClientWrapperForServerSds = (XdsClientWrapperForServerSds)Preconditions.checkNotNull((Object)xdsClientWrapperForServerSds, (Object)"xdsClientWrapperForServerSds");
        this.xdsServingStatusListener = (XdsServerBuilder.XdsServingStatusListener)Preconditions.checkNotNull((Object)xdsServingStatusListener, (Object)"xdsServingStatusListener");
        this.delayForRetry = delayForRetry;
        this.timeUnitForDelayForRetry = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)timeUnitForDelayForRetry), (Object)"timeUnitForDelayForRetry"));
    }

    public Server start() throws IOException {
        Preconditions.checkState((boolean)this.started.compareAndSet(false, true), (Object)"Already started");
        this.currentServingState = ServingState.STARTING;
        SettableFuture<Throwable> future = this.addServerWatcher();
        this.xdsClientWrapperForServerSds.start();
        try {
            Throwable throwable = (Throwable)future.get();
            if (throwable != null) {
                this.removeServerWatcher();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new IOException(throwable);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            this.removeServerWatcher();
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(ex);
        }
        return this;
    }

    @VisibleForTesting
    public ServingState getCurrentServingState() {
        return this.currentServingState;
    }

    private SettableFuture<Throwable> addServerWatcher() {
        final SettableFuture future = SettableFuture.create();
        this.serverWatcher = new XdsClientWrapperForServerSds.ServerWatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable throwable, boolean isAbsent) {
                ServerWrapperForXds serverWrapperForXds = ServerWrapperForXds.this;
                synchronized (serverWrapperForXds) {
                    if (ServerWrapperForXds.this.currentServingState == ServingState.SHUTDOWN) {
                        return;
                    }
                    if (ServerWrapperForXds.this.currentServingState == ServingState.STARTING) {
                        if (ServerWrapperForXds.isPermanentErrorFromXds(throwable)) {
                            ServerWrapperForXds.this.currentServingState = ServingState.SHUTDOWN;
                            future.set((Object)throwable);
                            return;
                        }
                        ServerWrapperForXds.this.xdsServingStatusListener.onNotServing(throwable);
                    } else if (isAbsent) {
                        ServerWrapperForXds.this.xdsServingStatusListener.onNotServing(throwable);
                        if (ServerWrapperForXds.this.currentServingState == ServingState.STARTED) {
                            ServerWrapperForXds.this.delegate.shutdown();
                            ServerWrapperForXds.this.currentServingState = ServingState.NOT_SERVING;
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onListenerUpdate() {
                ServerWrapperForXds serverWrapperForXds = ServerWrapperForXds.this;
                synchronized (serverWrapperForXds) {
                    if (ServerWrapperForXds.this.currentServingState == ServingState.SHUTDOWN) {
                        return;
                    }
                    if (ServerWrapperForXds.this.currentServingState == ServingState.STARTING) {
                        try {
                            ServerWrapperForXds.this.delegate.start();
                            ServerWrapperForXds.this.currentServingState = ServingState.STARTED;
                            ServerWrapperForXds.this.xdsServingStatusListener.onServing();
                            future.set(null);
                        }
                        catch (IOException ioe) {
                            future.set((Object)ioe);
                        }
                    } else if (ServerWrapperForXds.this.currentServingState == ServingState.NOT_SERVING) {
                        ServerWrapperForXds.this.currentServingState = ServingState.ENTER_SERVING;
                        ServerWrapperForXds.this.startRetryTask = new StartRetryTask();
                        ServerWrapperForXds.this.startRetryTask.createTask(0L);
                    }
                }
            }
        };
        this.xdsClientWrapperForServerSds.addServerWatcher(this.serverWatcher);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServerWatcher() {
        XdsClientWrapperForServerSds xdsClientWrapperForServerSds = this.xdsClientWrapperForServerSds;
        synchronized (xdsClientWrapperForServerSds) {
            if (this.serverWatcher != null) {
                this.xdsClientWrapperForServerSds.removeServerWatcher(this.serverWatcher);
                this.serverWatcher = null;
            }
        }
    }

    private static boolean isRetriableErrorInDelegateStart(IOException ioe) {
        if (ioe instanceof BindException) {
            return true;
        }
        Throwable cause = ioe.getCause();
        return cause instanceof BindException;
    }

    private static boolean isPermanentErrorFromXds(Throwable throwable) {
        if (throwable instanceof XdsInitializationException) {
            return true;
        }
        Status.Code code = Status.fromThrowable((Throwable)throwable).getCode();
        return EnumSet.of(Status.Code.INTERNAL, Status.Code.INVALID_ARGUMENT, Status.Code.FAILED_PRECONDITION, Status.Code.PERMISSION_DENIED, Status.Code.UNAUTHENTICATED).contains(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupStartRetryTaskAndShutdownDelegateAndXdsClient(boolean shutdownNow) {
        Server delegateCopy = null;
        ServerWrapperForXds serverWrapperForXds = this;
        synchronized (serverWrapperForXds) {
            if (this.startRetryTask != null) {
                this.startRetryTask.shutdownNow();
            }
            this.currentServingState = ServingState.SHUTDOWN;
            if (this.delegate != null && !this.delegate.isShutdown()) {
                delegateCopy = this.delegate;
            }
        }
        if (delegateCopy != null) {
            if (shutdownNow) {
                delegateCopy.shutdownNow();
            } else {
                delegateCopy.shutdown();
            }
        }
        this.xdsClientWrapperForServerSds.shutdown();
    }

    public Server shutdown() {
        this.cleanupStartRetryTaskAndShutdownDelegateAndXdsClient(false);
        return this;
    }

    public Server shutdownNow() {
        this.cleanupStartRetryTaskAndShutdownDelegateAndXdsClient(true);
        return this;
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public void awaitTermination() throws InterruptedException {
        this.delegate.awaitTermination();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public List<? extends SocketAddress> getListenSockets() {
        return this.delegate.getListenSockets();
    }

    public List<ServerServiceDefinition> getServices() {
        return this.delegate.getServices();
    }

    public List<ServerServiceDefinition> getImmutableServices() {
        return this.delegate.getImmutableServices();
    }

    public List<ServerServiceDefinition> getMutableServices() {
        return this.delegate.getMutableServices();
    }

    private final class StartRetryTask
    implements Runnable {
        ScheduledExecutorService timerService;
        AtomicReference<ScheduledFuture<?>> future = new AtomicReference();

        private StartRetryTask() {
        }

        private void createTask(long delay) {
            if (this.timerService == null) {
                this.timerService = (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
            }
            this.future.set(this.timerService.schedule(this, delay, ServerWrapperForXds.this.timeUnitForDelayForRetry));
        }

        private void rebuildAndRestartServer() {
            ServerWrapperForXds.this.delegate = ServerWrapperForXds.this.delegateBuilder.build();
            try {
                ServerWrapperForXds.this.delegate = ServerWrapperForXds.this.delegate.start();
                ServerWrapperForXds.this.currentServingState = ServingState.STARTED;
                ServerWrapperForXds.this.xdsServingStatusListener.onServing();
                this.cleanUpStartRetryTask();
            }
            catch (IOException ioe) {
                ServerWrapperForXds.this.xdsServingStatusListener.onNotServing(ioe);
                if (ServerWrapperForXds.isRetriableErrorInDelegateStart(ioe)) {
                    this.createTask(ServerWrapperForXds.this.delayForRetry);
                }
                ServerWrapperForXds.this.currentServingState = ServingState.SHUTDOWN;
                this.cleanUpStartRetryTask();
            }
        }

        @Override
        public void run() {
            if (ServerWrapperForXds.this.currentServingState == ServingState.SHUTDOWN) {
                return;
            }
            if (ServerWrapperForXds.this.currentServingState != ServingState.ENTER_SERVING) {
                throw new AssertionError((Object)("Wrong state:" + (Object)((Object)ServerWrapperForXds.this.currentServingState)));
            }
            this.rebuildAndRestartServer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUpStartRetryTask() {
            ServerWrapperForXds serverWrapperForXds = ServerWrapperForXds.this;
            synchronized (serverWrapperForXds) {
                if (this.timerService != null) {
                    this.timerService = (ScheduledExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.timerService);
                }
                ServerWrapperForXds.this.startRetryTask = null;
            }
        }

        public void shutdownNow() {
            ScheduledFuture oldValue = this.future.getAndSet(null);
            if (oldValue != null) {
                oldValue.cancel(true);
            }
            this.cleanUpStartRetryTask();
        }
    }

    @VisibleForTesting
    public static enum ServingState {
        STARTING,
        STARTED,
        NOT_SERVING,
        ENTER_SERVING,
        SHUTDOWN;

    }
}

